!----------------------------------------------------------------------
!     Copyright (c) 2012 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wt_zonal_module ƥȥץ
!
!      ݥݥƥ󥷥ζ
!
!  2012/07/08  ݹ   et_test_Vor2StrmGrid.f90  
!                             wt_module Ѥ˲¤
!      2012/08/26  ݹ   wt_module_polvelbc_test.f90 ¤
!
program wt_zonal_module_polvelbc_grid

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wt_zonal_module

  implicit none

  integer,parameter  :: im=1, jm=16, km=16  ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=16        ! ȿ(ʿ, ư)
  real(8),parameter  :: ri=0.5, ro=1.5      ! ⳰Ⱦ

  real(8), dimension(0:im-1,1:jm,0:km)     :: xyz_Poloidal
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyz_LaplaPol
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyz_Poloidal_sol
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyz_LaplaPol_sol
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyz_dPoloidaldz
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyz_d2Poloidaldz2
  real(8), dimension(0:im-1,1:jm)          :: xy_Zero=0.0D0

  ! Ƚ
  integer, parameter :: check_digits = 9
  integer, parameter :: ignore = -10

  real(8), parameter  :: pi=3.1415926535897932385D0

  call MessageNotify('M','wt_zonal_module_polvelbc_grid_test', &
       'wt_zonal_module wt_LaplaPol2polGrid_wt function tests')

  call wt_initial(im,jm,km,nm,lm,ri,ro)

  !----- wt_LaplaPol2PolGrid (FF) ------

  ! P_10
  xyz_Poloidal_sol = sin(xyz_Lat) * sin( pi*(xyz_Rad-ri)/(ro-ri) )
  xyz_LaplaPol_sol = xyz_wt(wt_Lapla_wt(wt_xyz(xyz_Poloidal_sol)))
  !xyz_LaplaPol_sol = sin(xyz_Lat) * sin( pi*(xyz_Rad-ri)/(ro-ri) )
  ! P_1_1
  !xyz_LaplaPol_sol = cos(xyz_Lat)*cos(xyz_Lon)* sin( pi*(xyz_Rad-ri)/(ro-ri) )
  !xyz_LaplaPol_sol = 2*sin(xyz_Lat)**2 * sin( pi*(xyz_Rad-ri)/(ro-ri) )
  
  xyz_Poloidal = xyz_wt(wt_LaplaPol2PolGrid_wt(wt_xyz(xyz_LaplaPol_sol),&
                                                  cond='FF',new=.true.))

  xyz_LaplaPol = xyz_wt(wt_Lapla_wt(wt_xyz(xyz_Poloidal)))
  xyz_dPoloidaldz   = xyz_wt(wt_DRad_wt(wt_xyz(xyz_Poloidal)))
  xyz_d2Poloidaldz2 = xyz_wt(wt_DRad_wt(wt_DRad_wt(wt_xyz(xyz_Poloidal))))

  call AssertEqual(&
    message='wt_LaplaPol2PolGrid_wt (FF)',                        &
    answer =xyz_Poloidal_sol,                                     &
    check = xyz_Poloidal,                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_LaplaPol2PolGrid_wt (FF, LaplaPol)',              &
    answer =xyz_LaplaPol_sol(:,:,1:km-1),                         &
    check = xyz_LaplaPol(:,:,1:km-1),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_LaplaPol2PolGrid_wt (FF, Top)',                   &
    answer =xy_Zero,                                              &
    check = xyz_d2Poloidaldz2(:,:,0),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_LaplaPol2PolGrid_wt (FF, Bottom)',                &
    answer =xy_Zero,                                              &
    check = xyz_d2Poloidaldz2(:,:,km),                            &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !----- wt_LaplaPol2PolGrid (RF) ------

  ! P_10
  xyz_Poloidal_sol = sin(xyz_Lat) * (xyz_Rad-ri)**3*(xyz_Rad-ro)**2
  xyz_LaplaPol_sol = xyz_wt(wt_Lapla_wt(wt_xyz(xyz_Poloidal_sol)))
  !xyz_LaplaPol_sol = sin(xyz_Lat) * sin( pi*(xyz_Rad-ri)/(ro-ri) )
  ! P_1_1
  !xyz_LaplaPol_sol = cos(xyz_Lat)*cos(xyz_Lon)* sin( pi*(xyz_Rad-ri)/(ro-ri) )
  !xyz_LaplaPol_sol = 2*sin(xyz_Lat)**2 * sin( pi*(xyz_Rad-ri)/(ro-ri) )
  
  xyz_Poloidal = xyz_wt(wt_LaplaPol2PolGrid_wt(wt_xyz(xyz_LaplaPol_sol),&
                                                  cond='RF',new=.true.))

  xyz_LaplaPol = xyz_wt(wt_Lapla_wt(wt_xyz(xyz_Poloidal)))
  xyz_dPoloidaldz   = xyz_wt(wt_DRad_wt(wt_xyz(xyz_Poloidal)))
  xyz_d2Poloidaldz2 = xyz_wt(wt_DRad_wt(wt_DRad_wt(wt_xyz(xyz_Poloidal))))

  call AssertEqual(&
    message='wt_LaplaPol2PolGrid_wt (RF)',                        &
    answer =xyz_Poloidal_sol,                                     &
    check = xyz_Poloidal,                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_LaplaPol2PolGrid_wt (RF, LaplaPol)',              &
    answer =xyz_LaplaPol_sol(:,:,1:km-1),                         &
    check = xyz_LaplaPol(:,:,1:km-1),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_LaplaPol2PolGrid_wt (RF, Top)',                   &
    answer =xy_Zero,                                              &
    check = xyz_dPoloidaldz(:,:,0),                               &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_LaplaPol2PolGrid_wt (RF, Bottom)',                &
    answer =xy_Zero,                                              &
    check = xyz_d2Poloidaldz2(:,:,km),                            &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !----- wt_LaplaPol2PolGrid (FR) ------

  ! P_10
  xyz_Poloidal_sol = sin(xyz_Lat) * (xyz_Rad-ri)**2*(xyz_Rad-ro)**3
  xyz_LaplaPol_sol = xyz_wt(wt_Lapla_wt(wt_xyz(xyz_Poloidal_sol)))
  !xyz_LaplaPol_sol = sin(xyz_Lat) * sin( pi*(xyz_Rad-ri)/(ro-ri) )
  ! P_1_1
  !xyz_LaplaPol_sol = cos(xyz_Lat)*cos(xyz_Lon)* sin( pi*(xyz_Rad-ri)/(ro-ri) )
  !xyz_LaplaPol_sol = 2*sin(xyz_Lat)**2 * sin( pi*(xyz_Rad-ri)/(ro-ri) )
  
  xyz_Poloidal = xyz_wt(wt_LaplaPol2PolGrid_wt(wt_xyz(xyz_LaplaPol_sol),&
                                                  cond='FR',new=.true.))

  xyz_LaplaPol = xyz_wt(wt_Lapla_wt(wt_xyz(xyz_Poloidal)))
  xyz_dPoloidaldz   = xyz_wt(wt_DRad_wt(wt_xyz(xyz_Poloidal)))
  xyz_d2Poloidaldz2 = xyz_wt(wt_DRad_wt(wt_DRad_wt(wt_xyz(xyz_Poloidal))))

  call AssertEqual(&
    message='wt_LaplaPol2PolGrid_wt (FR)',                        &
    answer =xyz_Poloidal_sol,                                     &
    check = xyz_Poloidal,                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_LaplaPol2PolGrid_wt (FR, LaplaPol)',              &
    answer =xyz_LaplaPol_sol(:,:,1:km-1),                         &
    check = xyz_LaplaPol(:,:,1:km-1),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_LaplaPol2PolGrid_wt (FR, Top)',                   &
    answer =xy_Zero,                                              &
    check = xyz_d2Poloidaldz2(:,:,0),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_LaplaPol2PolGrid_wt (FR, Bottom)',                &
    answer =xy_Zero,                                              &
    check = xyz_dPoloidaldz(:,:,km),                              &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !----- wt_LaplaPol2PolGrid (RR) ------

  ! P_10
  xyz_Poloidal_sol = sin(xyz_Lat) * (xyz_Rad-ri)**2*(xyz_Rad-ro)**2
  xyz_LaplaPol_sol = xyz_wt(wt_Lapla_wt(wt_xyz(xyz_Poloidal_sol)))
  !xyz_LaplaPol_sol = sin(xyz_Lat) * sin( pi*(xyz_Rad-ri)/(ro-ri) )
  ! P_1_1
  !xyz_LaplaPol_sol = cos(xyz_Lat)*cos(xyz_Lon)* sin( pi*(xyz_Rad-ri)/(ro-ri) )
  !xyz_LaplaPol_sol = 2*sin(xyz_Lat)**2 * sin( pi*(xyz_Rad-ri)/(ro-ri) )
  
  xyz_Poloidal = xyz_wt(wt_LaplaPol2PolGrid_wt(wt_xyz(xyz_LaplaPol_sol),&
                                                  cond='RR',new=.true.))

  xyz_LaplaPol = xyz_wt(wt_Lapla_wt(wt_xyz(xyz_Poloidal)))
  xyz_dPoloidaldz   = xyz_wt(wt_DRad_wt(wt_xyz(xyz_Poloidal)))
  xyz_d2Poloidaldz2 = xyz_wt(wt_DRad_wt(wt_DRad_wt(wt_xyz(xyz_Poloidal))))

  call AssertEqual(&
    message='wt_LaplaPol2PolGrid_wt (RR)',                        &
    answer =xyz_Poloidal_sol,                                     &
    check = xyz_Poloidal,                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_LaplaPol2PolGrid_wt (RR, LaplaPol)',              &
    answer =xyz_LaplaPol_sol(:,:,1:km-1),                         &
    check = xyz_LaplaPol(:,:,1:km-1),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_LaplaPol2PolGrid_wt (RR, Top)',                   &
    answer =xy_Zero,                                              &
    check = xyz_dPoloidaldz(:,:,0),                               &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='wt_LaplaPol2PolGrid_wt (RR, Bottom)',                 &
    answer =xy_Zero,                                              &
    check = xyz_dPoloidaldz(:,:,km),                              &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','wt_zonal_module_polvelbc_grid_test', &
       'wt_zonal_module wt_LaplaPol2polGrid_wt function tests suceeded!')

end program wt_zonal_module_polvelbc_grid
