=begin JA

= ̷ѥ᥿

# *  (odakker),  (morikawa)
#   * $Id: dc_types.rd,v 1.3 2009-02-28 13:36:32 morikawa Exp $

=end JA
=begin EN

= Type parameter specification

# * Masatsugu ODAKA (odakker)
#   * $Id: dc_types.rd,v 1.3 2009-02-28 13:36:32 morikawa Exp $

=end EN

=begin JA

¿ѿ٤ʸѿʸꤹݤ, Fortran90 
Ǥϼ̷ѥ᥿Ѥ뤳ȤǤޤ. 
gtool5 ˤɸŪʼ̷ѥ᥿󶡤⥸塼 
((<dc_types|URL:../code_reference/classes/dc_types.html>)) Ѱ
Ƥޤ. ѤɸŪʼ̷ѥ᥿ʬ
ȤʤѤ뤳ȤǽȤʤޤ. 

Ȥ, ((<"ǡ: °Ĥ"|URL:gthist_attr.htm>)) 
Ѥ((<ץץ|URL:gthist_attr/diffusion_attr.f90>))ˤ, 
¿ѿ٤̷ѥ᥿Ѥƻꤷץ򼨤ޤ
(ɤ((<|URL:dc_types/diffusion_3.f90>))). 
ֻ(顼Ǥʤϥܡ) dc_types ˴طƤսǤ.

=end JA
=begin EN

In Fortran 90 programs, the value of the kind type parameter for a
given data type can be specified by the KIND intrinsic
function. 
((<Dc_types|URL:../code_reference/classes/dc_types.html>))
module of gtool5 provides standard type parameters. 
By using the dc_types module, it is not necessary to
define type parameters in user's programs.

For example, a sample program using the dc_types module
(((<diffusion_3.f90|URL:dc_types/diffusion_3.f90>))) is shown here, which are
modified from ((<diffusion_attr.f90|URL:gthist_attr/diffusion_attr.f90>)) in ((<"Data
I/O interface: Add attribute"|URL:gthist_attr.htm>)).  Statements
with colored font (or bold font) are associated with the
dc_types module.

=end EN

=begin HTML
<pre style="background-color: #FFFFFF; color: blue; border-style: groove; border-width: 2">
!= Sample program for gtool_history/gtool5
!
! * 2007/06/25 M.Odaka
! * 2006/10/25 Y.Morikawa
! * 2003/08/21 M.Odaka
! * 2001/02/27 S.Takehiro
!
! Solving diffusion equation
! \[
!     du/dt = \kappa d^2 u/dx^2
! \]
! for giving values of $u$ at $x=[0,1]$.
!
program diffusion_3

  use gtool_history                                   ! Access module(⥸塼)
  <b><font color="red">use dc_types, only : DP                           ! Access module (⥸塼)</font></b>

  integer, parameter     :: nx=30                   ! Grid number (åɿ)
  integer, parameter     :: nt=200                  ! Time step number (֥ƥå׿)
  integer, parameter     :: ndisp=10                ! Output interval (ϴֳ)
  real(<b><font color="red">DP</font></b>), parameter    :: dx=1.0/(nx-1)           ! Grid interval (åɴֳ)
  real(<b><font color="red">DP</font></b>), parameter    :: dt=0.0005               ! Time step (ֳִ)
  real(<b><font color="red">DP</font></b>), dimension(nx):: x=(/(dx*(i-1),i=1,nx)/) ! X coordinate (ɸѿ)
  real(<b><font color="red">DP</font></b>), dimension(nx):: temp                    ! Temperature ()
  real(<b><font color="red">DP</font></b>), parameter    :: kappa=1.0               ! Diffusion coefficient (ǮȻ)

  tinit = 0.0                                       ! Set initial Time 
                                                    ! ()
  
  temp = exp(-((x-0.5)/0.1)**2)                     ! Set initial value 
                                                    ! ()

  call HistoryCreate( &amp;                             ! Create output file 
    &amp; file='diffusion_3.nc', &amp;                      ! (ҥȥ꡼)
    &amp; title='Diffusion equation',                        &amp;
    &amp; source='Sample program of gtool_history/gtool5',   &amp;
    &amp; institution='GFD_Dennou Club davis project',       &amp;
    &amp; dims=(/'x','t'/), dimsizes=(/nx,0/),               &amp;
    &amp; longnames=(/'X-coordinate','time        '/),       &amp;
    &amp; units=(/'m','s'/),                                 &amp;
    &amp; origin=real(tinit), interval=real(ndisp*dt) )

  call HistoryPut('x',x)                            ! Output 'x' (ѿ)

  call HistoryAddVariable( &amp;                        ! Set output variable 
    &amp; varname='temp', dims=(/'x','t'/), &amp;           ! (ѿ)
    &amp; longname='temperature', units='K', xtype='double')

  call HistoryAddAttr('temp','gt_graph_tick_all',1)
  call HistoryAddAttr('temp','gt_graph_contour_spacing',(/0.0,1.0,0.01/))
  call HistoryAddAttr('temp','+gt_user_davis_kappa',kappa)

  call HistoryPut('temp',temp)                      ! Output 'temp' (ѿ)

  do it=1,nt
    temp(2:nx-1) = temp(2:nx-1) &amp;                   ! Time integration (ʬ)
      &amp; + kappa*(temp(3:nx)-2*temp(2:nx-1)+temp(1:nx-2))/dx**2*dt

    if ( mod(it,ndisp) == 0 ) then
      call HistoryPut('temp',temp)                  ! Output 'temp' (ѿ)
    endif
  enddo

  call HistoryClose
  stop
end program diffusion_3
</pre>
=end HTML

=begin JA

Ǥϼ¿ѿ٤, dc_types ⥸塼뤬Ѱդ
ټ¿̷ѥ᥿ ((*DP*)) Ѥƻꤷޤ. 
dc_types ⥸塼ˤϤ¾ʸѿΤ
̷ѥ᥿ѰդƤޤ. ܤ
((<ե󥹥ޥ˥奢|URL:../code_reference/classes/dc_types.html>)) 
򻲾ȤƤ. 

=end JA

=begin EN

In this sample program, the parameter ((*DP*)) provided by dc_types
module is used as the kind type parameter for double precision real
literal constant. The dc_types module also provides 
kind type parameters for integer and character literal constants. 
In detail, please see 
((<gtool5 reference manual|URL:../code_reference/classes/dc_types.html>)). 

=end EN

=begin HTML
<hr /> <small>
  $Id: dc_types.rd,v 1.3 2009-02-28 13:36:32 morikawa Exp $
</small>
=end HTML
