!= 䤤碌
!= Inquire information of calendar
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dccalinquire.f90,v 1.3 2010-08-26 10:50:08 morikawa Exp $
! Tag Name::  $Name: gtool5-20101228-1 $
! Copyright:: Copyright (C) GFD Dennou Club, 2009-. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! Υե˵ܤ³ dc_calendar ⥸塼뤫󶡤ޤ. 
!
! Procedures described in this file are provided from "dc_calendar" module. 
!

subroutine DCCalInquire1( cal_type, &
  &                       month_in_year, day_in_month, day_in_month_ptr, &
  &                       hour_in_day, min_in_hour, sec_in_min, &
  &                       cal, err )
  !
  ! 䤤碌Ԥޤ. 
  !
  ! *cal_type* ˤϰʲʸ֤ޤ. 
  !
  ! gregorian         :: 쥴ꥪ
  ! julian            :: ꥦ
  ! noleap            :: ǯ̵
  ! 360day            :: 1 30 
  ! cyclic            :: 
  !                      30.6    ޤǤ
  !                      ξʲڼΤȤ
  ! user_defined      :: 桼
  !
  ! άǽ *cal* ά줿ˤ, dc_calendar 
  ! ݻ˴ؤޤ. 
  ! *cal* άʤˤϤѿꤵ줿ξޤ. 
  !
  ! Inquire information of calendar. 
  !
  ! Following strings are returned to *cal_type*. 
  !
  ! gregorian         :: Gregorian calendar. 
  ! julian            :: Julian calendar. 
  ! noleap            :: A calendar without leap year. 
  ! 360day            :: A calendar in which number of days of a month is 30. 
  ! cyclic            :: A calendar in which number of days of a year is
  !                      "30.6 x (number of months) - (total days until last month)"
  !                      (truncate fractional part). 
  ! user_defined      :: User defined calendar
  !
  ! If an optional argument *cal* is omitted, 
  ! information of a calendar that is stored in the "dc_calendar"
  ! is returned, 
  ! If *cal* is not omitted, information of the variable is returned. 
  !

  use dc_calendar_types, only: DC_CAL
  use dc_calendar_internal, only: default_cal, default_cal_set, dccaltype_str
  use dc_message, only: MessageNotify
  use dc_string, only: LChar
  use dc_trace, only: BeginSub, EndSub
  use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
  use dc_types, only: STRING, DP
  implicit none
  character(*), intent(out), optional:: cal_type
                              ! μ򼨤ʸ. 
                              ! 
                              ! Strings that specify a kind of calendar. 
  integer, intent(out), optional:: month_in_year
                              ! 1 ǯη. 
                              ! Months in a year. 
  integer, intent(out), optional:: day_in_month(:)
                              ! 1 . 
                              ! 쥴ꥪξ,  2 ܤ (2) 
                              ! ˤɬ 28 ֤ޤ. 
                              !
                              ! Days in months. 
                              ! In Gregorian calendar, 28 is returned to 
                              ! 2nd position of the array (February) 
                              ! at all times. 
                              !
  integer, pointer, optional:: day_in_month_ptr(:)
                              ! 1  (ݥ). 
                              ! 쥴ꥪξ,  2 ܤ (2) 
                              ! ˤɬ 28 ֤ޤ. 
                              !
                              ! Days in months (pointer). 
                              ! In Gregorian calendar, 28 is returned to 
                              ! 2nd position of the array (February) 
                              ! at all times. 
                              !
  integer, intent(out), optional:: hour_in_day
                              ! 1 λֿ. 
                              ! Hours in a day. 
  integer, intent(out), optional:: min_in_hour
                              ! 1 ֤ʬ. 
                              ! Minutes in a hour. 
  real(DP), intent(out), optional:: sec_in_min
                              ! 1 ʬÿ. 
                              ! Seconds in a minute. 
  type(DC_CAL), intent(in), optional, target:: cal
                              ! ᤿֥. 
                              ! 
                              ! An object that stores information of 
                              ! calendar. 
  logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 


  ! ѿ
  ! Work variables
  !
  type(DC_CAL), pointer:: calp =>null()
  integer:: siz_dm
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter:: subname = 'DCCalInquire1'
continue
  call BeginSub( subname )
  stat = DC_NOERR
  cause_c = ''

  ! ֥ȤΥݥ󥿳
  ! Associate pointer of an object
  !
  if ( present( cal ) ) then
    calp => cal
  else
    calp => default_cal
    if ( .not. calp % initialized ) call default_cal_set
  end if

  ! Υå
  ! Check initialization
  !
  if ( .not. calp % initialized ) then
    stat = DC_ENOTINIT
    cause_c = 'DC_CAL'
    goto 999
  end if

  ! Ǥؤͤλ
  ! Refer elements
  !
  if ( present( cal_type      ) ) then 
    cal_type = dccaltype_str( calp % cal_type )
  end if
  if ( present( month_in_year ) ) month_in_year = calp % month_in_year
  if ( present( hour_in_day   ) ) hour_in_day   = calp % hour_in_day
  if ( present( min_in_hour   ) ) min_in_hour   = calp % min_in_hour
  if ( present( sec_in_min    ) ) sec_in_min    = calp % sec_in_min

  if ( present( day_in_month     ) ) then
    if ( size( day_in_month ) > 0 ) then
      day_in_month = 0
      siz_dm = min( size( day_in_month ), size( calp % day_in_month ) )
      day_in_month(1:siz_dm) = calp % day_in_month(1:siz_dm)
    end if
  end if

  if ( present( day_in_month_ptr ) ) then
    siz_dm = size( calp % day_in_month )
    allocate( day_in_month_ptr(1:siz_dm) )
    day_in_month_ptr(1:siz_dm) = calp % day_in_month(1:siz_dm)
  end if

  ! λ, 㳰
  ! Termination and Exception handling
  !
999 continue
  nullify( calp )
  call StoreError( stat, subname, err, cause_c )
  call EndSub( subname )
end subroutine DCCalInquire1
