#
# step2.rb
#   $Id: step2.rb,v 1.1.1.1 2011-02-23 07:21:27 horinout Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math

nmax = 100

x = NArray.sfloat(nmax)
y = NArray.sfloat( nmax)

#-- data ----
iseed = 0
x[0] = 2*(rand(iseed)-0.5)
y[nmax-1] = x[0]

for i in 1..nmax-1
  x[i] = 2*(rand(iseed)-0.5)
  y[i-1] = x[i]
end

#-- graph ----
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws
DCL::grfrm

DCL::usspnt(x, y)
DCL::uspfit
DCL::grstrf

DCL::ussttl( 'X-TITLE', 'x-unit', 'Y-TITLE', 'y-unit' )
DCL::usdaxs

cnt = nmax/4
st = 0
ed = cnt-1
DCL::uusmki(5)
DCL::uusmks(0.015)
DCL::uumrk(x[st..ed], y[st..ed])

st += cnt
ed += cnt
DCL::uusmkt(2)
DCL::uumrk(x[st..ed], y[st..ed])

st += cnt
ed += cnt
DCL::uusmkt(3)
DCL::uumrk(x[st..ed], y[st..ed])

st += cnt
ed += cnt
DCL::uusmkt(4)
DCL::uumrk(x[st..ed], y[st..ed])

DCL::grcls

