#
# scpkt8.rb
#
# $Id: scpkt8.rb,v 1.1.1.1 2011-02-23 07:21:27 horinout Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math


nx = 37
xmin = 0
xmax = 360
ymin = 0
ymax = 180
drad = PI/180

alon = NArray.sfloat(nx)
alat = NArray.sfloat(nx)
r = NArray.sfloat(nx)
a = NArray.sfloat( nx)

#-- data ---
alon.indgen(xmin, (xmax-xmin)/(nx-1).to_f)
alat.indgen(ymin, (ymax-ymin)/(nx-1).to_f)
r.fill!(1.0)

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i

DCL::sgopn iws

DCL::sgfrm
DCL::sglset('LDEG', true)

#---------------- 3-D ------------------
DCL::scsorg(1.0, 0.0, 0.0, 0.0)
DCL::scstrn(3)
DCL::scstrf

DCL::scseye(5.0, 1.0, 2.0)
DCL::scsobj(0.0, 0.0, 0.0)
DCL::scsprj

DCL::scspmt(10)
DCL::scspmi(1)
DCL::scspms(0.01)

for i in 0..nx-1
  a.fill!(alat[i])
  DCL::scplu(r, a, alon)
  DCL::scpmu(r, a, alon)
end

DCL::sgcls


