#
# sgpk09.rb
#
# $Id: sgpk09.rb,v 1.1.1.1 2011-02-23 07:21:27 horinout Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math


kmax = 4
nn = 73
dd = 2.0
ux = NArray.sfloat(nn)
uy = NArray.sfloat(nn)

#-- data ---
xorg = NArray[2.5, 7.5, 2.5, 7.5]
yorg = NArray[7.5, 7.5, 2.5, 2.5]

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::sgopn iws

DCL::sgfrm

DCL::sgswnd(0.0, 10.0, 0.0, 10.0)
DCL::sgsvpt(0.0, 1.0, 0.0, 1.0)
DCL::sgstrn(1)
DCL::sgstrf

DCL::sgstxs(0.03)
DCL::sgstxi(3)
DCL::sgstxc(0)

DCL::sgsplc('K=1')

for k in 0..kmax-1
  DCL::sgslni(1)
  DCL::sglnu(xorg[k]-dd, yorg[k], xorg[k]+dd, yorg[k])
  DCL::sglnu(xorg[k], yorg[k]-dd, xorg[k], yorg[k]+dd)

  for i in 0..nn-1
    th = 2*PI*i/(nn-1)
    ux[i] = xorg[k] + dd*cos(th+k*PI/7)
    uy[i] = yorg[k] + dd*sin((k+1)*th)
  end

  DCL::sgspli(2)
  DCL::sgsplt(k+1)
  DCL::sglset('LCHAR', true)
  DCL::sgplu(ux, uy)
  DCL::sglset('LCHAR', false)
  DCL::sgnplc
end

DCL::sgcls

