#
# kihon3.rb
#   $Id: kihon3.rb,v 1.1.1.1 2011-02-23 07:21:26 horinout Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math

nmax = 40
imax = 7
dt = 4.0*PI/nmax

x = NArray.sfloat(nmax+1)
y = NArray.sfloat(nmax+1, imax)

#-- data ----
x = x.indgen * 1.0/nmax
for n in 0..nmax
  for i in 0..imax-1
    y[n,i] = 0.2*sin(n*dt) + 0.8 - 0.1*i
  end
end

#-- graph ----
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::sgopn iws

#-- marker type : frame 1 --
DCL::sgfrm
DCL::slpvpr(1) 

DCL::sgpmv(x, y[true,0])

for i in 1..imax-1
  itype = i + 1
  DCL::sgspmt(itype)
  DCL::sgpmv(x, y[true,i])
end

#-- marker size : frame 2 --
DCL::sgfrm
DCL::slpvpr(1) 

DCL::sgspmt(10)
DCL::sgpmv(x, y[true,0])

for i in 1..imax-1
  rsize = 0.005*i
  DCL::sgspms(rsize)
  DCL::sgpmv(x, y[true,i])
end

DCL::sgcls

