#
# kihona.rb
#   $Id: kihona.rb,v 1.1.1.1 2011-02-23 07:21:26 horinout Exp $
#


require "narray"
require "numru/dcl"
include NumRu
include NMath


nmax = 40
xmin = 0.0
xmax = 4*PI
ymin = -1.0
ymax = 1.0
x = NArray.sfloat(nmax+1)
y = NArray.sfloat(nmax+1)

#-- data ---
dt = xmax/nmax
x = x.indgen * dt
y = sin(x)

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::sgopn iws

DCL::sgfrm

DCL::sglset('LCHAR', true)

#-- ٥Ĥޤ ----
DCL::sgswnd(xmin, xmax, ymin, ymax)
DCL::sgsvpt(0.0, 1.0, 0.9, 1.0)
DCL::sgstrn(1)
DCL::sgstrf

DCL::sgsplc('A')
DCL::sgsplt(1)
DCL::sgplu(x, y)

#-- ٥: A,B,C,... ----
for i in 1..2
  vymin = 0.9 - 0.1*i
  vymax = vymin + 0.1
  DCL::sgswnd(xmin, xmax, ymin, ymax)
  DCL::sgsvpt(0.0, 1.0, vymin, vymax)
  DCL::sgstrn(1)
  DCL::sgstrf

  DCL::sgnplc
  DCL::sgplu(x, y)
end

#-- ٥: K=1,K=2,... ----
DCL::sgsplc('K=1')

for i in 3..4
  vymin = 0.9 - 0.1*i
  vymax = vymin + 0.1
  DCL::sgswnd(xmin, xmax, ymin, ymax)
  DCL::sgsvpt(0.0, 1.0, vymin, vymax)
  DCL::sgstrn(1)
  DCL::sgstrf

  DCL::sgsplt(i-1)
  DCL::sgplu(x, y)
  DCL::sgnplc
end

DCL::sgsplt(1)

#--  ٥ʸι⤵ ----
DCL::sgswnd(xmin, xmax, ymin, ymax)
DCL::sgsvpt(0.0, 1.0, 0.4, 0.5)
DCL::sgstrn(1)
DCL::sgstrf

DCL::sgspls(0.01)
DCL::sgsplc('small')
DCL::sgplu(x, y)

DCL::sgspls(0.02)

#--  ٥γ ----
DCL::sgswnd(xmin, xmax, ymin, ymax)
DCL::sgsvpt(0.0, 1.0, 0.3, 0.4)
DCL::sgstrn(1)
DCL::sgstrf

DCL::sglset('LROT', true)
DCL::sgiset('IROT', 90)
DCL::sgsplc('ROT')
DCL::sgplu(x, y)

DCL::sglset('LROT', false)

#--  ٥δֳ ----
DCL::sgswnd(xmin, xmax, ymin, ymax)
DCL::sgsvpt(0.0, 1.0, 0.2, 0.3)
DCL::sgstrn(1)
DCL::sgstrf

DCL::sgrset('CWL', 5.0)
DCL::sgsplc('CWL')
DCL::sgplu(x, y)

DCL::sgrset('CWL', 30.0)

#--  ٥ν񤭻Ϥ ----
DCL::sgswnd(xmin, xmax, ymin, ymax)
DCL::sgsvpt(0.0, 1.0, 0.1, 0.2)
DCL::sgstrn(1)
DCL::sgstrf

DCL::sgrset('FFCT', 0.9)
DCL::sgsplc('FCT')
DCL::sgplu(x, y)

DCL::sgcls

