#
# map3d2.rb
#   $Id: map3d2.rb,v 1.1.1.1 2011-02-23 07:21:26 horinout Exp $
#


require "narray"
require "numru/dcl"
include NumRu
include Math


nx = 37
ny = 37
xmin = 0
xmax = 360
ymin = -90
ymax = 90
drad = PI/180
p = NArray.sfloat(nx, ny)

#-- data ---
for j in 0..ny-1
  for i in 0..nx-1
    alon = ( xmin + (xmax-xmin)*i/(nx-1) ) * drad
    alat = ( ymin + (ymax-ymin)*j/(ny-1) ) * drad
    slat = sin(alat)
    p[i,j] = 3*sqrt(1-slat**2)*slat*cos(alon) - 0.5*(3*slat**2-1)
  end
end

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::sglset('LSOFTF', false)
DCL::grfrm

DCL::sgswnd(xmin, xmax, ymin, ymax)
DCL::sgsvpt(0.1, 0.9, 0.1, 0.9)
DCL::sgssim(0.4, 0.0, 0.0)
DCL::sgsmpl(135.0, 35.0, 0.0)
DCL::sgstxy(-180.0, 180.0, 0.0, 90.0)
DCL::sgstrn(30)
DCL::sgstrf

for k in -5..3
  tlev1 = 0.4*k
  tlev2 = tlev1 + 0.4
  if (k <= -1)
    ipat = 600 + (k+1).abs
  else
    ipat =  30 + k
  end
  DCL::uestlv(tlev1, tlev2, ipat)
end

DCL::uetone(p)

DCL::udgclb(p, 0.4)
DCL::udcntr(p)

DCL::umpmap('coast_world')
DCL::umpglb

DCL::grcls

