#
# map3d3.rb
#   $Id: map3d3.rb,v 1.1.1.1 2011-02-23 07:21:26 horinout Exp $
#


require "narray"
require "numru/dcl"
include NumRu
include Math

nx = 16
ny = 16
xmin = 120
xmax = 150
ymin = 20
ymax = 50
fact = 0.21
u = NArray.sfloat(nx, ny)
v = NArray.sfloat(nx, ny)
alon = NArray.sfloat(nx)
alat = NArray.sfloat(ny)

#-- data ---
for i in 0..nx-1
  alon[i] = xmin + (xmax-xmin)*i/(nx-1).to_f
end
for j in 0..ny-1
  alat[j] = ymin + (ymax-ymin)*j/(ny-1).to_f
end

for j in 0..ny-1
  for i in 0..nx-1
    u[i,j] =   (j-(ny-1)/2.0) * fact
    v[i,j] = - (i-(nx-1)/2.0) * fact
  end
end

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm
DCL::sglset('LCLIP', true)

DCL::grswnd(xmin, xmax, ymin, ymax)
DCL::grsvpt(0.1, 0.9, 0.1, 0.9)
DCL::grstrn(10)
DCL::umpfit
DCL::grstrf

DCL::slpvpr(3)
DCL::umrset('DGRIDMJ', 10.0)
DCL::umrset('DGRIDMN', 2.0)
DCL::umpmap('coast_world')
DCL::umpglb

DCL::sgslai(3)
for j in 0..ny-1
  for i in 0..nx-1
    DCL::sglau(alon[i], alat[j], alon[i]+u[i,j], alat[j]+v[i,j])
  end
end

DCL::grcls

