#
# u2d6.rb
#   $Id: u2d6.rb,v 1.1.1.1 2011-02-23 07:21:26 horinout Exp $
#


require "narray"
require "numru/dcl"
include NumRu
include Math


nx = 11
ny = 11
xmin = -1
xmax = 1
ymin = -1
ymax = 1
u = NArray.sfloat(nx, ny)
v = NArray.sfloat(nx, ny)

#-- data ---
for j in 0..ny-1
  for i in 0..nx-1
    x = xmin + (xmax-xmin)*i/(nx-1).to_f
    y = ymin + (ymax-ymin)*j/(ny-1).to_f
    u[i,j] =  x * 0.1
    v[i,j] = -y
  end
end

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm

DCL::grswnd(xmin, xmax, ymin, ymax)
DCL::grsvpt(0.2, 0.8, 0.2, 0.8)
DCL::grstrn(1)
DCL::grstrf

DCL::usdaxs

DCL::uglset('LNRMAL', false)
DCL::ugrset('XFACT1', 0.5)
DCL::ugrset('YFACT1', 0.05)
DCL::uglset('LUNIT', true)
DCL::ugrset('VXUNIT', 0.1)
DCL::ugrset('VYUNIT', 0.1)
DCL::ugrset('VXUOFF', 0.06)
DCL::ugsut('X', 'U')
DCL::ugsut('Y', 'V')
DCL::ugvect(u, v)

DCL::grcls

