/*
 * $Id: p_header,v 1.2 2011-02-23 17:47:10 koshiro Exp $
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"

/* for compatibility with ruby 1.6 */
#ifndef StringValuePtr
#define StringValuePtr(s) STR2CSTR(s)
#endif

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return real */
/* fnclib */
extern real rd2r_(real *);
extern real rr2d_(real *);
extern real rexp_(real *, integer *, integer *);
extern real rfpi_(void);
extern real rmod_(real *, real *);
/* gnmlib */
extern real rgnlt_(real *);
extern real rgnle_(real *);
extern real rgngt_(real *);
extern real rgnge_(real *);
/* rfalib */
extern real rmax_(real *, integer *, integer *);
extern real rmin_(real *, integer *, integer *);
extern real rsum_(real *, integer *, integer *);
extern real rave_(real *, integer *, integer *);
extern real rvar_(real *, integer *, integer *);
extern real rstd_(real *, integer *, integer *);
extern real rrms_(real *, integer *, integer *);
extern real ramp_(real *, integer *, integer *);
/* rfblib */
extern real rprd_(real *, real *, integer *, integer *, integer *);
extern real rcov_(real *, real *, integer *, integer *, integer *);
extern real rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

static VALUE
dcl_vrrnm(obj, rx, n, jx, jy, nb)
    VALUE obj, rx, n, jx, jy, nb;
{
    real *i_rx;
    real *o_ry;
    integer i_n;
    integer i_jx;
    integer i_jy;
    integer i_nb;
    VALUE ry;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }
    if ((TYPE(jy) != T_BIGNUM) || (TYPE(jy) != T_FIXNUM)) {
      jy = rb_funcall(jy, rb_intern("to_i"), 0);
    }
    if ((TYPE(nb) != T_BIGNUM) || (TYPE(nb) != T_FIXNUM)) {
      nb = rb_funcall(nb, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_jy = NUM2INT(jy);
    i_nb = NUM2INT(nb);
    i_rx = dcl_obj2crealary(rx);

    o_ry= ALLOCA_N(real, i_jy*(i_n-1)+1);

    vrrnm_(i_rx, o_ry, &i_n, &i_jx, &i_jy, &i_nb);

    {int array_shape[1] = {i_jy*(i_n-1)+1};
     ry = dcl_crealary2obj(o_ry, i_jy*(i_n-1)+1, 1, array_shape);
    }

    dcl_freecrealary(i_rx);

    return ry;

}

static VALUE
dcl_vrrnm0(obj, rx, n, jx, jy, nb)
    VALUE obj, rx, n, jx, jy, nb;
{
    real *i_rx;
    real *o_ry;
    integer i_n;
    integer i_jx;
    integer i_jy;
    integer i_nb;
    VALUE ry;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }
    if ((TYPE(jy) != T_BIGNUM) || (TYPE(jy) != T_FIXNUM)) {
      jy = rb_funcall(jy, rb_intern("to_i"), 0);
    }
    if ((TYPE(nb) != T_BIGNUM) || (TYPE(nb) != T_FIXNUM)) {
      nb = rb_funcall(nb, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_jy = NUM2INT(jy);
    i_nb = NUM2INT(nb);
    i_rx = dcl_obj2crealary(rx);

    o_ry= ALLOCA_N(real, i_jy*(i_n-1)+1);

    vrrnm0_(i_rx, o_ry, &i_n, &i_jx, &i_jy, &i_nb);

    {int array_shape[1] = {i_jy*(i_n-1)+1};
     ry = dcl_crealary2obj(o_ry, i_jy*(i_n-1)+1, 1, array_shape);
    }

    dcl_freecrealary(i_rx);

    return ry;

}

static VALUE
dcl_vrrnm1(obj, rx, n, jx, jy, nb)
    VALUE obj, rx, n, jx, jy, nb;
{
    real *i_rx;
    real *o_ry;
    integer i_n;
    integer i_jx;
    integer i_jy;
    integer i_nb;
    VALUE ry;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }
    if ((TYPE(jy) != T_BIGNUM) || (TYPE(jy) != T_FIXNUM)) {
      jy = rb_funcall(jy, rb_intern("to_i"), 0);
    }
    if ((TYPE(nb) != T_BIGNUM) || (TYPE(nb) != T_FIXNUM)) {
      nb = rb_funcall(nb, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_jy = NUM2INT(jy);
    i_nb = NUM2INT(nb);
    i_rx = dcl_obj2crealary(rx);

    o_ry= ALLOCA_N(real, i_jx*(i_n-1)+1);

    vrrnm1_(i_rx, o_ry, &i_n, &i_jx, &i_jy, &i_nb);

    {int array_shape[1] = {i_jx*(i_n-1)+1};
     ry = dcl_crealary2obj(o_ry, i_jx*(i_n-1)+1, 1, array_shape);
    }

    dcl_freecrealary(i_rx);

    return ry;

}
void
init_math2_rnmlib(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "vrrnm", dcl_vrrnm, 5);
    rb_define_module_function(mDCL, "vrrnm0", dcl_vrrnm0, 5);
    rb_define_module_function(mDCL, "vrrnm1", dcl_vrrnm1, 5);
}
