/*
 * $Id: p_header,v 1.3 2015/03/18 03:27:42 horinout Exp $
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"
#include "cdcl.h"

/* for compatibility with ruby 1.6 */
#ifndef StringValuePtr
#define StringValuePtr(s) STR2CSTR(s)
#endif

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return real */
/* fnclib */
extern real rd2r_(real *);
extern real rr2d_(real *);
extern real rexp_(real *, integer *, integer *);
extern real rfpi_(void);
extern real rmod_(real *, real *);
/* gnmlib */
extern real rgnlt_(real *);
extern real rgnle_(real *);
extern real rgngt_(real *);
extern real rgnge_(real *);
/* rfalib */
extern real rmax_(real *, integer *, integer *);
extern real rmin_(real *, integer *, integer *);
extern real rsum_(real *, integer *, integer *);
extern real rave_(real *, integer *, integer *);
extern real rvar_(real *, integer *, integer *);
extern real rstd_(real *, integer *, integer *);
extern real rrms_(real *, integer *, integer *);
extern real ramp_(real *, integer *, integer *);
/* rfblib */
extern real rprd_(real *, real *, integer *, integer *, integer *);
extern real rcov_(real *, real *, integer *, integer *, integer *);
extern real rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

static VALUE
dcl_lreq(obj, x, y)
    VALUE obj, x, y;
{
    real i_x;
    real i_y;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);


    o_rtn_val = lreq_(&i_x, &i_y);

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_lreq0(obj, x, y)
    VALUE obj, x, y;
{
    real i_x;
    real i_y;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);


    o_rtn_val = lreq0_(&i_x, &i_y);

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_lreq1(obj, x, y)
    VALUE obj, x, y;
{
    real i_x;
    real i_y;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);


    o_rtn_val = lreq1_(&i_x, &i_y);

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_lreqa(obj, x, y, epsl)
    VALUE obj, x, y, epsl;
{
    real i_x;
    real i_y;
    real i_epsl;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }
    if (TYPE(epsl) != T_FLOAT) {
      epsl = rb_funcall(epsl, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);
    i_epsl = (real)NUM2DBL(epsl);


    o_rtn_val = lreqa_(&i_x, &i_y, &i_epsl);

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_lrne(obj, x, y)
    VALUE obj, x, y;
{
    real i_x;
    real i_y;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);


    o_rtn_val = lrne_(&i_x, &i_y);

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_lrne0(obj, x, y)
    VALUE obj, x, y;
{
    real i_x;
    real i_y;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);


    o_rtn_val = lrne0_(&i_x, &i_y);

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_lrne1(obj, x, y)
    VALUE obj, x, y;
{
    real i_x;
    real i_y;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);


    o_rtn_val = lrne1_(&i_x, &i_y);

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_lrnea(obj, x, y, epsl)
    VALUE obj, x, y, epsl;
{
    real i_x;
    real i_y;
    real i_epsl;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }
    if (TYPE(epsl) != T_FLOAT) {
      epsl = rb_funcall(epsl, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);
    i_epsl = (real)NUM2DBL(epsl);


    o_rtn_val = lrnea_(&i_x, &i_y, &i_epsl);

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_lrlt(obj, x, y)
    VALUE obj, x, y;
{
    real i_x;
    real i_y;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);


    o_rtn_val = lrlt_(&i_x, &i_y);

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_lrlt0(obj, x, y)
    VALUE obj, x, y;
{
    real i_x;
    real i_y;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);


    o_rtn_val = lrlt0_(&i_x, &i_y);

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_lrlt1(obj, x, y)
    VALUE obj, x, y;
{
    real i_x;
    real i_y;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);


    o_rtn_val = lrlt1_(&i_x, &i_y);

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_lrlta(obj, x, y, epsl)
    VALUE obj, x, y, epsl;
{
    real i_x;
    real i_y;
    real i_epsl;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }
    if (TYPE(epsl) != T_FLOAT) {
      epsl = rb_funcall(epsl, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);
    i_epsl = (real)NUM2DBL(epsl);


    o_rtn_val = lrlta_(&i_x, &i_y, &i_epsl);

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_lrgt(obj, x, y)
    VALUE obj, x, y;
{
    real i_x;
    real i_y;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);


    o_rtn_val = lrgt_(&i_x, &i_y);

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_lrgt0(obj, x, y)
    VALUE obj, x, y;
{
    real i_x;
    real i_y;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);


    o_rtn_val = lrgt0_(&i_x, &i_y);

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_lrgt1(obj, x, y)
    VALUE obj, x, y;
{
    real i_x;
    real i_y;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);


    o_rtn_val = lrgt1_(&i_x, &i_y);

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_lrgta(obj, x, y, epsl)
    VALUE obj, x, y, epsl;
{
    real i_x;
    real i_y;
    real i_epsl;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }
    if (TYPE(epsl) != T_FLOAT) {
      epsl = rb_funcall(epsl, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);
    i_epsl = (real)NUM2DBL(epsl);


    o_rtn_val = lrgta_(&i_x, &i_y, &i_epsl);

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_lrle(obj, x, y)
    VALUE obj, x, y;
{
    real i_x;
    real i_y;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);


    o_rtn_val = lrle_(&i_x, &i_y);

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_lrle0(obj, x, y)
    VALUE obj, x, y;
{
    real i_x;
    real i_y;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);


    o_rtn_val = lrle0_(&i_x, &i_y);

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_lrle1(obj, x, y)
    VALUE obj, x, y;
{
    real i_x;
    real i_y;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);


    o_rtn_val = lrle1_(&i_x, &i_y);

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_lrlea(obj, x, y, epsl)
    VALUE obj, x, y, epsl;
{
    real i_x;
    real i_y;
    real i_epsl;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }
    if (TYPE(epsl) != T_FLOAT) {
      epsl = rb_funcall(epsl, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);
    i_epsl = (real)NUM2DBL(epsl);


    o_rtn_val = lrlea_(&i_x, &i_y, &i_epsl);

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_lrge(obj, x, y)
    VALUE obj, x, y;
{
    real i_x;
    real i_y;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);


    o_rtn_val = lrge_(&i_x, &i_y);

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_lrge0(obj, x, y)
    VALUE obj, x, y;
{
    real i_x;
    real i_y;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);


    o_rtn_val = lrge0_(&i_x, &i_y);

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_lrge1(obj, x, y)
    VALUE obj, x, y;
{
    real i_x;
    real i_y;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);


    o_rtn_val = lrge1_(&i_x, &i_y);

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_lrgea(obj, x, y, epsl)
    VALUE obj, x, y, epsl;
{
    real i_x;
    real i_y;
    real i_epsl;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }
    if (TYPE(epsl) != T_FLOAT) {
      epsl = rb_funcall(epsl, rb_intern("to_f"), 0);
    }

    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);
    i_epsl = (real)NUM2DBL(epsl);


    o_rtn_val = lrgea_(&i_x, &i_y, &i_epsl);

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}
void
init_math1_lrllib(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "lreq", dcl_lreq, 2);
    rb_define_module_function(mDCL, "lreq0", dcl_lreq0, 2);
    rb_define_module_function(mDCL, "lreq1", dcl_lreq1, 2);
    rb_define_module_function(mDCL, "lreqa", dcl_lreqa, 3);
    rb_define_module_function(mDCL, "lrne", dcl_lrne, 2);
    rb_define_module_function(mDCL, "lrne0", dcl_lrne0, 2);
    rb_define_module_function(mDCL, "lrne1", dcl_lrne1, 2);
    rb_define_module_function(mDCL, "lrnea", dcl_lrnea, 3);
    rb_define_module_function(mDCL, "lrlt", dcl_lrlt, 2);
    rb_define_module_function(mDCL, "lrlt0", dcl_lrlt0, 2);
    rb_define_module_function(mDCL, "lrlt1", dcl_lrlt1, 2);
    rb_define_module_function(mDCL, "lrlta", dcl_lrlta, 3);
    rb_define_module_function(mDCL, "lrgt", dcl_lrgt, 2);
    rb_define_module_function(mDCL, "lrgt0", dcl_lrgt0, 2);
    rb_define_module_function(mDCL, "lrgt1", dcl_lrgt1, 2);
    rb_define_module_function(mDCL, "lrgta", dcl_lrgta, 3);
    rb_define_module_function(mDCL, "lrle", dcl_lrle, 2);
    rb_define_module_function(mDCL, "lrle0", dcl_lrle0, 2);
    rb_define_module_function(mDCL, "lrle1", dcl_lrle1, 2);
    rb_define_module_function(mDCL, "lrlea", dcl_lrlea, 3);
    rb_define_module_function(mDCL, "lrge", dcl_lrge, 2);
    rb_define_module_function(mDCL, "lrge0", dcl_lrge0, 2);
    rb_define_module_function(mDCL, "lrge1", dcl_lrge1, 2);
    rb_define_module_function(mDCL, "lrgea", dcl_lrgea, 3);
}
