require "test/unit"
require "fileutils"
require "numru/dclext/gtk"
include NumRu


class TestGet < Test::Unit::TestCase
  DUMP_FNAME = ".dclext_test"

  def setup
    @padding = 2

    @width = 15
    @height = 10

    DCL.swlset("lwnd", false)
    DCL.swcset("fname", DUMP_FNAME)
    DCL.swiset("iwidth", @width)
    DCL.swiset("iheight", @height)
    DCL.gropn(4)
  end
  def teardown
    DCL.grcls
    Dir[DUMP_FNAME+"*.png"].each do |fname|
      FileUtils.rm(fname)
    end
  end

  def test_get_gobj
    drawing_area = DCLExt.zgqdrw
    allocation = drawing_area.allocation
    assert_equal @width+@padding*2, allocation.width
    assert_equal @height+@padding*2, allocation.height

    pixmap = DCLExt.zgqpmp
    size = pixmap.size
    assert_equal @width+@padding*2, size[0]
    assert_equal @height+@padding*2, size[1]
  end

end

