/*
 * $Id: p_header,v 1.3 2015/03/18 03:27:42 horinout Exp $
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"
#include "cdcl.h"

/* for compatibility with ruby 1.6 */
#ifndef StringValuePtr
#define StringValuePtr(s) STR2CSTR(s)
#endif

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return real */
/* fnclib */
extern real rd2r_(real *);
extern real rr2d_(real *);
extern real rexp_(real *, integer *, integer *);
extern real rfpi_(void);
extern real rmod_(real *, real *);
/* gnmlib */
extern real rgnlt_(real *);
extern real rgnle_(real *);
extern real rgngt_(real *);
extern real rgnge_(real *);
/* rfalib */
extern real rmax_(real *, integer *, integer *);
extern real rmin_(real *, integer *, integer *);
extern real rsum_(real *, integer *, integer *);
extern real rave_(real *, integer *, integer *);
extern real rvar_(real *, integer *, integer *);
extern real rstd_(real *, integer *, integer *);
extern real rrms_(real *, integer *, integer *);
extern real ramp_(real *, integer *, integer *);
/* rfblib */
extern real rprd_(real *, real *, integer *, integer *, integer *);
extern real rcov_(real *, real *, integer *, integer *, integer *);
extern real rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

#if DCLVER >= 544

static VALUE
dcl_uipdat(obj, z, mx, nx, ny)
    VALUE obj, z, mx, nx, ny;
{
    real *i_z;
    integer i_mx;
    integer i_nx;
    integer i_ny;

    if (TYPE(z) == T_FLOAT) {
      z = rb_Array(z);
    }
    /* if ((TYPE(z) != T_ARRAY) && 
           (rb_obj_is_kind_of(z, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(mx) != T_BIGNUM) || (TYPE(mx) != T_FIXNUM)) {
      mx = rb_funcall(mx, rb_intern("to_i"), 0);
    }
    if ((TYPE(nx) != T_BIGNUM) || (TYPE(nx) != T_FIXNUM)) {
      nx = rb_funcall(nx, rb_intern("to_i"), 0);
    }
    if ((TYPE(ny) != T_BIGNUM) || (TYPE(ny) != T_FIXNUM)) {
      ny = rb_funcall(ny, rb_intern("to_i"), 0);
    }

    i_mx = NUM2INT(mx);
    i_nx = NUM2INT(nx);
    i_ny = NUM2INT(ny);
    i_z = dcl_obj2crealary(z);


    uipdat_(i_z, &i_mx, &i_nx, &i_ny);

    dcl_freecrealary(i_z);

    return Qnil;

}

static VALUE
dcl_uipda2(obj, u, v, mx, nx, ny)
    VALUE obj, u, v, mx, nx, ny;
{
    real *i_u;
    real *i_v;
    integer i_mx;
    integer i_nx;
    integer i_ny;

    if (TYPE(u) == T_FLOAT) {
      u = rb_Array(u);
    }
    /* if ((TYPE(u) != T_ARRAY) && 
           (rb_obj_is_kind_of(u, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(v) == T_FLOAT) {
      v = rb_Array(v);
    }
    /* if ((TYPE(v) != T_ARRAY) && 
           (rb_obj_is_kind_of(v, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(mx) != T_BIGNUM) || (TYPE(mx) != T_FIXNUM)) {
      mx = rb_funcall(mx, rb_intern("to_i"), 0);
    }
    if ((TYPE(nx) != T_BIGNUM) || (TYPE(nx) != T_FIXNUM)) {
      nx = rb_funcall(nx, rb_intern("to_i"), 0);
    }
    if ((TYPE(ny) != T_BIGNUM) || (TYPE(ny) != T_FIXNUM)) {
      ny = rb_funcall(ny, rb_intern("to_i"), 0);
    }

    i_mx = NUM2INT(mx);
    i_nx = NUM2INT(nx);
    i_ny = NUM2INT(ny);
    i_u = dcl_obj2crealary(u);
    i_v = dcl_obj2crealary(v);


    uipda2_(i_u, i_v, &i_mx, &i_nx, &i_ny);

    dcl_freecrealary(i_u);
    dcl_freecrealary(i_v);

    return Qnil;

}

static VALUE
dcl_uipda3(obj, u, v, w, mx, nx, ny)
    VALUE obj, u, v, w, mx, nx, ny;
{
    real *i_u;
    real *i_v;
    real *i_w;
    integer i_mx;
    integer i_nx;
    integer i_ny;

    if (TYPE(u) == T_FLOAT) {
      u = rb_Array(u);
    }
    /* if ((TYPE(u) != T_ARRAY) && 
           (rb_obj_is_kind_of(u, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(v) == T_FLOAT) {
      v = rb_Array(v);
    }
    /* if ((TYPE(v) != T_ARRAY) && 
           (rb_obj_is_kind_of(v, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(w) == T_FLOAT) {
      w = rb_Array(w);
    }
    /* if ((TYPE(w) != T_ARRAY) && 
           (rb_obj_is_kind_of(w, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(mx) != T_BIGNUM) || (TYPE(mx) != T_FIXNUM)) {
      mx = rb_funcall(mx, rb_intern("to_i"), 0);
    }
    if ((TYPE(nx) != T_BIGNUM) || (TYPE(nx) != T_FIXNUM)) {
      nx = rb_funcall(nx, rb_intern("to_i"), 0);
    }
    if ((TYPE(ny) != T_BIGNUM) || (TYPE(ny) != T_FIXNUM)) {
      ny = rb_funcall(ny, rb_intern("to_i"), 0);
    }

    i_mx = NUM2INT(mx);
    i_nx = NUM2INT(nx);
    i_ny = NUM2INT(ny);
    i_u = dcl_obj2crealary(u);
    i_v = dcl_obj2crealary(v);
    i_w = dcl_obj2crealary(w);


    uipda3_(i_u, i_v, i_w, &i_mx, &i_nx, &i_ny);

    dcl_freecrealary(i_u);
    dcl_freecrealary(i_v);
    dcl_freecrealary(i_w);

    return Qnil;

}

static VALUE
dcl_uiscrg(obj, zmin, zmax)
    VALUE obj, zmin, zmax;
{
    real i_zmin;
    real i_zmax;

    if (TYPE(zmin) != T_FLOAT) {
      zmin = rb_funcall(zmin, rb_intern("to_f"), 0);
    }
    if (TYPE(zmax) != T_FLOAT) {
      zmax = rb_funcall(zmax, rb_intern("to_f"), 0);
    }

    i_zmin = (real)NUM2DBL(zmin);
    i_zmax = (real)NUM2DBL(zmax);


    uiscrg_(&i_zmin, &i_zmax);

    return Qnil;

}

static VALUE
dcl_uismrg(obj, zmin, zmax)
    VALUE obj, zmin, zmax;
{
    real i_zmin;
    real i_zmax;

    if (TYPE(zmin) != T_FLOAT) {
      zmin = rb_funcall(zmin, rb_intern("to_f"), 0);
    }
    if (TYPE(zmax) != T_FLOAT) {
      zmax = rb_funcall(zmax, rb_intern("to_f"), 0);
    }

    i_zmin = (real)NUM2DBL(zmin);
    i_zmax = (real)NUM2DBL(zmax);


    uismrg_(&i_zmin, &i_zmax);

    return Qnil;

}

static VALUE
dcl_uiscsq(obj, clrlvl, icolor, n)
    VALUE obj, clrlvl, icolor, n;
{
    real *i_clrlvl;
    integer *i_icolor;
    integer i_n;

    if (TYPE(clrlvl) == T_FLOAT) {
      clrlvl = rb_Array(clrlvl);
    }
    /* if ((TYPE(clrlvl) != T_ARRAY) && 
           (rb_obj_is_kind_of(clrlvl, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(icolor) == T_BIGNUM) || (TYPE(icolor) == T_FIXNUM)) {
      icolor = rb_Array(icolor);
    }
    /* if ((TYPE(icolor) != T_ARRAY) && 
           (rb_obj_is_kind_of(icolor, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_clrlvl = dcl_obj2crealary(clrlvl);
    i_icolor = dcl_obj2cintegerary(icolor);


    uiscsq_(i_clrlvl, i_icolor, &i_n);

    dcl_freecrealary(i_clrlvl);
    dcl_freecintegerary(i_icolor);

    return Qnil;

}

static VALUE
dcl_uiscfl(obj, cdsn)
    VALUE obj, cdsn;
{
    char *i_cdsn;

    if (TYPE(cdsn) != T_STRING) {
      cdsn = rb_funcall(cdsn, rb_intern("to_str"), 0);
    }

    i_cdsn = StringValuePtr(cdsn);


    uiscfl_(i_cdsn, (ftnlen)strlen(i_cdsn));

    return Qnil;

}

static VALUE
dcl_uismsq(obj, shdlvl, shade, n)
    VALUE obj, shdlvl, shade, n;
{
    real *i_shdlvl;
    integer *i_shade;
    integer i_n;

    if (TYPE(shdlvl) == T_FLOAT) {
      shdlvl = rb_Array(shdlvl);
    }
    /* if ((TYPE(shdlvl) != T_ARRAY) && 
           (rb_obj_is_kind_of(shdlvl, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(shade) == T_BIGNUM) || (TYPE(shade) == T_FIXNUM)) {
      shade = rb_Array(shade);
    }
    /* if ((TYPE(shade) != T_ARRAY) && 
           (rb_obj_is_kind_of(shade, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_shdlvl = dcl_obj2crealary(shdlvl);
    i_shade = dcl_obj2cintegerary(shade);


    uismsq_(i_shdlvl, i_shade, &i_n);

    dcl_freecrealary(i_shdlvl);
    dcl_freecintegerary(i_shade);

    return Qnil;

}

static VALUE
dcl_uismfl(obj, cdsn)
    VALUE obj, cdsn;
{
    char *i_cdsn;

    if (TYPE(cdsn) != T_STRING) {
      cdsn = rb_funcall(cdsn, rb_intern("to_str"), 0);
    }

    i_cdsn = StringValuePtr(cdsn);


    uismfl_(i_cdsn, (ftnlen)strlen(i_cdsn));

    return Qnil;

}

static VALUE
dcl_uixbar(obj, xmin, xmax, ymin, ymax, zmin, zmax, cpos)
    VALUE obj, xmin, xmax, ymin, ymax, zmin, zmax, cpos;
{
    real i_xmin;
    real i_xmax;
    real i_ymin;
    real i_ymax;
    real i_zmin;
    real i_zmax;
    char *i_cpos;

    if (TYPE(xmin) != T_FLOAT) {
      xmin = rb_funcall(xmin, rb_intern("to_f"), 0);
    }
    if (TYPE(xmax) != T_FLOAT) {
      xmax = rb_funcall(xmax, rb_intern("to_f"), 0);
    }
    if (TYPE(ymin) != T_FLOAT) {
      ymin = rb_funcall(ymin, rb_intern("to_f"), 0);
    }
    if (TYPE(ymax) != T_FLOAT) {
      ymax = rb_funcall(ymax, rb_intern("to_f"), 0);
    }
    if (TYPE(zmin) != T_FLOAT) {
      zmin = rb_funcall(zmin, rb_intern("to_f"), 0);
    }
    if (TYPE(zmax) != T_FLOAT) {
      zmax = rb_funcall(zmax, rb_intern("to_f"), 0);
    }
    if (TYPE(cpos) != T_STRING) {
      cpos = rb_funcall(cpos, rb_intern("to_str"), 0);
    }

    i_xmin = (real)NUM2DBL(xmin);
    i_xmax = (real)NUM2DBL(xmax);
    i_ymin = (real)NUM2DBL(ymin);
    i_ymax = (real)NUM2DBL(ymax);
    i_zmin = (real)NUM2DBL(zmin);
    i_zmax = (real)NUM2DBL(zmax);
    i_cpos = StringValuePtr(cpos);


    uixbar_(&i_xmin, &i_xmax, &i_ymin, &i_ymax, &i_zmin, &i_zmax, i_cpos, (ftnlen)strlen(i_cpos));

    return Qnil;

}

static VALUE
dcl_uiybar(obj, xmin, xmax, ymin, ymax, zmin, zmax, cpos)
    VALUE obj, xmin, xmax, ymin, ymax, zmin, zmax, cpos;
{
    real i_xmin;
    real i_xmax;
    real i_ymin;
    real i_ymax;
    real i_zmin;
    real i_zmax;
    char *i_cpos;

    if (TYPE(xmin) != T_FLOAT) {
      xmin = rb_funcall(xmin, rb_intern("to_f"), 0);
    }
    if (TYPE(xmax) != T_FLOAT) {
      xmax = rb_funcall(xmax, rb_intern("to_f"), 0);
    }
    if (TYPE(ymin) != T_FLOAT) {
      ymin = rb_funcall(ymin, rb_intern("to_f"), 0);
    }
    if (TYPE(ymax) != T_FLOAT) {
      ymax = rb_funcall(ymax, rb_intern("to_f"), 0);
    }
    if (TYPE(zmin) != T_FLOAT) {
      zmin = rb_funcall(zmin, rb_intern("to_f"), 0);
    }
    if (TYPE(zmax) != T_FLOAT) {
      zmax = rb_funcall(zmax, rb_intern("to_f"), 0);
    }
    if (TYPE(cpos) != T_STRING) {
      cpos = rb_funcall(cpos, rb_intern("to_str"), 0);
    }

    i_xmin = (real)NUM2DBL(xmin);
    i_xmax = (real)NUM2DBL(xmax);
    i_ymin = (real)NUM2DBL(ymin);
    i_ymax = (real)NUM2DBL(ymax);
    i_zmin = (real)NUM2DBL(zmin);
    i_zmax = (real)NUM2DBL(zmax);
    i_cpos = StringValuePtr(cpos);


    uiybar_(&i_xmin, &i_xmax, &i_ymin, &i_ymax, &i_zmin, &i_zmax, i_cpos, (ftnlen)strlen(i_cpos));

    return Qnil;

}

static VALUE
dcl_uiscr2(obj, umin, umax, vmin, vmax)
    VALUE obj, umin, umax, vmin, vmax;
{
    real i_umin;
    real i_umax;
    real i_vmin;
    real i_vmax;

    if (TYPE(umin) != T_FLOAT) {
      umin = rb_funcall(umin, rb_intern("to_f"), 0);
    }
    if (TYPE(umax) != T_FLOAT) {
      umax = rb_funcall(umax, rb_intern("to_f"), 0);
    }
    if (TYPE(vmin) != T_FLOAT) {
      vmin = rb_funcall(vmin, rb_intern("to_f"), 0);
    }
    if (TYPE(vmax) != T_FLOAT) {
      vmax = rb_funcall(vmax, rb_intern("to_f"), 0);
    }

    i_umin = (real)NUM2DBL(umin);
    i_umax = (real)NUM2DBL(umax);
    i_vmin = (real)NUM2DBL(vmin);
    i_vmax = (real)NUM2DBL(vmax);


    uiscr2_(&i_umin, &i_umax, &i_vmin, &i_vmax);

    return Qnil;

}

static VALUE
dcl_uiqcr2(obj)
    VALUE obj;
{
    real o_umin;
    real o_umax;
    real o_vmin;
    real o_vmax;
    VALUE umin;
    VALUE umax;
    VALUE vmin;
    VALUE vmax;

    uiqcr2_(&o_umin, &o_umax, &o_vmin, &o_vmax);

    umin = rb_float_new((double)o_umin);
    umax = rb_float_new((double)o_umax);
    vmin = rb_float_new((double)o_vmin);
    vmax = rb_float_new((double)o_vmax);


    return rb_ary_new3(4, umin, umax, vmin, vmax);

}

static VALUE
dcl_uiscmp(obj, irgb1, irgb2, irgb3, irgb4)
    VALUE obj, irgb1, irgb2, irgb3, irgb4;
{
    integer i_irgb1;
    integer i_irgb2;
    integer i_irgb3;
    integer i_irgb4;

    if ((TYPE(irgb1) != T_BIGNUM) || (TYPE(irgb1) != T_FIXNUM)) {
      irgb1 = rb_funcall(irgb1, rb_intern("to_i"), 0);
    }
    if ((TYPE(irgb2) != T_BIGNUM) || (TYPE(irgb2) != T_FIXNUM)) {
      irgb2 = rb_funcall(irgb2, rb_intern("to_i"), 0);
    }
    if ((TYPE(irgb3) != T_BIGNUM) || (TYPE(irgb3) != T_FIXNUM)) {
      irgb3 = rb_funcall(irgb3, rb_intern("to_i"), 0);
    }
    if ((TYPE(irgb4) != T_BIGNUM) || (TYPE(irgb4) != T_FIXNUM)) {
      irgb4 = rb_funcall(irgb4, rb_intern("to_i"), 0);
    }

    i_irgb1 = NUM2INT(irgb1);
    i_irgb2 = NUM2INT(irgb2);
    i_irgb3 = NUM2INT(irgb3);
    i_irgb4 = NUM2INT(irgb4);


    uiscmp_(&i_irgb1, &i_irgb2, &i_irgb3, &i_irgb4);

    return Qnil;

}

static VALUE
dcl_uipcmp(obj, xmin, xmax, ymin, ymax, cpos)
    VALUE obj, xmin, xmax, ymin, ymax, cpos;
{
    real i_xmin;
    real i_xmax;
    real i_ymin;
    real i_ymax;
    char *i_cpos;

    if (TYPE(xmin) != T_FLOAT) {
      xmin = rb_funcall(xmin, rb_intern("to_f"), 0);
    }
    if (TYPE(xmax) != T_FLOAT) {
      xmax = rb_funcall(xmax, rb_intern("to_f"), 0);
    }
    if (TYPE(ymin) != T_FLOAT) {
      ymin = rb_funcall(ymin, rb_intern("to_f"), 0);
    }
    if (TYPE(ymax) != T_FLOAT) {
      ymax = rb_funcall(ymax, rb_intern("to_f"), 0);
    }
    if (TYPE(cpos) != T_STRING) {
      cpos = rb_funcall(cpos, rb_intern("to_str"), 0);
    }

    i_xmin = (real)NUM2DBL(xmin);
    i_xmax = (real)NUM2DBL(xmax);
    i_ymin = (real)NUM2DBL(ymin);
    i_ymax = (real)NUM2DBL(ymax);
    i_cpos = StringValuePtr(cpos);


    uipcmp_(&i_xmin, &i_xmax, &i_ymin, &i_ymax, i_cpos, (ftnlen)strlen(i_cpos));

    return Qnil;

}

static VALUE
dcl_uifpac(obj, ir, ig, ib)
    VALUE obj, ir, ig, ib;
{
    integer i_ir;
    integer i_ig;
    integer i_ib;
    integer o_irgb;
    VALUE irgb;

    if ((TYPE(ir) != T_BIGNUM) || (TYPE(ir) != T_FIXNUM)) {
      ir = rb_funcall(ir, rb_intern("to_i"), 0);
    }
    if ((TYPE(ig) != T_BIGNUM) || (TYPE(ig) != T_FIXNUM)) {
      ig = rb_funcall(ig, rb_intern("to_i"), 0);
    }
    if ((TYPE(ib) != T_BIGNUM) || (TYPE(ib) != T_FIXNUM)) {
      ib = rb_funcall(ib, rb_intern("to_i"), 0);
    }

    i_ir = NUM2INT(ir);
    i_ig = NUM2INT(ig);
    i_ib = NUM2INT(ib);


    uifpac_(&i_ir, &i_ig, &i_ib, &o_irgb);

    irgb = INT2NUM(o_irgb);


    return irgb;

}

static VALUE
dcl_uiipac(obj, irgb)
    VALUE obj, irgb;
{
    integer i_irgb;
    integer o_ir;
    integer o_ig;
    integer o_ib;
    VALUE ir;
    VALUE ig;
    VALUE ib;

    if ((TYPE(irgb) != T_BIGNUM) || (TYPE(irgb) != T_FIXNUM)) {
      irgb = rb_funcall(irgb, rb_intern("to_i"), 0);
    }

    i_irgb = NUM2INT(irgb);


    uiipac_(&i_irgb, &o_ir, &o_ig, &o_ib);

    ir = INT2NUM(o_ir);
    ig = INT2NUM(o_ig);
    ib = INT2NUM(o_ib);


    return rb_ary_new3(3, ir, ig, ib);

}

static VALUE
dcl_uiiget(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    integer o_ipara;
    VALUE ipara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    uiiget_(i_cp, &o_ipara, (ftnlen)strlen(i_cp));

    ipara = INT2NUM(o_ipara);


    return ipara;

}

static VALUE
dcl_uiiset(obj, cp, ipara)
    VALUE obj, cp, ipara;
{
    char *i_cp;
    integer i_ipara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }
    if ((TYPE(ipara) != T_BIGNUM) || (TYPE(ipara) != T_FIXNUM)) {
      ipara = rb_funcall(ipara, rb_intern("to_i"), 0);
    }

    i_cp = StringValuePtr(cp);
    i_ipara = NUM2INT(ipara);


    uiiset_(i_cp, &i_ipara, (ftnlen)strlen(i_cp));

    return Qnil;

}

static VALUE
dcl_uiistx(obj, cp, ipara)
    VALUE obj, cp, ipara;
{
    char *i_cp;
    integer i_ipara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }
    if ((TYPE(ipara) != T_BIGNUM) || (TYPE(ipara) != T_FIXNUM)) {
      ipara = rb_funcall(ipara, rb_intern("to_i"), 0);
    }

    i_cp = StringValuePtr(cp);
    i_ipara = NUM2INT(ipara);


    uiistx_(i_cp, &i_ipara, (ftnlen)strlen(i_cp));

    return Qnil;

}

static VALUE
dcl_uiiqnp(obj)
    VALUE obj;
{
    integer o_ncp;
    VALUE ncp;

    uiiqnp_(&o_ncp);

    ncp = INT2NUM(o_ncp);


    return ncp;

}

static VALUE
dcl_uiiqid(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    integer o_idx;
    VALUE idx;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    uiiqid_(i_cp, &o_idx, (ftnlen)strlen(i_cp));

    idx = INT2NUM(o_idx);


    return idx;

}

static VALUE
dcl_uiiqcp(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    char *o_cp;
    VALUE cp;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);

    o_cp= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cp, '\0', DFLT_SIZE+1);

    uiiqcp_(&i_idx, o_cp, (ftnlen)DFLT_SIZE);

    cp = rb_str_new2(o_cp);


    return cp;

}

static VALUE
dcl_uiiqcl(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    char *o_cp;
    VALUE cp;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);

    o_cp= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cp, '\0', DFLT_SIZE+1);

    uiiqcl_(&i_idx, o_cp, (ftnlen)DFLT_SIZE);

    cp = rb_str_new2(o_cp);


    return cp;

}

static VALUE
dcl_uiiqvl(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    integer o_ipara;
    VALUE ipara;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);


    uiiqvl_(&i_idx, &o_ipara);

    ipara = INT2NUM(o_ipara);


    return ipara;

}

static VALUE
dcl_uiisvl(obj, idx, ipara)
    VALUE obj, idx, ipara;
{
    integer i_idx;
    integer i_ipara;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }
    if ((TYPE(ipara) != T_BIGNUM) || (TYPE(ipara) != T_FIXNUM)) {
      ipara = rb_funcall(ipara, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);
    i_ipara = NUM2INT(ipara);


    uiisvl_(&i_idx, &i_ipara);

    return Qnil;

}

static VALUE
dcl_uiiqin(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    integer o_in;
    VALUE in;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    uiiqin_(i_cp, &o_in, (ftnlen)strlen(i_cp));

    in = INT2NUM(o_in);


    return in;

}

static VALUE
dcl_uilget(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    logical o_lpara;
    VALUE lpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    uilget_(i_cp, &o_lpara, (ftnlen)strlen(i_cp));

    lpara = (o_lpara == FALSE_) ? Qfalse : Qtrue;


    return lpara;

}

static VALUE
dcl_uilset(obj, cp, lpara)
    VALUE obj, cp, lpara;
{
    char *i_cp;
    logical i_lpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);
    i_lpara = ((lpara == Qnil)||(lpara == Qfalse)) ? FALSE_ : TRUE_;


    uilset_(i_cp, &i_lpara, (ftnlen)strlen(i_cp));

    return Qnil;

}

static VALUE
dcl_uilstx(obj, cp, lpara)
    VALUE obj, cp, lpara;
{
    char *i_cp;
    logical i_lpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);
    i_lpara = ((lpara == Qnil)||(lpara == Qfalse)) ? FALSE_ : TRUE_;


    uilstx_(i_cp, &i_lpara, (ftnlen)strlen(i_cp));

    return Qnil;

}

static VALUE
dcl_uilqnp(obj)
    VALUE obj;
{
    integer o_ncp;
    VALUE ncp;

    uilqnp_(&o_ncp);

    ncp = INT2NUM(o_ncp);


    return ncp;

}

static VALUE
dcl_uilqid(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    integer o_idx;
    VALUE idx;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    uilqid_(i_cp, &o_idx, (ftnlen)strlen(i_cp));

    idx = INT2NUM(o_idx);


    return idx;

}

static VALUE
dcl_uilqcp(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    char *o_cp;
    VALUE cp;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);

    o_cp= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cp, '\0', DFLT_SIZE+1);

    uilqcp_(&i_idx, o_cp, (ftnlen)DFLT_SIZE);

    cp = rb_str_new2(o_cp);


    return cp;

}

static VALUE
dcl_uilqcl(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    char *o_cp;
    VALUE cp;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);

    o_cp= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cp, '\0', DFLT_SIZE+1);

    uilqcl_(&i_idx, o_cp, (ftnlen)DFLT_SIZE);

    cp = rb_str_new2(o_cp);


    return cp;

}

static VALUE
dcl_uilqvl(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    logical o_lpara;
    VALUE lpara;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);


    uilqvl_(&i_idx, &o_lpara);

    lpara = (o_lpara == FALSE_) ? Qfalse : Qtrue;


    return lpara;

}

static VALUE
dcl_uilsvl(obj, idx, lpara)
    VALUE obj, idx, lpara;
{
    integer i_idx;
    logical i_lpara;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);
    i_lpara = ((lpara == Qnil)||(lpara == Qfalse)) ? FALSE_ : TRUE_;


    uilsvl_(&i_idx, &i_lpara);

    return Qnil;

}

static VALUE
dcl_uilqin(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    integer o_in;
    VALUE in;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    uilqin_(i_cp, &o_in, (ftnlen)strlen(i_cp));

    in = INT2NUM(o_in);


    return in;

}

static VALUE
dcl_uirget(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    real o_rpara;
    VALUE rpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    uirget_(i_cp, &o_rpara, (ftnlen)strlen(i_cp));

    rpara = rb_float_new((double)o_rpara);


    return rpara;

}

static VALUE
dcl_uirset(obj, cp, rpara)
    VALUE obj, cp, rpara;
{
    char *i_cp;
    real i_rpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }
    if (TYPE(rpara) != T_FLOAT) {
      rpara = rb_funcall(rpara, rb_intern("to_f"), 0);
    }

    i_cp = StringValuePtr(cp);
    i_rpara = (real)NUM2DBL(rpara);


    uirset_(i_cp, &i_rpara, (ftnlen)strlen(i_cp));

    return Qnil;

}

static VALUE
dcl_uirstx(obj, cp, rpara)
    VALUE obj, cp, rpara;
{
    char *i_cp;
    real i_rpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }
    if (TYPE(rpara) != T_FLOAT) {
      rpara = rb_funcall(rpara, rb_intern("to_f"), 0);
    }

    i_cp = StringValuePtr(cp);
    i_rpara = (real)NUM2DBL(rpara);


    uirstx_(i_cp, &i_rpara, (ftnlen)strlen(i_cp));

    return Qnil;

}

static VALUE
dcl_uirqnp(obj)
    VALUE obj;
{
    integer o_ncp;
    VALUE ncp;

    uirqnp_(&o_ncp);

    ncp = INT2NUM(o_ncp);


    return ncp;

}

static VALUE
dcl_uirqid(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    integer o_idx;
    VALUE idx;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    uirqid_(i_cp, &o_idx, (ftnlen)strlen(i_cp));

    idx = INT2NUM(o_idx);


    return idx;

}

static VALUE
dcl_uirqcp(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    char *o_cp;
    VALUE cp;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);

    o_cp= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cp, '\0', DFLT_SIZE+1);

    uirqcp_(&i_idx, o_cp, (ftnlen)DFLT_SIZE);

    cp = rb_str_new2(o_cp);


    return cp;

}

static VALUE
dcl_uirqcl(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    char *o_cp;
    VALUE cp;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);

    o_cp= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cp, '\0', DFLT_SIZE+1);

    uirqcl_(&i_idx, o_cp, (ftnlen)DFLT_SIZE);

    cp = rb_str_new2(o_cp);


    return cp;

}

static VALUE
dcl_uirqvl(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    real o_rpara;
    VALUE rpara;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);


    uirqvl_(&i_idx, &o_rpara);

    rpara = rb_float_new((double)o_rpara);


    return rpara;

}

static VALUE
dcl_uirsvl(obj, idx, rpara)
    VALUE obj, idx, rpara;
{
    integer i_idx;
    real i_rpara;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }
    if (TYPE(rpara) != T_FLOAT) {
      rpara = rb_funcall(rpara, rb_intern("to_f"), 0);
    }

    i_idx = NUM2INT(idx);
    i_rpara = (real)NUM2DBL(rpara);


    uirsvl_(&i_idx, &i_rpara);

    return Qnil;

}

static VALUE
dcl_uirqin(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    integer o_in;
    VALUE in;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = StringValuePtr(cp);


    uirqin_(i_cp, &o_in, (ftnlen)strlen(i_cp));

    in = INT2NUM(o_in);


    return in;

}

static VALUE
dcl_uiqfnm(obj, cpara)
    VALUE obj, cpara;
{
    char *i_cpara;
    char *o_cfname;
    VALUE cfname;

    if (TYPE(cpara) != T_STRING) {
      cpara = rb_funcall(cpara, rb_intern("to_str"), 0);
    }

    i_cpara = StringValuePtr(cpara);

    o_cfname= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cfname, '\0', DFLT_SIZE+1);

    uiqfnm_(i_cpara, o_cfname, (ftnlen)strlen(i_cpara), (ftnlen)DFLT_SIZE);

    cfname = rb_str_new2(o_cfname);


    return cfname;

}

#endif
void
init_grph2_uipack(mDCL)
VALUE mDCL;
{
#if DCLVER >= 544
    rb_define_module_function(mDCL, "uipdat", dcl_uipdat, 4);
    rb_define_module_function(mDCL, "uipda2", dcl_uipda2, 5);
    rb_define_module_function(mDCL, "uipda3", dcl_uipda3, 6);
    rb_define_module_function(mDCL, "uiscrg", dcl_uiscrg, 2);
    rb_define_module_function(mDCL, "uismrg", dcl_uismrg, 2);
    rb_define_module_function(mDCL, "uiscsq", dcl_uiscsq, 3);
    rb_define_module_function(mDCL, "uiscfl", dcl_uiscfl, 1);
    rb_define_module_function(mDCL, "uismsq", dcl_uismsq, 3);
    rb_define_module_function(mDCL, "uismfl", dcl_uismfl, 1);
    rb_define_module_function(mDCL, "uixbar", dcl_uixbar, 7);
    rb_define_module_function(mDCL, "uiybar", dcl_uiybar, 7);
    rb_define_module_function(mDCL, "uiscr2", dcl_uiscr2, 4);
    rb_define_module_function(mDCL, "uiqcr2", dcl_uiqcr2, 0);
    rb_define_module_function(mDCL, "uiscmp", dcl_uiscmp, 4);
    rb_define_module_function(mDCL, "uipcmp", dcl_uipcmp, 5);
    rb_define_module_function(mDCL, "uifpac", dcl_uifpac, 3);
    rb_define_module_function(mDCL, "uiipac", dcl_uiipac, 1);
    rb_define_module_function(mDCL, "uiiget", dcl_uiiget, 1);
    rb_define_module_function(mDCL, "uiiset", dcl_uiiset, 2);
    rb_define_module_function(mDCL, "uiistx", dcl_uiistx, 2);
    rb_define_module_function(mDCL, "uiiqnp", dcl_uiiqnp, 0);
    rb_define_module_function(mDCL, "uiiqid", dcl_uiiqid, 1);
    rb_define_module_function(mDCL, "uiiqcp", dcl_uiiqcp, 1);
    rb_define_module_function(mDCL, "uiiqcl", dcl_uiiqcl, 1);
    rb_define_module_function(mDCL, "uiiqvl", dcl_uiiqvl, 1);
    rb_define_module_function(mDCL, "uiisvl", dcl_uiisvl, 2);
    rb_define_module_function(mDCL, "uiiqin", dcl_uiiqin, 1);
    rb_define_module_function(mDCL, "uilget", dcl_uilget, 1);
    rb_define_module_function(mDCL, "uilset", dcl_uilset, 2);
    rb_define_module_function(mDCL, "uilstx", dcl_uilstx, 2);
    rb_define_module_function(mDCL, "uilqnp", dcl_uilqnp, 0);
    rb_define_module_function(mDCL, "uilqid", dcl_uilqid, 1);
    rb_define_module_function(mDCL, "uilqcp", dcl_uilqcp, 1);
    rb_define_module_function(mDCL, "uilqcl", dcl_uilqcl, 1);
    rb_define_module_function(mDCL, "uilqvl", dcl_uilqvl, 1);
    rb_define_module_function(mDCL, "uilsvl", dcl_uilsvl, 2);
    rb_define_module_function(mDCL, "uilqin", dcl_uilqin, 1);
    rb_define_module_function(mDCL, "uirget", dcl_uirget, 1);
    rb_define_module_function(mDCL, "uirset", dcl_uirset, 2);
    rb_define_module_function(mDCL, "uirstx", dcl_uirstx, 2);
    rb_define_module_function(mDCL, "uirqnp", dcl_uirqnp, 0);
    rb_define_module_function(mDCL, "uirqid", dcl_uirqid, 1);
    rb_define_module_function(mDCL, "uirqcp", dcl_uirqcp, 1);
    rb_define_module_function(mDCL, "uirqcl", dcl_uirqcl, 1);
    rb_define_module_function(mDCL, "uirqvl", dcl_uirqvl, 1);
    rb_define_module_function(mDCL, "uirsvl", dcl_uirsvl, 2);
    rb_define_module_function(mDCL, "uirqin", dcl_uirqin, 1);
    rb_define_module_function(mDCL, "uiqfnm", dcl_uiqfnm, 1);
#endif
}
