# ACL2 scripts for "ACL2 Proofs of Nonlinear Inequalities with Imandra" by Passmore

This archive contains ACL2 proof scripts automatically generated by our Imandra-ACL2 interface
described in our ACL2-2023 submission "ACL2 Proofs of Nonlinear Inequalities with Imandra."

To check each proof, you can `ld` it into ACL2 and then execute `:pf FINAL` to see the proved
theorem. For each example given in the paper, there is a corresponding `probN.lisp` file, where
`N` is determined by the order in which the problems are listed in the paper.

The theorems (taken over R) are:

- prob0:
  ```
  (IMPLIES (= (+ (* A X X) (* B X) C) 0)
           (>= (- (* B B) (* 4 A C)) 0))
  ```

- prob1:
  ```
  (IMPLIES (= (+ (* x x) (* y y) (* z z)) 1)
           (<= (* (+ x y z) (+ x y z)) 3))
  ```
  
- prob2:
  ```
  (IMPLIES (= (+ (* w w) (* x x) (* y y) (* z z)) 1)
           (<= (* (+ w x y z) (+ w x y z)) 4))
  ```

- prob3:
  ```
  (IMPLIES (AND (<= 0 x) (<= 0 y) (= (* x y) 1))
           (<= (+ x y) (+ (* x x) (* y y))))
  ```

- prob4:
  ```
  (IMPLIES (AND (>= x 1) (>= y 1)) (>= (* x y) (- (+ x y) 1)))
  ```
  
- prob5:
  ```
  (IMPLIES (AND (<= 0 x) (<= 0 y))
           (<= (* x y (expt (+ x y) 2))
               (expt (+ (* x x) (* y y)) 2)))
  ```
  
- prob6:
  ```
  (IMPLIES (AND (<= 0 a)
                (<= 0 b)
                (<= 0 c)
                (<= (* c (EXPT (+ (* 2 a) b) 3)) (* 27 x)))
           (<= (* c a a b) x))
  ```

- prob7:
  ```
  (>= (+ (EXPT x 6)
         (EXPT y 6) (EXPT z 6) (- 0 (* 3 x x y y z z)))
       0)
  ```

- prob8:
  ```
  (>= (+ (EXPT x 4) (EXPT y 4) (EXPT z 4) 1 (- 0 (* 4 x y z)))
      0)
  ```

# Installing Imandra

See our Imandra docs at docs.imandra.ai, in particular the Installation Instructions.

# Questions?

You can reach me at grant@imandra.ai. I'm also happy to try any additional problems you can
send my way!

Many thanks,
Grant

