{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetSeparate: Boolean;
    procedure SetSeparate(const Value: Boolean);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;
    class function ForVRMLVersion(const Version: TX3DVersion): Boolean; override;

    strict private FFdSeparate: TSFBool;
    { Internal wrapper for property @code(Separate). This wrapper API may change, we advise to access simpler @code(Separate) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSeparate: TSFBool read FFdSeparate;
    {  }
    property Separate: Boolean read GetSeparate write SetSeparate;

{$endif read_interface}

{$ifdef read_implementation}

{ TWWWInlineNode_1 ----------------------------------------------- }

function TWWWInlineNode_1.GetSeparate: Boolean;
begin
  Result := FdSeparate.Value;
end;

procedure TWWWInlineNode_1.SetSeparate(const Value: Boolean);
begin
  FdSeparate.Send(Value);
end;

class function TWWWInlineNode_1.ForVRMLVersion(const Version: TX3DVersion): Boolean;
begin
  Result := Version.Major <= 1; // parse this node only in VRML 1.0 and Inventor files
end;

class function TWWWInlineNode_1.ClassX3DType: String;
begin
  Result := 'WWWInline';
end;

procedure TWWWInlineNode_1.CreateNode;
begin
  inherited;

  FFdSeparate := TSFBool.Create(Self, True, 'separate', true);
   FdSeparate.ChangeAlways := chEverything;
  AddField(FFdSeparate);
end;

{$endif read_implementation}
