/*
  This file is part of CDO. CDO is a collection of Operators to
  manipulate and analyse Climate model Data.

  Copyright (C) 2003-2020 Uwe Schulzweida, <uwe.schulzweida AT mpimet.mpg.de>
  See COPYING file for copying and redistribution conditions.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
*/

#ifndef FILESTREAM_H
#define FILESTREAM_H

#include <string>
#include "cdoStream.h"

class FileStream : public CdoStream
{
public:
  // Constructors
  FileStream(const std::string &p_fileStream);
  // ---

  // CdoStream Interface functions
  int openRead() override;
  int openWrite(int p_filetype) override;
  int openAppend() override;

  int inqVlist() override;
  void defVlist(int p_vlistID) override;

  void inqRecord(int *varID, int *levelID) override;
  void defRecord(int varID, int levelID) override;

  void readRecord(float *p_data, size_t *nmiss) override;
  void readRecord(double *p_data, size_t *nmiss) override;
  void readRecord(Field *p_field, size_t *nmiss) override;

  void writeRecord(float *p_data, size_t nmiss) override;
  void writeRecord(double *p_data, size_t nmiss) override;
  void writeRecord(Field *p_field, size_t nmiss) override;

  void copyRecord(CdoStreamID p_fileStream) override;

  int inqTimestep(int tsID) override;
  void defTimestep(int tsID) override;

  int inqFileType() override;
  int inqByteorder() override;

  void close() override;

  size_t getNvals() override;
  // ---

  // FileStreamOnly
  int getFileID();
  static void
  enableTimers(const bool p_enable)
  {
    FileStream::TimerEnabled = p_enable;
  }
  static bool
  timersEnabled()
  {
    return FileStream::TimerEnabled;
  }
  // ---

protected:
  static bool TimerEnabled;

private:
  FileStream() = delete;
  std::string m_filename;
  void checkDatarange(int varID, double *array, size_t nmiss);
};

#endif
