# Float32, Float64

[Числа с плавающей запятой](https://en.wikipedia.org/wiki/IEEE_754).

Типы эквивалентны типам языка С:

- `Float32` - `float`;
- `Float64` - `double`.

Рекомендуется хранить данные в целочисленноми виде всегда, когда это возможно. Например, переводите в целочисленные значения числа с фиксированной точностью, такие как денежные суммы или времена загрузки страниц в миллисекундах.

## Особенности использования чисел с плавающей запятой

- При вычислениях с числами с плавающей запятой возможна ошибка округления.

``` sql
SELECT 1 - 0.9
```
```
┌───────minus(1, 0.9)─┐
│ 0.09999999999999998 │
└─────────────────────┘
```

- Результат вычисления зависит от метода вычисления (типа процессора и архитектуры вычислительной системы).
- При вычислениях с плавающей запятой возможно появление таких категорий числа как бесконечность (`Inf`) и "не число" (`NaN`). Это необходимо учитывать при обработке результатов вычислений.
- При чтении чисел с плавающей запятой из строк, в качестве результата может быть получено не обязательно ближайшее машинно-представимое число.
 
## NaN и Inf

В отличие от стандартного SQL, ClickHouse поддерживает следующие категории чисел с плавающей запятой:

- `Inf` - бесконечность.

``` sql
SELECT 0.5 / 0
```

```
┌─divide(0.5, 0)─┐
│            inf │
└────────────────┘
```

- `-Inf` - отрицательная бесконечность;

``` sql
SELECT -0.5 / 0
```

```
┌─divide(-0.5, 0)─┐
│            -inf │
└─────────────────┘
```

- `NaN` - не число.

```
SELECT 0 / 0
```
```
┌─divide(0, 0)─┐
│          nan │
└──────────────┘
```

  Смотрите правила сортировки `NaN` в разделе [Секция ORDER BY](../query_language/select.md).

[Оригинальная статья](https://clickhouse.yandex/docs/ru/data_types/float/) <!--hide-->
