/*
 * TicketKeeperMenuStateProcotol.h
 *
 * Declarations of types for constants used in the Process-to-Process Communication
 * protocol used between TicketKeeperLib and TicketKeeper. This should not be used
 * by others
 *
 */
 
#ifndef TicketKeeperMenuStateProcotol_h
#define TicketKeeperMenuStateProcotol_h

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

/* Use these to find the PPC port for TicketKeeper */
enum {
	mkPort_Creator = FOUR_CHAR_CODE ('MnuK'),
	mkPort_Type = FOUR_CHAR_CODE ('appe')
};
	
/* Use these on PPC blocks sent to TK. The block type determines what command you are sending */
enum {
	mkBlock_Creator = FOUR_CHAR_CODE ('MnuK'),
	mkBlock_Type_MenuState = FOUR_CHAR_CODE ('Menu'),
	mkBlock_Type_SetDefault	= FOUR_CHAR_CODE ('SDef'),
	mkBlock_Type_Logout	= FOUR_CHAR_CODE ('LotP'),
	mkBlock_Type_LogoutDefault	= FOUR_CHAR_CODE ('Lout'),
	mkBlock_Type_NewLogin	= FOUR_CHAR_CODE ('Logn'),
	mkBlock_Type_Renew	= FOUR_CHAR_CODE ('RnwP'),
	mkBlock_Type_RenewDefault	= FOUR_CHAR_CODE ('Renw'),
	mkBlock_Type_ChangePassword = FOUR_CHAR_CODE ('ChpP'),
	mkBlock_Type_ChangePasswordDefault = FOUR_CHAR_CODE ('Chps'),
	mkBlock_Type_MoveFloaterStructureRegion	= FOUR_CHAR_CODE ('MFst'),
	mkBlock_Type_SetDrawPies	= FOUR_CHAR_CODE ('pie?'),
	mkBlock_Type_SetHasCloseBox	= FOUR_CHAR_CODE ('cls?'),
	mkBlock_Type_SetIsVisible	= FOUR_CHAR_CODE ('vis?'),
	mkBlock_Type_SetIsZoomedOut	= FOUR_CHAR_CODE ('zum?'),
	mkBlock_Type_GetIsVisible = FOUR_CHAR_CODE ('?vis'),
	mkBlock_Type_GetDrawPies = FOUR_CHAR_CODE ('?pie'),
	mkBlock_Type_GetHasCloseBox = FOUR_CHAR_CODE ('?cls'),
	mkBlock_Type_GetIsZoomedOut = FOUR_CHAR_CODE ('?zum'),
	mkBlock_Type_OpenKerberosControlPanel = FOUR_CHAR_CODE ('OKCP')
};

/* Version number for menu state command */
enum {
	mkReply_MenuState_CurrentVersion = 2
};

/*
 * MenuState ('Menu') command returns a blob of data in the following format:
 * (but you should really use the functions in TickerKeeperLib.h to parse it)
 *
 * 	[4 Bytes]	Size of the structure
 * 	[4 Bytes]	Version of the structure (current = 2)
 *
 *	[4 Bytes]	Last change time for the default cache information
 *	[4 Bytes]	Last change time for the cache list information
 *	[4 Bytes]	1 if default cache has valid tickets, 0 otherwise
 * 	[4 bytes]	Expiration time of the default cache in Mac epoch
 *	[PString]	Principal of the default cache
 *  [PString]	Display principal of the default cache (quoting removed)
 *  [PString]	Short display principal of the default cache (quoting and default realm removed)
 *
 *	[4 Bytes]	Number of caches
 *
 *	[4 Bytes]	1 if the first cache is default
 *	[4 Bytes]	Version of the first cache
 *	[4 Bytes]	1 if the first cache has valid tickets
 *	[4 Bytes]	start time of the first cache
 *	[4 Bytes]	expiration time of the first cache
 *	[PString]	Principal of the 1st cache
 *  [PString]	Display principal if the 1st cache (quoting removed)
 *  [PString]	Short display principal if the 1st cache (quoting and default realm removed)
 *
 *	   ...
 *
 *	[4 Bytes]	1 if the last cache is default
 *	[4 Bytes]	Version of the last cache
 *	[4 Bytes]	1 if the last cache has valid tickets
 *	[4 Bytes]	start time of the last cache
 *	[4 Bytes]	expiration time of the last cache
 *	[PString]	Principal of the last cache
 *  [PString]	Display principal if the nth cache (quoting removed)
 *  [PString]	Short display principal if the nth cache (quoting and default realm removed)
 */

struct MenuStateHeader {
	UInt32	version;
	UInt32	defaultCacheLastChangeTime;
	UInt32	cacheListLastChangeTime;
	UInt32	defaultCacheHasValidTickets;
	UInt32	defaultCacheExpiration;
	Str255	defaultCachePrincipal;
};

struct CacheEntry {
	UInt32	isDefault;
	UInt32	version;
	UInt32	isValid;
	UInt32	startTime;
	UInt32	expirationTime;
	Str255	principal;
};

struct CacheList {
	UInt32		numCaches;
	CacheEntry	cacheList;
};

/*
 * SetDefaultPrincipal, Logout, and Renew commands take a blob of data which contains the 
 * new principal to be made default (version + string format)
 */
 
struct PrincipalParam {
	UInt32		version;
	Str255		principal;
};

struct MoveFloaterStructureRegionParam {
	Rect		bounds;
};

typedef PrincipalParam SetDefaultParam;
typedef PrincipalParam LogoutParam;
typedef PrincipalParam RenewParam;
typedef PrincipalParam ChangePasswordParam;

typedef Boolean			SetDrawPiesParam;
typedef Boolean			SetHasCloseBoxParam;
typedef Boolean			SetIsVisibleParam;
typedef Boolean			SetIsZoomedOutParam;

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#endif /* TicketKeeperMenuStateProcotol_h */