.TH LPBANNER 1 2006-12-09 "LPRng" "lpbanner filter"
.SH NAME
lpbanner, pclbanner, psbanner \- printer banners in text, PCL and PostScript
.SH SYNOPSIS
.B lpbanner
[
.BI "\-l " length
] [
.BI "\-w " width
] [
.BI "\-P " printer
] [
.BI "\-L " bannername
] [
.BI "\-n " loginname
] [
.BI "\-h " host
] [
.BI "\-J " jobtitle
] [
.BI "\-C " class
] [
.BI "\-? " option
.BI args
] [
all
]
.SH DESCRIPTION
The
.B lpbanner
program is used to print a simple banner on a fixed size font printer,
the
.B pclbanner
program generates a PCL banner and the
.B psbanner
program generates a PostScript banner.
All information to be printed is passed using command line arguments.
In order to be compatible with vintage line printer spoolers,
reads a line form standard input, but ignores the information.
.SH OPTIONS
.TP 
.BI \-w " width"
Page width in characters (default 132).
.TP 
.BI \-l " length"
Page length in lines (default 60).
.TP 
.BI \-P " printer"
printer queue for banner information.
.TP 
.BI \-L " bannername"
Name used on banner as main name.
.TP 
.BI \-n " loginname"
Name used on banner as login name.
.TP 
.BI \-h " host"
Name used on banner as host name.
.TP 
.BI \-J " jobtitle"
String used on banner as main title.
.TP 
.BI \-C " class"
String used on banner as class.
.TP 
.BI \-? " value"
All other options and arguments provided by LPRng are ignored.
.SH "EXIT STATUS"
.PP
The following exit values are returned:
.TP 15
.B "zero (0)"
Successful completion.
.TP
.B "non-zero (!=0)"
An error occurred.
.SH "SEE ALSO"
.LP
lpd.conf(5),
lpc(8),
lpd(8),
checkpc(8),
lpr(1),
lpq(1),
lprm(1),
printcap(5),
lpd.conf(5),
pr(1), lprng_certs(1), lprng_index_certs(1).
.SH "AUTHOR"
Patrick Powell <papowell@lprng.com>.
.SH "HISTORY"
LPRng is a enhanced printer spooler system
with functionality similar to the Berkeley LPR software.
The LPRng developer mailing list is lprng-devel@lists.sourceforge.net;
subscribe by visiting 
.B https://lists.sourceforge.net/lists/listinfo/lprng-devel
or sending mail to 
.B lprng-request@lists.sourceforge.net
with
the word 
.I subscribe 
in the body.
.br
The software is available via 
.B http://lprng.sourceforge.net
