## API Report File for "@lumino/datagrid"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { IDisposable } from '@lumino/disposable';
import { IIterator } from '@lumino/algorithm';
import { IMessageHandler } from '@lumino/messaging';
import { ISignal } from '@lumino/signaling';
import { Message } from '@lumino/messaging';
import { ReadonlyJSONObject } from '@lumino/coreutils';
import { Widget } from '@lumino/widgets';

// @public
export class BasicKeyHandler implements DataGrid.IKeyHandler {
    dispose(): void;
    readonly isDisposed: boolean;
    protected onArrowDown(grid: DataGrid, event: KeyboardEvent): void;
    protected onArrowLeft(grid: DataGrid, event: KeyboardEvent): void;
    protected onArrowRight(grid: DataGrid, event: KeyboardEvent): void;
    protected onArrowUp(grid: DataGrid, event: KeyboardEvent): void;
    protected onEscape(grid: DataGrid, event: KeyboardEvent): void;
    protected onKeyC(grid: DataGrid, event: KeyboardEvent): void;
    onKeyDown(grid: DataGrid, event: KeyboardEvent): void;
    protected onPageDown(grid: DataGrid, event: KeyboardEvent): void;
    protected onPageUp(grid: DataGrid, event: KeyboardEvent): void;
}

// @public
export class BasicMouseHandler implements DataGrid.IMouseHandler {
    dispose(): void;
    readonly isDisposed: boolean;
    onContextMenu(grid: DataGrid, event: MouseEvent): void;
    onMouseDown(grid: DataGrid, event: MouseEvent): void;
    onMouseHover(grid: DataGrid, event: MouseEvent): void;
    onMouseLeave(grid: DataGrid, event: MouseEvent): void;
    onMouseMove(grid: DataGrid, event: MouseEvent): void;
    onMouseUp(grid: DataGrid, event: MouseEvent): void;
    onWheel(grid: DataGrid, event: WheelEvent): void;
    release(): void;
}

// @public
export class BasicSelectionModel extends SelectionModel {
    clear(): void;
    currentSelection(): SelectionModel.Selection | null;
    readonly cursorColumn: number;
    readonly cursorRow: number;
    readonly isEmpty: boolean;
    protected onDataModelChanged(sender: DataModel, args: DataModel.ChangedArgs): void;
    select(args: SelectionModel.SelectArgs): void;
    selections(): IIterator<SelectionModel.Selection>;
    }

// @public
export abstract class CellRenderer {
    abstract paint(gc: GraphicsContext, config: CellRenderer.CellConfig): void;
}

// @public
export namespace CellRenderer {
    export type CellConfig = {
        readonly x: number;
        readonly y: number;
        readonly height: number;
        readonly width: number;
        readonly region: DataModel.CellRegion;
        readonly row: number;
        readonly column: number;
        readonly value: any;
        readonly metadata: DataModel.Metadata;
    };
    export type ConfigFunc<T> = (config: CellConfig) => T;
    export type ConfigOption<T> = T | ConfigFunc<T>;
    export function resolveOption<T>(option: ConfigOption<T>, config: CellConfig): T;
}

// @public
export class DataGrid extends Widget {
    constructor(options?: DataGrid.IOptions);
    readonly bodyHeight: number;
    readonly bodyWidth: number;
    cellRenderers: RendererMap;
    columnAt(region: DataModel.ColumnRegion, offset: number): number;
    columnCount(region: DataModel.RowRegion): number;
    columnOffset(region: DataModel.ColumnRegion, index: number): number;
    columnSize(region: DataModel.ColumnRegion, index: number): number;
    copyConfig: DataGrid.CopyConfig;
    copyToClipboard(): void;
    dataModel: DataModel | null;
    defaultSizes: DataGrid.DefaultSizes;
    dispose(): void;
    handleEvent(event: Event): void;
    readonly headerHeight: number;
    headerVisibility: DataGrid.HeaderVisibility;
    readonly headerWidth: number;
    hitTest(clientX: number, clientY: number): DataGrid.HitTestResult;
    keyHandler: DataGrid.IKeyHandler | null;
    mapToLocal(clientX: number, clientY: number): {
        lx: number;
        ly: number;
    };
    mapToVirtual(clientX: number, clientY: number): {
        vx: number;
        vy: number;
    };
    readonly maxScrollX: number;
    readonly maxScrollY: number;
    messageHook(handler: IMessageHandler, msg: Message): boolean;
    mouseHandler: DataGrid.IMouseHandler | null;
    protected onActivateRequest(msg: Message): void;
    protected onAfterDetach(msg: Message): void;
    protected onBeforeAttach(msg: Message): void;
    protected onBeforeShow(msg: Message): void;
    protected onResize(msg: Widget.ResizeMessage): void;
    readonly pageHeight: number;
    readonly pageWidth: number;
    processMessage(msg: Message): void;
    resetColumns(region: DataModel.ColumnRegion | 'all'): void;
    resetRows(region: DataModel.RowRegion | 'all'): void;
    resizeColumn(region: DataModel.ColumnRegion, index: number, size: number): void;
    resizeRow(region: DataModel.RowRegion, index: number, size: number): void;
    rowAt(region: DataModel.RowRegion, offset: number): number;
    rowCount(region: DataModel.RowRegion): number;
    rowOffset(region: DataModel.RowRegion, index: number): number;
    rowSize(region: DataModel.RowRegion, index: number): number;
    scrollBy(dx: number, dy: number): void;
    scrollByPage(dir: 'up' | 'down' | 'left' | 'right'): void;
    scrollByStep(dir: 'up' | 'down' | 'left' | 'right'): void;
    scrollTo(x: number, y: number): void;
    scrollToCell(row: number, column: number): void;
    scrollToColumn(column: number): void;
    scrollToCursor(): void;
    scrollToRow(row: number): void;
    readonly scrollX: number;
    readonly scrollY: number;
    selectionModel: SelectionModel | null;
    stretchLastColumn: boolean;
    stretchLastRow: boolean;
    style: DataGrid.Style;
    readonly totalHeight: number;
    readonly totalWidth: number;
    readonly viewport: Widget;
    readonly viewportHeight: number;
    readonly viewportWidth: number;
    }

// @public
export namespace DataGrid {
    export type CopyConfig = {
        readonly separator: string;
        readonly headers: 'none' | 'row' | 'column' | 'all';
        readonly format: CopyFormatFunc;
        readonly warningThreshold: number;
    };
    export type CopyFormatArgs = {
        region: DataModel.CellRegion;
        row: number;
        column: number;
        value: any;
        metadata: DataModel.Metadata;
    };
    export type CopyFormatFunc = (args: CopyFormatArgs) => string;
    export function copyFormatGeneric(args: CopyFormatArgs): string;
    export type DefaultSizes = {
        readonly rowHeight: number;
        readonly columnWidth: number;
        readonly rowHeaderWidth: number;
        readonly columnHeaderHeight: number;
    };
    export type HeaderVisibility = 'all' | 'row' | 'column' | 'none';
    export type HitTestResult = {
        readonly region: DataModel.CellRegion | 'void';
        readonly row: number;
        readonly column: number;
        readonly x: number;
        readonly y: number;
        readonly width: number;
        readonly height: number;
    };
    export interface IKeyHandler extends IDisposable {
        onKeyDown(grid: DataGrid, event: KeyboardEvent): void;
    }
    export interface IMouseHandler extends IDisposable {
        onContextMenu(grid: DataGrid, event: MouseEvent): void;
        onMouseDown(grid: DataGrid, event: MouseEvent): void;
        onMouseHover(grid: DataGrid, event: MouseEvent): void;
        onMouseLeave(grid: DataGrid, event: MouseEvent): void;
        onMouseMove(grid: DataGrid, event: MouseEvent): void;
        onMouseUp(grid: DataGrid, event: MouseEvent): void;
        onWheel(grid: DataGrid, event: WheelEvent): void;
        release(): void;
    }
    export interface IOptions {
        cellRenderers?: RendererMap;
        copyConfig?: CopyConfig;
        defaultRenderer?: CellRenderer;
        defaultSizes?: DefaultSizes;
        headerVisibility?: HeaderVisibility;
        stretchLastColumn?: boolean;
        stretchLastRow?: boolean;
        style?: Style;
    }
    export type Style = {
        readonly voidColor?: string;
        readonly backgroundColor?: string;
        readonly rowBackgroundColor?: (index: number) => string;
        readonly columnBackgroundColor?: (index: number) => string;
        readonly gridLineColor?: string;
        readonly verticalGridLineColor?: string;
        readonly horizontalGridLineColor?: string;
        readonly headerBackgroundColor?: string;
        readonly headerGridLineColor?: string;
        readonly headerVerticalGridLineColor?: string;
        readonly headerHorizontalGridLineColor?: string;
        readonly selectionFillColor?: string;
        readonly selectionBorderColor?: string;
        readonly cursorFillColor?: string;
        readonly cursorBorderColor?: string;
        readonly headerSelectionFillColor?: string;
        readonly headerSelectionBorderColor?: string;
        readonly scrollShadow?: {
            readonly size: number;
            readonly color1: string;
            readonly color2: string;
            readonly color3: string;
        };
    };
    const defaultStyle: Style;
    const defaultSizes: DefaultSizes;
    const defaultCopyConfig: CopyConfig;
}

// @public
export abstract class DataModel {
    readonly changed: ISignal<this, DataModel.ChangedArgs>;
    abstract columnCount(region: DataModel.ColumnRegion): number;
    abstract data(region: DataModel.CellRegion, row: number, column: number): any;
    protected emitChanged(args: DataModel.ChangedArgs): void;
    metadata(region: DataModel.CellRegion, row: number, column: number): DataModel.Metadata;
    abstract rowCount(region: DataModel.RowRegion): number;
}

// @public
export namespace DataModel {
    export type CellRegion = 'body' | 'row-header' | 'column-header' | 'corner-header';
    export type CellsChangedArgs = {
        readonly type: 'cells-changed';
        readonly region: CellRegion;
        readonly row: number;
        readonly column: number;
        readonly rowSpan: number;
        readonly columnSpan: number;
    };
    export type ChangedArgs = (RowsChangedArgs | ColumnsChangedArgs | RowsMovedArgs | ColumnsMovedArgs | CellsChangedArgs | ModelResetArgs);
    export type ColumnRegion = 'body' | 'row-header';
    const emptyMetadata: Metadata;
    export type ColumnsChangedArgs = {
        readonly type: 'columns-inserted' | 'columns-removed';
        readonly region: ColumnRegion;
        readonly index: number;
        readonly span: number;
    };
    export type ColumnsMovedArgs = {
        readonly type: 'columns-moved';
        readonly region: ColumnRegion;
        readonly index: number;
        readonly span: number;
        readonly destination: number;
    };
    export type Metadata = {
        [key: string]: any;
    };
    export type ModelResetArgs = {
        readonly type: 'model-reset';
    };
    export type RowRegion = 'body' | 'column-header';
    export type RowsChangedArgs = {
        readonly type: 'rows-inserted' | 'rows-removed';
        readonly region: RowRegion;
        readonly index: number;
        readonly span: number;
    };
    export type RowsMovedArgs = {
        readonly type: 'rows-moved';
        readonly region: RowRegion;
        readonly index: number;
        readonly span: number;
        readonly destination: number;
    };
}

// @public
export class GraphicsContext implements IDisposable {
    constructor(context: CanvasRenderingContext2D);
    // (undocumented)
    arc(x: number, y: number, radius: number, startAngle: number, endAngle: number, anticlockwise?: boolean): void;
    // (undocumented)
    arcTo(x1: number, y1: number, x2: number, y2: number, radius: number): void;
    // (undocumented)
    beginPath(): void;
    // (undocumented)
    bezierCurveTo(cp1x: number, cp1y: number, cp2x: number, cp2y: number, x: number, y: number): void;
    // (undocumented)
    clearRect(x: number, y: number, w: number, h: number): void;
    // (undocumented)
    clip(fillRule?: CanvasFillRule): void;
    // (undocumented)
    closePath(): void;
    // (undocumented)
    createImageData(imageData: ImageData): ImageData;
    // (undocumented)
    createImageData(sw: number, sh: number): ImageData;
    // (undocumented)
    createLinearGradient(x0: number, y0: number, x1: number, y1: number): CanvasGradient;
    // (undocumented)
    createPattern(image: HTMLImageElement | HTMLCanvasElement | HTMLVideoElement, repetition: string): CanvasPattern;
    // (undocumented)
    createRadialGradient(x0: number, y0: number, r0: number, x1: number, y1: number, r1: number): CanvasGradient;
    // (undocumented)
    dispose(): void;
    // (undocumented)
    drawFocusIfNeeded(element: Element): void;
    // (undocumented)
    drawImage(image: HTMLImageElement | HTMLCanvasElement | HTMLVideoElement | ImageBitmap, dstX: number, dstY: number): void;
    // (undocumented)
    drawImage(image: HTMLImageElement | HTMLCanvasElement | HTMLVideoElement | ImageBitmap, dstX: number, dstY: number, dstW: number, dstH: number): void;
    // (undocumented)
    drawImage(image: HTMLImageElement | HTMLCanvasElement | HTMLVideoElement | ImageBitmap, srcX: number, srcY: number, srcW: number, srcH: number, dstX: number, dstY: number, dstW: number, dstH: number): void;
    // (undocumented)
    ellipse(x: number, y: number, radiusX: number, radiusY: number, rotation: number, startAngle: number, endAngle: number, anticlockwise?: boolean): void;
    // (undocumented)
    fill(fillRule?: CanvasFillRule): void;
    // (undocumented)
    fillRect(x: number, y: number, w: number, h: number): void;
    // (undocumented)
    fillStyle: string | CanvasGradient | CanvasPattern;
    // (undocumented)
    fillText(text: string, x: number, y: number, maxWidth?: number): void;
    // (undocumented)
    font: string;
    // (undocumented)
    getImageData(sx: number, sy: number, sw: number, sh: number): ImageData;
    // (undocumented)
    getLineDash(): number[];
    // (undocumented)
    globalAlpha: number;
    // (undocumented)
    globalCompositeOperation: string;
    // (undocumented)
    imageSmoothingEnabled: boolean;
    // (undocumented)
    readonly isDisposed: boolean;
    // (undocumented)
    isPointInPath(x: number, y: number, fillRule?: CanvasFillRule): boolean;
    // (undocumented)
    lineCap: string;
    // (undocumented)
    lineDashOffset: number;
    // (undocumented)
    lineJoin: string;
    // (undocumented)
    lineTo(x: number, y: number): void;
    // (undocumented)
    lineWidth: number;
    // (undocumented)
    measureText(text: string): TextMetrics;
    // (undocumented)
    miterLimit: number;
    // (undocumented)
    moveTo(x: number, y: number): void;
    // (undocumented)
    putImageData(imagedata: ImageData, dx: number, dy: number): void;
    // (undocumented)
    putImageData(imagedata: ImageData, dx: number, dy: number, dirtyX: number, dirtyY: number, dirtyWidth: number, dirtyHeight: number): void;
    // (undocumented)
    quadraticCurveTo(cpx: number, cpy: number, x: number, y: number): void;
    // (undocumented)
    rect(x: number, y: number, w: number, h: number): void;
    // (undocumented)
    restore(): void;
    // (undocumented)
    rotate(angle: number): void;
    // (undocumented)
    save(): void;
    // (undocumented)
    scale(x: number, y: number): void;
    // (undocumented)
    setLineDash(segments: number[]): void;
    // (undocumented)
    setTransform(m11: number, m12: number, m21: number, m22: number, dx: number, dy: number): void;
    // (undocumented)
    shadowBlur: number;
    // (undocumented)
    shadowColor: string;
    // (undocumented)
    shadowOffsetX: number;
    // (undocumented)
    shadowOffsetY: number;
    // (undocumented)
    stroke(): void;
    // (undocumented)
    strokeRect(x: number, y: number, w: number, h: number): void;
    // (undocumented)
    strokeStyle: string | CanvasGradient | CanvasPattern;
    // (undocumented)
    strokeText(text: string, x: number, y: number, maxWidth?: number): void;
    // (undocumented)
    textAlign: string;
    // (undocumented)
    textBaseline: string;
    // (undocumented)
    transform(m11: number, m12: number, m21: number, m22: number, dx: number, dy: number): void;
    // (undocumented)
    translate(x: number, y: number): void;
}

// @public
export class JSONModel extends DataModel {
    constructor(options: JSONModel.IOptions);
    columnCount(region: DataModel.ColumnRegion): number;
    data(region: DataModel.CellRegion, row: number, column: number): any;
    metadata(region: DataModel.CellRegion, row: number, column: number): DataModel.Metadata;
    rowCount(region: DataModel.RowRegion): number;
}

// @public
export namespace JSONModel {
    export type DataSource = ReadonlyArray<ReadonlyJSONObject>;
    export type Field = {
        readonly name: string;
        readonly type?: string;
        readonly format?: string;
        readonly title?: string;
    };
    export interface IOptions {
        data: DataSource;
        schema: Schema;
    }
    export type Schema = {
        readonly fields: Field[];
        readonly missingValues?: string[];
        readonly primaryKey?: string | string[];
    };
}

// @public
export class RendererMap {
    constructor(values?: RendererMap.Values, fallback?: CellRenderer);
    readonly changed: ISignal<this, void>;
    get(config: CellRenderer.CellConfig): CellRenderer;
    update(values?: RendererMap.Values, fallback?: CellRenderer): void;
    }

// @public
export namespace RendererMap {
    export type Resolver = CellRenderer.ConfigFunc<CellRenderer | undefined>;
    export type Values = {
        [R in DataModel.CellRegion]?: Resolver | CellRenderer | undefined;
    };
}

// @public
export abstract class SelectionModel {
    constructor(options: SelectionModel.IOptions);
    readonly changed: ISignal<this, void>;
    abstract clear(): void;
    abstract currentSelection(): SelectionModel.Selection | null;
    abstract readonly cursorColumn: number;
    abstract readonly cursorRow: number;
    readonly dataModel: DataModel;
    protected emitChanged(): void;
    isCellSelected(row: number, column: number): boolean;
    isColumnSelected(index: number): boolean;
    abstract readonly isEmpty: boolean;
    isRowSelected(index: number): boolean;
    protected onDataModelChanged(sender: DataModel, args: DataModel.ChangedArgs): void;
    abstract select(args: SelectionModel.SelectArgs): void;
    selectionMode: SelectionModel.SelectionMode;
    abstract selections(): IIterator<SelectionModel.Selection>;
}

// @public
export namespace SelectionModel {
    export type ClearMode = 'all' | 'current' | 'none';
    export interface IOptions {
        dataModel: DataModel;
        selectionMode?: SelectionMode;
    }
    export type SelectArgs = {
        r1: number;
        c1: number;
        r2: number;
        c2: number;
        cursorRow: number;
        cursorColumn: number;
        clear: ClearMode;
    };
    export type Selection = {
        readonly r1: number;
        readonly c1: number;
        readonly r2: number;
        readonly c2: number;
    };
    export type SelectionMode = 'row' | 'column' | 'cell';
}

// @public
export class TextRenderer extends CellRenderer {
    constructor(options?: TextRenderer.IOptions);
    readonly backgroundColor: CellRenderer.ConfigOption<string>;
    drawBackground(gc: GraphicsContext, config: CellRenderer.CellConfig): void;
    drawText(gc: GraphicsContext, config: CellRenderer.CellConfig): void;
    readonly font: CellRenderer.ConfigOption<string>;
    readonly format: TextRenderer.FormatFunc;
    readonly horizontalAlignment: CellRenderer.ConfigOption<TextRenderer.HorizontalAlignment>;
    paint(gc: GraphicsContext, config: CellRenderer.CellConfig): void;
    readonly textColor: CellRenderer.ConfigOption<string>;
    readonly verticalAlignment: CellRenderer.ConfigOption<TextRenderer.VerticalAlignment>;
}

// @public
export namespace TextRenderer {
    export function formatDate(options?: formatDate.IOptions): FormatFunc;
    export namespace formatDate {
        export interface IOptions {
            missing?: string;
        }
    }
    export function formatExponential(options?: formatExponential.IOptions): FormatFunc;
    export namespace formatExponential {
        export interface IOptions {
            digits?: number;
            missing?: string;
        }
    }
    export function formatFixed(options?: formatFixed.IOptions): FormatFunc;
    export namespace formatFixed {
        export interface IOptions {
            digits?: number;
            missing?: string;
        }
    }
    export type FormatFunc = CellRenderer.ConfigFunc<string>;
    export function formatGeneric(options?: formatGeneric.IOptions): FormatFunc;
    export namespace formatGeneric {
        export interface IOptions {
            missing?: string;
        }
    }
    export function formatIntlDateTime(options?: formatIntlDateTime.IOptions): FormatFunc;
    export namespace formatIntlDateTime {
        export interface IOptions {
            locales?: string | string[];
            missing?: string;
            options?: Intl.DateTimeFormatOptions;
        }
    }
    export function formatIntlNumber(options?: formatIntlNumber.IOptions): FormatFunc;
    export namespace formatIntlNumber {
        export interface IOptions {
            locales?: string | string[];
            missing?: string;
            options?: Intl.NumberFormatOptions;
        }
    }
    export function formatISODateTime(options?: formatISODateTime.IOptions): FormatFunc;
    export namespace formatISODateTime {
        export interface IOptions {
            missing?: string;
        }
    }
    export function formatPrecision(options?: formatPrecision.IOptions): FormatFunc;
    export namespace formatPrecision {
        export interface IOptions {
            digits?: number;
            missing?: string;
        }
    }
    export function formatTime(options?: formatTime.IOptions): FormatFunc;
    export namespace formatTime {
        export interface IOptions {
            missing?: string;
        }
    }
    export function formatUTCDateTime(options?: formatUTCDateTime.IOptions): FormatFunc;
    export namespace formatUTCDateTime {
        export interface IOptions {
            missing?: string;
        }
    }
    export type HorizontalAlignment = 'left' | 'center' | 'right';
    export interface IOptions {
        backgroundColor?: CellRenderer.ConfigOption<string>;
        font?: CellRenderer.ConfigOption<string>;
        format?: FormatFunc;
        horizontalAlignment?: CellRenderer.ConfigOption<HorizontalAlignment>;
        textColor?: CellRenderer.ConfigOption<string>;
        verticalAlignment?: CellRenderer.ConfigOption<VerticalAlignment>;
    }
    export function measureFontHeight(font: string): number;
    export type VerticalAlignment = 'top' | 'center' | 'bottom';
}


// (No @packageDocumentation comment for this package)

```
