% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AmalgamatedArray.R
\name{AmalgamatedArray}
\alias{AmalgamatedArray}
\alias{AmalgamatedArray-class}
\alias{AmalgamatedMatrix-class}
\alias{AmalgamatedArraySeed}
\alias{AmalgamatedArraySeed-class}
\alias{DelayedArray,AmalgamatedArraySeed-method}
\alias{matrixClass,AmalgamatedArray-method}
\alias{componentNames}
\alias{extractComponents}
\alias{stageObject,AmalgamatedArray-method}
\alias{coerce,AmalgamatedArray,AmalgamatedMatrix-method}
\alias{coerce,AmalgamatedMatrix,AmalgamatedArray-method}
\title{Amalgamated array class}
\description{
Implements an amalgamated array, equivalent to a delayed combination of DelayedArray objects.
It allows \code{\link{stageObject}} to save a combination of multiple matrices without actually aggregating their data into a single file.
}
\section{Constructors}{

\code{AmalgamatedArraySeed(..., along=1)} accepts any number of named array-like objects and returns a AmalgamatedArraySeed.
Each object corresponds to a block and should be named accordingly; names should be unique and non-empty.
The \code{along} argument specifies the dimension in which matrices should be combined - for matrices, this is 1 for rows, 2 for columns.

\code{AmalgamatedArray(..., along=1)} accepts any number of named array-like objects and returns a AmalgamatedArray.
Alternatively, a single AmalgamatedArraySeed may be provided in \code{...}.
}

\section{Functions}{

\code{componentNames(x)} will return a character vector of names of component arrays in a AmalgamatedArray(Seed) object \code{x}.

\code{extractComponents(x)} will return a named list of array-like objects,
corresponding to the component arrays used to construct the AmalgamatedArray(Seed) object \code{x}.

\code{\link{stageObject}(x, dir, path, child = FALSE)} will save the AmalgamatedArray \code{x} and its components into the \code{path} inside \code{dir}.
Each component array is staged into its own subdirectory inside \code{path}.
}

\section{Comments on usage}{

The AmalgamatedArraySeed is closely related to (and in fact, is a subclass of) the \linkS4class{DelayedAbind} class.
This means that we can leverage many of the \pkg{DelayedArray} methods for handling the delayed bind.
In theory, we could just use a DelayedAbind directly and save it with \pkg{chihaya} in \code{\link{stageObject}} (via \code{\link{preserveDelayedOperations}(TRUE)}).
However, this provides fewer opportunities for tracking and manipulating the samples.
It also saves the per-sample matrices into a single file, which eliminates possibilities for per-file deduplication and linking, e.g., with \code{\link{recycleHdf5Files}(TRUE)}.
}

\examples{
first <- Matrix::rsparsematrix(10, 10, 0.1)
second <- Matrix::rsparsematrix(10, 20, 0.1)
mat <- AmalgamatedArray(list(foo = first, bar = second), along=2)
mat

componentNames(mat)
out <- extractComponents(mat)
lapply(out, dim)

}
\author{
Aaron Lun
}
