% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffusionmap.r
\docType{class}
\name{DiffusionMap-class}
\alias{DiffusionMap-class}
\alias{DiffusionMap}
\title{Create a diffusion map of cells}
\usage{
DiffusionMap(
  data = stopifnot_distmatrix(distance),
  sigma = "local",
  k = find_dm_k(dataset_n_observations(data, distance) - 1L),
  n_eigs = min(20L, dataset_n_observations(data, distance) - 2L),
  density_norm = TRUE,
  ...,
  distance = c("euclidean", "cosine", "rankcor", "l2"),
  n_pcs = NULL,
  n_local = seq(to = min(k, 7L), length.out = min(k, 3L)),
  rotate = FALSE,
  censor_val = NULL,
  censor_range = NULL,
  missing_range = NULL,
  vars = NULL,
  knn_params = list(),
  verbose = !is.null(censor_range),
  suppress_dpt = FALSE
)
}
\arguments{
\item{data}{Expression data to be analyzed and covariates. Provide \code{vars} to select specific columns other than the default: all double value columns.
If \code{distance} is a distance matrix, \code{data} has to be a \code{\link{data.frame}} with covariates only.}

\item{sigma}{Diffusion scale parameter of the Gaussian kernel. One of \code{'local'}, \code{'global'}, a (\link[base]{numeric}) global sigma or a \link{Sigmas} object.
When choosing \code{'global'}, a global sigma will be calculated using \code{\link{find_sigmas}}. (Optional. default: \code{'local'})
A larger sigma might be necessary if the eigenvalues can not be found because of a singularity in the matrix}

\item{k}{Number of nearest neighbors to consider (default: a guess betweeen 100 and \eqn{n - 1}. See \code{\link{find_dm_k}}).}

\item{n_eigs}{Number of eigenvectors/values to return (default: 20)}

\item{density_norm}{logical. If TRUE, use density normalisation}

\item{...}{Unused. All parameters to the right of the \code{...} have to be specified by name (e.g. \code{DiffusionMap(data, distance = 'cosine')})}

\item{distance}{Distance measurement method applied to \code{data} or a distance matrix/\code{\link[stats]{dist}}. For the allowed values, see \code{\link{find_knn}}.
If this is a \code{\link[Matrix]{sparseMatrix}}, zeros are interpreted as "not a close neighbors",
which allows the use of kNN-sparsified matrices (see the return value of \code{\link{find_knn}}.}

\item{n_pcs}{Number of principal components to compute to base calculations on. Using e.g. 50 DCs results in more regular looking diffusion maps.
The default NULL will not compute principal components, but use \code{reducedDims(data, 'pca')} if present. Set to NA to suppress using PCs.}

\item{n_local}{If \code{sigma == 'local'}, the \code{n_local}th nearest neighbor(s) determine(s) the local sigma}

\item{rotate}{logical. If TRUE, rotate the eigenvalues to get a slimmer diffusion map}

\item{censor_val}{Value regarded as uncertain. Either a single value or one for every dimension (Optional, default: censor_val)}

\item{censor_range}{Uncertainity range for censoring (Optional, default: none). A length-2-vector of certainty range start and end. TODO: also allow \eqn{2\times G} matrix}

\item{missing_range}{Whole data range for missing value model. Has to be specified if NAs are in the data}

\item{vars}{Variables (columns) of the data to use. Specifying NULL will select all columns (default: All floating point value columns)}

\item{knn_params}{Parameters passed to \code{\link{find_knn}}}

\item{verbose}{Show a progressbar and other progress information (default: do it if censoring is enabled)}

\item{suppress_dpt}{Specify TRUE to skip calculation of necessary (but spacious) information for \code{\link{DPT}} in the returned object (default: FALSE)}
}
\value{
A DiffusionMap object:
}
\description{
The provided data can be a double \link[base]{matrix} of expression data or a \link[base]{data.frame} with all non-integer (double) columns
being treated as expression data features (and the others ignored), an \link[Biobase:class.ExpressionSet]{ExpressionSet}, or a \link[SingleCellExperiment]{SingleCellExperiment}.
}
\section{Slots}{

\describe{
\item{\code{eigenvalues}}{Eigenvalues ranking the eigenvectors}

\item{\code{eigenvectors}}{Eigenvectors mapping the datapoints to \code{n_eigs} dimensions}

\item{\code{sigmas}}{\link{Sigmas} object with either information about the \link{find_sigmas} heuristic run or just local or \link{optimal_sigma}.}

\item{\code{data_env}}{Environment referencing the data used to create the diffusion map}

\item{\code{eigenvec0}}{First (constant) eigenvector not included as diffusion component.}

\item{\code{transitions}}{Transition probabilities. Can be NULL}

\item{\code{d}}{Density vector of transition probability matrix}

\item{\code{d_norm}}{Density vector of normalized transition probability matrix}

\item{\code{k}}{The k parameter for kNN}

\item{\code{n_pcs}}{Number of principal components used in kNN computation (NA if raw data was used)}

\item{\code{n_local}}{The \code{n_local}th nearest neighbor(s) is/are used to determine local kernel density}

\item{\code{density_norm}}{Was density normalization used?}

\item{\code{rotate}}{Were the eigenvectors rotated?}

\item{\code{distance}}{Distance measurement method used}

\item{\code{censor_val}}{Censoring value}

\item{\code{censor_range}}{Censoring range}

\item{\code{missing_range}}{Whole data range for missing value model}

\item{\code{vars}}{Vars parameter used to extract the part of the data used for diffusion map creation}

\item{\code{knn_params}}{Parameters passed to \code{\link{find_knn}}}
}}

\examples{
data(guo)
DiffusionMap(guo)
DiffusionMap(guo, 13, censor_val = 15, censor_range = c(15, 40), verbose = TRUE)

covars <- data.frame(covar1 = letters[1:100])
dists <- dist(matrix(rnorm(100*10), 100))
DiffusionMap(covars, distance = dists)

}
\seealso{
\link{DiffusionMap methods} to get and set the slots. \code{\link{find_sigmas}} to pre-calculate a fitting global \code{sigma} parameter
}
