% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_mofa.R
\name{create_mofa_from_matrix}
\alias{create_mofa_from_matrix}
\title{create a MOFA object from a a list of matrices}
\usage{
create_mofa_from_matrix(data, groups = NULL)
}
\arguments{
\item{data}{A list of matrices, where each entry corresponds to one view.
Samples are stored in columns and features in rows.
Missing values must be filled in prior to creating the MOFA object (see for example the CLL tutorial)}

\item{groups}{A character vector with group assignment for every sample. Default is \code{NULL}, no group structure.}
}
\value{
Returns an untrained \code{\link{MOFA}} object
}
\description{
Method to create a \code{\link{MOFA}} object from a list of matrices
}
\examples{
m <- make_example_data()
create_mofa_from_matrix(m$data)
}
