% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_muts_region.R
\name{split_muts_region}
\alias{split_muts_region}
\title{Split GRangesList or GRanges based on a list of regions.}
\usage{
split_muts_region(vcf_list, ranges_grl, include_other = TRUE)
}
\arguments{
\item{vcf_list}{GRangesList or GRanges object}

\item{ranges_grl}{GRangesList or GRanges object containing regions of interest}

\item{include_other}{Boolean. Whether or not to include a "Other" region
containing mutations that aren't in any other region.}
}
\value{
GRangesList
}
\description{
A GRangesList or GRanges object containing variants is split based on a list of regions.
This list can be either a GRangesList or a GRanges object.
The result is a GRangesList where each element contains the variants of one sample from one region.
Variant that are not in any of the provided region are put in a list of 'other'.
}
\examples{

## Read in some existing genomic regions.
## See the 'genomic_distribution()' example for how we obtained the
## following data:
CTCF_g <- readRDS(system.file("states/CTCF_g_data.rds",
  package = "MutationalPatterns"
))
promoter_g <- readRDS(system.file("states/promoter_g_data.rds",
  package = "MutationalPatterns"
))
flanking_g <- readRDS(system.file("states/promoter_flanking_g_data.rds",
  package = "MutationalPatterns"
))

## Combine the regions into a single GRangesList
regions <- GRangesList(promoter_g, flanking_g, CTCF_g)

names(regions) <- c("Promoter", "Promoter flanking", "CTCF")

## Read in some variants.
## See the 'read_vcfs_as_granges()' example for how we obtained the
## following data:
grl <- readRDS(system.file("states/read_vcfs_as_granges_output.rds",
  package = "MutationalPatterns"
))

## Split muts based on the supplied regions
split_muts_region(grl, regions)

## Don't include muts outside of the supplied regions
split_muts_region(grl, regions, include_other = FALSE)
}
\seealso{
Other genomic_regions: 
\code{\link{bin_mutation_density}()},
\code{\link{lengthen_mut_matrix}()},
\code{\link{plot_profile_region}()},
\code{\link{plot_spectrum_region}()}
}
\concept{genomic_regions}
