% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/302-extractDrugApol.R
\name{extractDrugApol}
\alias{extractDrugApol}
\title{Calculate the Sum of the Atomic Polarizabilities Descriptor}
\usage{
extractDrugApol(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process
should be shown or not, default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules,
each column represents one feature.
This function returns one column named \code{apol}.
}
\description{
Calculate the Sum of the Atomic Polarizabilities Descriptor
}
\details{
Calculates the sum of the atomic polarizabilities
(including implicit hydrogens) descriptor.
Polarizabilities are taken from
\url{http://www.sunysccc.edu/academic/mst/ptable/p-table2.htm}.
}
\examples{
smi = system.file('vignettedata/FDAMDD.smi', package = 'Rcpi')
\donttest{
mol = readMolFromSmi(smi, type = 'mol')
dat = extractDrugApol(mol)
head(dat)}
}
