% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{class}
\name{bma-class}
\alias{bma-class}
\title{Class "bma"}
\description{
A list holding results from a BMA iteration chain
}
\section{Objects from the Class}{
 Objects can be created via calls to
\code{\link{bms}}, but indirectly also via \code{\link{c.bma}}\cr A
\code{bma} object is a list whose elements hold information on input and
output for a Bayesian Model Averaging iteration chain, such as from a call
to \code{\link{bms}}:
}

\examples{

 data(datafls)
 mm=bms(datafls)
 #show posterior model size
 print(mm$info$msize/mm$info$cumsumweights)
 #is the same number as in
 summary(mm)
 

}
\references{
\url{http://bms.zeugner.eu}
}
\seealso{
\code{\link{bms}} for creating \code{bma} objects,\cr or
\code{\linkS4class{topmod}} for the topmod object
}
\author{
Martin Feldkircher and Stefan Zeugner
}
\keyword{classes}
