% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{\%inner\%}
\alias{\%inner\%}
\title{Numerical and Symbolic Inner Product}
\usage{
x \%inner\% y
}
\arguments{
\item{x}{\code{numeric} or \code{character} array.}

\item{y}{\code{numeric} or \code{character} array.}
}
\value{
\code{numeric} or \code{character}.
}
\description{
Computes the inner product of two \code{numeric} or \code{character} arrays.
}
\details{
The inner product between two arrays \code{A} and \code{B} is computed as:
\deqn{C = \sum_{j_1\dots j_n} A_{j_1\dots j_n}B_{j_1\dots j_n}}
}
\examples{
### numeric inner product 
x <- array(1:4, dim = c(2,2))
x \%inner\% x

### symbolic inner product 
x <- array(letters[1:4], dim = c(2,2))
x \%inner\% x

}
\references{
Guidotti E (2022). "calculus: High-Dimensional Numerical and Symbolic Calculus in R." Journal of Statistical Software, 104(5), 1-37. \doi{10.18637/jss.v104.i05}
}
\seealso{
Other basic arithmetic: 
\code{\link{\%diff\%}()},
\code{\link{\%div\%}()},
\code{\link{\%dot\%}()},
\code{\link{\%kronecker\%}()},
\code{\link{\%outer\%}()},
\code{\link{\%prod\%}()},
\code{\link{\%sum\%}()}
}
\concept{basic arithmetic}
