% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{tab_settings}
\alias{tab_settings}
\title{Set tabulation marks configuration}
\usage{
tab_settings(x, i = NULL, j = NULL, value = TRUE, part = "body")
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{columns selection}

\item{value}{an object of generated by \code{\link[officer:fp_tabs]{officer::fp_tabs()}}.}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}
}
\description{
Define tabulation marks configuration.
Specifying positions and types of tabulation marks in table
paragraphs helps to organize the content, especially in clinical tables
by aligning numbers properly.
}
\examples{
library(officer)
library(flextable)

z <- data.frame(
  Statistic = c("Median (Q1 ; Q3)", "Min ; Max"),
  Value = c(
    "\t999.99\t(99.9 ; 99.9)",
    "\t9.99\t(9999.9 ; 99.9)"
  )
)

ts <- fp_tabs(
  fp_tab(pos = 0.4, style = "decimal"),
  fp_tab(pos = 1.4, style = "decimal")
)

zz <- flextable(z) |>
  tab_settings(j = 2, value = ts) |>
  width(width = c(1.5, 2))


save_as_docx(zz, path = tempfile(fileext = ".docx"))
}
\seealso{
Other sugar functions for table style: 
\code{\link{align}()},
\code{\link{bg}()},
\code{\link{bold}()},
\code{\link{color}()},
\code{\link{empty_blanks}()},
\code{\link{font}()},
\code{\link{fontsize}()},
\code{\link{highlight}()},
\code{\link{italic}()},
\code{\link{keep_with_next}()},
\code{\link{line_spacing}()},
\code{\link{padding}()},
\code{\link{rotate}()},
\code{\link{valign}()}
}
\concept{sugar functions for table style}
