% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord-polar.R, R/coord-radial.R
\name{coord_polar}
\alias{coord_polar}
\alias{coord_radial}
\title{Polar coordinates}
\usage{
coord_polar(theta = "x", start = 0, direction = 1, clip = "on")

coord_radial(
  theta = "x",
  start = 0,
  end = NULL,
  expand = TRUE,
  direction = 1,
  clip = "off",
  r.axis.inside = NULL,
  rotate.angle = FALSE,
  inner.radius = 0,
  r_axis_inside = deprecated(),
  rotate_angle = deprecated()
)
}
\arguments{
\item{theta}{variable to map angle to (\code{x} or \code{y})}

\item{start}{Offset of starting point from 12 o'clock in radians. Offset
is applied clockwise or anticlockwise depending on value of \code{direction}.}

\item{direction}{1, clockwise; -1, anticlockwise}

\item{clip}{Should drawing be clipped to the extent of the plot panel? A
setting of \code{"on"} (the default) means yes, and a setting of \code{"off"}
means no. For details, please see \code{\link[=coord_cartesian]{coord_cartesian()}}.}

\item{end}{Position from 12 o'clock in radians where plot ends, to allow
for partial polar coordinates. The default, \code{NULL}, is set to
\code{start + 2 * pi}.}

\item{expand}{If \code{TRUE}, the default, adds a small expansion factor the
the limits to prevent overlap between data and axes. If \code{FALSE}, limits
are taken directly from the scale.}

\item{r.axis.inside}{If \code{TRUE}, places the radius axis inside the
panel. If \code{FALSE}, places the radius axis next to the panel. The default,
\code{NULL}, places the radius axis outside if the \code{start} and \code{end} arguments
form a full circle.}

\item{rotate.angle}{If \code{TRUE}, transforms the \code{angle} aesthetic in data
in accordance with the computed \code{theta} position. If \code{FALSE} (default),
no such transformation is performed. Can be useful to rotate text geoms in
alignment with the coordinates.}

\item{inner.radius}{A \code{numeric} between 0 and 1 setting the size of a inner.radius hole.}

\item{r_axis_inside, rotate_angle}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\description{
The polar coordinate system is most commonly used for pie charts, which
are a stacked bar chart in polar coordinates. \code{coord_radial()} has extended
options.
}
\note{
In \code{coord_radial()}, position guides are can be defined by using
\code{guides(r = ..., theta = ..., r.sec = ..., theta.sec = ...)}. Note that
these guides require \code{r} and \code{theta} as available aesthetics. The classic
\code{guide_axis()} can be used for the \code{r} positions and \code{guide_axis_theta()} can
be used for the \code{theta} positions. Using the \code{theta.sec} position is only
sensible when \code{inner.radius > 0}.
}
\examples{
# NOTE: Use these plots with caution - polar coordinates has
# major perceptual problems.  The main point of these examples is
# to demonstrate how these common plots can be described in the
# grammar.  Use with EXTREME caution.

#' # A pie chart = stacked bar chart + polar coordinates
pie <- ggplot(mtcars, aes(x = factor(1), fill = factor(cyl))) +
 geom_bar(width = 1)
pie + coord_polar(theta = "y")

\donttest{

# A coxcomb plot = bar chart + polar coordinates
cxc <- ggplot(mtcars, aes(x = factor(cyl))) +
  geom_bar(width = 1, colour = "black")
cxc + coord_polar()
# A new type of plot?
cxc + coord_polar(theta = "y")

# The bullseye chart
pie + coord_polar()

# Hadley's favourite pie chart
df <- data.frame(
  variable = c("does not resemble", "resembles"),
  value = c(20, 80)
)
ggplot(df, aes(x = "", y = value, fill = variable)) +
  geom_col(width = 1) +
  scale_fill_manual(values = c("red", "yellow")) +
  coord_polar("y", start = pi / 3) +
  labs(title = "Pac man")

# Windrose + doughnut plot
if (require("ggplot2movies")) {
movies$rrating <- cut_interval(movies$rating, length = 1)
movies$budgetq <- cut_number(movies$budget, 4)

doh <- ggplot(movies, aes(x = rrating, fill = budgetq))

# Wind rose
doh + geom_bar(width = 1) + coord_polar()
# Race track plot
doh + geom_bar(width = 0.9, position = "fill") + coord_polar(theta = "y")
}
}
# A partial polar plot
ggplot(mtcars, aes(disp, mpg)) +
  geom_point() +
  coord_radial(start = -0.4 * pi, end = 0.4 * pi, inner.radius = 0.3)
}
\seealso{
The \href{https://ggplot2-book.org/coord#polar-coordinates-with-coord_polar}{polar coordinates section} of the online ggplot2 book.
}
