% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readParameters.R
\name{printParameters}
\alias{printParameters}
\title{Print parameter space in the textual format accepted by irace.}
\usage{
printParameters(params, digits = 15L)
}
\arguments{
\item{params}{(\code{list()}) Parameter object stored in \code{irace.Rdata} or read with \code{irace::readParameters()}.}

\item{digits}{(\code{integer()}) The desired number of digits after the decimal point for real-valued parameters. Default is 15, but it should be the value in \code{scenario$digits}.}
}
\description{
FIXME: Dependent parameter bounds are not supported yet.
}
\examples{
 parameters.table <- '
 # name       switch           type  values               [conditions (using R syntax)]
 algorithm    "--"             c     (as,mmas,eas,ras,acs)
 localsearch  "--localsearch " c     (0, 1, 2, 3)
 ants         "--ants "        i,log (5, 100)
 q0           "--q0 "          r     (0.0, 1.0)           | algorithm == "acs"
 nnls         "--nnls "        i     (5, 50)              | localsearch \%in\% c(1,2,3)
 '
parameters <- readParameters(text=parameters.table)
printParameters(parameters)
}
