% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MxAutoStart.R
\name{mxAutoStart}
\alias{mxAutoStart}
\title{Automatically set starting values for an MxModel}
\usage{
mxAutoStart(model, type = c("ULS", "DWLS"))
}
\arguments{
\item{model}{The MxModel for which starting values are desired}

\item{type}{The type of starting values to obtain, currently unweighted or diagonally weighted least squares, ULS or DWLS}
}
\value{
an MxModel with new free parameter values
}
\description{
Automatically set starting values for an MxModel
}
\details{
This function automatically picks very good starting values for many models (RAM, LISREL, Normal), including multiple group versions of these.
It works for models with algebras. Models of continuous, ordinal, and joint ordinal-continuous variables are also acceptable.
It works for models with covariance or raw data.
However, it does not currently work for models with definition variables, state space models, item factor analysis models, or multilevel models.

The method used to obtain new starting values is quite simple. The user's model is changed to an unweighted least squares (ULS) model. The ULS model is estimated and its final point estimates are returned as the new starting values. Optionally, diagonally weighted least squares (DWLS) can be used instead with the \code{type} argument.

Please note that ULS is sensitive to the scales of your variables. For example, if you have variables with means of 20 and variances of 0.001, then ULS will "weight" the means 20,000 times more than the variances and might result in zero variance estimates. Likewise if one variable has a variance of 20 and another has a variance of 0.001, the same problem may arise. To avoid this, make sure your variables are scaled accordingly. You could also use \code{type='DWLS'} to have the function use diagonally weighted least squares to obtain starting values.  Of course, using diagonally weighted least squares will take much much longer and will usually not provide better starting values than unweighted least squares.

Also note that if \code{model} contains a \link[=mxExpectationGREML]{GREML expectation}, argument \code{type} is ignored, and the function always uses a form of ULS.
}
\examples{
# Use the frontpage model with negative variances to show better
# starting values
library(OpenMx)
data(demoOneFactor)

latents  = c("G") # the latent factor
manifests = names(demoOneFactor) # manifest variables to be modeled

m1 <- mxModel("One Factor", type = "RAM",
	manifestVars = manifests, latentVars = latents,
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2, values=-.2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
	mxPath(from = "one", to = manifests),
	mxData(demoOneFactor, type = "raw")
)

# Starting values imply negative variances!
mxGetExpected(m1, 'covariance')

# Use mxAutoStart to get much better starting values
m1s <- mxAutoStart(m1)
mxGetExpected(m1s, 'covariance')
}
