% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probeInteraction.R
\name{plotProbe}
\alias{plotProbe}
\title{Plot a latent interaction}
\usage{
plotProbe(object, xlim, xlab = "Indepedent Variable",
  ylab = "Dependent Variable", legend = TRUE, legendArgs = list(), ...)
}
\arguments{
\item{object}{The result of probing latent interaction obtained from
\code{\link{probe2WayMC}}, \code{\link{probe2WayRC}},
\code{\link{probe3WayMC}}, or \code{\link{probe3WayRC}} function.}

\item{xlim}{The vector of two numbers: the minimum and maximum values of the
independent variable}

\item{xlab}{The label of the x-axis}

\item{ylab}{The label of the y-axis}

\item{legend}{\code{logical}. If \code{TRUE} (default), a legend is printed.}

\item{legendArgs}{\code{list} of arguments passed to \code{\link{legend}}
function if \code{legend=TRUE}.}

\item{\dots}{Any addition argument for the \code{\link{plot}} function}
}
\value{
None. This function will plot the simple main effect only.
}
\description{
This function will plot the line graphs representing the simple effect of
the independent variable given the values of the moderator. For multigroup
models, it will only generate a plot for 1 group, as specified in the
function used to obtain the first argument.
}
\examples{

library(lavaan)

dat2wayMC <- indProd(dat2way, 1:3, 4:6)

model1 <- "
f1 =~ x1 + x2 + x3
f2 =~ x4 + x5 + x6
f12 =~ x1.x4 + x2.x5 + x3.x6
f3 =~ x7 + x8 + x9
f3 ~ f1 + f2 + f12
f12 ~~ 0*f1
f12 ~~ 0*f2
x1 ~ 0*1
x4 ~ 0*1
x1.x4 ~ 0*1
x7 ~ 0*1
f1 ~ NA*1
f2 ~ NA*1
f12 ~ NA*1
f3 ~ NA*1
"

fitMC2way <- sem(model1, data = dat2wayMC, std.lv = FALSE,
                 meanstructure = TRUE)
result2wayMC <- probe2WayMC(fitMC2way, c("f1", "f2", "f12"),
                            "f3", "f2", c(-1, 0, 1))
plotProbe(result2wayMC, xlim = c(-2, 2))


dat3wayMC <- indProd(dat3way, 1:3, 4:6, 7:9)

model3 <- "
f1 =~ x1 + x2 + x3
f2 =~ x4 + x5 + x6
f3 =~ x7 + x8 + x9
f12 =~ x1.x4 + x2.x5 + x3.x6
f13 =~ x1.x7 + x2.x8 + x3.x9
f23 =~ x4.x7 + x5.x8 + x6.x9
f123 =~ x1.x4.x7 + x2.x5.x8 + x3.x6.x9
f4 =~ x10 + x11 + x12
f4 ~ f1 + f2 + f3 + f12 + f13 + f23 + f123
f1 ~~ 0*f12
f1 ~~ 0*f13
f1 ~~ 0*f123
f2 ~~ 0*f12
f2 ~~ 0*f23
f2 ~~ 0*f123
f3 ~~ 0*f13
f3 ~~ 0*f23
f3 ~~ 0*f123
f12 ~~ 0*f123
f13 ~~ 0*f123
f23 ~~ 0*f123
x1 ~ 0*1
x4 ~ 0*1
x7 ~ 0*1
x10 ~ 0*1
x1.x4 ~ 0*1
x1.x7 ~ 0*1
x4.x7 ~ 0*1
x1.x4.x7 ~ 0*1
f1 ~ NA*1
f2 ~ NA*1
f3 ~ NA*1
f12 ~ NA*1
f13 ~ NA*1
f23 ~ NA*1
f123 ~ NA*1
f4 ~ NA*1
"

fitMC3way <- sem(model3, data = dat3wayMC, std.lv = FALSE,
                 meanstructure = TRUE)
result3wayMC <- probe3WayMC(fitMC3way,
                            c("f1", "f2", "f3", "f12", "f13", "f23", "f123"),
                            "f4", c("f1", "f2"), c(-1, 0, 1), c(-1, 0, 1))
plotProbe(result3wayMC, xlim = c(-2, 2))

}
\seealso{
\itemize{
 \item \code{\link{indProd}} For creating the indicator products with no
  centering, mean centering, double-mean centering, or residual centering.
 \item \code{\link{probe2WayMC}} For probing the two-way latent interaction
  when the results are obtained from mean-centering, or double-mean centering
 \item \code{\link{probe3WayMC}} For probing the three-way latent interaction
  when the results are obtained from mean-centering, or double-mean centering
 \item \code{\link{probe2WayRC}} For probing the two-way latent interaction
  when the results are obtained from residual-centering approach.
 \item \code{\link{probe3WayRC}} For probing the two-way latent interaction
  when the results are obtained from residual-centering approach.
}
}
\author{
Sunthud Pornprasertmanit (\email{psunthud@gmail.com})

Terrence D. Jorgensen (University of Amsterdam; \email{TJorgensen314@gmail.com})
}
