// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2020 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from testrpc.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.test {
  public class Ethernet : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("test.Ethernet:1.0.0", null);

    public Ethernet(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Ethernet(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Ethernet StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Ethernet(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public class GetDevicesResult {
      public System.Collections.Generic.IEnumerable<string> _ret_;
    }

    public GetDevicesResult getDevices() {
      JsonObject _parameters = null;
      var _result = RpcCall("getDevices", _parameters);
      var _ret = new GetDevicesResult();
      _ret._ret_ = new System.Collections.Generic.List<string>(_result["_ret_"].AsJsonArray.Select(
        _value => (string)_value));
      return _ret;
    }

    public AsyncRequest getDevices(AsyncRpcResponse<GetDevicesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getDevices(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getDevices(AsyncRpcResponse<GetDevicesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getDevices", _parameters,
        _result => {
          try {
            var _ret = new GetDevicesResult();
            _ret._ret_ = new System.Collections.Generic.List<string>(_result["_ret_"].AsJsonArray.Select(
              _value => (string)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public enum Speed {
      SPD_10,
      SPD_100,
      SPD_1000,
    }

    public enum Duplex {
      DPX_HALF,
      DPX_FULL,
    }

    public class SetParametersResult {
      public int _ret_;
    }

    public SetParametersResult setParameters(string device, Com.Raritan.Idl.test.Ethernet.Speed speed, Com.Raritan.Idl.test.Ethernet.Duplex duplex, bool isAutoNeg) {
      var _parameters = new LightJson.JsonObject();
      _parameters["device"] = device;
      _parameters["speed"] = (int)speed;
      _parameters["duplex"] = (int)duplex;
      _parameters["isAutoNeg"] = isAutoNeg;

      var _result = RpcCall("setParameters", _parameters);
      var _ret = new SetParametersResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setParameters(string device, Com.Raritan.Idl.test.Ethernet.Speed speed, Com.Raritan.Idl.test.Ethernet.Duplex duplex, bool isAutoNeg, AsyncRpcResponse<SetParametersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setParameters(device, speed, duplex, isAutoNeg, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setParameters(string device, Com.Raritan.Idl.test.Ethernet.Speed speed, Com.Raritan.Idl.test.Ethernet.Duplex duplex, bool isAutoNeg, AsyncRpcResponse<SetParametersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["device"] = device;
        _parameters["speed"] = (int)speed;
        _parameters["duplex"] = (int)duplex;
        _parameters["isAutoNeg"] = isAutoNeg;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setParameters", _parameters,
        _result => {
          try {
            var _ret = new SetParametersResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
