/* Generated by re2c */
#line 1 "real_world/parse_date.re"
// re2c $INPUT -o $OUTPUT 
/*
   +----------------------------------------------------------------------+
   | PHP Version 5                                                        |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997-2006 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Derick Rethans <derick@derickrethans.nl>                    |
   +----------------------------------------------------------------------+
 */



#include "timelib.h"

#include <stdio.h>
#include <ctype.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define TIMELIB_SECOND  1
#define TIMELIB_MINUTE  2
#define TIMELIB_HOUR    3
#define TIMELIB_DAY     4
#define TIMELIB_MONTH   5
#define TIMELIB_YEAR    6
#define TIMELIB_WEEKDAY 7

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; s->time->relative.weekday_behavior = 0; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_weekday_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { return TIMELIB_ERROR; } else { s->time.have_zone = 1; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x) { \
	if ((x) == -1) {         \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

#include "timelib_structs.h"

typedef struct timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	int           errors;

	struct timelib_time *time;
	timelib_tzdb        *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

#define HOUR(a) (int)(a * 60)

/* The timezone table. */
static timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

static timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

static timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		*ptr += 3;
	} else {
		++*ptr;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = -1;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	free(str);
	return tmp_nr;
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!strncasecmp(*ptr, "nd", 2) || !strncasecmp(*ptr, "rd", 2) ||!strncasecmp(*ptr, "st", 2) || !strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static double timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = -1;
	int len = 0;

	while ((**ptr != '.') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtod(str, NULL);
	free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
	} else if (**ptr == '-') {
		dir = -1;
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static long timelib_parse_tz_cor(char **ptr)
{
	char *begin = *ptr, *end;
	long  tmp;

	while (**ptr != '\0') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1:
		case 2:
			return HOUR(strtol(begin, NULL, 10));
			break;
		case 3:
		case 4:
			if (begin[1] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 2, NULL, 10);
				return tmp;
			} else if (begin[2] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
				return tmp;
			} else {
				tmp = strtol(begin, NULL, 10);
				return HOUR(tmp / 100) + tmp % 100;
			}
		case 5:
			tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
			return tmp;
	}
	return 0;
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	free(word);
	return value;
}

static long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ') {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	relunit = timelib_lookup_relunit(ptr);
	switch (relunit->unit) {
		case TIMELIB_SECOND: s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE: s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:   s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:    s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:  s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:   s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;
	}
}

static timelib_tz_lookup_table* zone_search(const char *word, long gmtoffset, int isdst)
{
	int first_found = 0;
	timelib_tz_lookup_table  *tp, *first_found_elem;
	timelib_tz_lookup_table  *fmp;

	if (strcasecmp("utc", word) == 0 || strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}
	
	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if ((fmp->gmtoffset * 3600) == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static long timelib_lookup_zone(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = zone_search(word, -1, 0))) {
		value = -tp->gmtoffset / 60;
		*dst = tp->type;
		value += tp->type * 60;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

static long timelib_get_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, timelib_tzdb *tzdb)
{
	timelib_tzinfo *res;
	long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '(') {
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		long offset;
		char *tz_abbr;

		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_ABBR;

		offset = timelib_lookup_zone(ptr, dst, &tz_abbr, &found);
#if 0
		/* If we found a TimeZone identifier, use it */
		if (tz_name) {
			t->tz_info = timelib_parse_tzfile(tz_name);
			t->zone_type = TIMELIB_ZONETYPE_ID;
		}
#endif
		/* If we have a TimeZone identifier to start with, use it */
		if (strstr(tz_abbr, "/")) {
			if ((res = timelib_parse_tzfile(tz_abbr, tzdb)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		if (t->zone_type != TIMELIB_ZONETYPE_ID) {
			timelib_time_tz_abbr_update(t, tz_abbr);
		}
		free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		free(arg.v[i]);            \
	}                              \
	if (arg.v) {                   \
		free(arg.v);               \
	}                              \
}

static int scan(Scanner *s)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;
		
std:
	s->tok = cursor;
	s->len = 0;
#line 846 "real_world/parse_date.re"



#line 744 "real_world/parse_date.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if ((YYLIMIT - YYCURSOR) < 26) YYFILL(26);
	yych = *YYCURSOR;
	switch (yych) {
		case 0x00:
		case '\n': goto yy1;
		case ' ': goto yy4;
		case '(': goto yy6;
		case '+':
		case '-': goto yy7;
		case ',':
		case '.': goto yy8;
		case '0': goto yy9;
		case '1': goto yy10;
		case '2': goto yy11;
		case '3': goto yy12;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy13;
		case '@': goto yy14;
		case 'A': goto yy15;
		case 'B':
		case 'C':
		case 'G':
		case 'H':
		case 'K':
		case 'Q':
		case 'R':
		case 'U':
		case 'Z': goto yy17;
		case 'D': goto yy18;
		case 'E': goto yy19;
		case 'F': goto yy20;
		case 'I': goto yy21;
		case 'J': goto yy22;
		case 'L': goto yy23;
		case 'M': goto yy24;
		case 'N': goto yy25;
		case 'O': goto yy26;
		case 'P': goto yy27;
		case 'S': goto yy28;
		case 'T': goto yy29;
		case 'V': goto yy30;
		case 'W': goto yy31;
		case 'X': goto yy32;
		case 'Y': goto yy33;
		case 'a': goto yy34;
		case 'b':
		case 'c':
		case 'g':
		case 'h':
		case 'i':
		case 'k':
		case 'q':
		case 'r':
		case 'u':
		case 'v':
		case 'x':
		case 'z': goto yy35;
		case 'd': goto yy36;
		case 'e': goto yy37;
		case 'f': goto yy38;
		case 'j': goto yy39;
		case 'l': goto yy40;
		case 'm': goto yy41;
		case 'n': goto yy42;
		case 'o': goto yy43;
		case 'p': goto yy44;
		case 's': goto yy45;
		case 't': goto yy46;
		case 'w': goto yy47;
		case 'y': goto yy48;
		default: goto yy2;
	}
yy1:
	++YYCURSOR;
#line 1401 "real_world/parse_date.re"
	{
		s->pos = cursor; s->line++;
		goto std;
	}
#line 831 "real_world/parse_date.c"
yy2:
	++YYCURSOR;
yy3:
#line 1407 "real_world/parse_date.re"
	{
/*		printf("unexpected character: #%d, %c ", *s->tok, *s->tok); */
		s->errors++;
		goto std;
	}
#line 841 "real_world/parse_date.c"
yy4:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ': goto yy49;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy51;
		default: goto yy5;
	}
yy5:
#line 1396 "real_world/parse_date.re"
	{
		goto std;
	}
#line 864 "real_world/parse_date.c"
yy6:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy35;
		default: goto yy3;
	}
yy7:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ': goto yy49;
		case '0':
		case '1': goto yy52;
		case '2': goto yy53;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy54;
		default: goto yy3;
	}
yy8:
	++YYCURSOR;
	goto yy5;
yy9:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'o':
		case 'w':
		case 'y': goto yy56;
		case '-': goto yy59;
		case '.': goto yy60;
		case '/': goto yy61;
		case '0': goto yy62;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy63;
		case ':': goto yy64;
		case 'n': goto yy81;
		case 'r': goto yy82;
		case 's': goto yy83;
		case 't': goto yy84;
		default: goto yy3;
	}
yy10:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'o':
		case 'p':
		case 'w':
		case 'y': goto yy86;
		case '-': goto yy59;
		case '.': goto yy87;
		case '/': goto yy61;
		case '0':
		case '1':
		case '2': goto yy63;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy88;
		case ':': goto yy89;
		case 'n': goto yy81;
		case 'r': goto yy82;
		case 's': goto yy83;
		case 't': goto yy84;
		default: goto yy3;
	}
yy11:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'o':
		case 'p':
		case 'w':
		case 'y': goto yy86;
		case '-': goto yy59;
		case '.': goto yy87;
		case '/': goto yy61;
		case '0':
		case '1':
		case '2':
		case '3': goto yy88;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy92;
		case ':': goto yy89;
		case 'n': goto yy81;
		case 'r': goto yy82;
		case 's': goto yy83;
		case 't': goto yy84;
		default: goto yy3;
	}
yy12:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'o':
		case 'p':
		case 'w':
		case 'y': goto yy86;
		case '-': goto yy59;
		case '.': goto yy87;
		case '/': goto yy61;
		case '0':
		case '1': goto yy92;
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy93;
		case ':': goto yy89;
		case 'n': goto yy81;
		case 'r': goto yy82;
		case 's': goto yy83;
		case 't': goto yy84;
		default: goto yy3;
	}
yy13:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'o':
		case 'p':
		case 'w':
		case 'y': goto yy86;
		case '-': goto yy59;
		case '.': goto yy87;
		case '/': goto yy61;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy93;
		case ':': goto yy89;
		case 'n': goto yy81;
		case 'r': goto yy82;
		case 's': goto yy83;
		case 't': goto yy84;
		default: goto yy3;
	}
yy14:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '-': goto yy94;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy95;
		default: goto yy3;
	}
yy15:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy98;
		case 'G': goto yy99;
		case 'P': goto yy100;
		case 'U': goto yy101;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		case 'g': goto yy103;
		case 'p': goto yy104;
		case 'u': goto yy105;
		default: goto yy16;
	}
yy16:
#line 1341 "real_world/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		s->errors += tz_not_found;
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
#line 1340 "real_world/parse_date.c"
yy17:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy98;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy16;
	}
yy18:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy98;
		case 'E': goto yy106;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		case 'e': goto yy107;
		default: goto yy16;
	}
yy19:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy98;
		case 'I': goto yy108;
		case 'L': goto yy109;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		case 'i': goto yy110;
		case 'l': goto yy111;
		default: goto yy16;
	}
yy20:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy98;
		case 'E': goto yy112;
		case 'I': goto yy113;
		case 'O': goto yy114;
		case 'R': goto yy115;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		case 'e': goto yy116;
		case 'i': goto yy117;
		case 'o': goto yy118;
		case 'r': goto yy119;
		default: goto yy16;
	}
yy21:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'W':
		case 'Y':
		case 'Z': goto yy98;
		case 'I': goto yy127;
		case 'V':
		case 'X': goto yy128;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy16;
	}
yy22:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A': goto yy129;
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy98;
		case 'U': goto yy130;
		case 'a': goto yy131;
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		case 'u': goto yy132;
		default: goto yy16;
	}
yy23:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A': goto yy133;
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy98;
		case 'a': goto yy134;
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy16;
	}
yy24:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A': goto yy135;
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy98;
		case 'I': goto yy136;
		case 'O': goto yy137;
		case 'a': goto yy138;
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		case 'i': goto yy139;
		case 'o': goto yy140;
		default: goto yy16;
	}
yy25:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy98;
		case 'E': goto yy141;
		case 'I': goto yy142;
		case 'O': goto yy143;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		case 'e': goto yy144;
		case 'i': goto yy145;
		case 'o': goto yy146;
		default: goto yy16;
	}
yy26:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy98;
		case 'C': goto yy147;
		case 'a':
		case 'b':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		case 'c': goto yy148;
		default: goto yy16;
	}
yy27:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy98;
		case 'R': goto yy149;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		case 'r': goto yy150;
		default: goto yy16;
	}
yy28:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A': goto yy151;
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy98;
		case 'E': goto yy152;
		case 'I': goto yy153;
		case 'U': goto yy137;
		case 'a': goto yy154;
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		case 'e': goto yy155;
		case 'i': goto yy156;
		case 'u': goto yy140;
		default: goto yy16;
	}
yy29:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'X':
		case 'Y':
		case 'Z': goto yy98;
		case 'E': goto yy142;
		case 'H': goto yy157;
		case 'O': goto yy158;
		case 'U': goto yy159;
		case 'W': goto yy160;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		case 'e': goto yy145;
		case 'h': goto yy161;
		case 'o': goto yy162;
		case 'u': goto yy163;
		case 'w': goto yy164;
		default: goto yy16;
	}
yy30:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy98;
		case 'I': goto yy165;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy16;
	}
yy31:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy98;
		case 'E': goto yy166;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		case 'e': goto yy167;
		default: goto yy16;
	}
yy32:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy98;
		case 'I': goto yy127;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		default: goto yy16;
	}
yy33:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy98;
		case 'E': goto yy168;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		case 'e': goto yy169;
		default: goto yy16;
	}
yy34:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy98;
		case 'G':
		case 'g': goto yy99;
		case 'P':
		case 'p': goto yy100;
		case 'U':
		case 'u': goto yy101;
		default: goto yy16;
	}
yy35:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy98;
		default: goto yy16;
	}
yy36:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy98;
		case 'E':
		case 'e': goto yy106;
		default: goto yy16;
	}
yy37:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy98;
		case 'I':
		case 'i': goto yy108;
		case 'L':
		case 'l': goto yy109;
		default: goto yy16;
	}
yy38:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy98;
		case 'E':
		case 'e': goto yy112;
		case 'I':
		case 'i': goto yy113;
		case 'O':
		case 'o': goto yy114;
		case 'R':
		case 'r': goto yy115;
		default: goto yy16;
	}
yy39:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'a': goto yy129;
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy98;
		case 'U':
		case 'u': goto yy130;
		default: goto yy16;
	}
yy40:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'a': goto yy133;
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy98;
		default: goto yy16;
	}
yy41:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'a': goto yy135;
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy98;
		case 'I':
		case 'i': goto yy136;
		case 'O':
		case 'o': goto yy137;
		default: goto yy16;
	}
yy42:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy98;
		case 'E':
		case 'e': goto yy141;
		case 'I':
		case 'i': goto yy142;
		case 'O':
		case 'o': goto yy143;
		default: goto yy16;
	}
yy43:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy98;
		case 'C':
		case 'c': goto yy147;
		default: goto yy16;
	}
yy44:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy98;
		case 'R':
		case 'r': goto yy149;
		default: goto yy16;
	}
yy45:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'a': goto yy151;
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy98;
		case 'E':
		case 'e': goto yy152;
		case 'I':
		case 'i': goto yy153;
		case 'U':
		case 'u': goto yy137;
		default: goto yy16;
	}
yy46:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'x':
		case 'y':
		case 'z': goto yy98;
		case 'E':
		case 'e': goto yy142;
		case 'H':
		case 'h': goto yy157;
		case 'O':
		case 'o': goto yy158;
		case 'U':
		case 'u': goto yy159;
		case 'W':
		case 'w': goto yy160;
		default: goto yy16;
	}
yy47:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy98;
		case 'E':
		case 'e': goto yy166;
		default: goto yy16;
	}
yy48:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy98;
		case 'E':
		case 'e': goto yy168;
		default: goto yy16;
	}
yy49:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case ' ': goto yy49;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy51;
		default: goto yy50;
	}
yy50:
	YYCURSOR = YYMARKER;
	switch (yyaccept) {
		case 0: goto yy5;
		case 1: goto yy3;
		case 2: goto yy16;
		case 3: goto yy70;
		case 4: goto yy187;
		case 5: goto yy192;
		case 6: goto yy250;
		case 7: goto yy269;
		case 8: goto yy124;
		case 9: goto yy298;
		case 10: goto yy351;
		case 11: goto yy353;
		case 12: goto yy357;
		case 13: goto yy437;
		case 14: goto yy468;
		case 15: goto yy575;
		case 16: goto yy578;
		case 17: goto yy614;
		case 18: goto yy655;
		case 19: goto yy766;
		case 20: goto yy499;
		case 21: goto yy794;
		case 22: goto yy846;
		case 23: goto yy851;
		case 24: goto yy890;
		case 25: goto yy935;
		default: goto yy1006;
	}
yy51:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	switch (yych) {
		case ' ': goto yy170;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy51;
		case 'D':
		case 'd': goto yy172;
		case 'F':
		case 'f': goto yy173;
		case 'H':
		case 'h': goto yy68;
		case 'M':
		case 'm': goto yy174;
		case 'S':
		case 's': goto yy175;
		case 'T':
		case 't': goto yy76;
		case 'W':
		case 'w': goto yy78;
		case 'Y':
		case 'y': goto yy80;
		default: goto yy50;
	}
yy52:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy54;
		case ':': goto yy176;
		default: goto yy16;
	}
yy53:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0':
		case '1':
		case '2':
		case '3': goto yy54;
		case '4':
		case '5': goto yy177;
		case '6':
		case '7':
		case '8':
		case '9': goto yy178;
		case ':': goto yy176;
		default: goto yy16;
	}
yy54:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy177;
		case '6':
		case '7':
		case '8':
		case '9': goto yy178;
		case ':': goto yy176;
		default: goto yy16;
	}
yy55:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy56:
	switch (yych) {
		case ' ': goto yy55;
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy57;
		case 'A':
		case 'a': goto yy65;
		case 'D':
		case 'd': goto yy66;
		case 'F':
		case 'f': goto yy67;
		case 'H':
		case 'h': goto yy68;
		case 'I': goto yy69;
		case 'J':
		case 'j': goto yy71;
		case 'M':
		case 'm': goto yy72;
		case 'N':
		case 'n': goto yy73;
		case 'O':
		case 'o': goto yy74;
		case 'S':
		case 's': goto yy75;
		case 'T':
		case 't': goto yy76;
		case 'V': goto yy77;
		case 'W':
		case 'w': goto yy78;
		case 'X': goto yy79;
		case 'Y':
		case 'y': goto yy80;
		default: goto yy50;
	}
yy57:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy58:
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy57;
		case 'A':
		case 'a': goto yy65;
		case 'D':
		case 'd': goto yy179;
		case 'F':
		case 'f': goto yy180;
		case 'I': goto yy69;
		case 'J':
		case 'j': goto yy71;
		case 'M':
		case 'm': goto yy181;
		case 'N':
		case 'n': goto yy73;
		case 'O':
		case 'o': goto yy74;
		case 'S':
		case 's': goto yy182;
		case 'V': goto yy77;
		case 'X': goto yy79;
		default: goto yy50;
	}
yy59:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy183;
		case '1': goto yy184;
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy185;
		default: goto yy58;
	}
yy60:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy186;
		case '1': goto yy188;
		case '2':
		case '3':
		case '4':
		case '5': goto yy189;
		case '6':
		case '7':
		case '8':
		case '9': goto yy190;
		default: goto yy58;
	}
yy61:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2': goto yy191;
		case '3': goto yy193;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy194;
		case 'A':
		case 'a': goto yy195;
		case 'D':
		case 'd': goto yy196;
		case 'F':
		case 'f': goto yy197;
		case 'J':
		case 'j': goto yy198;
		case 'M':
		case 'm': goto yy199;
		case 'N':
		case 'n': goto yy200;
		case 'O':
		case 'o': goto yy201;
		case 'S':
		case 's': goto yy202;
		default: goto yy50;
	}
yy62:
	yych = *++YYCURSOR;
	switch (yych) {
		case '-': goto yy59;
		case '.': goto yy60;
		case '/': goto yy61;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy203;
		case '6':
		case '7':
		case '8':
		case '9': goto yy204;
		case ':': goto yy64;
		case 'n': goto yy81;
		case 'r': goto yy82;
		case 's': goto yy83;
		case 't': goto yy84;
		default: goto yy56;
	}
yy63:
	yych = *++YYCURSOR;
	switch (yych) {
		case '-': goto yy59;
		case '.': goto yy87;
		case '/': goto yy61;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy203;
		case '6':
		case '7':
		case '8':
		case '9': goto yy204;
		case ':': goto yy89;
		case 'n': goto yy81;
		case 'r': goto yy82;
		case 's': goto yy83;
		case 't': goto yy84;
		default: goto yy86;
	}
yy64:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy205;
		case '6':
		case '7':
		case '8':
		case '9': goto yy206;
		default: goto yy50;
	}
yy65:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'P':
		case 'p': goto yy207;
		case 'U':
		case 'u': goto yy208;
		default: goto yy50;
	}
yy66:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy209;
		case 'E':
		case 'e': goto yy210;
		default: goto yy50;
	}
yy67:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy211;
		case 'O':
		case 'o': goto yy212;
		case 'R':
		case 'r': goto yy213;
		default: goto yy50;
	}
yy68:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'O':
		case 'o': goto yy214;
		default: goto yy50;
	}
yy69:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy215;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy216;
		case 'I': goto yy218;
		case 'V':
		case 'X': goto yy219;
		default: goto yy70;
	}
yy70:
#line 1140 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 3753 "real_world/parse_date.c"
yy71:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy220;
		case 'U':
		case 'u': goto yy221;
		default: goto yy50;
	}
yy72:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy222;
		case 'I':
		case 'i': goto yy223;
		case 'O':
		case 'o': goto yy224;
		default: goto yy50;
	}
yy73:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'O':
		case 'o': goto yy225;
		default: goto yy50;
	}
yy74:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'C':
		case 'c': goto yy226;
		default: goto yy50;
	}
yy75:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy227;
		case 'E':
		case 'e': goto yy228;
		case 'U':
		case 'u': goto yy229;
		default: goto yy50;
	}
yy76:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'H':
		case 'h': goto yy230;
		case 'U':
		case 'u': goto yy231;
		default: goto yy50;
	}
yy77:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy215;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy216;
		case 'I': goto yy79;
		default: goto yy70;
	}
yy78:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy232;
		default: goto yy50;
	}
yy79:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy215;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy216;
		case 'I': goto yy218;
		default: goto yy70;
	}
yy80:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy233;
		default: goto yy50;
	}
yy81:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'O':
		case 'o': goto yy225;
		case 'd': goto yy234;
		default: goto yy50;
	}
yy82:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'd': goto yy234;
		default: goto yy50;
	}
yy83:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy227;
		case 'E':
		case 'e': goto yy228;
		case 'U':
		case 'u': goto yy229;
		case 't': goto yy234;
		default: goto yy50;
	}
yy84:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'H': goto yy230;
		case 'U':
		case 'u': goto yy231;
		case 'h': goto yy235;
		default: goto yy50;
	}
yy85:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy86:
	switch (yych) {
		case ' ': goto yy85;
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy57;
		case 'A':
		case 'a': goto yy90;
		case 'D':
		case 'd': goto yy66;
		case 'F':
		case 'f': goto yy67;
		case 'H':
		case 'h': goto yy68;
		case 'I': goto yy69;
		case 'J':
		case 'j': goto yy71;
		case 'M':
		case 'm': goto yy72;
		case 'N':
		case 'n': goto yy73;
		case 'O':
		case 'o': goto yy74;
		case 'P':
		case 'p': goto yy91;
		case 'S':
		case 's': goto yy75;
		case 'T':
		case 't': goto yy76;
		case 'V': goto yy77;
		case 'W':
		case 'w': goto yy78;
		case 'X': goto yy79;
		case 'Y':
		case 'y': goto yy80;
		default: goto yy50;
	}
yy87:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy236;
		case '1': goto yy237;
		case '2':
		case '3':
		case '4':
		case '5': goto yy238;
		case '6':
		case '7':
		case '8':
		case '9': goto yy239;
		default: goto yy58;
	}
yy88:
	yych = *++YYCURSOR;
	switch (yych) {
		case '-': goto yy59;
		case '.': goto yy60;
		case '/': goto yy240;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy203;
		case '6':
		case '7':
		case '8':
		case '9': goto yy204;
		case ':': goto yy64;
		case 'n': goto yy81;
		case 'r': goto yy82;
		case 's': goto yy83;
		case 't': goto yy84;
		default: goto yy56;
	}
yy89:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy241;
		case '6':
		case '7':
		case '8':
		case '9': goto yy242;
		default: goto yy50;
	}
yy90:
	yych = *++YYCURSOR;
	switch (yych) {
		case '.': goto yy243;
		case 'M':
		case 'm': goto yy244;
		case 'P':
		case 'p': goto yy207;
		case 'U':
		case 'u': goto yy208;
		default: goto yy50;
	}
yy91:
	yych = *++YYCURSOR;
	switch (yych) {
		case '.': goto yy243;
		case 'M':
		case 'm': goto yy244;
		default: goto yy50;
	}
yy92:
	yych = *++YYCURSOR;
	switch (yych) {
		case '-': goto yy59;
		case '.': goto yy246;
		case '/': goto yy240;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy204;
		case 'n': goto yy81;
		case 'r': goto yy82;
		case 's': goto yy83;
		case 't': goto yy84;
		default: goto yy56;
	}
yy93:
	yych = *++YYCURSOR;
	switch (yych) {
		case '-': goto yy247;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy204;
		default: goto yy171;
	}
yy94:
	yych = *++YYCURSOR;
	switch (yych) {
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy95;
		default: goto yy50;
	}
yy95:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy95;
		default: goto yy96;
	}
yy96:
#line 906 "real_world/parse_date.re"
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 4139 "real_world/parse_date.c"
yy97:
	++YYCURSOR;
	goto yy16;
yy98:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		default: goto yy16;
	}
yy99:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'O':
		case 'o': goto yy249;
		default: goto yy16;
	}
yy100:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'R':
		case 'r': goto yy251;
		default: goto yy16;
	}
yy101:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'G':
		case 'g': goto yy252;
		default: goto yy16;
	}
yy102:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		default: goto yy16;
	}
yy103:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'O': goto yy249;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 'o': goto yy255;
		default: goto yy16;
	}
yy104:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'R': goto yy251;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 'r': goto yy256;
		default: goto yy16;
	}
yy105:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'G': goto yy252;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 'g': goto yy257;
		default: goto yy16;
	}
yy106:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'C':
		case 'c': goto yy258;
		default: goto yy16;
	}
yy107:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'C': goto yy258;
		case 'a':
		case 'b':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 'c': goto yy259;
		default: goto yy16;
	}
yy108:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'G':
		case 'g': goto yy260;
		default: goto yy16;
	}
yy109:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'E':
		case 'e': goto yy261;
		default: goto yy16;
	}
yy110:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'G': goto yy260;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 'g': goto yy262;
		default: goto yy16;
	}
yy111:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'E': goto yy261;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 'e': goto yy263;
		default: goto yy16;
	}
yy112:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'B':
		case 'b': goto yy264;
		default: goto yy16;
	}
yy113:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'F':
		case 'f': goto yy265;
		case 'R':
		case 'r': goto yy266;
		default: goto yy16;
	}
yy114:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'U':
		case 'u': goto yy267;
		default: goto yy16;
	}
yy115:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'I':
		case 'i': goto yy268;
		default: goto yy16;
	}
yy116:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'B': goto yy264;
		case 'a':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 'b': goto yy270;
		default: goto yy16;
	}
yy117:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'F': goto yy265;
		case 'R': goto yy266;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 'f': goto yy271;
		case 'r': goto yy272;
		default: goto yy16;
	}
yy118:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'U': goto yy267;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 'u': goto yy273;
		default: goto yy16;
	}
yy119:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'I': goto yy268;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 'i': goto yy274;
		default: goto yy16;
	}
yy120:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 17) YYFILL(17);
	yych = *YYCURSOR;
yy121:
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy120;
		case '0':
		case '1':
		case '2': goto yy123;
		case '3': goto yy125;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy126;
		default: goto yy50;
	}
yy122:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		default: goto yy16;
	}
yy123:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy277;
		default: goto yy276;
	}
yy124:
#line 1127 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 5544 "real_world/parse_date.c"
yy125:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1': goto yy277;
		case '2': goto yy278;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy279;
		default: goto yy276;
	}
yy126:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1': goto yy280;
		case '2': goto yy278;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy279;
		default: goto yy276;
	}
yy127:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'I': goto yy281;
		default: goto yy16;
	}
yy128:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		default: goto yy16;
	}
yy129:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'N':
		case 'n': goto yy282;
		default: goto yy16;
	}
yy130:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'M':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'm':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'L':
		case 'l': goto yy283;
		case 'N':
		case 'n': goto yy284;
		default: goto yy16;
	}
yy131:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'N': goto yy282;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 'n': goto yy285;
		default: goto yy16;
	}
yy132:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'M':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'L': goto yy283;
		case 'N': goto yy284;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'm':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 'l': goto yy286;
		case 'n': goto yy287;
		default: goto yy16;
	}
yy133:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'S':
		case 's': goto yy288;
		default: goto yy16;
	}
yy134:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'S': goto yy288;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 's': goto yy289;
		default: goto yy16;
	}
yy135:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'z': goto yy248;
		case 'R':
		case 'r': goto yy290;
		case 'Y':
		case 'y': goto yy291;
		default: goto yy16;
	}
yy136:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'D':
		case 'd': goto yy292;
		default: goto yy16;
	}
yy137:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'N':
		case 'n': goto yy268;
		default: goto yy16;
	}
yy138:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Z': goto yy248;
		case 'R': goto yy290;
		case 'Y': goto yy291;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'z': goto yy254;
		case 'r': goto yy293;
		case 'y': goto yy294;
		default: goto yy16;
	}
yy139:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'D': goto yy292;
		case 'a':
		case 'b':
		case 'c':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 'd': goto yy295;
		default: goto yy16;
	}
yy140:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'N': goto yy268;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 'n': goto yy274;
		default: goto yy16;
	}
yy141:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'y':
		case 'z': goto yy248;
		case 'X':
		case 'x': goto yy288;
		default: goto yy16;
	}
yy142:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'N':
		case 'n': goto yy265;
		default: goto yy16;
	}
yy143:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'O':
		case 'o': goto yy296;
		case 'V':
		case 'v': goto yy258;
		case 'W':
		case 'w': goto yy297;
		default: goto yy16;
	}
yy144:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'Y':
		case 'Z': goto yy248;
		case 'X': goto yy288;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'y':
		case 'z': goto yy254;
		case 'x': goto yy289;
		default: goto yy16;
	}
yy145:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'N': goto yy265;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 'n': goto yy271;
		default: goto yy16;
	}
yy146:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'O': goto yy296;
		case 'V': goto yy258;
		case 'W': goto yy297;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 'o': goto yy299;
		case 'v': goto yy259;
		case 'w': goto yy300;
		default: goto yy16;
	}
yy147:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'T':
		case 't': goto yy301;
		default: goto yy16;
	}
yy148:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'T': goto yy301;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 't': goto yy302;
		default: goto yy16;
	}
yy149:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'E':
		case 'e': goto yy303;
		default: goto yy16;
	}
yy150:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'E': goto yy303;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 'e': goto yy304;
		default: goto yy16;
	}
yy151:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'T':
		case 't': goto yy305;
		default: goto yy16;
	}
yy152:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'C':
		case 'c': goto yy306;
		case 'P':
		case 'p': goto yy307;
		case 'V':
		case 'v': goto yy308;
		default: goto yy16;
	}
yy153:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'y':
		case 'z': goto yy248;
		case 'X':
		case 'x': goto yy265;
		default: goto yy16;
	}
yy154:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'T': goto yy305;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 't': goto yy309;
		default: goto yy16;
	}
yy155:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'C': goto yy306;
		case 'P': goto yy307;
		case 'V': goto yy308;
		case 'a':
		case 'b':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 'c': goto yy310;
		case 'p': goto yy311;
		case 'v': goto yy312;
		default: goto yy16;
	}
yy156:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'Y':
		case 'Z': goto yy248;
		case 'X': goto yy265;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'y':
		case 'z': goto yy254;
		case 'x': goto yy271;
		default: goto yy16;
	}
yy157:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'I':
		case 'i': goto yy313;
		case 'U':
		case 'u': goto yy314;
		default: goto yy16;
	}
yy158:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'D':
		case 'd': goto yy315;
		case 'M':
		case 'm': goto yy316;
		default: goto yy16;
	}
yy159:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'E':
		case 'e': goto yy317;
		default: goto yy16;
	}
yy160:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'E':
		case 'e': goto yy318;
		default: goto yy16;
	}
yy161:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'I': goto yy313;
		case 'U': goto yy314;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 'i': goto yy319;
		case 'u': goto yy320;
		default: goto yy16;
	}
yy162:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'D': goto yy315;
		case 'M': goto yy316;
		case 'a':
		case 'b':
		case 'c':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 'd': goto yy321;
		case 'm': goto yy322;
		default: goto yy16;
	}
yy163:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'E': goto yy317;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 'e': goto yy323;
		default: goto yy16;
	}
yy164:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'E': goto yy318;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 'e': goto yy324;
		default: goto yy16;
	}
yy165:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'I': goto yy325;
		default: goto yy16;
	}
yy166:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'D':
		case 'd': goto yy326;
		default: goto yy16;
	}
yy167:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'D': goto yy326;
		case 'a':
		case 'b':
		case 'c':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 'd': goto yy327;
		default: goto yy16;
	}
yy168:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy248;
		case 'S':
		case 's': goto yy328;
		default: goto yy16;
	}
yy169:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy248;
		case 'S': goto yy328;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy254;
		case 's': goto yy329;
		default: goto yy16;
	}
yy170:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy171:
	switch (yych) {
		case ' ': goto yy170;
		case 'D':
		case 'd': goto yy172;
		case 'F':
		case 'f': goto yy173;
		case 'H':
		case 'h': goto yy68;
		case 'M':
		case 'm': goto yy174;
		case 'S':
		case 's': goto yy175;
		case 'T':
		case 't': goto yy76;
		case 'W':
		case 'w': goto yy78;
		case 'Y':
		case 'y': goto yy80;
		default: goto yy50;
	}
yy172:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy209;
		default: goto yy50;
	}
yy173:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'O':
		case 'o': goto yy212;
		case 'R':
		case 'r': goto yy213;
		default: goto yy50;
	}
yy174:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'I':
		case 'i': goto yy223;
		case 'O':
		case 'o': goto yy224;
		default: goto yy50;
	}
yy175:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy227;
		case 'E':
		case 'e': goto yy330;
		case 'U':
		case 'u': goto yy229;
		default: goto yy50;
	}
yy176:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy331;
		case '6':
		case '7':
		case '8':
		case '9': goto yy97;
		default: goto yy16;
	}
yy177:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy178;
		default: goto yy16;
	}
yy178:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy51;
		default: goto yy16;
	}
yy179:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy210;
		default: goto yy50;
	}
yy180:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy211;
		default: goto yy50;
	}
yy181:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy222;
		default: goto yy50;
	}
yy182:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy332;
		default: goto yy50;
	}
yy183:
	yych = *++YYCURSOR;
	switch (yych) {
		case '-': goto yy333;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy185;
		default: goto yy50;
	}
yy184:
	yych = *++YYCURSOR;
	switch (yych) {
		case '-': goto yy333;
		case '0':
		case '1':
		case '2': goto yy185;
		default: goto yy50;
	}
yy185:
	yych = *++YYCURSOR;
	switch (yych) {
		case '-': goto yy333;
		default: goto yy50;
	}
yy186:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.': goto yy334;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy190;
		case ':': goto yy335;
		default: goto yy187;
	}
yy187:
#line 947 "real_world/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 8447 "real_world/parse_date.c"
yy188:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.': goto yy334;
		case '0':
		case '1':
		case '2': goto yy190;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy206;
		case ':': goto yy335;
		default: goto yy187;
	}
yy189:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.': goto yy334;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy206;
		case ':': goto yy335;
		default: goto yy187;
	}
yy190:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.': goto yy334;
		case ':': goto yy335;
		default: goto yy187;
	}
yy191:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '/': goto yy336;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy194;
		case 'n':
		case 'r': goto yy337;
		case 's': goto yy338;
		case 't': goto yy339;
		default: goto yy192;
	}
yy192:
#line 1034 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr((char **) &ptr, 4);
			TIMELIB_PROCESS_YEAR(s->time->y);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
#line 8528 "real_world/parse_date.c"
yy193:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '/': goto yy336;
		case '0':
		case '1': goto yy194;
		case 'n':
		case 'r': goto yy337;
		case 's': goto yy338;
		case 't': goto yy339;
		default: goto yy192;
	}
yy194:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '/': goto yy336;
		case 'n':
		case 'r': goto yy337;
		case 's': goto yy338;
		case 't': goto yy339;
		default: goto yy192;
	}
yy195:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'P':
		case 'p': goto yy340;
		case 'U':
		case 'u': goto yy341;
		default: goto yy50;
	}
yy196:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy342;
		default: goto yy50;
	}
yy197:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy343;
		default: goto yy50;
	}
yy198:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy344;
		case 'U':
		case 'u': goto yy345;
		default: goto yy50;
	}
yy199:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy346;
		default: goto yy50;
	}
yy200:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'O':
		case 'o': goto yy347;
		default: goto yy50;
	}
yy201:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'C':
		case 'c': goto yy348;
		default: goto yy50;
	}
yy202:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy349;
		default: goto yy50;
	}
yy203:
	yych = *++YYCURSOR;
	switch (yych) {
		case '-': goto yy247;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy350;
		default: goto yy171;
	}
yy204:
	yych = *++YYCURSOR;
	switch (yych) {
		case '-': goto yy247;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy352;
		default: goto yy171;
	}
yy205:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy335;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy206;
		default: goto yy187;
	}
yy206:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy335;
		default: goto yy187;
	}
yy207:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R':
		case 'r': goto yy354;
		default: goto yy50;
	}
yy208:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'G':
		case 'g': goto yy355;
		default: goto yy50;
	}
yy209:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'Y':
		case 'y': goto yy356;
		default: goto yy50;
	}
yy210:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'C':
		case 'c': goto yy358;
		default: goto yy50;
	}
yy211:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'B':
		case 'b': goto yy359;
		default: goto yy50;
	}
yy212:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R':
		case 'r': goto yy360;
		default: goto yy50;
	}
yy213:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'I':
		case 'i': goto yy361;
		default: goto yy50;
	}
yy214:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'U':
		case 'u': goto yy362;
		default: goto yy50;
	}
yy215:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy215;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy216;
		default: goto yy50;
	}
yy216:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy363;
		default: goto yy217;
	}
yy217:
#line 1074 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
#line 8788 "real_world/parse_date.c"
yy218:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy215;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy216;
		case 'I': goto yy219;
		default: goto yy70;
	}
yy219:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy215;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy216;
		default: goto yy70;
	}
yy220:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'N':
		case 'n': goto yy364;
		default: goto yy50;
	}
yy221:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'L':
		case 'l': goto yy365;
		case 'N':
		case 'n': goto yy366;
		default: goto yy50;
	}
yy222:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R':
		case 'r': goto yy367;
		case 'Y':
		case 'y': goto yy219;
		default: goto yy50;
	}
yy223:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'N':
		case 'n': goto yy368;
		default: goto yy50;
	}
yy224:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'N':
		case 'n': goto yy369;
		default: goto yy50;
	}
yy225:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'V':
		case 'v': goto yy358;
		default: goto yy50;
	}
yy226:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T':
		case 't': goto yy370;
		default: goto yy50;
	}
yy227:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T':
		case 't': goto yy371;
		default: goto yy50;
	}
yy228:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'C':
		case 'c': goto yy372;
		case 'P':
		case 'p': goto yy373;
		default: goto yy50;
	}
yy229:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'N':
		case 'n': goto yy361;
		default: goto yy50;
	}
yy230:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'U':
		case 'u': goto yy374;
		default: goto yy50;
	}
yy231:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy375;
		default: goto yy50;
	}
yy232:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'D':
		case 'd': goto yy376;
		case 'E':
		case 'e': goto yy377;
		default: goto yy50;
	}
yy233:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy362;
		default: goto yy50;
	}
yy234:
	yych = *++YYCURSOR;
	switch (yych) {
		case '.': goto yy246;
		case '/': goto yy240;
		default: goto yy58;
	}
yy235:
	yych = *++YYCURSOR;
	switch (yych) {
		case '.': goto yy246;
		case '/': goto yy240;
		case 'U':
		case 'u': goto yy374;
		default: goto yy58;
	}
yy236:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.': goto yy378;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy379;
		case ':': goto yy380;
		default: goto yy187;
	}
yy237:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.': goto yy378;
		case '0':
		case '1':
		case '2': goto yy379;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy381;
		case ':': goto yy380;
		default: goto yy187;
	}
yy238:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.': goto yy378;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy381;
		case ':': goto yy380;
		default: goto yy187;
	}
yy239:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.': goto yy378;
		case ':': goto yy380;
		default: goto yy187;
	}
yy240:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy195;
		case 'D':
		case 'd': goto yy196;
		case 'F':
		case 'f': goto yy197;
		case 'J':
		case 'j': goto yy198;
		case 'M':
		case 'm': goto yy199;
		case 'N':
		case 'n': goto yy200;
		case 'O':
		case 'o': goto yy201;
		case 'S':
		case 's': goto yy202;
		default: goto yy50;
	}
yy241:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy380;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy381;
		default: goto yy187;
	}
yy242:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy380;
		default: goto yy187;
	}
yy243:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'M':
		case 'm': goto yy244;
		default: goto yy50;
	}
yy244:
	yych = *++YYCURSOR;
	switch (yych) {
		case '.': goto yy382;
		default: goto yy245;
	}
yy245:
#line 930 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
#line 9113 "real_world/parse_date.c"
yy246:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy383;
		case '1': goto yy384;
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy385;
		default: goto yy58;
	}
yy247:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy183;
		case '1': goto yy184;
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy185;
		case 'A':
		case 'a': goto yy386;
		case 'D':
		case 'd': goto yy387;
		case 'F':
		case 'f': goto yy388;
		case 'J':
		case 'j': goto yy389;
		case 'M':
		case 'm': goto yy390;
		case 'N':
		case 'n': goto yy391;
		case 'O':
		case 'o': goto yy392;
		case 'S':
		case 's': goto yy393;
		default: goto yy50;
	}
yy248:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		default: goto yy16;
	}
yy249:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		default: goto yy250;
	}
yy250:
#line 1293 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
#line 9291 "real_world/parse_date.c"
yy251:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '-': goto yy395;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'I':
		case 'i': goto yy396;
		default: goto yy16;
	}
yy252:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '-': goto yy395;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'U':
		case 'u': goto yy397;
		default: goto yy16;
	}
yy253:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy398;
		default: goto yy50;
	}
yy254:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		default: goto yy16;
	}
yy255:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		default: goto yy250;
	}
yy256:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '-': goto yy395;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'I': goto yy396;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 'i': goto yy400;
		default: goto yy16;
	}
yy257:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '-': goto yy395;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'U': goto yy397;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 'u': goto yy401;
		default: goto yy16;
	}
yy258:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '-': goto yy395;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'E':
		case 'e': goto yy402;
		default: goto yy16;
	}
yy259:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '-': goto yy395;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'E': goto yy402;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 'e': goto yy403;
		default: goto yy16;
	}
yy260:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'H':
		case 'h': goto yy404;
		default: goto yy16;
	}
yy261:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'V':
		case 'v': goto yy405;
		default: goto yy16;
	}
yy262:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'H': goto yy404;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 'h': goto yy406;
		default: goto yy16;
	}
yy263:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'V': goto yy405;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 'v': goto yy407;
		default: goto yy16;
	}
yy264:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '-': goto yy395;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'R':
		case 'r': goto yy408;
		default: goto yy16;
	}
yy265:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'T':
		case 't': goto yy409;
		default: goto yy16;
	}
yy266:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'S':
		case 's': goto yy404;
		default: goto yy16;
	}
yy267:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'R':
		case 'r': goto yy410;
		default: goto yy16;
	}
yy268:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'D':
		case 'd': goto yy411;
		default: goto yy269;
	}
yy269:
#line 1308 "real_world/parse_date.re"
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		s->time->relative.weekday_behavior = 1;
		
		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
#line 10520 "real_world/parse_date.c"
yy270:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '-': goto yy395;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'R': goto yy408;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 'r': goto yy412;
		default: goto yy16;
	}
yy271:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'T': goto yy409;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 't': goto yy413;
		default: goto yy16;
	}
yy272:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'S': goto yy404;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 's': goto yy406;
		default: goto yy16;
	}
yy273:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'R': goto yy410;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 'r': goto yy414;
		default: goto yy16;
	}
yy274:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'D': goto yy411;
		case 'a':
		case 'b':
		case 'c':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 'd': goto yy415;
		default: goto yy269;
	}
yy275:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 14) YYFILL(14);
	yych = *YYCURSOR;
yy276:
	switch (yych) {
		case ' ':
		case ',':
		case '.':
		case 'd':
		case 'h':
		case 'n':
		case 'r':
		case 's':
		case 't': goto yy275;
		case '0':
		case '1': goto yy416;
		case '2': goto yy417;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy418;
		default: goto yy124;
	}
yy277:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.': goto yy419;
		case '0':
		case '1': goto yy420;
		case '2': goto yy421;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy422;
		case ':': goto yy423;
		default: goto yy276;
	}
yy278:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy423;
		case '0':
		case '1':
		case '2':
		case '3': goto yy424;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy425;
		default: goto yy124;
	}
yy279:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy423;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy425;
		default: goto yy124;
	}
yy280:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy423;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy424;
		default: goto yy124;
	}
yy281:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		default: goto yy16;
	}
yy282:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '-': goto yy395;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'U':
		case 'u': goto yy426;
		default: goto yy16;
	}
yy283:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '-': goto yy395;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'z': goto yy394;
		case 'Y':
		case 'y': goto yy427;
		default: goto yy16;
	}
yy284:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '-': goto yy395;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'E':
		case 'e': goto yy427;
		default: goto yy16;
	}
yy285:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '-': goto yy395;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'U': goto yy426;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 'u': goto yy428;
		default: goto yy16;
	}
yy286:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '-': goto yy395;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Z': goto yy394;
		case 'Y': goto yy427;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'z': goto yy399;
		case 'y': goto yy429;
		default: goto yy16;
	}
yy287:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '-': goto yy395;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'E': goto yy427;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 'e': goto yy429;
		default: goto yy16;
	}
yy288:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'T':
		case 't': goto yy430;
		default: goto yy16;
	}
yy289:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'T': goto yy430;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 't': goto yy431;
		default: goto yy16;
	}
yy290:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '-': goto yy395;
		case 'A':
		case 'B':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'C':
		case 'c': goto yy432;
		default: goto yy16;
	}
yy291:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '-': goto yy395;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		default: goto yy16;
	}
yy292:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'N':
		case 'n': goto yy433;
		default: goto yy16;
	}
yy293:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '-': goto yy395;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'C': goto yy432;
		case 'a':
		case 'b':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 'c': goto yy434;
		default: goto yy16;
	}
yy294:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '-': goto yy395;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		default: goto yy16;
	}
yy295:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'N': goto yy433;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 'n': goto yy435;
		default: goto yy16;
	}
yy296:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'N':
		case 'n': goto yy436;
		default: goto yy16;
	}
yy297:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		default: goto yy298;
	}
yy298:
#line 863 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 12235 "real_world/parse_date.c"
yy299:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'N': goto yy436;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 'n': goto yy438;
		default: goto yy16;
	}
yy300:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		default: goto yy298;
	}
yy301:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '-': goto yy395;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'O':
		case 'o': goto yy439;
		default: goto yy16;
	}
yy302:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '-': goto yy395;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'O': goto yy439;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 'o': goto yy440;
		default: goto yy16;
	}
yy303:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'V':
		case 'v': goto yy441;
		default: goto yy16;
	}
yy304:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'V': goto yy441;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 'v': goto yy442;
		default: goto yy16;
	}
yy305:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'U':
		case 'u': goto yy443;
		default: goto yy269;
	}
yy306:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'O':
		case 'o': goto yy444;
		default: goto yy16;
	}
yy307:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '-': goto yy395;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'T':
		case 't': goto yy445;
		default: goto yy16;
	}
yy308:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'E':
		case 'e': goto yy446;
		default: goto yy16;
	}
yy309:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'U': goto yy443;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 'u': goto yy447;
		default: goto yy269;
	}
yy310:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'O': goto yy444;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 'o': goto yy448;
		default: goto yy16;
	}
yy311:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '-': goto yy395;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'T': goto yy445;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 't': goto yy449;
		default: goto yy16;
	}
yy312:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'E': goto yy446;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 'e': goto yy450;
		default: goto yy16;
	}
yy313:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'R':
		case 'r': goto yy451;
		case 'S':
		case 's': goto yy430;
		default: goto yy16;
	}
yy314:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'R':
		case 'r': goto yy452;
		default: goto yy269;
	}
yy315:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'a': goto yy453;
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		default: goto yy16;
	}
yy316:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'O':
		case 'o': goto yy454;
		default: goto yy16;
	}
yy317:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'S':
		case 's': goto yy455;
		default: goto yy269;
	}
yy318:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'L':
		case 'l': goto yy456;
		default: goto yy16;
	}
yy319:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'R': goto yy451;
		case 'S': goto yy430;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 'r': goto yy457;
		case 's': goto yy431;
		default: goto yy16;
	}
yy320:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'R': goto yy452;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 'r': goto yy458;
		default: goto yy269;
	}
yy321:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A': goto yy453;
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'a': goto yy459;
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		default: goto yy16;
	}
yy322:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'O': goto yy454;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 'o': goto yy460;
		default: goto yy16;
	}
yy323:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'S': goto yy455;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 's': goto yy461;
		default: goto yy269;
	}
yy324:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'L': goto yy456;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 'l': goto yy462;
		default: goto yy16;
	}
yy325:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'I': goto yy427;
		default: goto yy16;
	}
yy326:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'N':
		case 'n': goto yy463;
		default: goto yy269;
	}
yy327:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'N': goto yy463;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 'n': goto yy464;
		default: goto yy269;
	}
yy328:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy394;
		case 'T':
		case 't': goto yy465;
		default: goto yy16;
	}
yy329:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy394;
		case 'T': goto yy465;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy399;
		case 't': goto yy466;
		default: goto yy16;
	}
yy330:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'C':
		case 'c': goto yy372;
		default: goto yy50;
	}
yy331:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy97;
		default: goto yy16;
	}
yy332:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'P':
		case 'p': goto yy373;
		default: goto yy50;
	}
yy333:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2': goto yy467;
		case '3': goto yy469;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy470;
		default: goto yy50;
	}
yy334:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy471;
		case '6': goto yy472;
		case '7':
		case '8':
		case '9': goto yy473;
		default: goto yy50;
	}
yy335:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy474;
		case '6': goto yy475;
		case '7':
		case '8':
		case '9': goto yy476;
		default: goto yy50;
	}
yy336:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy477;
		default: goto yy50;
	}
yy337:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'd': goto yy478;
		default: goto yy50;
	}
yy338:
	yych = *++YYCURSOR;
	switch (yych) {
		case 't': goto yy478;
		default: goto yy50;
	}
yy339:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'h': goto yy478;
		default: goto yy50;
	}
yy340:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R':
		case 'r': goto yy479;
		default: goto yy50;
	}
yy341:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'G':
		case 'g': goto yy479;
		default: goto yy50;
	}
yy342:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'C':
		case 'c': goto yy479;
		default: goto yy50;
	}
yy343:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'B':
		case 'b': goto yy479;
		default: goto yy50;
	}
yy344:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'N':
		case 'n': goto yy479;
		default: goto yy50;
	}
yy345:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'L':
		case 'N':
		case 'l':
		case 'n': goto yy479;
		default: goto yy50;
	}
yy346:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R':
		case 'Y':
		case 'r':
		case 'y': goto yy479;
		default: goto yy50;
	}
yy347:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'V':
		case 'v': goto yy479;
		default: goto yy50;
	}
yy348:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T':
		case 't': goto yy479;
		default: goto yy50;
	}
yy349:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'P':
		case 'p': goto yy480;
		default: goto yy50;
	}
yy350:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'S':
		case 'T':
		case 'V':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'n':
		case 'o':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy482;
		case '-': goto yy485;
		case '.': goto yy486;
		case '/': goto yy487;
		case '0': goto yy488;
		case '1': goto yy489;
		case '2': goto yy490;
		case '3': goto yy491;
		case '4':
		case '5': goto yy492;
		case '6': goto yy493;
		case '7':
		case '8':
		case '9': goto yy51;
		case ':': goto yy494;
		case 'W': goto yy506;
		default: goto yy351;
	}
yy351:
#line 971 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
#line 14468 "real_world/parse_date.c"
yy352:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'S':
		case 'T':
		case 'V':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'n':
		case 'o':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy482;
		case '-': goto yy485;
		case '.': goto yy486;
		case '/': goto yy487;
		case '0': goto yy508;
		case '1': goto yy509;
		case '2': goto yy510;
		case '3': goto yy511;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy51;
		case ':': goto yy494;
		case 'W': goto yy506;
		default: goto yy353;
	}
yy353:
#line 1284 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 14538 "real_world/parse_date.c"
yy354:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy215;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy216;
		case 'I':
		case 'i': goto yy512;
		default: goto yy70;
	}
yy355:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy215;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy216;
		case 'U':
		case 'u': goto yy513;
		default: goto yy70;
	}
yy356:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'S':
		case 's': goto yy514;
		default: goto yy357;
	}
yy357:
#line 1380 "real_world/parse_date.re"
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 0, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 14628 "real_world/parse_date.c"
yy358:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy215;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy216;
		case 'E':
		case 'e': goto yy515;
		default: goto yy70;
	}
yy359:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy215;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy216;
		case 'R':
		case 'r': goto yy516;
		default: goto yy70;
	}
yy360:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T':
		case 't': goto yy517;
		default: goto yy50;
	}
yy361:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'D':
		case 'd': goto yy518;
		default: goto yy357;
	}
yy362:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R':
		case 'r': goto yy356;
		default: goto yy50;
	}
yy363:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy519;
		default: goto yy217;
	}
yy364:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy215;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy216;
		case 'U':
		case 'u': goto yy520;
		default: goto yy70;
	}
yy365:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy215;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy216;
		case 'Y':
		case 'y': goto yy219;
		default: goto yy70;
	}
yy366:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy215;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy216;
		case 'E':
		case 'e': goto yy219;
		default: goto yy70;
	}
yy367:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy215;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy216;
		case 'C':
		case 'c': goto yy521;
		default: goto yy70;
	}
yy368:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'S':
		case 's': goto yy514;
		case 'U':
		case 'u': goto yy522;
		default: goto yy357;
	}
yy369:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'D':
		case 'd': goto yy518;
		case 'T':
		case 't': goto yy523;
		default: goto yy357;
	}
yy370:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy215;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy216;
		case 'O':
		case 'o': goto yy524;
		default: goto yy70;
	}
yy371:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'U':
		case 'u': goto yy525;
		default: goto yy357;
	}
yy372:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'O':
		case 'o': goto yy526;
		case 'S':
		case 's': goto yy514;
		default: goto yy357;
	}
yy373:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy215;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy216;
		case 'T':
		case 't': goto yy358;
		default: goto yy70;
	}
yy374:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'R':
		case 'r': goto yy527;
		default: goto yy357;
	}
yy375:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'S':
		case 's': goto yy528;
		default: goto yy357;
	}
yy376:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'N':
		case 'n': goto yy529;
		default: goto yy357;
	}
yy377:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'K':
		case 'k': goto yy356;
		default: goto yy50;
	}
yy378:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy530;
		case '6': goto yy531;
		case '7':
		case '8':
		case '9': goto yy473;
		default: goto yy50;
	}
yy379:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ': goto yy532;
		case '.': goto yy378;
		case ':': goto yy380;
		case 'A':
		case 'P':
		case 'a':
		case 'p': goto yy91;
		default: goto yy187;
	}
yy380:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy533;
		case '6': goto yy534;
		case '7':
		case '8':
		case '9': goto yy476;
		default: goto yy50;
	}
yy381:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ': goto yy532;
		case '.':
		case ':': goto yy380;
		case 'A':
		case 'P':
		case 'a':
		case 'p': goto yy91;
		default: goto yy187;
	}
yy382:
	++YYCURSOR;
	goto yy245;
yy383:
	yych = *++YYCURSOR;
	switch (yych) {
		case '.': goto yy535;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy385;
		default: goto yy50;
	}
yy384:
	yych = *++YYCURSOR;
	switch (yych) {
		case '.': goto yy535;
		case '0':
		case '1':
		case '2': goto yy385;
		default: goto yy50;
	}
yy385:
	yych = *++YYCURSOR;
	switch (yych) {
		case '.': goto yy535;
		default: goto yy50;
	}
yy386:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'P':
		case 'p': goto yy536;
		case 'U':
		case 'u': goto yy537;
		default: goto yy50;
	}
yy387:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy538;
		default: goto yy50;
	}
yy388:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy539;
		default: goto yy50;
	}
yy389:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy540;
		case 'U':
		case 'u': goto yy541;
		default: goto yy50;
	}
yy390:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy542;
		default: goto yy50;
	}
yy391:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'O':
		case 'o': goto yy543;
		default: goto yy50;
	}
yy392:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'C':
		case 'c': goto yy544;
		default: goto yy50;
	}
yy393:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy545;
		default: goto yy50;
	}
yy394:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		default: goto yy16;
	}
yy395:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy546;
		case '1':
		case '2': goto yy547;
		case '3': goto yy548;
		default: goto yy121;
	}
yy396:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case 'L':
		case 'l': goto yy120;
		default: goto yy16;
	}
yy397:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case 'S':
		case 's': goto yy549;
		default: goto yy16;
	}
yy398:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy550;
		default: goto yy50;
	}
yy399:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		default: goto yy16;
	}
yy400:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'L': goto yy120;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'l': goto yy553;
		default: goto yy16;
	}
yy401:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'S': goto yy549;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 's': goto yy554;
		default: goto yy16;
	}
yy402:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case 'M':
		case 'm': goto yy555;
		default: goto yy16;
	}
yy403:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'M': goto yy555;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'm': goto yy556;
		default: goto yy16;
	}
yy404:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case 'T':
		case 't': goto yy557;
		default: goto yy16;
	}
yy405:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case 'E':
		case 'e': goto yy559;
		default: goto yy16;
	}
yy406:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'T': goto yy557;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 't': goto yy560;
		default: goto yy16;
	}
yy407:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'E': goto yy559;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'e': goto yy561;
		default: goto yy16;
	}
yy408:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case 'U':
		case 'u': goto yy562;
		default: goto yy16;
	}
yy409:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case 'H':
		case 'h': goto yy557;
		default: goto yy16;
	}
yy410:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case 'T':
		case 't': goto yy563;
		default: goto yy16;
	}
yy411:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'a': goto yy564;
		default: goto yy16;
	}
yy412:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'U': goto yy562;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'u': goto yy565;
		default: goto yy16;
	}
yy413:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'H': goto yy557;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'h': goto yy560;
		default: goto yy16;
	}
yy414:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'T': goto yy563;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 't': goto yy566;
		default: goto yy16;
	}
yy415:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A': goto yy564;
		case 'a': goto yy567;
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		default: goto yy16;
	}
yy416:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy423;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy568;
		default: goto yy124;
	}
yy417:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy423;
		case '0':
		case '1':
		case '2':
		case '3': goto yy568;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy569;
		default: goto yy124;
	}
yy418:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy423;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy569;
		default: goto yy124;
	}
yy419:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1': goto yy570;
		case '2': goto yy571;
		case '3':
		case '4':
		case '5': goto yy572;
		case '6':
		case '7':
		case '8':
		case '9': goto yy573;
		default: goto yy276;
	}
yy420:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy423;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy574;
		default: goto yy124;
	}
yy421:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy423;
		case '0':
		case '1':
		case '2':
		case '3': goto yy574;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy576;
		default: goto yy124;
	}
yy422:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy423;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy576;
		default: goto yy124;
	}
yy423:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy577;
		case '6':
		case '7':
		case '8':
		case '9': goto yy579;
		default: goto yy50;
	}
yy424:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy423;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy580;
		default: goto yy124;
	}
yy425:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy580;
		default: goto yy124;
	}
yy426:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case 'A':
		case 'a': goto yy581;
		default: goto yy16;
	}
yy427:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		default: goto yy16;
	}
yy428:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'A': goto yy581;
		case 'a': goto yy582;
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		default: goto yy16;
	}
yy429:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '/':
		case '_': goto yy253;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		default: goto yy16;
	}
yy430:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy558;
		case ')': goto yy97;
		default: goto yy16;
	}
yy431:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y': goto yy558;
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'a':
		case 'b':
		case 'c':
		case 'e':
		case 'g':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 'u':
		case 'v':
		case 'x':
		case 'z': goto yy551;
		case 'd': goto yy591;
		case 'f': goto yy592;
		case 'h': goto yy593;
		case 'm': goto yy594;
		case 's': goto yy595;
		case 't': goto yy596;
		case 'w': goto yy597;
		case 'y': goto yy598;
		default: goto yy16;
	}
yy432:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case 'H':
		case 'h': goto yy120;
		default: goto yy16;
	}
yy433:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case 'I':
		case 'i': goto yy599;
		default: goto yy16;
	}
yy434:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'H': goto yy120;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'h': goto yy553;
		default: goto yy16;
	}
yy435:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'I': goto yy599;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'i': goto yy600;
		default: goto yy16;
	}
yy436:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		default: goto yy437;
	}
yy437:
#line 872 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 16119 "real_world/parse_date.c"
yy438:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		default: goto yy437;
	}
yy439:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case 'B':
		case 'b': goto yy601;
		default: goto yy16;
	}
yy440:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'B': goto yy601;
		case 'a':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'b': goto yy602;
		default: goto yy16;
	}
yy441:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case 'I':
		case 'i': goto yy603;
		default: goto yy16;
	}
yy442:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'I': goto yy603;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'i': goto yy604;
		default: goto yy16;
	}
yy443:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case 'R':
		case 'r': goto yy605;
		default: goto yy16;
	}
yy444:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case 'N':
		case 'n': goto yy606;
		default: goto yy16;
	}
yy445:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '-': goto yy395;
		case 'E':
		case 'e': goto yy607;
		default: goto yy16;
	}
yy446:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case 'N':
		case 'n': goto yy608;
		default: goto yy16;
	}
yy447:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'R': goto yy605;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'r': goto yy609;
		default: goto yy16;
	}
yy448:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'N': goto yy606;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'n': goto yy610;
		default: goto yy16;
	}
yy449:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case '*':
		case '+':
		case ',':
		case '.':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy121;
		case ')': goto yy122;
		case '-': goto yy395;
		case '/':
		case '_': goto yy253;
		case 'E': goto yy607;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'e': goto yy611;
		default: goto yy16;
	}
yy450:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'N': goto yy608;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'n': goto yy612;
		default: goto yy16;
	}
yy451:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case 'D':
		case 'd': goto yy557;
		default: goto yy16;
	}
yy452:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case 'S':
		case 's': goto yy605;
		default: goto yy16;
	}
yy453:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy97;
		case 'Y':
		case 'y': goto yy613;
		default: goto yy16;
	}
yy454:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case 'R':
		case 'r': goto yy615;
		default: goto yy16;
	}
yy455:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case 'D':
		case 'd': goto yy616;
		default: goto yy16;
	}
yy456:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case 'F':
		case 'f': goto yy608;
		default: goto yy16;
	}
yy457:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'D': goto yy557;
		case 'a':
		case 'b':
		case 'c':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'd': goto yy560;
		default: goto yy16;
	}
yy458:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'S': goto yy605;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 's': goto yy609;
		default: goto yy16;
	}
yy459:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'Y': goto yy613;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'z': goto yy551;
		case 'y': goto yy617;
		default: goto yy16;
	}
yy460:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'R': goto yy615;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'r': goto yy618;
		default: goto yy16;
	}
yy461:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'D': goto yy616;
		case 'a':
		case 'b':
		case 'c':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'd': goto yy619;
		default: goto yy16;
	}
yy462:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'F': goto yy608;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'f': goto yy612;
		default: goto yy16;
	}
yy463:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case 'E':
		case 'e': goto yy620;
		default: goto yy16;
	}
yy464:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'E': goto yy620;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'e': goto yy621;
		default: goto yy16;
	}
yy465:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case 'E':
		case 'e': goto yy622;
		default: goto yy16;
	}
yy466:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '/':
		case '_': goto yy253;
		case 'E': goto yy622;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'e': goto yy623;
		default: goto yy16;
	}
yy467:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy470;
		case 'n':
		case 'r': goto yy624;
		case 's': goto yy625;
		case 't': goto yy626;
		default: goto yy468;
	}
yy468:
#line 1061 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 16865 "real_world/parse_date.c"
yy469:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '0':
		case '1': goto yy470;
		case 'n':
		case 'r': goto yy624;
		case 's': goto yy625;
		case 't': goto yy626;
		default: goto yy468;
	}
yy470:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'n':
		case 'r': goto yy624;
		case 's': goto yy625;
		case 't': goto yy626;
		default: goto yy468;
	}
yy471:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.': goto yy627;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy628;
		default: goto yy187;
	}
yy472:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.': goto yy627;
		case '0': goto yy628;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy629;
		default: goto yy187;
	}
yy473:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.': goto yy627;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy629;
		default: goto yy187;
	}
yy474:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.': goto yy627;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy476;
		default: goto yy187;
	}
yy475:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.': goto yy627;
		case '0': goto yy476;
		default: goto yy187;
	}
yy476:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.': goto yy627;
		default: goto yy187;
	}
yy477:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy631;
		default: goto yy192;
	}
yy478:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '/': goto yy336;
		default: goto yy192;
	}
yy479:
	yych = *++YYCURSOR;
	switch (yych) {
		case '/': goto yy632;
		default: goto yy50;
	}
yy480:
	yych = *++YYCURSOR;
	switch (yych) {
		case '/': goto yy632;
		case 'T':
		case 't': goto yy479;
		default: goto yy50;
	}
yy481:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy482:
	switch (yych) {
		case ' ': goto yy481;
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy483;
		case 'A':
		case 'a': goto yy495;
		case 'D':
		case 'd': goto yy496;
		case 'F':
		case 'f': goto yy497;
		case 'H':
		case 'h': goto yy68;
		case 'I': goto yy498;
		case 'J':
		case 'j': goto yy500;
		case 'M':
		case 'm': goto yy501;
		case 'N':
		case 'n': goto yy502;
		case 'O':
		case 'o': goto yy503;
		case 'S':
		case 's': goto yy504;
		case 'T':
		case 't': goto yy76;
		case 'V': goto yy505;
		case 'W':
		case 'w': goto yy78;
		case 'X': goto yy507;
		case 'Y':
		case 'y': goto yy80;
		default: goto yy50;
	}
yy483:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy484:
	switch (yych) {
		case ' ':
		case '!':
		case '"':
		case '#':
		case '$':
		case '%':
		case '&':
		case '\'':
		case '(':
		case ')':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.': goto yy483;
		case 'A':
		case 'a': goto yy495;
		case 'D':
		case 'd': goto yy633;
		case 'F':
		case 'f': goto yy634;
		case 'I': goto yy498;
		case 'J':
		case 'j': goto yy500;
		case 'M':
		case 'm': goto yy635;
		case 'N':
		case 'n': goto yy502;
		case 'O':
		case 'o': goto yy503;
		case 'S':
		case 's': goto yy636;
		case 'V': goto yy505;
		case 'X': goto yy507;
		default: goto yy50;
	}
yy485:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy637;
		case '1': goto yy638;
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy639;
		case 'A':
		case 'a': goto yy640;
		case 'D':
		case 'd': goto yy641;
		case 'F':
		case 'f': goto yy642;
		case 'J':
		case 'j': goto yy643;
		case 'M':
		case 'm': goto yy644;
		case 'N':
		case 'n': goto yy645;
		case 'O':
		case 'o': goto yy646;
		case 'S':
		case 's': goto yy647;
		default: goto yy484;
	}
yy486:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy648;
		case '1':
		case '2': goto yy649;
		case '3': goto yy650;
		default: goto yy484;
	}
yy487:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy651;
		case '1': goto yy652;
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy653;
		default: goto yy50;
	}
yy488:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy654;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy656;
		default: goto yy171;
	}
yy489:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2': goto yy656;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy657;
		default: goto yy171;
	}
yy490:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy657;
		default: goto yy171;
	}
yy491:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy657;
		case '6': goto yy658;
		case '7':
		case '8':
		case '9': goto yy659;
		default: goto yy171;
	}
yy492:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy659;
		default: goto yy171;
	}
yy493:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy659;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy51;
		default: goto yy171;
	}
yy494:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy660;
		case '1': goto yy661;
		default: goto yy50;
	}
yy495:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'P':
		case 'p': goto yy662;
		case 'U':
		case 'u': goto yy663;
		default: goto yy50;
	}
yy496:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy209;
		case 'E':
		case 'e': goto yy664;
		default: goto yy50;
	}
yy497:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy665;
		case 'O':
		case 'o': goto yy212;
		case 'R':
		case 'r': goto yy213;
		default: goto yy50;
	}
yy498:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'I': goto yy666;
		case 'V':
		case 'X': goto yy667;
		default: goto yy499;
	}
yy499:
#line 1114 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 17301 "real_world/parse_date.c"
yy500:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy668;
		case 'U':
		case 'u': goto yy669;
		default: goto yy50;
	}
yy501:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy670;
		case 'I':
		case 'i': goto yy223;
		case 'O':
		case 'o': goto yy224;
		default: goto yy50;
	}
yy502:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'O':
		case 'o': goto yy671;
		default: goto yy50;
	}
yy503:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'C':
		case 'c': goto yy672;
		default: goto yy50;
	}
yy504:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy227;
		case 'E':
		case 'e': goto yy673;
		case 'U':
		case 'u': goto yy229;
		default: goto yy50;
	}
yy505:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'I': goto yy507;
		default: goto yy499;
	}
yy506:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy674;
		case '1':
		case '2':
		case '3':
		case '4': goto yy675;
		case '5': goto yy676;
		case 'E':
		case 'e': goto yy232;
		default: goto yy50;
	}
yy507:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'I': goto yy666;
		default: goto yy499;
	}
yy508:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy677;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy678;
		default: goto yy171;
	}
yy509:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2': goto yy678;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy679;
		default: goto yy171;
	}
yy510:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy679;
		default: goto yy171;
	}
yy511:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy679;
		case '6': goto yy680;
		case '7':
		case '8':
		case '9': goto yy51;
		default: goto yy171;
	}
yy512:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'L':
		case 'l': goto yy219;
		default: goto yy50;
	}
yy513:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'S':
		case 's': goto yy681;
		default: goto yy50;
	}
yy514:
	++YYCURSOR;
	goto yy357;
yy515:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'M':
		case 'm': goto yy524;
		default: goto yy50;
	}
yy516:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'U':
		case 'u': goto yy520;
		default: goto yy50;
	}
yy517:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'H':
		case 'h': goto yy682;
		case 'N':
		case 'n': goto yy683;
		default: goto yy50;
	}
yy518:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy684;
		default: goto yy50;
	}
yy519:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy685;
		default: goto yy217;
	}
yy520:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy686;
		default: goto yy50;
	}
yy521:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'H':
		case 'h': goto yy219;
		default: goto yy50;
	}
yy522:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T':
		case 't': goto yy687;
		default: goto yy50;
	}
yy523:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'H':
		case 'h': goto yy356;
		default: goto yy50;
	}
yy524:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'B':
		case 'b': goto yy688;
		default: goto yy50;
	}
yy525:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R':
		case 'r': goto yy528;
		default: goto yy50;
	}
yy526:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'N':
		case 'n': goto yy689;
		default: goto yy50;
	}
yy527:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'S':
		case 's': goto yy528;
		default: goto yy50;
	}
yy528:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'D':
		case 'd': goto yy518;
		default: goto yy50;
	}
yy529:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy527;
		default: goto yy50;
	}
yy530:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.': goto yy627;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy690;
		default: goto yy187;
	}
yy531:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.': goto yy627;
		case '0': goto yy690;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy629;
		default: goto yy187;
	}
yy532:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	switch (yych) {
		case ' ': goto yy532;
		case 'A':
		case 'P':
		case 'a':
		case 'p': goto yy91;
		default: goto yy50;
	}
yy533:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.': goto yy627;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy691;
		default: goto yy187;
	}
yy534:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.': goto yy627;
		case '0': goto yy691;
		default: goto yy187;
	}
yy535:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy692;
		default: goto yy50;
	}
yy536:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R':
		case 'r': goto yy693;
		default: goto yy50;
	}
yy537:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'G':
		case 'g': goto yy693;
		default: goto yy50;
	}
yy538:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'C':
		case 'c': goto yy693;
		default: goto yy50;
	}
yy539:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'B':
		case 'b': goto yy693;
		default: goto yy50;
	}
yy540:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'N':
		case 'n': goto yy693;
		default: goto yy50;
	}
yy541:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'L':
		case 'N':
		case 'l':
		case 'n': goto yy693;
		default: goto yy50;
	}
yy542:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R':
		case 'Y':
		case 'r':
		case 'y': goto yy693;
		default: goto yy50;
	}
yy543:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'V':
		case 'v': goto yy693;
		default: goto yy50;
	}
yy544:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T':
		case 't': goto yy693;
		default: goto yy50;
	}
yy545:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'P':
		case 'p': goto yy694;
		default: goto yy50;
	}
yy546:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy277;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy695;
		default: goto yy276;
	}
yy547:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy695;
		default: goto yy276;
	}
yy548:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1': goto yy695;
		case '2': goto yy278;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy279;
		default: goto yy276;
	}
yy549:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T':
		case 't': goto yy120;
		default: goto yy50;
	}
yy550:
	yyaccept = 2;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '/':
		case '_': goto yy253;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy550;
		default: goto yy16;
	}
yy551:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy552:
	switch (yych) {
		case '/':
		case '_': goto yy253;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		default: goto yy50;
	}
yy553:
	yych = *++YYCURSOR;
	switch (yych) {
		case '/':
		case '_': goto yy253;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		default: goto yy121;
	}
yy554:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T': goto yy120;
		case 't': goto yy553;
		default: goto yy552;
	}
yy555:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'B':
		case 'b': goto yy601;
		default: goto yy50;
	}
yy556:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'B': goto yy601;
		case 'b': goto yy602;
		default: goto yy552;
	}
yy557:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy558:
	switch (yych) {
		case ' ': goto yy557;
		case 'D':
		case 'd': goto yy583;
		case 'F':
		case 'f': goto yy584;
		case 'H':
		case 'h': goto yy585;
		case 'M':
		case 'm': goto yy586;
		case 'S':
		case 's': goto yy587;
		case 'T':
		case 't': goto yy588;
		case 'W':
		case 'w': goto yy589;
		case 'Y':
		case 'y': goto yy590;
		default: goto yy50;
	}
yy559:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'N':
		case 'n': goto yy608;
		default: goto yy50;
	}
yy560:
	yych = *++YYCURSOR;
	switch (yych) {
		case '/':
		case '_': goto yy253;
		case 'a':
		case 'b':
		case 'c':
		case 'e':
		case 'g':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 'u':
		case 'v':
		case 'x':
		case 'z': goto yy551;
		case 'd': goto yy591;
		case 'f': goto yy592;
		case 'h': goto yy593;
		case 'm': goto yy594;
		case 's': goto yy595;
		case 't': goto yy596;
		case 'w': goto yy597;
		case 'y': goto yy598;
		default: goto yy558;
	}
yy561:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'N': goto yy608;
		case 'n': goto yy612;
		default: goto yy552;
	}
yy562:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy581;
		default: goto yy50;
	}
yy563:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'H':
		case 'h': goto yy557;
		default: goto yy50;
	}
yy564:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'Y':
		case 'y': goto yy696;
		default: goto yy50;
	}
yy565:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A': goto yy581;
		case 'a': goto yy582;
		default: goto yy552;
	}
yy566:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'H': goto yy557;
		case 'h': goto yy560;
		default: goto yy552;
	}
yy567:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'Y': goto yy696;
		case 'y': goto yy697;
		default: goto yy552;
	}
yy568:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy423;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy698;
		default: goto yy124;
	}
yy569:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy698;
		default: goto yy124;
	}
yy570:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy699;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy700;
		default: goto yy124;
	}
yy571:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy699;
		case '0':
		case '1':
		case '2':
		case '3': goto yy700;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy701;
		default: goto yy124;
	}
yy572:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy699;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy701;
		default: goto yy124;
	}
yy573:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy699;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy569;
		default: goto yy124;
	}
yy574:
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy423;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy698;
		default: goto yy575;
	}
yy575:
#line 1101 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 18152 "real_world/parse_date.c"
yy576:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy698;
		default: goto yy575;
	}
yy577:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy702;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy579;
		default: goto yy578;
	}
yy578:
#line 1352 "real_world/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 18214 "real_world/parse_date.c"
yy579:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy702;
		default: goto yy578;
	}
yy580:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy703;
		default: goto yy575;
	}
yy581:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R':
		case 'r': goto yy704;
		default: goto yy50;
	}
yy582:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R': goto yy704;
		case 'r': goto yy705;
		default: goto yy552;
	}
yy583:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy706;
		default: goto yy50;
	}
yy584:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'O':
		case 'o': goto yy707;
		case 'R':
		case 'r': goto yy708;
		default: goto yy50;
	}
yy585:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'O':
		case 'o': goto yy709;
		default: goto yy50;
	}
yy586:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'I':
		case 'i': goto yy710;
		case 'O':
		case 'o': goto yy711;
		default: goto yy50;
	}
yy587:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy712;
		case 'E':
		case 'e': goto yy713;
		case 'U':
		case 'u': goto yy714;
		default: goto yy50;
	}
yy588:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'H':
		case 'h': goto yy715;
		case 'U':
		case 'u': goto yy716;
		default: goto yy50;
	}
yy589:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy717;
		default: goto yy50;
	}
yy590:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy718;
		default: goto yy50;
	}
yy591:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A': goto yy706;
		case 'a': goto yy719;
		default: goto yy552;
	}
yy592:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'O': goto yy707;
		case 'R': goto yy708;
		case 'o': goto yy720;
		case 'r': goto yy721;
		default: goto yy552;
	}
yy593:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'O': goto yy709;
		case 'o': goto yy722;
		default: goto yy552;
	}
yy594:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'I': goto yy710;
		case 'O': goto yy711;
		case 'i': goto yy723;
		case 'o': goto yy724;
		default: goto yy552;
	}
yy595:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A': goto yy712;
		case 'E': goto yy713;
		case 'U': goto yy714;
		case 'a': goto yy725;
		case 'e': goto yy726;
		case 'u': goto yy727;
		default: goto yy552;
	}
yy596:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'H': goto yy715;
		case 'U': goto yy716;
		case 'h': goto yy728;
		case 'u': goto yy729;
		default: goto yy552;
	}
yy597:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E': goto yy717;
		case 'e': goto yy730;
		default: goto yy552;
	}
yy598:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E': goto yy718;
		case 'e': goto yy731;
		default: goto yy552;
	}
yy599:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'G':
		case 'g': goto yy732;
		default: goto yy50;
	}
yy600:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'G': goto yy732;
		case 'g': goto yy733;
		default: goto yy552;
	}
yy601:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy734;
		default: goto yy50;
	}
yy602:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E': goto yy734;
		case 'e': goto yy735;
		default: goto yy552;
	}
yy603:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'O':
		case 'o': goto yy736;
		default: goto yy50;
	}
yy604:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'O': goto yy736;
		case 'o': goto yy737;
		default: goto yy552;
	}
yy605:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'D':
		case 'd': goto yy616;
		default: goto yy50;
	}
yy606:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'D':
		case 'd': goto yy557;
		default: goto yy50;
	}
yy607:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'M':
		case 'm': goto yy555;
		default: goto yy50;
	}
yy608:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T':
		case 't': goto yy563;
		default: goto yy50;
	}
yy609:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'D': goto yy616;
		case 'd': goto yy619;
		default: goto yy552;
	}
yy610:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'D': goto yy557;
		case 'd': goto yy560;
		default: goto yy552;
	}
yy611:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'M': goto yy555;
		case 'm': goto yy556;
		default: goto yy552;
	}
yy612:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T': goto yy563;
		case 't': goto yy566;
		default: goto yy552;
	}
yy613:
	++YYCURSOR;
yy614:
#line 884 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 18494 "real_world/parse_date.c"
yy615:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R':
		case 'r': goto yy738;
		default: goto yy50;
	}
yy616:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy564;
		default: goto yy50;
	}
yy617:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '/':
		case '_': goto yy253;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		default: goto yy614;
	}
yy618:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R': goto yy738;
		case 'r': goto yy739;
		default: goto yy552;
	}
yy619:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A': goto yy564;
		case 'a': goto yy567;
		default: goto yy552;
	}
yy620:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'S':
		case 's': goto yy605;
		default: goto yy50;
	}
yy621:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'S': goto yy605;
		case 's': goto yy609;
		default: goto yy552;
	}
yy622:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R':
		case 'r': goto yy740;
		default: goto yy50;
	}
yy623:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R': goto yy740;
		case 'r': goto yy741;
		default: goto yy552;
	}
yy624:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'd': goto yy742;
		default: goto yy50;
	}
yy625:
	yych = *++YYCURSOR;
	switch (yych) {
		case 't': goto yy742;
		default: goto yy50;
	}
yy626:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'h': goto yy742;
		default: goto yy50;
	}
yy627:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy743;
		default: goto yy50;
	}
yy628:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.': goto yy627;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy744;
		default: goto yy187;
	}
yy629:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy744;
		default: goto yy630;
	}
yy630:
#line 1088 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("pointed date");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 18663 "real_world/parse_date.c"
yy631:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy745;
		default: goto yy192;
	}
yy632:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy746;
		default: goto yy50;
	}
yy633:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy664;
		default: goto yy50;
	}
yy634:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy665;
		default: goto yy50;
	}
yy635:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy670;
		default: goto yy50;
	}
yy636:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy747;
		default: goto yy50;
	}
yy637:
	yych = *++YYCURSOR;
	switch (yych) {
		case '-': goto yy748;
		case '0': goto yy639;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy749;
		default: goto yy50;
	}
yy638:
	yych = *++YYCURSOR;
	switch (yych) {
		case '-': goto yy748;
		case '0':
		case '1':
		case '2': goto yy749;
		default: goto yy50;
	}
yy639:
	yych = *++YYCURSOR;
	switch (yych) {
		case '-': goto yy748;
		default: goto yy50;
	}
yy640:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'P':
		case 'p': goto yy750;
		case 'U':
		case 'u': goto yy751;
		default: goto yy50;
	}
yy641:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy752;
		default: goto yy50;
	}
yy642:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy753;
		default: goto yy50;
	}
yy643:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy754;
		case 'U':
		case 'u': goto yy755;
		default: goto yy50;
	}
yy644:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy756;
		default: goto yy50;
	}
yy645:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'O':
		case 'o': goto yy757;
		default: goto yy50;
	}
yy646:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'C':
		case 'c': goto yy758;
		default: goto yy50;
	}
yy647:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy759;
		default: goto yy50;
	}
yy648:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy760;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy761;
		default: goto yy50;
	}
yy649:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy761;
		default: goto yy50;
	}
yy650:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy761;
		case '6': goto yy762;
		default: goto yy50;
	}
yy651:
	yych = *++YYCURSOR;
	switch (yych) {
		case '/': goto yy763;
		case '0': goto yy653;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy764;
		default: goto yy50;
	}
yy652:
	yych = *++YYCURSOR;
	switch (yych) {
		case '/': goto yy763;
		case '0':
		case '1':
		case '2': goto yy764;
		default: goto yy50;
	}
yy653:
	yych = *++YYCURSOR;
	switch (yych) {
		case '/': goto yy763;
		default: goto yy50;
	}
yy654:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0': goto yy51;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy765;
		default: goto yy655;
	}
yy655:
#line 1016 "real_world/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
#line 18937 "real_world/parse_date.c"
yy656:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0': goto yy767;
		case '1':
		case '2': goto yy768;
		case '3': goto yy769;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy765;
		default: goto yy655;
	}
yy657:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy765;
		default: goto yy655;
	}
yy658:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6': goto yy765;
		case '7':
		case '8':
		case '9': goto yy51;
		default: goto yy655;
	}
yy659:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy51;
		default: goto yy655;
	}
yy660:
	yych = *++YYCURSOR;
	switch (yych) {
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy770;
		default: goto yy50;
	}
yy661:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2': goto yy770;
		default: goto yy50;
	}
yy662:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R':
		case 'r': goto yy771;
		default: goto yy50;
	}
yy663:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'G':
		case 'g': goto yy772;
		default: goto yy50;
	}
yy664:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'C':
		case 'c': goto yy773;
		default: goto yy50;
	}
yy665:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'B':
		case 'b': goto yy774;
		default: goto yy50;
	}
yy666:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'I': goto yy667;
		default: goto yy499;
	}
yy667:
	++YYCURSOR;
	goto yy499;
yy668:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'N':
		case 'n': goto yy775;
		default: goto yy50;
	}
yy669:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'L':
		case 'l': goto yy776;
		case 'N':
		case 'n': goto yy777;
		default: goto yy50;
	}
yy670:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R':
		case 'r': goto yy778;
		case 'Y':
		case 'y': goto yy667;
		default: goto yy50;
	}
yy671:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'V':
		case 'v': goto yy773;
		default: goto yy50;
	}
yy672:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T':
		case 't': goto yy779;
		default: goto yy50;
	}
yy673:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'C':
		case 'c': goto yy372;
		case 'P':
		case 'p': goto yy780;
		default: goto yy50;
	}
yy674:
	yych = *++YYCURSOR;
	switch (yych) {
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy781;
		default: goto yy50;
	}
yy675:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy781;
		default: goto yy50;
	}
yy676:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3': goto yy781;
		default: goto yy50;
	}
yy677:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy51;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy765;
		default: goto yy171;
	}
yy678:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy767;
		case '1':
		case '2': goto yy768;
		case '3': goto yy769;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy765;
		default: goto yy171;
	}
yy679:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy765;
		default: goto yy171;
	}
yy680:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6': goto yy765;
		case '7':
		case '8':
		case '9': goto yy51;
		default: goto yy171;
	}
yy681:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T':
		case 't': goto yy219;
		default: goto yy50;
	}
yy682:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'N':
		case 'n': goto yy683;
		default: goto yy50;
	}
yy683:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'I':
		case 'i': goto yy783;
		default: goto yy50;
	}
yy684:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'Y':
		case 'y': goto yy514;
		default: goto yy50;
	}
yy685:
	++YYCURSOR;
	goto yy217;
yy686:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R':
		case 'r': goto yy784;
		default: goto yy50;
	}
yy687:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy356;
		default: goto yy50;
	}
yy688:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy785;
		default: goto yy50;
	}
yy689:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'D':
		case 'd': goto yy356;
		default: goto yy50;
	}
yy690:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ': goto yy532;
		case '.': goto yy627;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy744;
		case 'A':
		case 'P':
		case 'a':
		case 'p': goto yy91;
		default: goto yy187;
	}
yy691:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ': goto yy532;
		case '.': goto yy627;
		case 'A':
		case 'P':
		case 'a':
		case 'p': goto yy91;
		default: goto yy187;
	}
yy692:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy629;
		default: goto yy630;
	}
yy693:
	yych = *++YYCURSOR;
	switch (yych) {
		case '-': goto yy786;
		default: goto yy50;
	}
yy694:
	yych = *++YYCURSOR;
	switch (yych) {
		case '-': goto yy786;
		case 'T':
		case 't': goto yy693;
		default: goto yy50;
	}
yy695:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '-': goto yy787;
		case '.': goto yy419;
		case '0':
		case '1': goto yy420;
		case '2': goto yy421;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy422;
		case ':': goto yy423;
		default: goto yy276;
	}
yy696:
	++YYCURSOR;
	goto yy269;
yy697:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '/':
		case '_': goto yy253;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		default: goto yy269;
	}
yy698:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy703;
		default: goto yy124;
	}
yy699:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy788;
		case '6': goto yy789;
		case '7':
		case '8':
		case '9': goto yy579;
		default: goto yy50;
	}
yy700:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy699;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy698;
		default: goto yy124;
	}
yy701:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy702;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy698;
		default: goto yy124;
	}
yy702:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy790;
		case '6': goto yy791;
		case '7':
		case '8':
		case '9': goto yy792;
		default: goto yy50;
	}
yy703:
	++YYCURSOR;
	goto yy124;
yy704:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'Y':
		case 'y': goto yy120;
		default: goto yy50;
	}
yy705:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'Y': goto yy120;
		case 'y': goto yy553;
		default: goto yy552;
	}
yy706:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'Y':
		case 'y': goto yy793;
		default: goto yy50;
	}
yy707:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R':
		case 'r': goto yy795;
		default: goto yy50;
	}
yy708:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'I':
		case 'i': goto yy796;
		default: goto yy50;
	}
yy709:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'U':
		case 'u': goto yy797;
		default: goto yy50;
	}
yy710:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'N':
		case 'n': goto yy798;
		default: goto yy50;
	}
yy711:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'N':
		case 'n': goto yy799;
		default: goto yy50;
	}
yy712:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T':
		case 't': goto yy800;
		default: goto yy50;
	}
yy713:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'C':
		case 'c': goto yy801;
		default: goto yy50;
	}
yy714:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'N':
		case 'n': goto yy796;
		default: goto yy50;
	}
yy715:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'U':
		case 'u': goto yy802;
		default: goto yy50;
	}
yy716:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy803;
		default: goto yy50;
	}
yy717:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'D':
		case 'd': goto yy804;
		case 'E':
		case 'e': goto yy805;
		default: goto yy50;
	}
yy718:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy797;
		default: goto yy50;
	}
yy719:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'Y': goto yy793;
		case 'y': goto yy806;
		default: goto yy552;
	}
yy720:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R': goto yy795;
		case 'r': goto yy807;
		default: goto yy552;
	}
yy721:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'I': goto yy796;
		case 'i': goto yy808;
		default: goto yy552;
	}
yy722:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'U': goto yy797;
		case 'u': goto yy809;
		default: goto yy552;
	}
yy723:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'N': goto yy798;
		case 'n': goto yy810;
		default: goto yy552;
	}
yy724:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'N': goto yy799;
		case 'n': goto yy811;
		default: goto yy552;
	}
yy725:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T': goto yy800;
		case 't': goto yy812;
		default: goto yy552;
	}
yy726:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'C': goto yy801;
		case 'c': goto yy813;
		default: goto yy552;
	}
yy727:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'N': goto yy796;
		case 'n': goto yy808;
		default: goto yy552;
	}
yy728:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'U': goto yy802;
		case 'u': goto yy814;
		default: goto yy552;
	}
yy729:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E': goto yy803;
		case 'e': goto yy815;
		default: goto yy552;
	}
yy730:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'D': goto yy804;
		case 'E': goto yy805;
		case 'd': goto yy816;
		case 'e': goto yy817;
		default: goto yy552;
	}
yy731:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A': goto yy797;
		case 'a': goto yy809;
		default: goto yy552;
	}
yy732:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'H':
		case 'h': goto yy818;
		default: goto yy50;
	}
yy733:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'H': goto yy818;
		case 'h': goto yy819;
		default: goto yy552;
	}
yy734:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R':
		case 'r': goto yy120;
		default: goto yy50;
	}
yy735:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R': goto yy120;
		case 'r': goto yy553;
		default: goto yy552;
	}
yy736:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'U':
		case 'u': goto yy820;
		default: goto yy50;
	}
yy737:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'U': goto yy820;
		case 'u': goto yy821;
		default: goto yy552;
	}
yy738:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'O':
		case 'o': goto yy822;
		default: goto yy50;
	}
yy739:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'O': goto yy822;
		case 'o': goto yy823;
		default: goto yy552;
	}
yy740:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'D':
		case 'd': goto yy824;
		default: goto yy50;
	}
yy741:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'D': goto yy824;
		case 'd': goto yy825;
		default: goto yy552;
	}
yy742:
	++YYCURSOR;
	goto yy468;
yy743:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy743;
		default: goto yy187;
	}
yy744:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy826;
		default: goto yy630;
	}
yy745:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy827;
		default: goto yy192;
	}
yy746:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy828;
		default: goto yy50;
	}
yy747:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'P':
		case 'p': goto yy780;
		default: goto yy50;
	}
yy748:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2': goto yy829;
		case '3': goto yy830;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy831;
		default: goto yy50;
	}
yy749:
	yych = *++YYCURSOR;
	switch (yych) {
		case '-': goto yy832;
		default: goto yy50;
	}
yy750:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R':
		case 'r': goto yy833;
		default: goto yy50;
	}
yy751:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'G':
		case 'g': goto yy834;
		default: goto yy50;
	}
yy752:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'C':
		case 'c': goto yy835;
		default: goto yy50;
	}
yy753:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'B':
		case 'b': goto yy836;
		default: goto yy50;
	}
yy754:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'N':
		case 'n': goto yy837;
		default: goto yy50;
	}
yy755:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'L':
		case 'l': goto yy838;
		case 'N':
		case 'n': goto yy839;
		default: goto yy50;
	}
yy756:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R':
		case 'r': goto yy840;
		case 'Y':
		case 'y': goto yy841;
		default: goto yy50;
	}
yy757:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'V':
		case 'v': goto yy835;
		default: goto yy50;
	}
yy758:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T':
		case 't': goto yy842;
		default: goto yy50;
	}
yy759:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'P':
		case 'p': goto yy843;
		default: goto yy50;
	}
yy760:
	yych = *++YYCURSOR;
	switch (yych) {
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy844;
		default: goto yy50;
	}
yy761:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy844;
		default: goto yy50;
	}
yy762:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6': goto yy844;
		default: goto yy50;
	}
yy763:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2': goto yy845;
		case '3': goto yy847;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy848;
		default: goto yy50;
	}
yy764:
	yych = *++YYCURSOR;
	switch (yych) {
		case '/': goto yy849;
		default: goto yy50;
	}
yy765:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy51;
		default: goto yy766;
	}
yy766:
#line 1188 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
#line 20082 "real_world/parse_date.c"
yy767:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0': goto yy51;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy850;
		default: goto yy766;
	}
yy768:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy850;
		default: goto yy766;
	}
yy769:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y':
		case 'd':
		case 'f':
		case 'h':
		case 'm':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy171;
		case '0':
		case '1': goto yy850;
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy51;
		default: goto yy766;
	}
yy770:
	yych = *++YYCURSOR;
	switch (yych) {
		case ':': goto yy852;
		default: goto yy50;
	}
yy771:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'I':
		case 'i': goto yy853;
		default: goto yy499;
	}
yy772:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'U':
		case 'u': goto yy854;
		default: goto yy499;
	}
yy773:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'E':
		case 'e': goto yy855;
		default: goto yy499;
	}
yy774:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'R':
		case 'r': goto yy856;
		default: goto yy499;
	}
yy775:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'U':
		case 'u': goto yy857;
		default: goto yy499;
	}
yy776:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'Y':
		case 'y': goto yy667;
		default: goto yy499;
	}
yy777:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy667;
		default: goto yy499;
	}
yy778:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'C':
		case 'c': goto yy858;
		default: goto yy499;
	}
yy779:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'O':
		case 'o': goto yy859;
		default: goto yy499;
	}
yy780:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T':
		case 't': goto yy773;
		default: goto yy499;
	}
yy781:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7': goto yy860;
		default: goto yy782;
	}
yy782:
#line 1220 "real_world/parse_date.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 20297 "real_world/parse_date.c"
yy783:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'G':
		case 'g': goto yy861;
		default: goto yy50;
	}
yy784:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'Y':
		case 'y': goto yy219;
		default: goto yy50;
	}
yy785:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R':
		case 'r': goto yy219;
		default: goto yy50;
	}
yy786:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy862;
		case '1':
		case '2': goto yy863;
		case '3': goto yy864;
		default: goto yy50;
	}
yy787:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy865;
		default: goto yy50;
	}
yy788:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy702;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy867;
		default: goto yy578;
	}
yy789:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.':
		case ':': goto yy702;
		case '0': goto yy868;
		default: goto yy578;
	}
yy790:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy868;
		default: goto yy578;
	}
yy791:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy868;
		default: goto yy578;
	}
yy792:
	++YYCURSOR;
	goto yy578;
yy793:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'S':
		case 's': goto yy869;
		default: goto yy794;
	}
yy794:
#line 1324 "real_world/parse_date.re"
	{
		timelib_sll i;
		int         behavior;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 20418 "real_world/parse_date.c"
yy795:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T':
		case 't': goto yy870;
		default: goto yy50;
	}
yy796:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'D':
		case 'd': goto yy871;
		default: goto yy794;
	}
yy797:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R':
		case 'r': goto yy793;
		default: goto yy50;
	}
yy798:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'S':
		case 's': goto yy869;
		case 'U':
		case 'u': goto yy872;
		default: goto yy794;
	}
yy799:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'D':
		case 'd': goto yy871;
		case 'T':
		case 't': goto yy873;
		default: goto yy794;
	}
yy800:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'U':
		case 'u': goto yy874;
		default: goto yy794;
	}
yy801:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'O':
		case 'o': goto yy875;
		case 'S':
		case 's': goto yy869;
		default: goto yy794;
	}
yy802:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'R':
		case 'r': goto yy876;
		default: goto yy794;
	}
yy803:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'S':
		case 's': goto yy877;
		default: goto yy794;
	}
yy804:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'N':
		case 'n': goto yy878;
		default: goto yy794;
	}
yy805:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'K':
		case 'k': goto yy793;
		default: goto yy50;
	}
yy806:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '/':
		case '_': goto yy253;
		case 'S': goto yy869;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 's': goto yy879;
		default: goto yy794;
	}
yy807:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T': goto yy870;
		case 't': goto yy880;
		default: goto yy552;
	}
yy808:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '/':
		case '_': goto yy253;
		case 'D': goto yy871;
		case 'a':
		case 'b':
		case 'c':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'd': goto yy881;
		default: goto yy794;
	}
yy809:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R': goto yy793;
		case 'r': goto yy806;
		default: goto yy552;
	}
yy810:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '/':
		case '_': goto yy253;
		case 'S': goto yy869;
		case 'U': goto yy872;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 't':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 's': goto yy879;
		case 'u': goto yy882;
		default: goto yy794;
	}
yy811:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '/':
		case '_': goto yy253;
		case 'D': goto yy871;
		case 'T': goto yy873;
		case 'a':
		case 'b':
		case 'c':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'd': goto yy881;
		case 't': goto yy883;
		default: goto yy794;
	}
yy812:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '/':
		case '_': goto yy253;
		case 'U': goto yy874;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'u': goto yy884;
		default: goto yy794;
	}
yy813:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '/':
		case '_': goto yy253;
		case 'O': goto yy875;
		case 'S': goto yy869;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'o': goto yy885;
		case 's': goto yy879;
		default: goto yy794;
	}
yy814:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '/':
		case '_': goto yy253;
		case 'R': goto yy876;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'r': goto yy886;
		default: goto yy794;
	}
yy815:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '/':
		case '_': goto yy253;
		case 'S': goto yy877;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 's': goto yy887;
		default: goto yy794;
	}
yy816:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '/':
		case '_': goto yy253;
		case 'N': goto yy878;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		case 'n': goto yy888;
		default: goto yy794;
	}
yy817:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'K': goto yy793;
		case 'k': goto yy806;
		default: goto yy552;
	}
yy818:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T':
		case 't': goto yy613;
		default: goto yy50;
	}
yy819:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T': goto yy613;
		case 't': goto yy617;
		default: goto yy552;
	}
yy820:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'S':
		case 's': goto yy557;
		default: goto yy50;
	}
yy821:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'S': goto yy557;
		case 's': goto yy560;
		default: goto yy552;
	}
yy822:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'W':
		case 'w': goto yy889;
		default: goto yy50;
	}
yy823:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'W': goto yy889;
		case 'w': goto yy891;
		default: goto yy552;
	}
yy824:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy892;
		default: goto yy50;
	}
yy825:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A': goto yy892;
		case 'a': goto yy893;
		default: goto yy552;
	}
yy826:
	++YYCURSOR;
	goto yy630;
yy827:
	++YYCURSOR;
	goto yy192;
yy828:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy894;
		default: goto yy50;
	}
yy829:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy831;
		case 'T': goto yy895;
		case 'n':
		case 'r': goto yy896;
		case 's': goto yy897;
		case 't': goto yy898;
		default: goto yy468;
	}
yy830:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '0':
		case '1': goto yy831;
		case 'T': goto yy895;
		case 'n':
		case 'r': goto yy896;
		case 's': goto yy897;
		case 't': goto yy898;
		default: goto yy468;
	}
yy831:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'T': goto yy895;
		case 'n':
		case 'r': goto yy896;
		case 's': goto yy897;
		case 't': goto yy898;
		default: goto yy468;
	}
yy832:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy899;
		case '1':
		case '2': goto yy900;
		case '3': goto yy901;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy831;
		default: goto yy50;
	}
yy833:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '-': goto yy786;
		case 'I':
		case 'i': goto yy853;
		default: goto yy499;
	}
yy834:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '-': goto yy786;
		case 'U':
		case 'u': goto yy854;
		default: goto yy499;
	}
yy835:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '-': goto yy786;
		case 'E':
		case 'e': goto yy855;
		default: goto yy499;
	}
yy836:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '-': goto yy786;
		case 'R':
		case 'r': goto yy856;
		default: goto yy499;
	}
yy837:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '-': goto yy786;
		case 'U':
		case 'u': goto yy857;
		default: goto yy499;
	}
yy838:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '-': goto yy786;
		case 'Y':
		case 'y': goto yy667;
		default: goto yy499;
	}
yy839:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '-': goto yy786;
		case 'E':
		case 'e': goto yy667;
		default: goto yy499;
	}
yy840:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '-': goto yy786;
		case 'C':
		case 'c': goto yy858;
		default: goto yy499;
	}
yy841:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '-': goto yy786;
		default: goto yy499;
	}
yy842:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '-': goto yy786;
		case 'O':
		case 'o': goto yy859;
		default: goto yy499;
	}
yy843:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '-': goto yy786;
		case 'T':
		case 't': goto yy835;
		default: goto yy499;
	}
yy844:
	++YYCURSOR;
	goto yy766;
yy845:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy848;
		case 'n':
		case 'r': goto yy902;
		case 's': goto yy903;
		case 't': goto yy904;
		default: goto yy846;
	}
yy846:
#line 1049 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("iso8601date | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 21118 "real_world/parse_date.c"
yy847:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '0':
		case '1': goto yy848;
		case 'n':
		case 'r': goto yy902;
		case 's': goto yy903;
		case 't': goto yy904;
		default: goto yy846;
	}
yy848:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'n':
		case 'r': goto yy902;
		case 's': goto yy903;
		case 't': goto yy904;
		default: goto yy846;
	}
yy849:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy905;
		case '1':
		case '2': goto yy906;
		case '3': goto yy907;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy848;
		default: goto yy50;
	}
yy850:
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ': goto yy170;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy51;
		case 'D':
		case 'd': goto yy172;
		case 'F':
		case 'f': goto yy173;
		case 'H':
		case 'h': goto yy68;
		case 'M':
		case 'm': goto yy174;
		case 'S':
		case 's': goto yy175;
		case 'T': goto yy908;
		case 'W':
		case 'w': goto yy78;
		case 'Y':
		case 'y': goto yy80;
		case 't': goto yy909;
		default: goto yy851;
	}
yy851:
#line 1152 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
#line 21201 "real_world/parse_date.c"
yy852:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy910;
		case '1':
		case '2': goto yy911;
		case '3': goto yy912;
		default: goto yy50;
	}
yy853:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'L':
		case 'l': goto yy667;
		default: goto yy50;
	}
yy854:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'S':
		case 's': goto yy913;
		default: goto yy50;
	}
yy855:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'M':
		case 'm': goto yy859;
		default: goto yy50;
	}
yy856:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'U':
		case 'u': goto yy857;
		default: goto yy50;
	}
yy857:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy914;
		default: goto yy50;
	}
yy858:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'H':
		case 'h': goto yy667;
		default: goto yy50;
	}
yy859:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'B':
		case 'b': goto yy915;
		default: goto yy50;
	}
yy860:
	++YYCURSOR;
#line 1201 "real_world/parse_date.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 21280 "real_world/parse_date.c"
yy861:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'H':
		case 'h': goto yy916;
		default: goto yy50;
	}
yy862:
	yych = *++YYCURSOR;
	switch (yych) {
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy917;
		default: goto yy50;
	}
yy863:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy917;
		default: goto yy50;
	}
yy864:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1': goto yy917;
		default: goto yy50;
	}
yy865:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy918;
		default: goto yy866;
	}
yy866:
#line 1239 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 21352 "real_world/parse_date.c"
yy867:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ': goto yy919;
		case '(': goto yy920;
		case '+':
		case '-': goto yy921;
		case '.':
		case ':': goto yy702;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy922;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy923;
		default: goto yy578;
	}
yy868:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ' ': goto yy919;
		case '(': goto yy920;
		case '+':
		case '-': goto yy921;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy922;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy923;
		default: goto yy578;
	}
yy869:
	++YYCURSOR;
	goto yy794;
yy870:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'H':
		case 'h': goto yy924;
		case 'N':
		case 'n': goto yy925;
		default: goto yy50;
	}
yy871:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy926;
		default: goto yy50;
	}
yy872:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T':
		case 't': goto yy927;
		default: goto yy50;
	}
yy873:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'H':
		case 'h': goto yy793;
		default: goto yy50;
	}
yy874:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R':
		case 'r': goto yy877;
		default: goto yy50;
	}
yy875:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'N':
		case 'n': goto yy928;
		default: goto yy50;
	}
yy876:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'S':
		case 's': goto yy877;
		default: goto yy50;
	}
yy877:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'D':
		case 'd': goto yy871;
		default: goto yy50;
	}
yy878:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy876;
		default: goto yy50;
	}
yy879:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '/':
		case '_': goto yy253;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		default: goto yy794;
	}
yy880:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'H': goto yy924;
		case 'N': goto yy925;
		case 'h': goto yy929;
		case 'n': goto yy930;
		default: goto yy552;
	}
yy881:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A': goto yy926;
		case 'a': goto yy931;
		default: goto yy552;
	}
yy882:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T': goto yy927;
		case 't': goto yy932;
		default: goto yy552;
	}
yy883:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'H': goto yy793;
		case 'h': goto yy806;
		default: goto yy552;
	}
yy884:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R': goto yy877;
		case 'r': goto yy887;
		default: goto yy552;
	}
yy885:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'N': goto yy928;
		case 'n': goto yy933;
		default: goto yy552;
	}
yy886:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'S': goto yy877;
		case 's': goto yy887;
		default: goto yy552;
	}
yy887:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'D': goto yy871;
		case 'd': goto yy881;
		default: goto yy552;
	}
yy888:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E': goto yy876;
		case 'e': goto yy886;
		default: goto yy552;
	}
yy889:
	++YYCURSOR;
yy890:
#line 894 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 21660 "real_world/parse_date.c"
yy891:
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '/':
		case '_': goto yy253;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		default: goto yy890;
	}
yy892:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'Y':
		case 'y': goto yy934;
		default: goto yy50;
	}
yy893:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'Y': goto yy934;
		case 'y': goto yy936;
		default: goto yy552;
	}
yy894:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy937;
		default: goto yy50;
	}
yy895:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1': goto yy938;
		case '2': goto yy939;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy940;
		default: goto yy50;
	}
yy896:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'd': goto yy941;
		default: goto yy50;
	}
yy897:
	yych = *++YYCURSOR;
	switch (yych) {
		case 't': goto yy941;
		default: goto yy50;
	}
yy898:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'h': goto yy941;
		default: goto yy50;
	}
yy899:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '0': goto yy831;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy942;
		case 'T': goto yy895;
		case 'n':
		case 'r': goto yy896;
		case 's': goto yy897;
		case 't': goto yy898;
		default: goto yy468;
	}
yy900:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy942;
		case 'T': goto yy895;
		case 'n':
		case 'r': goto yy896;
		case 's': goto yy897;
		case 't': goto yy898;
		default: goto yy468;
	}
yy901:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '0':
		case '1': goto yy942;
		case 'T': goto yy895;
		case 'n':
		case 'r': goto yy896;
		case 's': goto yy897;
		case 't': goto yy898;
		default: goto yy468;
	}
yy902:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'd': goto yy943;
		default: goto yy50;
	}
yy903:
	yych = *++YYCURSOR;
	switch (yych) {
		case 't': goto yy943;
		default: goto yy50;
	}
yy904:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'h': goto yy943;
		default: goto yy50;
	}
yy905:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '0': goto yy848;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy944;
		case 'n':
		case 'r': goto yy902;
		case 's': goto yy903;
		case 't': goto yy904;
		default: goto yy846;
	}
yy906:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy944;
		case 'n':
		case 'r': goto yy902;
		case 's': goto yy903;
		case 't': goto yy904;
		default: goto yy846;
	}
yy907:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '0':
		case '1': goto yy944;
		case 'n':
		case 'r': goto yy902;
		case 's': goto yy903;
		case 't': goto yy904;
		default: goto yy846;
	}
yy908:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1': goto yy945;
		case '2': goto yy946;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy947;
		case 'H':
		case 'h': goto yy230;
		case 'U':
		case 'u': goto yy231;
		default: goto yy50;
	}
yy909:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1': goto yy948;
		case '2': goto yy949;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy950;
		case 'H':
		case 'h': goto yy230;
		case 'U':
		case 'u': goto yy231;
		default: goto yy50;
	}
yy910:
	yych = *++YYCURSOR;
	switch (yych) {
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy951;
		default: goto yy50;
	}
yy911:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy951;
		default: goto yy50;
	}
yy912:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1': goto yy951;
		default: goto yy50;
	}
yy913:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T':
		case 't': goto yy667;
		default: goto yy50;
	}
yy914:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R':
		case 'r': goto yy952;
		default: goto yy50;
	}
yy915:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy953;
		default: goto yy50;
	}
yy916:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T':
		case 't': goto yy356;
		default: goto yy50;
	}
yy917:
	++YYCURSOR;
#line 1252 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 21998 "real_world/parse_date.c"
yy918:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy954;
		default: goto yy866;
	}
yy919:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	switch (yych) {
		case ' ': goto yy919;
		case '(': goto yy920;
		case '+':
		case '-': goto yy921;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy922;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy923;
		default: goto yy50;
	}
yy920:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy923;
		default: goto yy50;
	}
yy921:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1': goto yy955;
		case '2': goto yy956;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy957;
		default: goto yy50;
	}
yy922:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy792;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy958;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy959;
		default: goto yy578;
	}
yy923:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy792;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy958;
		default: goto yy578;
	}
yy924:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'N':
		case 'n': goto yy925;
		default: goto yy50;
	}
yy925:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'I':
		case 'i': goto yy960;
		default: goto yy50;
	}
yy926:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'Y':
		case 'y': goto yy869;
		default: goto yy50;
	}
yy927:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E':
		case 'e': goto yy793;
		default: goto yy50;
	}
yy928:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'D':
		case 'd': goto yy793;
		default: goto yy50;
	}
yy929:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'N': goto yy925;
		case 'n': goto yy930;
		default: goto yy552;
	}
yy930:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'I': goto yy960;
		case 'i': goto yy961;
		default: goto yy552;
	}
yy931:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'Y': goto yy869;
		case 'y': goto yy879;
		default: goto yy552;
	}
yy932:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'E': goto yy793;
		case 'e': goto yy806;
		default: goto yy552;
	}
yy933:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'D': goto yy793;
		case 'd': goto yy806;
		default: goto yy552;
	}
yy934:
	++YYCURSOR;
yy935:
#line 851 "real_world/parse_date.re"
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 22349 "real_world/parse_date.c"
yy936:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '/':
		case '_': goto yy253;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy551;
		default: goto yy935;
	}
yy937:
	yych = *++YYCURSOR;
	switch (yych) {
		case ':': goto yy962;
		default: goto yy50;
	}
yy938:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy940;
		case ':': goto yy963;
		default: goto yy50;
	}
yy939:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3': goto yy940;
		case ':': goto yy963;
		default: goto yy50;
	}
yy940:
	yych = *++YYCURSOR;
	switch (yych) {
		case ':': goto yy963;
		default: goto yy50;
	}
yy941:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'T': goto yy895;
		default: goto yy468;
	}
yy942:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case 'T': goto yy964;
		case 'n':
		case 'r': goto yy896;
		case 's': goto yy897;
		case 't': goto yy898;
		default: goto yy846;
	}
yy943:
	++YYCURSOR;
	goto yy846;
yy944:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '/': goto yy943;
		case 'n':
		case 'r': goto yy902;
		case 's': goto yy903;
		case 't': goto yy904;
		default: goto yy846;
	}
yy945:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy965;
		case '6':
		case '7':
		case '8':
		case '9': goto yy947;
		case ':': goto yy966;
		default: goto yy50;
	}
yy946:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3': goto yy965;
		case '4':
		case '5': goto yy967;
		case ':': goto yy966;
		default: goto yy50;
	}
yy947:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy967;
		case ':': goto yy966;
		default: goto yy50;
	}
yy948:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy968;
		case '6':
		case '7':
		case '8':
		case '9': goto yy950;
		default: goto yy50;
	}
yy949:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3': goto yy968;
		case '4':
		case '5': goto yy967;
		default: goto yy50;
	}
yy950:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy967;
		default: goto yy50;
	}
yy951:
	yych = *++YYCURSOR;
	switch (yych) {
		case ' ': goto yy969;
		default: goto yy50;
	}
yy952:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'Y':
		case 'y': goto yy667;
		default: goto yy50;
	}
yy953:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'R':
		case 'r': goto yy667;
		default: goto yy50;
	}
yy954:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy970;
		default: goto yy866;
	}
yy955:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy957;
		case ':': goto yy971;
		default: goto yy578;
	}
yy956:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3': goto yy957;
		case '4':
		case '5': goto yy972;
		case '6':
		case '7':
		case '8':
		case '9': goto yy792;
		case ':': goto yy971;
		default: goto yy578;
	}
yy957:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy972;
		case '6':
		case '7':
		case '8':
		case '9': goto yy792;
		case ':': goto yy971;
		default: goto yy578;
	}
yy958:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy792;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy973;
		default: goto yy578;
	}
yy959:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy792;
		case '/':
		case '_': goto yy974;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy973;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy975;
		default: goto yy578;
	}
yy960:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'G':
		case 'g': goto yy976;
		default: goto yy50;
	}
yy961:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'G': goto yy976;
		case 'g': goto yy977;
		default: goto yy552;
	}
yy962:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1': goto yy978;
		case '2': goto yy979;
		default: goto yy50;
	}
yy963:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy980;
		case '6':
		case '7':
		case '8':
		case '9': goto yy981;
		default: goto yy50;
	}
yy964:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1': goto yy982;
		case '2': goto yy983;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy940;
		default: goto yy50;
	}
yy965:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy984;
		case '6':
		case '7':
		case '8':
		case '9': goto yy985;
		case ':': goto yy966;
		default: goto yy50;
	}
yy966:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy986;
		default: goto yy50;
	}
yy967:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy985;
		default: goto yy50;
	}
yy968:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy984;
		case '6':
		case '7':
		case '8':
		case '9': goto yy985;
		default: goto yy50;
	}
yy969:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1': goto yy987;
		case '2': goto yy988;
		default: goto yy50;
	}
yy970:
	++YYCURSOR;
	goto yy866;
yy971:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy972;
		case '6':
		case '7':
		case '8':
		case '9': goto yy792;
		default: goto yy578;
	}
yy972:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy792;
		default: goto yy578;
	}
yy973:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy792;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy989;
		default: goto yy578;
	}
yy974:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy990;
		default: goto yy50;
	}
yy975:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy792;
		case '/':
		case '_': goto yy974;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z': goto yy989;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy991;
		default: goto yy578;
	}
yy976:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'H':
		case 'h': goto yy992;
		default: goto yy50;
	}
yy977:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'H': goto yy992;
		case 'h': goto yy993;
		default: goto yy552;
	}
yy978:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy994;
		default: goto yy50;
	}
yy979:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3': goto yy994;
		default: goto yy50;
	}
yy980:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy981;
		case ':': goto yy995;
		default: goto yy50;
	}
yy981:
	yych = *++YYCURSOR;
	switch (yych) {
		case ':': goto yy995;
		default: goto yy50;
	}
yy982:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy996;
		case ':': goto yy963;
		default: goto yy50;
	}
yy983:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3': goto yy996;
		case ':': goto yy963;
		default: goto yy50;
	}
yy984:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy995;
		case '6': goto yy997;
		case '7':
		case '8':
		case '9': goto yy985;
		default: goto yy50;
	}
yy985:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy998;
		case '6': goto yy999;
		default: goto yy50;
	}
yy986:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1000;
		default: goto yy50;
	}
yy987:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1001;
		default: goto yy50;
	}
yy988:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3': goto yy1001;
		default: goto yy50;
	}
yy989:
	yych = *++YYCURSOR;
	switch (yych) {
		case ')': goto yy792;
		default: goto yy578;
	}
yy990:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy1002;
		default: goto yy50;
	}
yy991:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy792;
		case '/':
		case '_': goto yy974;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy1003;
		default: goto yy578;
	}
yy992:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T':
		case 't': goto yy793;
		default: goto yy50;
	}
yy993:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'T': goto yy793;
		case 't': goto yy806;
		default: goto yy552;
	}
yy994:
	yych = *++YYCURSOR;
	switch (yych) {
		case ':': goto yy1004;
		default: goto yy50;
	}
yy995:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy1005;
		case '6': goto yy1007;
		case '7':
		case '8':
		case '9': goto yy1008;
		default: goto yy50;
	}
yy996:
	yych = *++YYCURSOR;
	switch (yych) {
		case ':': goto yy1009;
		default: goto yy50;
	}
yy997:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy1005;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy998;
		case '6': goto yy999;
		default: goto yy50;
	}
yy998:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1008;
		default: goto yy50;
	}
yy999:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy1008;
		default: goto yy50;
	}
yy1000:
	yych = *++YYCURSOR;
	switch (yych) {
		case ':': goto yy985;
		default: goto yy50;
	}
yy1001:
	yych = *++YYCURSOR;
	switch (yych) {
		case ':': goto yy966;
		default: goto yy50;
	}
yy1002:
	yyaccept = 16;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '/':
		case '_': goto yy974;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy1002;
		default: goto yy578;
	}
yy1003:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '/':
		case '_': goto yy974;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy1003;
		default: goto yy50;
	}
yy1004:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy1010;
		default: goto yy50;
	}
yy1005:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1008;
		default: goto yy1006;
	}
yy1006:
#line 1164 "real_world/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->f = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
				s->errors += tz_not_found;
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
#line 23468 "real_world/parse_date.c"
yy1007:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy1008;
		default: goto yy1006;
	}
yy1008:
	++YYCURSOR;
	goto yy1006;
yy1009:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy1011;
		case '6':
		case '7':
		case '8':
		case '9': goto yy981;
		default: goto yy50;
	}
yy1010:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1012;
		default: goto yy50;
	}
yy1011:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1013;
		case ':': goto yy995;
		default: goto yy50;
	}
yy1012:
	yych = *++YYCURSOR;
	switch (yych) {
		case ':': goto yy1014;
		default: goto yy50;
	}
yy1013:
	yych = *++YYCURSOR;
	switch (yych) {
		case ':': goto yy1015;
		default: goto yy50;
	}
yy1014:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy1016;
		case '6': goto yy1017;
		default: goto yy50;
	}
yy1015:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy1018;
		case '6': goto yy1019;
		case '7':
		case '8':
		case '9': goto yy1008;
		default: goto yy50;
	}
yy1016:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1020;
		default: goto yy50;
	}
yy1017:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy1020;
		default: goto yy50;
	}
yy1018:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1021;
		default: goto yy1006;
	}
yy1019:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy1021;
		default: goto yy1006;
	}
yy1020:
	yych = *++YYCURSOR;
	switch (yych) {
		case ' ': goto yy1022;
		default: goto yy50;
	}
yy1021:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '.': goto yy1023;
		default: goto yy1006;
	}
yy1022:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	switch (yych) {
		case ' ': goto yy1022;
		case '+':
		case '-': goto yy1024;
		default: goto yy50;
	}
yy1023:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1025;
		default: goto yy50;
	}
yy1024:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1': goto yy1026;
		case '2': goto yy1028;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1029;
		default: goto yy50;
	}
yy1025:
	yyaccept = 26;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	switch (yych) {
		case '+':
		case '-': goto yy1030;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1025;
		default: goto yy1006;
	}
yy1026:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1029;
		case ':': goto yy1031;
		default: goto yy1027;
	}
yy1027:
#line 1265 "real_world/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		s->errors += tz_not_found;
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 23713 "real_world/parse_date.c"
yy1028:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3': goto yy1029;
		case '4':
		case '5': goto yy1032;
		case '6':
		case '7':
		case '8':
		case '9': goto yy1033;
		case ':': goto yy1031;
		default: goto yy1027;
	}
yy1029:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy1032;
		case '6':
		case '7':
		case '8':
		case '9': goto yy1033;
		case ':': goto yy1031;
		default: goto yy1027;
	}
yy1030:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1': goto yy1034;
		case '2': goto yy1035;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1036;
		default: goto yy50;
	}
yy1031:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy1032;
		case '6':
		case '7':
		case '8':
		case '9': goto yy1033;
		default: goto yy1027;
	}
yy1032:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1033;
		default: goto yy1027;
	}
yy1033:
	++YYCURSOR;
	goto yy1027;
yy1034:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1036;
		case ':': goto yy1037;
		default: goto yy1006;
	}
yy1035:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3': goto yy1036;
		case '4':
		case '5': goto yy1005;
		case '6':
		case '7':
		case '8':
		case '9': goto yy1008;
		case ':': goto yy1037;
		default: goto yy1006;
	}
yy1036:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy1005;
		case '6':
		case '7':
		case '8':
		case '9': goto yy1008;
		case ':': goto yy1037;
		default: goto yy1006;
	}
yy1037:
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5': goto yy1005;
		case '6':
		case '7':
		case '8':
		case '9': goto yy1008;
		default: goto yy1006;
	}
}
#line 1412 "real_world/parse_date.re"

}

#line 23862 "real_world/parse_date.c"
#define YYMAXFILL 26
#line 1415 "real_world/parse_date.re"


timelib_time* timelib_strtotime(char *s, int len, int *errors, timelib_tzdb *tzdb)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	while (isspace(*s) && s < e) {
		s++;
	}
	while (isspace(*e) && e > s) {
		e--;
	}
	if (e - s < 1) {
		*errors = 1;
		in.time = timelib_time_ctor();
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->f = in.time->z = in.time->dst = -1;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	memset(&in, 0, sizeof(in));
	in.str = malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = -1;
	in.time->d = -1;
	in.time->m = -1;
	in.time->h = -1;
	in.time->i = -1;
	in.time->s = -1;
	in.time->f = -1;
	in.time->z = -1;
	in.time->dst = -1;
	in.errors = 0;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	do {
		t = scan(&in);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	free(in.str);
	*errors = in.errors;
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options && TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->f = 0;
	}
	if (parsed->y == -1) parsed->y = now->y != -1 ? now->y : 0;
	if (parsed->d == -1) parsed->d = now->d != -1 ? now->d : 0;
	if (parsed->m == -1) parsed->m = now->m != -1 ? now->m : 0;
	if (parsed->h == -1) parsed->h = now->h != -1 ? now->h : 0;
	if (parsed->i == -1) parsed->i = now->i != -1 ? now->i : 0;
	if (parsed->s == -1) parsed->s = now->s != -1 ? now->s : 0;
	if (parsed->f == -1) parsed->f = now->f != -1 ? now->f : 0;
	if (parsed->z == -1) parsed->z = now->z != -1 ? now->z : 0;
	if (parsed->dst == -1) parsed->dst = now->dst != -1 ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, long gmtoffset, int isdst)
{
	timelib_tz_lookup_table *tp;

	tp = zone_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS", 
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;				
}
#endif

/*
 * vim: syntax=c
 */
