/* Ricochet - https://ricochet.im/
 * Copyright (C) 2014, John Brooks <john.brooks@dereferenced.net>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *    * Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *
 *    * Redistributions in binary form must reproduce the above
 *      copyright notice, this list of conditions and the following disclaimer
 *      in the documentation and/or other materials provided with the
 *      distribution.
 *
 *    * Neither the names of the copyright owners nor the names of its
 *      contributors may be used to endorse or promote products derived from
 *      this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef PROTOCOL_AUTHHIDDENSERVICECHANNEL_H
#define PROTOCOL_AUTHHIDDENSERVICECHANNEL_H

#include "Channel.h"
#include "utils/CryptoKey.h"
#include "AuthHiddenService.pb.h"

namespace Protocol
{

class AuthHiddenServiceChannelPrivate;

class AuthHiddenServiceChannel : public Channel
{
    Q_OBJECT
    Q_DISABLE_COPY(AuthHiddenServiceChannel)
    Q_DECLARE_PRIVATE(AuthHiddenServiceChannel)

public:
    explicit AuthHiddenServiceChannel(Direction direction, Connection *connection);

    void setPrivateKey(const CryptoKey &key);

signals:
    void authSuccessful();
    void authFailed();

private slots:
    void sendAuthMessage();

protected:
    virtual bool allowInboundChannelRequest(const Data::Control::OpenChannel *request, Data::Control::ChannelResult *result);
    virtual bool allowOutboundChannelRequest(Data::Control::OpenChannel *request);
    virtual bool processChannelOpenResult(const Data::Control::ChannelResult *result);
    virtual void receivePacket(const QByteArray &packet);

private:
    void handleProof(const Data::AuthHiddenService::Proof &message);
    void handleResult(const Data::AuthHiddenService::Result &message);
};

}

#endif
