// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_USHLL_2D_2OPIMM_TRACE_AARCH64_H_
#define VIXL_SIM_USHLL_2D_2OPIMM_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_ushll_2D_2OPIMM[] = {
  0x00000000fffffffd, 0x00000000fffffffe,
  0x00000001fffffffa, 0x00000001fffffffc,
  0x00000003fffffff4, 0x00000003fffffff8,
  0x00000007ffffffe8, 0x00000007fffffff0,
  0x0000000fffffffd0, 0x0000000fffffffe0,
  0x0000001fffffffa0, 0x0000001fffffffc0,
  0x0000003fffffff40, 0x0000003fffffff80,
  0x0000007ffffffe80, 0x0000007fffffff00,
  0x000000fffffffd00, 0x000000fffffffe00,
  0x000001fffffffa00, 0x000001fffffffc00,
  0x000003fffffff400, 0x000003fffffff800,
  0x000007ffffffe800, 0x000007fffffff000,
  0x00000fffffffd000, 0x00000fffffffe000,
  0x00001fffffffa000, 0x00001fffffffc000,
  0x00003fffffff4000, 0x00003fffffff8000,
  0x00007ffffffe8000, 0x00007fffffff0000,
  0x0000fffffffd0000, 0x0000fffffffe0000,
  0x0001fffffffa0000, 0x0001fffffffc0000,
  0x0003fffffff40000, 0x0003fffffff80000,
  0x0007ffffffe80000, 0x0007fffffff00000,
  0x000fffffffd00000, 0x000fffffffe00000,
  0x001fffffffa00000, 0x001fffffffc00000,
  0x003fffffff400000, 0x003fffffff800000,
  0x007ffffffe800000, 0x007fffffff000000,
  0x00fffffffd000000, 0x00fffffffe000000,
  0x01fffffffa000000, 0x01fffffffc000000,
  0x03fffffff4000000, 0x03fffffff8000000,
  0x07ffffffe8000000, 0x07fffffff0000000,
  0x0fffffffd0000000, 0x0fffffffe0000000,
  0x1fffffffa0000000, 0x1fffffffc0000000,
  0x3fffffff40000000, 0x3fffffff80000000,
  0x7ffffffe80000000, 0x7fffffff00000000,
  0x00000000fffffffe, 0x00000000ffffffff,
  0x00000001fffffffc, 0x00000001fffffffe,
  0x00000003fffffff8, 0x00000003fffffffc,
  0x00000007fffffff0, 0x00000007fffffff8,
  0x0000000fffffffe0, 0x0000000ffffffff0,
  0x0000001fffffffc0, 0x0000001fffffffe0,
  0x0000003fffffff80, 0x0000003fffffffc0,
  0x0000007fffffff00, 0x0000007fffffff80,
  0x000000fffffffe00, 0x000000ffffffff00,
  0x000001fffffffc00, 0x000001fffffffe00,
  0x000003fffffff800, 0x000003fffffffc00,
  0x000007fffffff000, 0x000007fffffff800,
  0x00000fffffffe000, 0x00000ffffffff000,
  0x00001fffffffc000, 0x00001fffffffe000,
  0x00003fffffff8000, 0x00003fffffffc000,
  0x00007fffffff0000, 0x00007fffffff8000,
  0x0000fffffffe0000, 0x0000ffffffff0000,
  0x0001fffffffc0000, 0x0001fffffffe0000,
  0x0003fffffff80000, 0x0003fffffffc0000,
  0x0007fffffff00000, 0x0007fffffff80000,
  0x000fffffffe00000, 0x000ffffffff00000,
  0x001fffffffc00000, 0x001fffffffe00000,
  0x003fffffff800000, 0x003fffffffc00000,
  0x007fffffff000000, 0x007fffffff800000,
  0x00fffffffe000000, 0x00ffffffff000000,
  0x01fffffffc000000, 0x01fffffffe000000,
  0x03fffffff8000000, 0x03fffffffc000000,
  0x07fffffff0000000, 0x07fffffff8000000,
  0x0fffffffe0000000, 0x0ffffffff0000000,
  0x1fffffffc0000000, 0x1fffffffe0000000,
  0x3fffffff80000000, 0x3fffffffc0000000,
  0x7fffffff00000000, 0x7fffffff80000000,
  0x00000000ffffffff, 0x0000000000000000,
  0x00000001fffffffe, 0x0000000000000000,
  0x00000003fffffffc, 0x0000000000000000,
  0x00000007fffffff8, 0x0000000000000000,
  0x0000000ffffffff0, 0x0000000000000000,
  0x0000001fffffffe0, 0x0000000000000000,
  0x0000003fffffffc0, 0x0000000000000000,
  0x0000007fffffff80, 0x0000000000000000,
  0x000000ffffffff00, 0x0000000000000000,
  0x000001fffffffe00, 0x0000000000000000,
  0x000003fffffffc00, 0x0000000000000000,
  0x000007fffffff800, 0x0000000000000000,
  0x00000ffffffff000, 0x0000000000000000,
  0x00001fffffffe000, 0x0000000000000000,
  0x00003fffffffc000, 0x0000000000000000,
  0x00007fffffff8000, 0x0000000000000000,
  0x0000ffffffff0000, 0x0000000000000000,
  0x0001fffffffe0000, 0x0000000000000000,
  0x0003fffffffc0000, 0x0000000000000000,
  0x0007fffffff80000, 0x0000000000000000,
  0x000ffffffff00000, 0x0000000000000000,
  0x001fffffffe00000, 0x0000000000000000,
  0x003fffffffc00000, 0x0000000000000000,
  0x007fffffff800000, 0x0000000000000000,
  0x00ffffffff000000, 0x0000000000000000,
  0x01fffffffe000000, 0x0000000000000000,
  0x03fffffffc000000, 0x0000000000000000,
  0x07fffffff8000000, 0x0000000000000000,
  0x0ffffffff0000000, 0x0000000000000000,
  0x1fffffffe0000000, 0x0000000000000000,
  0x3fffffffc0000000, 0x0000000000000000,
  0x7fffffff80000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000000, 0x0000000000000004,
  0x0000000000000000, 0x0000000000000008,
  0x0000000000000000, 0x0000000000000010,
  0x0000000000000000, 0x0000000000000020,
  0x0000000000000000, 0x0000000000000040,
  0x0000000000000000, 0x0000000000000080,
  0x0000000000000000, 0x0000000000000100,
  0x0000000000000000, 0x0000000000000200,
  0x0000000000000000, 0x0000000000000400,
  0x0000000000000000, 0x0000000000000800,
  0x0000000000000000, 0x0000000000001000,
  0x0000000000000000, 0x0000000000002000,
  0x0000000000000000, 0x0000000000004000,
  0x0000000000000000, 0x0000000000008000,
  0x0000000000000000, 0x0000000000010000,
  0x0000000000000000, 0x0000000000020000,
  0x0000000000000000, 0x0000000000040000,
  0x0000000000000000, 0x0000000000080000,
  0x0000000000000000, 0x0000000000100000,
  0x0000000000000000, 0x0000000000200000,
  0x0000000000000000, 0x0000000000400000,
  0x0000000000000000, 0x0000000000800000,
  0x0000000000000000, 0x0000000001000000,
  0x0000000000000000, 0x0000000002000000,
  0x0000000000000000, 0x0000000004000000,
  0x0000000000000000, 0x0000000008000000,
  0x0000000000000000, 0x0000000010000000,
  0x0000000000000000, 0x0000000020000000,
  0x0000000000000000, 0x0000000040000000,
  0x0000000000000000, 0x0000000080000000,
  0x0000000000000001, 0x0000000000000002,
  0x0000000000000002, 0x0000000000000004,
  0x0000000000000004, 0x0000000000000008,
  0x0000000000000008, 0x0000000000000010,
  0x0000000000000010, 0x0000000000000020,
  0x0000000000000020, 0x0000000000000040,
  0x0000000000000040, 0x0000000000000080,
  0x0000000000000080, 0x0000000000000100,
  0x0000000000000100, 0x0000000000000200,
  0x0000000000000200, 0x0000000000000400,
  0x0000000000000400, 0x0000000000000800,
  0x0000000000000800, 0x0000000000001000,
  0x0000000000001000, 0x0000000000002000,
  0x0000000000002000, 0x0000000000004000,
  0x0000000000004000, 0x0000000000008000,
  0x0000000000008000, 0x0000000000010000,
  0x0000000000010000, 0x0000000000020000,
  0x0000000000020000, 0x0000000000040000,
  0x0000000000040000, 0x0000000000080000,
  0x0000000000080000, 0x0000000000100000,
  0x0000000000100000, 0x0000000000200000,
  0x0000000000200000, 0x0000000000400000,
  0x0000000000400000, 0x0000000000800000,
  0x0000000000800000, 0x0000000001000000,
  0x0000000001000000, 0x0000000002000000,
  0x0000000002000000, 0x0000000004000000,
  0x0000000004000000, 0x0000000008000000,
  0x0000000008000000, 0x0000000010000000,
  0x0000000010000000, 0x0000000020000000,
  0x0000000020000000, 0x0000000040000000,
  0x0000000040000000, 0x0000000080000000,
  0x0000000080000000, 0x0000000100000000,
  0x0000000000000002, 0x0000000000000020,
  0x0000000000000004, 0x0000000000000040,
  0x0000000000000008, 0x0000000000000080,
  0x0000000000000010, 0x0000000000000100,
  0x0000000000000020, 0x0000000000000200,
  0x0000000000000040, 0x0000000000000400,
  0x0000000000000080, 0x0000000000000800,
  0x0000000000000100, 0x0000000000001000,
  0x0000000000000200, 0x0000000000002000,
  0x0000000000000400, 0x0000000000004000,
  0x0000000000000800, 0x0000000000008000,
  0x0000000000001000, 0x0000000000010000,
  0x0000000000002000, 0x0000000000020000,
  0x0000000000004000, 0x0000000000040000,
  0x0000000000008000, 0x0000000000080000,
  0x0000000000010000, 0x0000000000100000,
  0x0000000000020000, 0x0000000000200000,
  0x0000000000040000, 0x0000000000400000,
  0x0000000000080000, 0x0000000000800000,
  0x0000000000100000, 0x0000000001000000,
  0x0000000000200000, 0x0000000002000000,
  0x0000000000400000, 0x0000000004000000,
  0x0000000000800000, 0x0000000008000000,
  0x0000000001000000, 0x0000000010000000,
  0x0000000002000000, 0x0000000020000000,
  0x0000000004000000, 0x0000000040000000,
  0x0000000008000000, 0x0000000080000000,
  0x0000000010000000, 0x0000000100000000,
  0x0000000020000000, 0x0000000200000000,
  0x0000000040000000, 0x0000000400000000,
  0x0000000080000000, 0x0000000800000000,
  0x0000000100000000, 0x0000001000000000,
  0x0000000000000020, 0x000000000000007d,
  0x0000000000000040, 0x00000000000000fa,
  0x0000000000000080, 0x00000000000001f4,
  0x0000000000000100, 0x00000000000003e8,
  0x0000000000000200, 0x00000000000007d0,
  0x0000000000000400, 0x0000000000000fa0,
  0x0000000000000800, 0x0000000000001f40,
  0x0000000000001000, 0x0000000000003e80,
  0x0000000000002000, 0x0000000000007d00,
  0x0000000000004000, 0x000000000000fa00,
  0x0000000000008000, 0x000000000001f400,
  0x0000000000010000, 0x000000000003e800,
  0x0000000000020000, 0x000000000007d000,
  0x0000000000040000, 0x00000000000fa000,
  0x0000000000080000, 0x00000000001f4000,
  0x0000000000100000, 0x00000000003e8000,
  0x0000000000200000, 0x00000000007d0000,
  0x0000000000400000, 0x0000000000fa0000,
  0x0000000000800000, 0x0000000001f40000,
  0x0000000001000000, 0x0000000003e80000,
  0x0000000002000000, 0x0000000007d00000,
  0x0000000004000000, 0x000000000fa00000,
  0x0000000008000000, 0x000000001f400000,
  0x0000000010000000, 0x000000003e800000,
  0x0000000020000000, 0x000000007d000000,
  0x0000000040000000, 0x00000000fa000000,
  0x0000000080000000, 0x00000001f4000000,
  0x0000000100000000, 0x00000003e8000000,
  0x0000000200000000, 0x00000007d0000000,
  0x0000000400000000, 0x0000000fa0000000,
  0x0000000800000000, 0x0000001f40000000,
  0x0000001000000000, 0x0000003e80000000,
  0x000000000000007d, 0x000000000000007e,
  0x00000000000000fa, 0x00000000000000fc,
  0x00000000000001f4, 0x00000000000001f8,
  0x00000000000003e8, 0x00000000000003f0,
  0x00000000000007d0, 0x00000000000007e0,
  0x0000000000000fa0, 0x0000000000000fc0,
  0x0000000000001f40, 0x0000000000001f80,
  0x0000000000003e80, 0x0000000000003f00,
  0x0000000000007d00, 0x0000000000007e00,
  0x000000000000fa00, 0x000000000000fc00,
  0x000000000001f400, 0x000000000001f800,
  0x000000000003e800, 0x000000000003f000,
  0x000000000007d000, 0x000000000007e000,
  0x00000000000fa000, 0x00000000000fc000,
  0x00000000001f4000, 0x00000000001f8000,
  0x00000000003e8000, 0x00000000003f0000,
  0x00000000007d0000, 0x00000000007e0000,
  0x0000000000fa0000, 0x0000000000fc0000,
  0x0000000001f40000, 0x0000000001f80000,
  0x0000000003e80000, 0x0000000003f00000,
  0x0000000007d00000, 0x0000000007e00000,
  0x000000000fa00000, 0x000000000fc00000,
  0x000000001f400000, 0x000000001f800000,
  0x000000003e800000, 0x000000003f000000,
  0x000000007d000000, 0x000000007e000000,
  0x00000000fa000000, 0x00000000fc000000,
  0x00000001f4000000, 0x00000001f8000000,
  0x00000003e8000000, 0x00000003f0000000,
  0x00000007d0000000, 0x00000007e0000000,
  0x0000000fa0000000, 0x0000000fc0000000,
  0x0000001f40000000, 0x0000001f80000000,
  0x0000003e80000000, 0x0000003f00000000,
  0x000000000000007e, 0x000000000000007f,
  0x00000000000000fc, 0x00000000000000fe,
  0x00000000000001f8, 0x00000000000001fc,
  0x00000000000003f0, 0x00000000000003f8,
  0x00000000000007e0, 0x00000000000007f0,
  0x0000000000000fc0, 0x0000000000000fe0,
  0x0000000000001f80, 0x0000000000001fc0,
  0x0000000000003f00, 0x0000000000003f80,
  0x0000000000007e00, 0x0000000000007f00,
  0x000000000000fc00, 0x000000000000fe00,
  0x000000000001f800, 0x000000000001fc00,
  0x000000000003f000, 0x000000000003f800,
  0x000000000007e000, 0x000000000007f000,
  0x00000000000fc000, 0x00000000000fe000,
  0x00000000001f8000, 0x00000000001fc000,
  0x00000000003f0000, 0x00000000003f8000,
  0x00000000007e0000, 0x00000000007f0000,
  0x0000000000fc0000, 0x0000000000fe0000,
  0x0000000001f80000, 0x0000000001fc0000,
  0x0000000003f00000, 0x0000000003f80000,
  0x0000000007e00000, 0x0000000007f00000,
  0x000000000fc00000, 0x000000000fe00000,
  0x000000001f800000, 0x000000001fc00000,
  0x000000003f000000, 0x000000003f800000,
  0x000000007e000000, 0x000000007f000000,
  0x00000000fc000000, 0x00000000fe000000,
  0x00000001f8000000, 0x00000001fc000000,
  0x00000003f0000000, 0x00000003f8000000,
  0x00000007e0000000, 0x00000007f0000000,
  0x0000000fc0000000, 0x0000000fe0000000,
  0x0000001f80000000, 0x0000001fc0000000,
  0x0000003f00000000, 0x0000003f80000000,
  0x000000000000007f, 0x0000000000007ffd,
  0x00000000000000fe, 0x000000000000fffa,
  0x00000000000001fc, 0x000000000001fff4,
  0x00000000000003f8, 0x000000000003ffe8,
  0x00000000000007f0, 0x000000000007ffd0,
  0x0000000000000fe0, 0x00000000000fffa0,
  0x0000000000001fc0, 0x00000000001fff40,
  0x0000000000003f80, 0x00000000003ffe80,
  0x0000000000007f00, 0x00000000007ffd00,
  0x000000000000fe00, 0x0000000000fffa00,
  0x000000000001fc00, 0x0000000001fff400,
  0x000000000003f800, 0x0000000003ffe800,
  0x000000000007f000, 0x0000000007ffd000,
  0x00000000000fe000, 0x000000000fffa000,
  0x00000000001fc000, 0x000000001fff4000,
  0x00000000003f8000, 0x000000003ffe8000,
  0x00000000007f0000, 0x000000007ffd0000,
  0x0000000000fe0000, 0x00000000fffa0000,
  0x0000000001fc0000, 0x00000001fff40000,
  0x0000000003f80000, 0x00000003ffe80000,
  0x0000000007f00000, 0x00000007ffd00000,
  0x000000000fe00000, 0x0000000fffa00000,
  0x000000001fc00000, 0x0000001fff400000,
  0x000000003f800000, 0x0000003ffe800000,
  0x000000007f000000, 0x0000007ffd000000,
  0x00000000fe000000, 0x000000fffa000000,
  0x00000001fc000000, 0x000001fff4000000,
  0x00000003f8000000, 0x000003ffe8000000,
  0x00000007f0000000, 0x000007ffd0000000,
  0x0000000fe0000000, 0x00000fffa0000000,
  0x0000001fc0000000, 0x00001fff40000000,
  0x0000003f80000000, 0x00003ffe80000000,
  0x0000000000007ffd, 0x0000000000007ffe,
  0x000000000000fffa, 0x000000000000fffc,
  0x000000000001fff4, 0x000000000001fff8,
  0x000000000003ffe8, 0x000000000003fff0,
  0x000000000007ffd0, 0x000000000007ffe0,
  0x00000000000fffa0, 0x00000000000fffc0,
  0x00000000001fff40, 0x00000000001fff80,
  0x00000000003ffe80, 0x00000000003fff00,
  0x00000000007ffd00, 0x00000000007ffe00,
  0x0000000000fffa00, 0x0000000000fffc00,
  0x0000000001fff400, 0x0000000001fff800,
  0x0000000003ffe800, 0x0000000003fff000,
  0x0000000007ffd000, 0x0000000007ffe000,
  0x000000000fffa000, 0x000000000fffc000,
  0x000000001fff4000, 0x000000001fff8000,
  0x000000003ffe8000, 0x000000003fff0000,
  0x000000007ffd0000, 0x000000007ffe0000,
  0x00000000fffa0000, 0x00000000fffc0000,
  0x00000001fff40000, 0x00000001fff80000,
  0x00000003ffe80000, 0x00000003fff00000,
  0x00000007ffd00000, 0x00000007ffe00000,
  0x0000000fffa00000, 0x0000000fffc00000,
  0x0000001fff400000, 0x0000001fff800000,
  0x0000003ffe800000, 0x0000003fff000000,
  0x0000007ffd000000, 0x0000007ffe000000,
  0x000000fffa000000, 0x000000fffc000000,
  0x000001fff4000000, 0x000001fff8000000,
  0x000003ffe8000000, 0x000003fff0000000,
  0x000007ffd0000000, 0x000007ffe0000000,
  0x00000fffa0000000, 0x00000fffc0000000,
  0x00001fff40000000, 0x00001fff80000000,
  0x00003ffe80000000, 0x00003fff00000000,
  0x0000000000007ffe, 0x0000000000007fff,
  0x000000000000fffc, 0x000000000000fffe,
  0x000000000001fff8, 0x000000000001fffc,
  0x000000000003fff0, 0x000000000003fff8,
  0x000000000007ffe0, 0x000000000007fff0,
  0x00000000000fffc0, 0x00000000000fffe0,
  0x00000000001fff80, 0x00000000001fffc0,
  0x00000000003fff00, 0x00000000003fff80,
  0x00000000007ffe00, 0x00000000007fff00,
  0x0000000000fffc00, 0x0000000000fffe00,
  0x0000000001fff800, 0x0000000001fffc00,
  0x0000000003fff000, 0x0000000003fff800,
  0x0000000007ffe000, 0x0000000007fff000,
  0x000000000fffc000, 0x000000000fffe000,
  0x000000001fff8000, 0x000000001fffc000,
  0x000000003fff0000, 0x000000003fff8000,
  0x000000007ffe0000, 0x000000007fff0000,
  0x00000000fffc0000, 0x00000000fffe0000,
  0x00000001fff80000, 0x00000001fffc0000,
  0x00000003fff00000, 0x00000003fff80000,
  0x00000007ffe00000, 0x00000007fff00000,
  0x0000000fffc00000, 0x0000000fffe00000,
  0x0000001fff800000, 0x0000001fffc00000,
  0x0000003fff000000, 0x0000003fff800000,
  0x0000007ffe000000, 0x0000007fff000000,
  0x000000fffc000000, 0x000000fffe000000,
  0x000001fff8000000, 0x000001fffc000000,
  0x000003fff0000000, 0x000003fff8000000,
  0x000007ffe0000000, 0x000007fff0000000,
  0x00000fffc0000000, 0x00000fffe0000000,
  0x00001fff80000000, 0x00001fffc0000000,
  0x00003fff00000000, 0x00003fff80000000,
  0x0000000000007fff, 0x0000000033333333,
  0x000000000000fffe, 0x0000000066666666,
  0x000000000001fffc, 0x00000000cccccccc,
  0x000000000003fff8, 0x0000000199999998,
  0x000000000007fff0, 0x0000000333333330,
  0x00000000000fffe0, 0x0000000666666660,
  0x00000000001fffc0, 0x0000000cccccccc0,
  0x00000000003fff80, 0x0000001999999980,
  0x00000000007fff00, 0x0000003333333300,
  0x0000000000fffe00, 0x0000006666666600,
  0x0000000001fffc00, 0x000000cccccccc00,
  0x0000000003fff800, 0x0000019999999800,
  0x0000000007fff000, 0x0000033333333000,
  0x000000000fffe000, 0x0000066666666000,
  0x000000001fffc000, 0x00000cccccccc000,
  0x000000003fff8000, 0x0000199999998000,
  0x000000007fff0000, 0x0000333333330000,
  0x00000000fffe0000, 0x0000666666660000,
  0x00000001fffc0000, 0x0000cccccccc0000,
  0x00000003fff80000, 0x0001999999980000,
  0x00000007fff00000, 0x0003333333300000,
  0x0000000fffe00000, 0x0006666666600000,
  0x0000001fffc00000, 0x000cccccccc00000,
  0x0000003fff800000, 0x0019999999800000,
  0x0000007fff000000, 0x0033333333000000,
  0x000000fffe000000, 0x0066666666000000,
  0x000001fffc000000, 0x00cccccccc000000,
  0x000003fff8000000, 0x0199999998000000,
  0x000007fff0000000, 0x0333333330000000,
  0x00000fffe0000000, 0x0666666660000000,
  0x00001fffc0000000, 0x0cccccccc0000000,
  0x00003fff80000000, 0x1999999980000000,
  0x0000000033333333, 0x0000000055555555,
  0x0000000066666666, 0x00000000aaaaaaaa,
  0x00000000cccccccc, 0x0000000155555554,
  0x0000000199999998, 0x00000002aaaaaaa8,
  0x0000000333333330, 0x0000000555555550,
  0x0000000666666660, 0x0000000aaaaaaaa0,
  0x0000000cccccccc0, 0x0000001555555540,
  0x0000001999999980, 0x0000002aaaaaaa80,
  0x0000003333333300, 0x0000005555555500,
  0x0000006666666600, 0x000000aaaaaaaa00,
  0x000000cccccccc00, 0x0000015555555400,
  0x0000019999999800, 0x000002aaaaaaa800,
  0x0000033333333000, 0x0000055555555000,
  0x0000066666666000, 0x00000aaaaaaaa000,
  0x00000cccccccc000, 0x0000155555554000,
  0x0000199999998000, 0x00002aaaaaaa8000,
  0x0000333333330000, 0x0000555555550000,
  0x0000666666660000, 0x0000aaaaaaaa0000,
  0x0000cccccccc0000, 0x0001555555540000,
  0x0001999999980000, 0x0002aaaaaaa80000,
  0x0003333333300000, 0x0005555555500000,
  0x0006666666600000, 0x000aaaaaaaa00000,
  0x000cccccccc00000, 0x0015555555400000,
  0x0019999999800000, 0x002aaaaaaa800000,
  0x0033333333000000, 0x0055555555000000,
  0x0066666666000000, 0x00aaaaaaaa000000,
  0x00cccccccc000000, 0x0155555554000000,
  0x0199999998000000, 0x02aaaaaaa8000000,
  0x0333333330000000, 0x0555555550000000,
  0x0666666660000000, 0x0aaaaaaaa0000000,
  0x0cccccccc0000000, 0x1555555540000000,
  0x1999999980000000, 0x2aaaaaaa80000000,
  0x0000000055555555, 0x000000007ffffffd,
  0x00000000aaaaaaaa, 0x00000000fffffffa,
  0x0000000155555554, 0x00000001fffffff4,
  0x00000002aaaaaaa8, 0x00000003ffffffe8,
  0x0000000555555550, 0x00000007ffffffd0,
  0x0000000aaaaaaaa0, 0x0000000fffffffa0,
  0x0000001555555540, 0x0000001fffffff40,
  0x0000002aaaaaaa80, 0x0000003ffffffe80,
  0x0000005555555500, 0x0000007ffffffd00,
  0x000000aaaaaaaa00, 0x000000fffffffa00,
  0x0000015555555400, 0x000001fffffff400,
  0x000002aaaaaaa800, 0x000003ffffffe800,
  0x0000055555555000, 0x000007ffffffd000,
  0x00000aaaaaaaa000, 0x00000fffffffa000,
  0x0000155555554000, 0x00001fffffff4000,
  0x00002aaaaaaa8000, 0x00003ffffffe8000,
  0x0000555555550000, 0x00007ffffffd0000,
  0x0000aaaaaaaa0000, 0x0000fffffffa0000,
  0x0001555555540000, 0x0001fffffff40000,
  0x0002aaaaaaa80000, 0x0003ffffffe80000,
  0x0005555555500000, 0x0007ffffffd00000,
  0x000aaaaaaaa00000, 0x000fffffffa00000,
  0x0015555555400000, 0x001fffffff400000,
  0x002aaaaaaa800000, 0x003ffffffe800000,
  0x0055555555000000, 0x007ffffffd000000,
  0x00aaaaaaaa000000, 0x00fffffffa000000,
  0x0155555554000000, 0x01fffffff4000000,
  0x02aaaaaaa8000000, 0x03ffffffe8000000,
  0x0555555550000000, 0x07ffffffd0000000,
  0x0aaaaaaaa0000000, 0x0fffffffa0000000,
  0x1555555540000000, 0x1fffffff40000000,
  0x2aaaaaaa80000000, 0x3ffffffe80000000,
  0x000000007ffffffd, 0x000000007ffffffe,
  0x00000000fffffffa, 0x00000000fffffffc,
  0x00000001fffffff4, 0x00000001fffffff8,
  0x00000003ffffffe8, 0x00000003fffffff0,
  0x00000007ffffffd0, 0x00000007ffffffe0,
  0x0000000fffffffa0, 0x0000000fffffffc0,
  0x0000001fffffff40, 0x0000001fffffff80,
  0x0000003ffffffe80, 0x0000003fffffff00,
  0x0000007ffffffd00, 0x0000007ffffffe00,
  0x000000fffffffa00, 0x000000fffffffc00,
  0x000001fffffff400, 0x000001fffffff800,
  0x000003ffffffe800, 0x000003fffffff000,
  0x000007ffffffd000, 0x000007ffffffe000,
  0x00000fffffffa000, 0x00000fffffffc000,
  0x00001fffffff4000, 0x00001fffffff8000,
  0x00003ffffffe8000, 0x00003fffffff0000,
  0x00007ffffffd0000, 0x00007ffffffe0000,
  0x0000fffffffa0000, 0x0000fffffffc0000,
  0x0001fffffff40000, 0x0001fffffff80000,
  0x0003ffffffe80000, 0x0003fffffff00000,
  0x0007ffffffd00000, 0x0007ffffffe00000,
  0x000fffffffa00000, 0x000fffffffc00000,
  0x001fffffff400000, 0x001fffffff800000,
  0x003ffffffe800000, 0x003fffffff000000,
  0x007ffffffd000000, 0x007ffffffe000000,
  0x00fffffffa000000, 0x00fffffffc000000,
  0x01fffffff4000000, 0x01fffffff8000000,
  0x03ffffffe8000000, 0x03fffffff0000000,
  0x07ffffffd0000000, 0x07ffffffe0000000,
  0x0fffffffa0000000, 0x0fffffffc0000000,
  0x1fffffff40000000, 0x1fffffff80000000,
  0x3ffffffe80000000, 0x3fffffff00000000,
  0x000000007ffffffe, 0x000000007fffffff,
  0x00000000fffffffc, 0x00000000fffffffe,
  0x00000001fffffff8, 0x00000001fffffffc,
  0x00000003fffffff0, 0x00000003fffffff8,
  0x00000007ffffffe0, 0x00000007fffffff0,
  0x0000000fffffffc0, 0x0000000fffffffe0,
  0x0000001fffffff80, 0x0000001fffffffc0,
  0x0000003fffffff00, 0x0000003fffffff80,
  0x0000007ffffffe00, 0x0000007fffffff00,
  0x000000fffffffc00, 0x000000fffffffe00,
  0x000001fffffff800, 0x000001fffffffc00,
  0x000003fffffff000, 0x000003fffffff800,
  0x000007ffffffe000, 0x000007fffffff000,
  0x00000fffffffc000, 0x00000fffffffe000,
  0x00001fffffff8000, 0x00001fffffffc000,
  0x00003fffffff0000, 0x00003fffffff8000,
  0x00007ffffffe0000, 0x00007fffffff0000,
  0x0000fffffffc0000, 0x0000fffffffe0000,
  0x0001fffffff80000, 0x0001fffffffc0000,
  0x0003fffffff00000, 0x0003fffffff80000,
  0x0007ffffffe00000, 0x0007fffffff00000,
  0x000fffffffc00000, 0x000fffffffe00000,
  0x001fffffff800000, 0x001fffffffc00000,
  0x003fffffff000000, 0x003fffffff800000,
  0x007ffffffe000000, 0x007fffffff000000,
  0x00fffffffc000000, 0x00fffffffe000000,
  0x01fffffff8000000, 0x01fffffffc000000,
  0x03fffffff0000000, 0x03fffffff8000000,
  0x07ffffffe0000000, 0x07fffffff0000000,
  0x0fffffffc0000000, 0x0fffffffe0000000,
  0x1fffffff80000000, 0x1fffffffc0000000,
  0x3fffffff00000000, 0x3fffffff80000000,
  0x000000007fffffff, 0x0000000080000000,
  0x00000000fffffffe, 0x0000000100000000,
  0x00000001fffffffc, 0x0000000200000000,
  0x00000003fffffff8, 0x0000000400000000,
  0x00000007fffffff0, 0x0000000800000000,
  0x0000000fffffffe0, 0x0000001000000000,
  0x0000001fffffffc0, 0x0000002000000000,
  0x0000003fffffff80, 0x0000004000000000,
  0x0000007fffffff00, 0x0000008000000000,
  0x000000fffffffe00, 0x0000010000000000,
  0x000001fffffffc00, 0x0000020000000000,
  0x000003fffffff800, 0x0000040000000000,
  0x000007fffffff000, 0x0000080000000000,
  0x00000fffffffe000, 0x0000100000000000,
  0x00001fffffffc000, 0x0000200000000000,
  0x00003fffffff8000, 0x0000400000000000,
  0x00007fffffff0000, 0x0000800000000000,
  0x0000fffffffe0000, 0x0001000000000000,
  0x0001fffffffc0000, 0x0002000000000000,
  0x0003fffffff80000, 0x0004000000000000,
  0x0007fffffff00000, 0x0008000000000000,
  0x000fffffffe00000, 0x0010000000000000,
  0x001fffffffc00000, 0x0020000000000000,
  0x003fffffff800000, 0x0040000000000000,
  0x007fffffff000000, 0x0080000000000000,
  0x00fffffffe000000, 0x0100000000000000,
  0x01fffffffc000000, 0x0200000000000000,
  0x03fffffff8000000, 0x0400000000000000,
  0x07fffffff0000000, 0x0800000000000000,
  0x0fffffffe0000000, 0x1000000000000000,
  0x1fffffffc0000000, 0x2000000000000000,
  0x3fffffff80000000, 0x4000000000000000,
  0x0000000080000000, 0x0000000080000001,
  0x0000000100000000, 0x0000000100000002,
  0x0000000200000000, 0x0000000200000004,
  0x0000000400000000, 0x0000000400000008,
  0x0000000800000000, 0x0000000800000010,
  0x0000001000000000, 0x0000001000000020,
  0x0000002000000000, 0x0000002000000040,
  0x0000004000000000, 0x0000004000000080,
  0x0000008000000000, 0x0000008000000100,
  0x0000010000000000, 0x0000010000000200,
  0x0000020000000000, 0x0000020000000400,
  0x0000040000000000, 0x0000040000000800,
  0x0000080000000000, 0x0000080000001000,
  0x0000100000000000, 0x0000100000002000,
  0x0000200000000000, 0x0000200000004000,
  0x0000400000000000, 0x0000400000008000,
  0x0000800000000000, 0x0000800000010000,
  0x0001000000000000, 0x0001000000020000,
  0x0002000000000000, 0x0002000000040000,
  0x0004000000000000, 0x0004000000080000,
  0x0008000000000000, 0x0008000000100000,
  0x0010000000000000, 0x0010000000200000,
  0x0020000000000000, 0x0020000000400000,
  0x0040000000000000, 0x0040000000800000,
  0x0080000000000000, 0x0080000001000000,
  0x0100000000000000, 0x0100000002000000,
  0x0200000000000000, 0x0200000004000000,
  0x0400000000000000, 0x0400000008000000,
  0x0800000000000000, 0x0800000010000000,
  0x1000000000000000, 0x1000000020000000,
  0x2000000000000000, 0x2000000040000000,
  0x4000000000000000, 0x4000000080000000,
  0x0000000080000001, 0x00000000aaaaaaaa,
  0x0000000100000002, 0x0000000155555554,
  0x0000000200000004, 0x00000002aaaaaaa8,
  0x0000000400000008, 0x0000000555555550,
  0x0000000800000010, 0x0000000aaaaaaaa0,
  0x0000001000000020, 0x0000001555555540,
  0x0000002000000040, 0x0000002aaaaaaa80,
  0x0000004000000080, 0x0000005555555500,
  0x0000008000000100, 0x000000aaaaaaaa00,
  0x0000010000000200, 0x0000015555555400,
  0x0000020000000400, 0x000002aaaaaaa800,
  0x0000040000000800, 0x0000055555555000,
  0x0000080000001000, 0x00000aaaaaaaa000,
  0x0000100000002000, 0x0000155555554000,
  0x0000200000004000, 0x00002aaaaaaa8000,
  0x0000400000008000, 0x0000555555550000,
  0x0000800000010000, 0x0000aaaaaaaa0000,
  0x0001000000020000, 0x0001555555540000,
  0x0002000000040000, 0x0002aaaaaaa80000,
  0x0004000000080000, 0x0005555555500000,
  0x0008000000100000, 0x000aaaaaaaa00000,
  0x0010000000200000, 0x0015555555400000,
  0x0020000000400000, 0x002aaaaaaa800000,
  0x0040000000800000, 0x0055555555000000,
  0x0080000001000000, 0x00aaaaaaaa000000,
  0x0100000002000000, 0x0155555554000000,
  0x0200000004000000, 0x02aaaaaaa8000000,
  0x0400000008000000, 0x0555555550000000,
  0x0800000010000000, 0x0aaaaaaaa0000000,
  0x1000000020000000, 0x1555555540000000,
  0x2000000040000000, 0x2aaaaaaa80000000,
  0x4000000080000000, 0x5555555500000000,
  0x00000000aaaaaaaa, 0x00000000cccccccc,
  0x0000000155555554, 0x0000000199999998,
  0x00000002aaaaaaa8, 0x0000000333333330,
  0x0000000555555550, 0x0000000666666660,
  0x0000000aaaaaaaa0, 0x0000000cccccccc0,
  0x0000001555555540, 0x0000001999999980,
  0x0000002aaaaaaa80, 0x0000003333333300,
  0x0000005555555500, 0x0000006666666600,
  0x000000aaaaaaaa00, 0x000000cccccccc00,
  0x0000015555555400, 0x0000019999999800,
  0x000002aaaaaaa800, 0x0000033333333000,
  0x0000055555555000, 0x0000066666666000,
  0x00000aaaaaaaa000, 0x00000cccccccc000,
  0x0000155555554000, 0x0000199999998000,
  0x00002aaaaaaa8000, 0x0000333333330000,
  0x0000555555550000, 0x0000666666660000,
  0x0000aaaaaaaa0000, 0x0000cccccccc0000,
  0x0001555555540000, 0x0001999999980000,
  0x0002aaaaaaa80000, 0x0003333333300000,
  0x0005555555500000, 0x0006666666600000,
  0x000aaaaaaaa00000, 0x000cccccccc00000,
  0x0015555555400000, 0x0019999999800000,
  0x002aaaaaaa800000, 0x0033333333000000,
  0x0055555555000000, 0x0066666666000000,
  0x00aaaaaaaa000000, 0x00cccccccc000000,
  0x0155555554000000, 0x0199999998000000,
  0x02aaaaaaa8000000, 0x0333333330000000,
  0x0555555550000000, 0x0666666660000000,
  0x0aaaaaaaa0000000, 0x0cccccccc0000000,
  0x1555555540000000, 0x1999999980000000,
  0x2aaaaaaa80000000, 0x3333333300000000,
  0x5555555500000000, 0x6666666600000000,
  0x00000000cccccccc, 0x00000000ffff8000,
  0x0000000199999998, 0x00000001ffff0000,
  0x0000000333333330, 0x00000003fffe0000,
  0x0000000666666660, 0x00000007fffc0000,
  0x0000000cccccccc0, 0x0000000ffff80000,
  0x0000001999999980, 0x0000001ffff00000,
  0x0000003333333300, 0x0000003fffe00000,
  0x0000006666666600, 0x0000007fffc00000,
  0x000000cccccccc00, 0x000000ffff800000,
  0x0000019999999800, 0x000001ffff000000,
  0x0000033333333000, 0x000003fffe000000,
  0x0000066666666000, 0x000007fffc000000,
  0x00000cccccccc000, 0x00000ffff8000000,
  0x0000199999998000, 0x00001ffff0000000,
  0x0000333333330000, 0x00003fffe0000000,
  0x0000666666660000, 0x00007fffc0000000,
  0x0000cccccccc0000, 0x0000ffff80000000,
  0x0001999999980000, 0x0001ffff00000000,
  0x0003333333300000, 0x0003fffe00000000,
  0x0006666666600000, 0x0007fffc00000000,
  0x000cccccccc00000, 0x000ffff800000000,
  0x0019999999800000, 0x001ffff000000000,
  0x0033333333000000, 0x003fffe000000000,
  0x0066666666000000, 0x007fffc000000000,
  0x00cccccccc000000, 0x00ffff8000000000,
  0x0199999998000000, 0x01ffff0000000000,
  0x0333333330000000, 0x03fffe0000000000,
  0x0666666660000000, 0x07fffc0000000000,
  0x0cccccccc0000000, 0x0ffff80000000000,
  0x1999999980000000, 0x1ffff00000000000,
  0x3333333300000000, 0x3fffe00000000000,
  0x6666666600000000, 0x7fffc00000000000,
  0x00000000ffff8000, 0x00000000ffff8001,
  0x00000001ffff0000, 0x00000001ffff0002,
  0x00000003fffe0000, 0x00000003fffe0004,
  0x00000007fffc0000, 0x00000007fffc0008,
  0x0000000ffff80000, 0x0000000ffff80010,
  0x0000001ffff00000, 0x0000001ffff00020,
  0x0000003fffe00000, 0x0000003fffe00040,
  0x0000007fffc00000, 0x0000007fffc00080,
  0x000000ffff800000, 0x000000ffff800100,
  0x000001ffff000000, 0x000001ffff000200,
  0x000003fffe000000, 0x000003fffe000400,
  0x000007fffc000000, 0x000007fffc000800,
  0x00000ffff8000000, 0x00000ffff8001000,
  0x00001ffff0000000, 0x00001ffff0002000,
  0x00003fffe0000000, 0x00003fffe0004000,
  0x00007fffc0000000, 0x00007fffc0008000,
  0x0000ffff80000000, 0x0000ffff80010000,
  0x0001ffff00000000, 0x0001ffff00020000,
  0x0003fffe00000000, 0x0003fffe00040000,
  0x0007fffc00000000, 0x0007fffc00080000,
  0x000ffff800000000, 0x000ffff800100000,
  0x001ffff000000000, 0x001ffff000200000,
  0x003fffe000000000, 0x003fffe000400000,
  0x007fffc000000000, 0x007fffc000800000,
  0x00ffff8000000000, 0x00ffff8001000000,
  0x01ffff0000000000, 0x01ffff0002000000,
  0x03fffe0000000000, 0x03fffe0004000000,
  0x07fffc0000000000, 0x07fffc0008000000,
  0x0ffff80000000000, 0x0ffff80010000000,
  0x1ffff00000000000, 0x1ffff00020000000,
  0x3fffe00000000000, 0x3fffe00040000000,
  0x7fffc00000000000, 0x7fffc00080000000,
  0x00000000ffff8001, 0x00000000ffff8002,
  0x00000001ffff0002, 0x00000001ffff0004,
  0x00000003fffe0004, 0x00000003fffe0008,
  0x00000007fffc0008, 0x00000007fffc0010,
  0x0000000ffff80010, 0x0000000ffff80020,
  0x0000001ffff00020, 0x0000001ffff00040,
  0x0000003fffe00040, 0x0000003fffe00080,
  0x0000007fffc00080, 0x0000007fffc00100,
  0x000000ffff800100, 0x000000ffff800200,
  0x000001ffff000200, 0x000001ffff000400,
  0x000003fffe000400, 0x000003fffe000800,
  0x000007fffc000800, 0x000007fffc001000,
  0x00000ffff8001000, 0x00000ffff8002000,
  0x00001ffff0002000, 0x00001ffff0004000,
  0x00003fffe0004000, 0x00003fffe0008000,
  0x00007fffc0008000, 0x00007fffc0010000,
  0x0000ffff80010000, 0x0000ffff80020000,
  0x0001ffff00020000, 0x0001ffff00040000,
  0x0003fffe00040000, 0x0003fffe00080000,
  0x0007fffc00080000, 0x0007fffc00100000,
  0x000ffff800100000, 0x000ffff800200000,
  0x001ffff000200000, 0x001ffff000400000,
  0x003fffe000400000, 0x003fffe000800000,
  0x007fffc000800000, 0x007fffc001000000,
  0x00ffff8001000000, 0x00ffff8002000000,
  0x01ffff0002000000, 0x01ffff0004000000,
  0x03fffe0004000000, 0x03fffe0008000000,
  0x07fffc0008000000, 0x07fffc0010000000,
  0x0ffff80010000000, 0x0ffff80020000000,
  0x1ffff00020000000, 0x1ffff00040000000,
  0x3fffe00040000000, 0x3fffe00080000000,
  0x7fffc00080000000, 0x7fffc00100000000,
  0x00000000ffff8002, 0x00000000ffff8003,
  0x00000001ffff0004, 0x00000001ffff0006,
  0x00000003fffe0008, 0x00000003fffe000c,
  0x00000007fffc0010, 0x00000007fffc0018,
  0x0000000ffff80020, 0x0000000ffff80030,
  0x0000001ffff00040, 0x0000001ffff00060,
  0x0000003fffe00080, 0x0000003fffe000c0,
  0x0000007fffc00100, 0x0000007fffc00180,
  0x000000ffff800200, 0x000000ffff800300,
  0x000001ffff000400, 0x000001ffff000600,
  0x000003fffe000800, 0x000003fffe000c00,
  0x000007fffc001000, 0x000007fffc001800,
  0x00000ffff8002000, 0x00000ffff8003000,
  0x00001ffff0004000, 0x00001ffff0006000,
  0x00003fffe0008000, 0x00003fffe000c000,
  0x00007fffc0010000, 0x00007fffc0018000,
  0x0000ffff80020000, 0x0000ffff80030000,
  0x0001ffff00040000, 0x0001ffff00060000,
  0x0003fffe00080000, 0x0003fffe000c0000,
  0x0007fffc00100000, 0x0007fffc00180000,
  0x000ffff800200000, 0x000ffff800300000,
  0x001ffff000400000, 0x001ffff000600000,
  0x003fffe000800000, 0x003fffe000c00000,
  0x007fffc001000000, 0x007fffc001800000,
  0x00ffff8002000000, 0x00ffff8003000000,
  0x01ffff0004000000, 0x01ffff0006000000,
  0x03fffe0008000000, 0x03fffe000c000000,
  0x07fffc0010000000, 0x07fffc0018000000,
  0x0ffff80020000000, 0x0ffff80030000000,
  0x1ffff00040000000, 0x1ffff00060000000,
  0x3fffe00080000000, 0x3fffe000c0000000,
  0x7fffc00100000000, 0x7fffc00180000000,
  0x00000000ffff8003, 0x00000000ffffff80,
  0x00000001ffff0006, 0x00000001ffffff00,
  0x00000003fffe000c, 0x00000003fffffe00,
  0x00000007fffc0018, 0x00000007fffffc00,
  0x0000000ffff80030, 0x0000000ffffff800,
  0x0000001ffff00060, 0x0000001ffffff000,
  0x0000003fffe000c0, 0x0000003fffffe000,
  0x0000007fffc00180, 0x0000007fffffc000,
  0x000000ffff800300, 0x000000ffffff8000,
  0x000001ffff000600, 0x000001ffffff0000,
  0x000003fffe000c00, 0x000003fffffe0000,
  0x000007fffc001800, 0x000007fffffc0000,
  0x00000ffff8003000, 0x00000ffffff80000,
  0x00001ffff0006000, 0x00001ffffff00000,
  0x00003fffe000c000, 0x00003fffffe00000,
  0x00007fffc0018000, 0x00007fffffc00000,
  0x0000ffff80030000, 0x0000ffffff800000,
  0x0001ffff00060000, 0x0001ffffff000000,
  0x0003fffe000c0000, 0x0003fffffe000000,
  0x0007fffc00180000, 0x0007fffffc000000,
  0x000ffff800300000, 0x000ffffff8000000,
  0x001ffff000600000, 0x001ffffff0000000,
  0x003fffe000c00000, 0x003fffffe0000000,
  0x007fffc001800000, 0x007fffffc0000000,
  0x00ffff8003000000, 0x00ffffff80000000,
  0x01ffff0006000000, 0x01ffffff00000000,
  0x03fffe000c000000, 0x03fffffe00000000,
  0x07fffc0018000000, 0x07fffffc00000000,
  0x0ffff80030000000, 0x0ffffff800000000,
  0x1ffff00060000000, 0x1ffffff000000000,
  0x3fffe000c0000000, 0x3fffffe000000000,
  0x7fffc00180000000, 0x7fffffc000000000,
  0x00000000ffffff80, 0x00000000ffffff81,
  0x00000001ffffff00, 0x00000001ffffff02,
  0x00000003fffffe00, 0x00000003fffffe04,
  0x00000007fffffc00, 0x00000007fffffc08,
  0x0000000ffffff800, 0x0000000ffffff810,
  0x0000001ffffff000, 0x0000001ffffff020,
  0x0000003fffffe000, 0x0000003fffffe040,
  0x0000007fffffc000, 0x0000007fffffc080,
  0x000000ffffff8000, 0x000000ffffff8100,
  0x000001ffffff0000, 0x000001ffffff0200,
  0x000003fffffe0000, 0x000003fffffe0400,
  0x000007fffffc0000, 0x000007fffffc0800,
  0x00000ffffff80000, 0x00000ffffff81000,
  0x00001ffffff00000, 0x00001ffffff02000,
  0x00003fffffe00000, 0x00003fffffe04000,
  0x00007fffffc00000, 0x00007fffffc08000,
  0x0000ffffff800000, 0x0000ffffff810000,
  0x0001ffffff000000, 0x0001ffffff020000,
  0x0003fffffe000000, 0x0003fffffe040000,
  0x0007fffffc000000, 0x0007fffffc080000,
  0x000ffffff8000000, 0x000ffffff8100000,
  0x001ffffff0000000, 0x001ffffff0200000,
  0x003fffffe0000000, 0x003fffffe0400000,
  0x007fffffc0000000, 0x007fffffc0800000,
  0x00ffffff80000000, 0x00ffffff81000000,
  0x01ffffff00000000, 0x01ffffff02000000,
  0x03fffffe00000000, 0x03fffffe04000000,
  0x07fffffc00000000, 0x07fffffc08000000,
  0x0ffffff800000000, 0x0ffffff810000000,
  0x1ffffff000000000, 0x1ffffff020000000,
  0x3fffffe000000000, 0x3fffffe040000000,
  0x7fffffc000000000, 0x7fffffc080000000,
  0x00000000ffffff81, 0x00000000ffffff82,
  0x00000001ffffff02, 0x00000001ffffff04,
  0x00000003fffffe04, 0x00000003fffffe08,
  0x00000007fffffc08, 0x00000007fffffc10,
  0x0000000ffffff810, 0x0000000ffffff820,
  0x0000001ffffff020, 0x0000001ffffff040,
  0x0000003fffffe040, 0x0000003fffffe080,
  0x0000007fffffc080, 0x0000007fffffc100,
  0x000000ffffff8100, 0x000000ffffff8200,
  0x000001ffffff0200, 0x000001ffffff0400,
  0x000003fffffe0400, 0x000003fffffe0800,
  0x000007fffffc0800, 0x000007fffffc1000,
  0x00000ffffff81000, 0x00000ffffff82000,
  0x00001ffffff02000, 0x00001ffffff04000,
  0x00003fffffe04000, 0x00003fffffe08000,
  0x00007fffffc08000, 0x00007fffffc10000,
  0x0000ffffff810000, 0x0000ffffff820000,
  0x0001ffffff020000, 0x0001ffffff040000,
  0x0003fffffe040000, 0x0003fffffe080000,
  0x0007fffffc080000, 0x0007fffffc100000,
  0x000ffffff8100000, 0x000ffffff8200000,
  0x001ffffff0200000, 0x001ffffff0400000,
  0x003fffffe0400000, 0x003fffffe0800000,
  0x007fffffc0800000, 0x007fffffc1000000,
  0x00ffffff81000000, 0x00ffffff82000000,
  0x01ffffff02000000, 0x01ffffff04000000,
  0x03fffffe04000000, 0x03fffffe08000000,
  0x07fffffc08000000, 0x07fffffc10000000,
  0x0ffffff810000000, 0x0ffffff820000000,
  0x1ffffff020000000, 0x1ffffff040000000,
  0x3fffffe040000000, 0x3fffffe080000000,
  0x7fffffc080000000, 0x7fffffc100000000,
  0x00000000ffffff82, 0x00000000ffffff83,
  0x00000001ffffff04, 0x00000001ffffff06,
  0x00000003fffffe08, 0x00000003fffffe0c,
  0x00000007fffffc10, 0x00000007fffffc18,
  0x0000000ffffff820, 0x0000000ffffff830,
  0x0000001ffffff040, 0x0000001ffffff060,
  0x0000003fffffe080, 0x0000003fffffe0c0,
  0x0000007fffffc100, 0x0000007fffffc180,
  0x000000ffffff8200, 0x000000ffffff8300,
  0x000001ffffff0400, 0x000001ffffff0600,
  0x000003fffffe0800, 0x000003fffffe0c00,
  0x000007fffffc1000, 0x000007fffffc1800,
  0x00000ffffff82000, 0x00000ffffff83000,
  0x00001ffffff04000, 0x00001ffffff06000,
  0x00003fffffe08000, 0x00003fffffe0c000,
  0x00007fffffc10000, 0x00007fffffc18000,
  0x0000ffffff820000, 0x0000ffffff830000,
  0x0001ffffff040000, 0x0001ffffff060000,
  0x0003fffffe080000, 0x0003fffffe0c0000,
  0x0007fffffc100000, 0x0007fffffc180000,
  0x000ffffff8200000, 0x000ffffff8300000,
  0x001ffffff0400000, 0x001ffffff0600000,
  0x003fffffe0800000, 0x003fffffe0c00000,
  0x007fffffc1000000, 0x007fffffc1800000,
  0x00ffffff82000000, 0x00ffffff83000000,
  0x01ffffff04000000, 0x01ffffff06000000,
  0x03fffffe08000000, 0x03fffffe0c000000,
  0x07fffffc10000000, 0x07fffffc18000000,
  0x0ffffff820000000, 0x0ffffff830000000,
  0x1ffffff040000000, 0x1ffffff060000000,
  0x3fffffe080000000, 0x3fffffe0c0000000,
  0x7fffffc100000000, 0x7fffffc180000000,
  0x00000000ffffff83, 0x00000000ffffffe0,
  0x00000001ffffff06, 0x00000001ffffffc0,
  0x00000003fffffe0c, 0x00000003ffffff80,
  0x00000007fffffc18, 0x00000007ffffff00,
  0x0000000ffffff830, 0x0000000ffffffe00,
  0x0000001ffffff060, 0x0000001ffffffc00,
  0x0000003fffffe0c0, 0x0000003ffffff800,
  0x0000007fffffc180, 0x0000007ffffff000,
  0x000000ffffff8300, 0x000000ffffffe000,
  0x000001ffffff0600, 0x000001ffffffc000,
  0x000003fffffe0c00, 0x000003ffffff8000,
  0x000007fffffc1800, 0x000007ffffff0000,
  0x00000ffffff83000, 0x00000ffffffe0000,
  0x00001ffffff06000, 0x00001ffffffc0000,
  0x00003fffffe0c000, 0x00003ffffff80000,
  0x00007fffffc18000, 0x00007ffffff00000,
  0x0000ffffff830000, 0x0000ffffffe00000,
  0x0001ffffff060000, 0x0001ffffffc00000,
  0x0003fffffe0c0000, 0x0003ffffff800000,
  0x0007fffffc180000, 0x0007ffffff000000,
  0x000ffffff8300000, 0x000ffffffe000000,
  0x001ffffff0600000, 0x001ffffffc000000,
  0x003fffffe0c00000, 0x003ffffff8000000,
  0x007fffffc1800000, 0x007ffffff0000000,
  0x00ffffff83000000, 0x00ffffffe0000000,
  0x01ffffff06000000, 0x01ffffffc0000000,
  0x03fffffe0c000000, 0x03ffffff80000000,
  0x07fffffc18000000, 0x07ffffff00000000,
  0x0ffffff830000000, 0x0ffffffe00000000,
  0x1ffffff060000000, 0x1ffffffc00000000,
  0x3fffffe0c0000000, 0x3ffffff800000000,
  0x7fffffc180000000, 0x7ffffff000000000,
  0x00000000ffffffe0, 0x00000000fffffffd,
  0x00000001ffffffc0, 0x00000001fffffffa,
  0x00000003ffffff80, 0x00000003fffffff4,
  0x00000007ffffff00, 0x00000007ffffffe8,
  0x0000000ffffffe00, 0x0000000fffffffd0,
  0x0000001ffffffc00, 0x0000001fffffffa0,
  0x0000003ffffff800, 0x0000003fffffff40,
  0x0000007ffffff000, 0x0000007ffffffe80,
  0x000000ffffffe000, 0x000000fffffffd00,
  0x000001ffffffc000, 0x000001fffffffa00,
  0x000003ffffff8000, 0x000003fffffff400,
  0x000007ffffff0000, 0x000007ffffffe800,
  0x00000ffffffe0000, 0x00000fffffffd000,
  0x00001ffffffc0000, 0x00001fffffffa000,
  0x00003ffffff80000, 0x00003fffffff4000,
  0x00007ffffff00000, 0x00007ffffffe8000,
  0x0000ffffffe00000, 0x0000fffffffd0000,
  0x0001ffffffc00000, 0x0001fffffffa0000,
  0x0003ffffff800000, 0x0003fffffff40000,
  0x0007ffffff000000, 0x0007ffffffe80000,
  0x000ffffffe000000, 0x000fffffffd00000,
  0x001ffffffc000000, 0x001fffffffa00000,
  0x003ffffff8000000, 0x003fffffff400000,
  0x007ffffff0000000, 0x007ffffffe800000,
  0x00ffffffe0000000, 0x00fffffffd000000,
  0x01ffffffc0000000, 0x01fffffffa000000,
  0x03ffffff80000000, 0x03fffffff4000000,
  0x07ffffff00000000, 0x07ffffffe8000000,
  0x0ffffffe00000000, 0x0fffffffd0000000,
  0x1ffffffc00000000, 0x1fffffffa0000000,
  0x3ffffff800000000, 0x3fffffff40000000,
  0x7ffffff000000000, 0x7ffffffe80000000,
};
const unsigned kExpectedCount_NEON_ushll_2D_2OPIMM = 992;

#endif  // VIXL_SIM_USHLL_2D_2OPIMM_TRACE_AARCH64_H_
