/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Frame;
import java.util.Enumeration;
import rene.dialogs.Warning;
import rene.gui.Global;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.Count;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.expression.Expression;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.FixedAngleEditDialog;
import rene.zirkel.objects.InsideObject;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.SimulationObject;

public class FixedAngleObject
extends PrimitiveLineObject
implements MoveableObject,
SimulationObject,
InsideObject {
    protected PointObject P2;
    static Count N = new Count();
    double A;
    double A1;
    double A2;
    double AA;
    Expression E;
    boolean Filled = false;
    boolean Inverse = false;
    boolean EditAborted = false;
    boolean Dragable = false;
    boolean Reduced = false;
    public static final int NORMALSIZE = 1;
    public static final int SMALL = 0;
    public static final int LARGER = 2;
    public static final int LARGE = 3;
    public static final int RECT = 4;
    protected int DisplaySize = 1;

    public FixedAngleObject(Construction construction, PointObject pointObject, PointObject pointObject2, double d2, double d3) {
        super(construction);
        this.P1 = pointObject;
        this.P2 = pointObject2;
        this.init(construction, d2, d3);
        this.Unit = Global.getParameter("unit.angle", "\u00b0");
    }

    public void init(Construction construction, double d2, double d3, boolean bl) {
        double d4 = this.P1.getX() - this.P2.getX();
        double d5 = this.P1.getY() - this.P2.getY();
        this.A1 = Math.atan2(d5, d4);
        d4 = d2 - this.P2.getX();
        d5 = d3 - this.P2.getY();
        this.A2 = Math.atan2(d5, d4);
        this.A = this.A2 - this.A1;
        if (this.A < 0.0) {
            this.A += Math.PI * 2;
        } else if (this.A > Math.PI * 2) {
            this.A -= Math.PI * 2;
        }
        if (this.Inverse && this.Obtuse) {
            this.A = Math.PI * 2 - this.A;
        }
        if (bl && !this.Obtuse) {
            if (this.A > Math.PI) {
                this.A = Math.PI * 2 - this.A;
                this.Inverse = true;
            } else {
                this.Inverse = false;
            }
        }
        this.E = new Expression("" + this.round(this.A / Math.PI * 180.0, ZirkelCanvas.EditFactor), construction, this);
        this.validate();
        this.setColor(this.ColorIndex);
        this.updateText();
    }

    public void init(Construction construction, double d2, double d3) {
        this.init(construction, d2, d3, true);
    }

    @Override
    public void paint(MyGraphics myGraphics, ZirkelCanvas zirkelCanvas) {
        double d2;
        double d3;
        double d4;
        if (!this.Valid || this.mustHide(zirkelCanvas)) {
            return;
        }
        double d5 = (zirkelCanvas.minX() + zirkelCanvas.maxX()) / 2.0;
        double d6 = (zirkelCanvas.minY() + zirkelCanvas.maxY()) / 2.0;
        double d7 = (d5 - this.X1) * this.DY - (d6 - this.Y1) * this.DX;
        double d8 = d5 - d7 * this.DY;
        double d9 = d6 + d7 * this.DX;
        double d10 = Math.max(zirkelCanvas.maxX() - zirkelCanvas.minX(), zirkelCanvas.maxY() - zirkelCanvas.minY());
        if (Math.abs(d7) > d10) {
            return;
        }
        double d11 = (d8 - this.X1) * this.DX + (d9 - this.Y1) * this.DY;
        double d12 = d11 - d10;
        double d13 = d11 + d10;
        if (d12 < 0.0) {
            d12 = 0.0;
        }
        if (d12 >= d13) {
            return;
        }
        double d14 = zirkelCanvas.col(this.X1 + d12 * this.DX);
        double d15 = zirkelCanvas.col(this.X1 + d13 * this.DX);
        double d16 = zirkelCanvas.row(this.Y1 + d12 * this.DY);
        double d17 = zirkelCanvas.row(this.Y1 + d13 * this.DY);
        myGraphics.setColor(this);
        if (!this.Reduced) {
            myGraphics.drawLine(d14, d16, d15, d17, this);
        }
        double d18 = zirkelCanvas.col(this.getDisplaySize(zirkelCanvas)) - zirkelCanvas.col(0.0);
        d14 = zirkelCanvas.col(this.X1) - d18;
        d16 = zirkelCanvas.row(this.Y1) - d18;
        String string = AngleObject.translateToUnicode(this.getDisplayText());
        double d19 = (int)(this.A / Math.PI * 180.0);
        if (d19 < 0.0) {
            d19 += 360.0;
        } else if (d19 >= 360.0) {
            d19 -= 360.0;
        }
        if (this.isStrongSelected() && myGraphics instanceof MyGraphics13) {
            ((MyGraphics13)myGraphics).drawMarkerArc(d14 + d18, d16 + d18, d18, this.A1 / Math.PI * 180.0, d19);
        }
        myGraphics.setColor(this);
        if (this.Filled) {
            myGraphics.fillArc(d14, d16, 2.0 * d18 + 1.0, 2.0 * d18 + 1.0, this.A1 / Math.PI * 180.0, d19, this.Selected || this.getColorType() == 0, this.getColorType() != 1, true, this);
        } else if (this.DisplaySize == 4) {
            d4 = Math.cos(this.A1);
            d3 = Math.sin(this.A1);
            d2 = Math.cos(this.A1 + d19 / 180.0 * Math.PI);
            double d20 = Math.sin(this.A1 + d19 / 180.0 * Math.PI);
            myGraphics.drawLine(d14 + d18 + d18 * d4, d16 + d18 - d18 * d3, d14 + d18 + d18 * (d4 + d2), d16 + d18 - d18 * (d3 + d20));
            myGraphics.drawLine(d14 + d18 + d18 * (d4 + d2), d16 + d18 - d18 * (d3 + d20), d14 + d18 + d18 * d2, d16 + d18 - d18 * d20);
        } else {
            myGraphics.drawCircleArc(d14 + d18, d16 + d18, d18, this.A1 / Math.PI * 180.0, d19, this);
        }
        if (!string.equals("")) {
            myGraphics.setLabelColor(this);
            this.setFont(myGraphics);
            this.DisplaysText = true;
            d4 = Math.cos(this.A1 + this.A / 2.0);
            d3 = Math.sin(this.A1 + this.A / 2.0);
            if (string.equals("90" + this.getUnit()) || this.Name.startsWith(".")) {
                if (this.KeepClose) {
                    d2 = Math.sqrt(this.XcOffset * this.XcOffset + this.YcOffset * this.YcOffset);
                    this.TX1 = zirkelCanvas.col(this.X1 + d2 * d4) - 3.0;
                    this.TY1 = zirkelCanvas.row(this.Y1 + d2 * d3) - 3.0;
                    this.TX2 = this.TX1 + 9.0;
                    this.TY2 = this.TY1 + 9.0;
                    myGraphics.drawRect(zirkelCanvas.col(this.X1 + d2 * d4) - 1.0, zirkelCanvas.row(this.Y1 + d2 * d3) - 1.0, 3.0, 3.0);
                } else {
                    this.TX1 = zirkelCanvas.col(this.X1 + zirkelCanvas.dx(d18 * 0.66) * d4 + this.XcOffset) - 3.0;
                    this.TY1 = zirkelCanvas.row(this.Y1 + zirkelCanvas.dy(d18 * 0.66) * d3 + this.YcOffset) - 3.0;
                    this.TX2 = this.TX1 + 9.0;
                    this.TY2 = this.TY1 + 9.0;
                    myGraphics.drawRect(zirkelCanvas.col(this.X1 + zirkelCanvas.dx(d18 * 0.66) * d4 + this.XcOffset) - 1.0, zirkelCanvas.row(this.Y1 + zirkelCanvas.dy(d18 * 0.66) * d3 + this.YcOffset) - 1.0, 3.0, 3.0);
                }
            } else if (this.KeepClose) {
                d2 = Math.sqrt(this.XcOffset * this.XcOffset + this.YcOffset * this.YcOffset);
                this.drawCenteredLabel(myGraphics, string, zirkelCanvas, this.X1 + d2 * d4, this.Y1 + d2 * d3, 0.0, 0.0);
            } else {
                this.drawCenteredLabel(myGraphics, string, zirkelCanvas, this.X1 + zirkelCanvas.dx(d18 * 0.66) * d4, this.Y1 + zirkelCanvas.dy(d18 * 0.66) * d3, this.XcOffset, this.YcOffset);
            }
        }
    }

    @Override
    public boolean canKeepClose() {
        return true;
    }

    @Override
    public void setKeepClose(double d2, double d3) {
        this.KeepClose = true;
        this.XcOffset = d2 - this.X1;
        this.YcOffset = d3 - this.Y1;
    }

    double getDisplaySize(ZirkelCanvas zirkelCanvas) {
        double d2 = zirkelCanvas.dx((int)(12.0 * zirkelCanvas.pointSize()));
        if (this.DisplaySize == 0 || this.DisplaySize == 4) {
            d2 /= 2.0;
        } else if (this.DisplaySize == 2) {
            d2 *= 2.0;
        } else if (this.DisplaySize == 3) {
            double d3 = this.P1.getX() - this.X1;
            double d4 = this.P1.getY() - this.Y1;
            d2 = Math.sqrt(d3 * d3 + d4 * d4);
        }
        return d2;
    }

    @Override
    public String getTag() {
        return "Angle";
    }

    @Override
    public int getN() {
        return N.next();
    }

    @Override
    public void updateText() {
        if (this.E == null || !this.E.isValid()) {
            return;
        }
        this.setText(FixedAngleObject.text3(Zirkel.name("text.fixedangle"), this.P1.getName(), this.P2.getName(), this.E.toString()));
    }

    @Override
    public String getDisplayValue() {
        if (ZirkelCanvas.AnglesFactor <= 2.0) {
            return "" + (int)(this.A / Math.PI * 180.0 + 0.5);
        }
        return "" + this.round(this.A / Math.PI * 180.0, ZirkelCanvas.AnglesFactor);
    }

    @Override
    public void validate() {
        double d2;
        if (!this.P1.valid() || !this.P2.valid()) {
            this.Valid = false;
            return;
        }
        this.X1 = this.P2.getX();
        this.Y1 = this.P2.getY();
        double d3 = this.P1.getX() - this.X1;
        if (Math.sqrt(d3 * d3 + (d2 = this.P1.getY() - this.Y1) * d2) < 1.0E-9) {
            this.Valid = false;
            return;
        }
        this.A1 = Math.atan2(d2, d3);
        boolean bl = false;
        try {
            if (this.E != null && this.E.isValid()) {
                this.A = this.E.getValue() / 180.0 * Math.PI;
            }
            if (this.Obtuse) {
                if (this.Inverse) {
                    this.A = -this.A;
                }
            } else {
                if (this.Inverse && Math.sin(this.A) > 0.0) {
                    this.A = -this.A;
                }
                if (!this.Inverse && Math.sin(this.A) < 0.0) {
                    this.A = -this.A;
                }
            }
            if (this.A < 0.0) {
                bl = true;
            }
            while (this.A < 0.0) {
                this.A += Math.PI * 2;
            }
            while (this.A >= Math.PI * 2) {
                this.A -= Math.PI * 2;
            }
            this.A2 = this.A1 + this.A;
            this.DX = Math.cos(this.A2);
            this.DY = Math.sin(this.A2);
            this.AA = this.A;
        }
        catch (Exception exception) {
            this.Valid = false;
            return;
        }
        if (!this.Obtuse && this.A > Math.PI) {
            this.A1 = this.A2;
            this.A = Math.PI * 2 - this.A;
            this.A2 = this.A1 + this.A;
        } else if (this.Obtuse && bl) {
            this.A1 = this.A2;
            this.A = Math.PI * 2 - this.A;
            this.A2 = this.A1 + this.A;
        }
        this.Valid = true;
    }

    public double getLength() {
        return this.A;
    }

    @Override
    public void setFixed(String string) {
        this.E = new Expression(string, this.getConstruction(), this);
        this.updateText();
    }

    @Override
    public void round() {
        try {
            this.setFixed(this.round(this.E.getValue(), ZirkelCanvas.AnglesFactor) + "");
            this.validate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setEditFixed(String string) {
        this.E = new Expression(string, this.getConstruction(), this);
        this.updateText();
    }

    @Override
    public boolean canFix() {
        return true;
    }

    @Override
    public void printArgs(XmlWriter xmlWriter) {
        xmlWriter.printArg("first", this.P1.getName());
        xmlWriter.printArg("root", this.P2.getName());
        if (this.DisplaySize == 0) {
            xmlWriter.printArg("display", "small");
        }
        if (this.DisplaySize == 3) {
            xmlWriter.printArg("display", "large");
        }
        if (this.DisplaySize == 2) {
            xmlWriter.printArg("display", "larger");
        }
        if (this.DisplaySize == 4) {
            xmlWriter.printArg("display", "rectangle");
        }
        if (this.Filled) {
            xmlWriter.printArg("filled", "true");
        }
        if (this.E.isValid()) {
            xmlWriter.printArg("fixed", this.E.toString());
        } else {
            xmlWriter.printArg("fixed", "" + this.A / Math.PI * 180.0);
        }
        if (!this.Obtuse) {
            xmlWriter.printArg("acute", "true");
        }
        if (this.Inverse) {
            xmlWriter.printArg("inverse", "true");
        }
        if (this.Reduced) {
            xmlWriter.printArg("reduced", "true");
        }
        if (this.Dragable) {
            xmlWriter.printArg("dragable", "true");
        }
        super.printArgs(xmlWriter);
    }

    @Override
    public void edit(ZirkelCanvas zirkelCanvas) {
        FixedAngleEditDialog fixedAngleEditDialog;
        while (true) {
            fixedAngleEditDialog = new FixedAngleEditDialog(zirkelCanvas.getFrame(), this, zirkelCanvas);
            fixedAngleEditDialog.setVisible(true);
            zirkelCanvas.repaint();
            this.EditAborted = false;
            if (fixedAngleEditDialog.isAborted()) {
                this.EditAborted = true;
                break;
            }
            if (this.E == null || this.E.isValid()) break;
            Frame frame = zirkelCanvas.getFrame();
            Warning warning = new Warning(frame, this.E.getErrorText(), Zirkel.name("warning"), true);
            warning.center(frame);
            warning.setVisible(true);
        }
        if (fixedAngleEditDialog.wantsMore()) {
            new EditConditionals(zirkelCanvas.getFrame(), this);
            this.validate();
        }
    }

    @Override
    public boolean nearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        double d2;
        boolean bl;
        if (!this.Valid && this.P2.valid()) {
            return this.P2.nearto(n, n2, zirkelCanvas);
        }
        if (!this.displays(zirkelCanvas)) {
            return false;
        }
        double d3 = zirkelCanvas.x(n);
        double d4 = zirkelCanvas.y(n2);
        double d5 = (d3 - this.X1) * this.DY - (d4 - this.Y1) * this.DX;
        double d6 = (d3 - this.X1) * this.DX + (d4 - this.Y1) * this.DY;
        this.Value = Math.abs(zirkelCanvas.col(zirkelCanvas.minX() + d5) - zirkelCanvas.col(zirkelCanvas.minX()));
        if (!this.Reduced && this.Value < zirkelCanvas.selectionSize() && d6 > 0.0) {
            return true;
        }
        double d7 = zirkelCanvas.x(n) - this.X1;
        double d8 = zirkelCanvas.y(n2) - this.Y1;
        double d9 = zirkelCanvas.dx((int)zirkelCanvas.selectionSize());
        double d10 = this.getDisplaySize(zirkelCanvas);
        double d11 = Math.sqrt(d7 * d7 + d8 * d8);
        if (this.Filled || this.DisplaySize == 4) {
            bl = d11 < d10 + d9;
        } else {
            boolean bl2 = bl = Math.abs(d11 - d10) < d9;
        }
        if (!bl) {
            return false;
        }
        if (d10 < d9) {
            return bl;
        }
        double d12 = Math.atan2(d8, d7);
        if (d12 < 0.0) {
            d12 += Math.PI * 2;
        }
        if (this.A1 - (d2 = 0.05) < d12 && this.A2 + d2 > d12) {
            return true;
        }
        if (this.A1 - d2 < (d12 -= Math.PI * 2) && this.A2 + d2 > d12) {
            return true;
        }
        return this.A1 - d2 < (d12 += Math.PI * 4) && this.A2 + d2 > d12;
    }

    public void setDisplaySize(int n) {
        this.DisplaySize = n;
    }

    public int getDisplaySize() {
        return this.DisplaySize;
    }

    @Override
    public Enumeration depending() {
        super.depending();
        this.depset(this.P1, this.P2);
        Enumeration enumeration = this.E.getDepList().elements();
        while (enumeration.hasMoreElements()) {
            DL.add((ConstructionObject)enumeration.nextElement());
        }
        return DL.elements();
    }

    @Override
    public void translate() {
        this.P1 = (PointObject)this.P1.getTranslation();
        this.P2 = (PointObject)this.P2.getTranslation();
        try {
            this.setFixed(this.E.toString());
            this.E.translate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getE() {
        return this.E.toString();
    }

    @Override
    public double getValue() throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return this.A / Math.PI * 180.0;
    }

    @Override
    public void setFilled(boolean bl) {
        this.Filled = bl;
    }

    @Override
    public boolean isFilled() {
        return this.Filled;
    }

    @Override
    public boolean isFilledForSelect() {
        return false;
    }

    @Override
    public boolean contains(double d2, double d3) {
        double d4 = (d2 - this.X1) * this.DX + (d3 - this.Y1) * this.DY;
        return !(d4 < 1.0E-9);
    }

    @Override
    public double project(double d2, double d3) {
        double d4 = super.project(d2, d3);
        if (d4 < 0.0) {
            return 0.0;
        }
        return d4;
    }

    @Override
    public Enumeration points() {
        super.depending();
        return this.depset(this.P2);
    }

    @Override
    public void move(double d2, double d3) {
        this.init(this.getConstruction(), d2, d3, true);
    }

    @Override
    public boolean moveable() {
        return this.Dragable;
    }

    @Override
    public boolean isFixed() {
        return true;
    }

    public boolean getInverse() {
        return this.Inverse;
    }

    public void setInverse(boolean bl) {
        this.Inverse = bl;
    }

    public boolean isEditAborted() {
        return this.EditAborted;
    }

    public boolean isDragable() {
        return this.Dragable;
    }

    public void setDragable(boolean bl) {
        this.Dragable = bl;
    }

    public boolean isReduced() {
        return this.Reduced;
    }

    public void setReduced(boolean bl) {
        this.Reduced = bl;
    }

    public boolean fixedByNumber() {
        return this.E != null && this.E.isNumber();
    }

    @Override
    public void setSimulationValue(double d2) {
        this.A = d2 / 180.0 * Math.PI;
        Expression expression = this.E;
        this.E = null;
        this.validate();
        this.E = expression;
    }

    @Override
    public void resetSimulationValue() {
        this.validate();
    }

    @Override
    public void startDrag(double d2, double d3) {
    }

    @Override
    public void dragTo(double d2, double d3) {
        this.move(d2, d3);
    }

    @Override
    public double containsInside(PointObject pointObject) {
        double d2 = pointObject.getX() - this.X1;
        double d3 = pointObject.getY() - this.Y1;
        double d4 = Math.atan2(d3, d2);
        if (d4 < this.A1) {
            d4 += Math.PI * 2;
        }
        double d5 = 1.0E-5;
        if (d4 > this.A1 && d4 < this.A1 + this.A) {
            return 1.0;
        }
        if (d4 > this.A1 - d5 && d4 < this.A1 + this.A + d5) {
            return 0.5;
        }
        return 0.0;
    }

    @Override
    public boolean keepInside(PointObject pointObject) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        if (this.containsInside(pointObject) > 0.0) {
            return true;
        }
        double d8 = pointObject.getX();
        double d9 = pointObject.getY();
        double d10 = this.X1;
        double d11 = this.Y1;
        double d12 = d10;
        double d13 = d11;
        double d14 = 1.0E20;
        double d15 = this.X1 + Math.cos(this.A1);
        double d16 = d15 - d10;
        double d17 = d16 * (d8 - d10) / (d7 = d16 * d16 + (d6 = (d5 = this.Y1 + Math.sin(this.A1)) - d11) * d6) + d6 * (d9 - d11) / d7;
        if (d17 < 0.0) {
            d17 = 0.0;
        }
        if ((d4 = Math.sqrt((d8 - (d3 = d10 + d17 * d16)) * (d8 - d3) + (d9 - (d2 = d11 + d17 * d6)) * (d9 - d2))) < d14) {
            d14 = d4;
            d12 = d3;
            d13 = d2;
        }
        if ((d17 = (d16 = (d15 = this.X1 + Math.cos(this.A2)) - d10) * (d8 - d10) / (d7 = d16 * d16 + (d6 = (d5 = this.Y1 + Math.sin(this.A2)) - d11) * d6) + d6 * (d9 - d11) / d7) < 0.0) {
            d17 = 0.0;
        }
        if ((d4 = Math.sqrt((d8 - (d3 = d10 + d17 * d16)) * (d8 - d3) + (d9 - (d2 = d11 + d17 * d6)) * (d9 - d2))) < d14) {
            d14 = d4;
            d12 = d3;
            d13 = d2;
        }
        pointObject.move(d12, d13);
        return false;
    }
}

