/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.RadiusData;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelCollection;
import org.jmol.script.Token;
import org.jmol.shape.Shape;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Point3fi;
import org.jmol.util.TextFormat;
import org.jmol.util.XmlUtil;
import org.jmol.viewer.JmolConstants;

public abstract class ModelSet
extends ModelCollection {
    private boolean selectionHaloEnabled = false;
    private boolean echoShapeActive = false;
    protected String modelSetTypeName;
    protected Shape[] shapes;
    protected final Atom[] closest = new Atom[1];
    private SymmetryInterface pointGroup;
    private static final boolean useRasMolHbondsCalculation = true;

    protected void releaseModelSet() {
        if (this.shapes != null) {
            for (int i = 0; i < 34; ++i) {
                this.shapes[i] = null;
            }
        }
        this.models = null;
        this.closest[0] = null;
        super.releaseModelSet();
    }

    public void setSelectionHaloEnabled(boolean bl) {
        if (this.selectionHaloEnabled != bl) {
            this.selectionHaloEnabled = bl;
        }
    }

    public boolean getSelectionHaloEnabled() {
        return this.selectionHaloEnabled;
    }

    public boolean getEchoStateActive() {
        return this.echoShapeActive;
    }

    public void setEchoStateActive(boolean bl) {
        this.echoShapeActive = bl;
    }

    public String getModelSetTypeName() {
        return this.modelSetTypeName;
    }

    private Shape allocateShape(int n) {
        if (n == 2 || n == 3 || n == 4) {
            return null;
        }
        String string = JmolConstants.getShapeClassName(n);
        try {
            Class<?> clazz = Class.forName(string);
            Shape shape = (Shape)clazz.newInstance();
            this.viewer.setShapeErrorState(n, "allocate");
            shape.initializeShape(this.viewer, this.g3d, this, n);
            this.viewer.setShapeErrorState(-1, null);
            return shape;
        }
        catch (Exception exception) {
            Logger.error("Could not instantiate shape:" + string, exception);
            return null;
        }
    }

    public Shape getShape(int n) {
        return this.shapes[n];
    }

    float getAtomShapeValue(int n, int n2) {
        int n3 = JmolConstants.shapeTokenIndex(n2);
        if (n3 < 0 || this.shapes[n3] == null) {
            return 0.0f;
        }
        int n4 = this.shapes[n3].getSize(n);
        if (n4 == 0) {
            Group group = this.atoms[n].getGroup();
            if ((group.shapeVisibilityFlags & this.shapes[n3].myVisibilityFlag) == 0) {
                return 0.0f;
            }
            n4 = this.shapes[n3].getSize(group);
        }
        return (float)n4 / 2000.0f;
    }

    public int getModelNumberIndex(int n, boolean bl, boolean bl2) {
        if (bl) {
            for (int i = 0; i < this.modelCount; ++i) {
                if (this.modelNumbers[i] != n) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.modelCount; ++i) {
            if (this.modelFileNumbers[i] != n) continue;
            if (bl2 && this.isTrajectory(i)) {
                this.setTrajectory(i);
            }
            return i;
        }
        return -1;
    }

    public String getTrajectoryInfo() {
        String string = "";
        if (this.trajectorySteps == null) {
            return "";
        }
        int n = this.modelCount;
        while (--n >= 0) {
            if (this.models[n].selectedTrajectory < 0) continue;
            string = " or " + this.getModelNumberDotted(this.models[n].selectedTrajectory) + string;
            n = this.models[n].trajectoryBaseIndex;
        }
        if (string.length() > 0) {
            string = "set trajectory {" + string.substring(4) + "}";
        }
        return string;
    }

    public BitSet getBitSetTrajectories() {
        if (this.trajectorySteps == null) {
            return null;
        }
        BitSet bitSet = new BitSet();
        int n = this.modelCount;
        while (--n >= 0) {
            if (this.models[n].selectedTrajectory < 0) continue;
            bitSet.set(this.models[n].selectedTrajectory);
            n = this.models[n].trajectoryBaseIndex;
        }
        return bitSet;
    }

    public void setTrajectory(BitSet bitSet) {
        for (int i = 0; i < this.modelCount; ++i) {
            if (!bitSet.get(i)) continue;
            this.setTrajectory(i);
        }
    }

    public void setTrajectory(int n) {
        int n2;
        if (n < 0 || !this.models[n].isTrajectory) {
            return;
        }
        int n3 = this.models[n].firstAtomIndex;
        if (this.atoms[n3].modelIndex == n) {
            return;
        }
        int n4 = this.models[n].trajectoryBaseIndex;
        this.models[n4].selectedTrajectory = n;
        Point3f[] point3fArray = (Point3f[])this.trajectorySteps.get(n);
        BitSet bitSet = new BitSet();
        int n5 = n3 + this.getAtomCountInModel(n4);
        int n6 = 0;
        for (n2 = n3; n2 < n5 && n6 < point3fArray.length && point3fArray[n6] != null; ++n2) {
            this.atoms[n2].setFractionalCoord(point3fArray[n6++]);
            this.atoms[n2].modelIndex = (short)n;
            bitSet.set(n2);
        }
        this.initializeBspf();
        this.bspf.clearBspt(n4);
        this.recalculateLeadMidpointsAndWingVectors(n4);
        Integer n7 = new Integer(n4);
        for (n2 = 0; n2 < 34; ++n2) {
            if (this.shapes[n2] == null) continue;
            this.setShapeProperty(n2, "refreshTrajectories", n7, bitSet);
        }
        if (this.models[n4].hasCalculatedHBonds) {
            this.clearCalculatedHydrogenBonds(n4, null);
            this.models[n4].calcHydrogenBonds(bitSet, bitSet);
        }
        if ((n2 = this.viewer.getCurrentModelIndex()) >= 0 && n2 != n && this.models[n2].fileIndex == this.models[n].fileIndex) {
            this.viewer.setCurrentModelIndex(n, false);
        }
    }

    public Point3f[] getFrameOffsets(BitSet bitSet) {
        int n;
        if (bitSet == null) {
            return null;
        }
        Point3f[] point3fArray = new Point3f[this.modelCount];
        for (n = 0; n < this.modelCount; ++n) {
            point3fArray[n] = new Point3f();
        }
        n = 0;
        int n2 = 0;
        Point3f point3f = point3fArray[0];
        boolean bl = this.trajectorySteps != null && this.trajectorySteps.size() == this.modelCount;
        int n3 = bl ? this.modelCount : 1;
        block1: for (int i = 0; i < n3; ++i) {
            if (bl) {
                this.setTrajectory(i);
            }
            for (int j = 0; j <= this.atomCount; ++j) {
                if (j == this.atomCount || this.atoms[j].modelIndex != n) {
                    if (n2 > 0) {
                        point3f.scale(-1.0f / (float)n2);
                        if (n != 0) {
                            point3f.sub(point3fArray[0]);
                        }
                        n2 = 0;
                    }
                    if (j == this.atomCount) continue block1;
                    n = this.atoms[j].modelIndex;
                    point3f = point3fArray[n];
                }
                if (!bitSet.get(j)) continue;
                point3f.add(this.atoms[j]);
                ++n2;
            }
        }
        point3fArray[0].set(0.0f, 0.0f, 0.0f);
        return point3fArray;
    }

    public BitSet getAtomBits(int n, Object object) {
        switch (n) {
            case 0x100022: {
                return this.getSpecModel((Integer)object);
            }
        }
        return super.getAtomBits(n, object);
    }

    public String getAtomLabel(int n) {
        return (String)this.getShapeProperty(5, "label", n);
    }

    private BitSet getSpecModel(int n) {
        int n2 = this.getModelNumberIndex(n, true, true);
        return n2 < 0 && n > 0 ? new BitSet() : this.getModelAtomBitSet(n2, true);
    }

    public int findNearestAtomIndex(int n, int n2) {
        int n3;
        if (this.atomCount == 0) {
            return -1;
        }
        this.closest[0] = null;
        if (this.g3d.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
        }
        this.findNearestAtomIndex(n, n2, this.closest);
        if (this.shapes != null) {
            for (n3 = 0; n3 < this.shapes.length && this.closest[0] == null; ++n3) {
                if (this.shapes[n3] == null) continue;
                this.shapes[n3].findNearestAtomIndex(n, n2, this.closest);
            }
        }
        n3 = this.closest[0] == null ? -1 : this.closest[0].index;
        this.closest[0] = null;
        return n3;
    }

    public void setShapeSize(int n, int n2, RadiusData radiusData, BitSet bitSet) {
        if (this.shapes == null) {
            return;
        }
        this.viewer.setShapeErrorState(n, "set size");
        if (radiusData != null && radiusData.value != 0.0f || radiusData == null && n2 != 0) {
            this.loadShape(n);
        }
        if (this.shapes[n] != null) {
            this.shapes[n].setShapeSize(n2, radiusData, bitSet);
        }
        this.viewer.setShapeErrorState(-1, null);
    }

    public Shape loadShape(int n) {
        if (this.shapes == null) {
            return null;
        }
        if (this.shapes[n] == null) {
            this.shapes[n] = this.allocateShape(n);
        }
        return this.shapes[n];
    }

    public void setShapeProperty(int n, String string, Object object, BitSet bitSet) {
        if (this.shapes == null || this.shapes[n] == null) {
            return;
        }
        this.viewer.setShapeErrorState(n, "set " + string);
        this.shapes[n].setShapeProperty(string.intern(), object, bitSet);
        this.viewer.setShapeErrorState(-1, null);
    }

    public void releaseShape(int n) {
        if (this.shapes != null) {
            this.shapes[n] = null;
        }
    }

    public Object getShapeProperty(int n, String string, int n2) {
        if (this.shapes == null || this.shapes[n] == null) {
            return null;
        }
        this.viewer.setShapeErrorState(n, "get " + string);
        Object object = this.shapes[n].getProperty(string, n2);
        this.viewer.setShapeErrorState(-1, null);
        return object;
    }

    public boolean getShapeProperty(int n, String string, Object[] objectArray) {
        if (this.shapes == null || this.shapes[n] == null) {
            return false;
        }
        this.viewer.setShapeErrorState(n, "get " + string);
        boolean bl = this.shapes[n].getProperty(string, objectArray);
        this.viewer.setShapeErrorState(-1, null);
        return bl;
    }

    public int getShapeIdFromObjectName(String string) {
        if (this.shapes != null) {
            for (int i = 16; i < 28; ++i) {
                if (this.shapes[i] == null || this.shapes[i].getIndexFromName(string) < 0) continue;
                return i;
            }
        }
        return -1;
    }

    public void setModelVisibility() {
        int n;
        if (this.shapes == null) {
            return;
        }
        BitSet bitSet = this.viewer.getVisibleFramesBitSet();
        for (n = 1; n < 34; ++n) {
            if (this.shapes[n] == null) continue;
            this.shapes[n].setVisibilityFlags(bitSet);
        }
        this.shapes[0].setVisibilityFlags(bitSet);
        for (n = 0; n < 34; ++n) {
            Shape shape = this.shapes[n];
            if (shape == null) continue;
            shape.setModelClickability();
        }
    }

    public void fillAtomData(AtomData atomData, int n) {
        if (n == 3) {
            int[] nArray = new int[1];
            atomData.hAtomRadius = (float)this.viewer.getVanderwaalsMar(1) / 1000.0f;
            atomData.hAtoms = this.getAdditionalHydrogens(atomData.bsSelected, nArray, false, true);
            atomData.hydrogenAtomCount = nArray[0];
            return;
        }
        atomData.firstAtomIndex = atomData.modelIndex < 0 ? (atomData.bsSelected == null ? 0 : Math.max(0, atomData.bsSelected.nextSetBit(0))) : this.models[atomData.modelIndex].firstAtomIndex;
        atomData.firstModelIndex = this.atomCount == 0 ? 0 : (int)this.atoms[atomData.firstAtomIndex].modelIndex;
        atomData.lastModelIndex = atomData.firstModelIndex;
        atomData.modelName = this.getModelNumberDotted(atomData.firstModelIndex);
        super.fillAtomData(atomData, n);
    }

    public boolean frankClicked(int n, int n2) {
        Shape shape = this.shapes[33];
        return shape != null && shape.wasClicked(n, n2);
    }

    public boolean checkObjectHovered(int n, int n2, BitSet bitSet) {
        Shape shape = this.shapes[28];
        if (shape != null && shape.checkObjectHovered(n, n2, bitSet)) {
            return true;
        }
        shape = this.shapes[23];
        if (shape != null && shape.checkObjectHovered(n, n2, bitSet)) {
            return true;
        }
        shape = this.shapes[22];
        if (shape != null && this.viewer.getDrawHover() && shape.checkObjectHovered(n, n2, bitSet)) {
            return true;
        }
        shape = this.shapes[33];
        return this.viewer.getShowFrank() && shape != null && shape.checkObjectHovered(n, n2, bitSet);
    }

    public Token checkObjectClicked(int n, int n2, int n3, BitSet bitSet) {
        Shape shape;
        Point3fi point3fi = null;
        if (this.viewer.getNavigationMode() && this.viewer.getNavigateSurface() && (shape = this.shapes[23]) != null && (point3fi = shape.checkObjectClicked(n, n2, n3, bitSet)) != null) {
            return new Token(135197, point3fi);
        }
        if (n3 != 0 && this.viewer.getBondPicking() && (point3fi = this.shapes[1].checkObjectClicked(n, n2, n3, bitSet)) != null) {
            return new Token(1678770178, point3fi);
        }
        shape = this.shapes[28];
        if (shape != null && n3 != 0 && (point3fi = shape.checkObjectClicked(n, n2, n3, bitSet)) != null) {
            return new Token(537022465, point3fi);
        }
        shape = this.shapes[22];
        if (shape != null && (point3fi = shape.checkObjectClicked(n, n2, n3, bitSet)) != null) {
            return new Token(135184, point3fi);
        }
        return null;
    }

    public boolean checkObjectDragged(int n, int n2, int n3, int n4, int n5, BitSet bitSet, int n6) {
        for (int i = n6; i < 34; ++i) {
            Shape shape = this.shapes[i];
            if ((shape == null || !shape.checkObjectDragged(n, n2, n3, n4, n5, bitSet)) && n6 <= 0) continue;
            return true;
        }
        return false;
    }

    public Hashtable getShapeInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.shapes != null) {
            for (int i = 0; i < 34; ++i) {
                Shape shape = this.shapes[i];
                if (shape == null) continue;
                String string = JmolConstants.shapeClassBases[i];
                Vector vector = shape.getShapeDetail();
                if (vector == null) continue;
                hashtable.put(string, vector);
            }
        }
        if (stringBuffer.length() > 0) {
            hashtable.put("shapeCommands", stringBuffer.toString());
        }
        return hashtable;
    }

    public void calculateStructures(BitSet bitSet) {
        int n;
        BitSet bitSet2 = new BitSet();
        BitSet bitSet3 = BitSetUtil.copyInvert(this.modelsOf(bitSet, bitSet2), this.modelCount);
        for (n = 0; n < this.modelCount; ++n) {
            if (bitSet3.get(n)) continue;
            this.addBioPolymerToModel(null, this.models[n]);
        }
        this.calculatePolymers(bitSet3);
        this.calculateStructuresAllExcept(bitSet3, false);
        if (this.shapes != null) {
            for (n = 0; n < this.shapes.length; ++n) {
                if (this.shapes[n] == null || !this.shapes[n].isBioShape) continue;
                this.shapes[n].setSize(0, bitSet2);
                this.shapes[n].setShapeProperty("color", new Byte(1), bitSet2);
            }
        }
        this.setStructureIds();
    }

    public String calculatePointGroup(BitSet bitSet) {
        return (String)this.calculatePointGroupForFirstModel(bitSet, false, false, false, null, 0, 0.0f);
    }

    public Hashtable getPointGroupInfo(BitSet bitSet) {
        return (Hashtable)this.calculatePointGroupForFirstModel(bitSet, false, false, true, null, 0, 0.0f);
    }

    public String getPointGroupAsString(BitSet bitSet, boolean bl, String string, int n, float f) {
        return (String)this.calculatePointGroupForFirstModel(bitSet, true, bl, false, string, n, f);
    }

    private Object calculatePointGroupForFirstModel(BitSet bitSet, boolean bl, boolean bl2, boolean bl3, String string, int n, float f) {
        Object object;
        int n2;
        int n3 = this.viewer.getCurrentModelIndex();
        int n4 = n2 = bitSet == null ? -1 : bitSet.nextSetBit(0);
        if (n3 < 0 && n2 >= 0) {
            n3 = this.atoms[n2].getModelIndex();
        }
        if (n3 < 0) {
            n3 = this.viewer.getVisibleFramesBitSet().nextSetBit(0);
            bitSet = null;
        }
        BitSet bitSet2 = this.getModelAtomBitSet(n3, true);
        if (bitSet != null) {
            for (int i = 0; i < this.atomCount; ++i) {
                if (this.atoms[i].modelIndex != n3 || bitSet.get(i)) continue;
                bitSet2.clear(i);
            }
        }
        if ((n2 = bitSet2.nextSetBit(0)) < 0) {
            bitSet2 = this.getModelAtomBitSet(n3, true);
            n2 = bitSet2.nextSetBit(0);
        }
        boolean bl4 = (object = this.getShapeProperty(18, "mad", n2)) != null && (Integer)object != 0 || this.viewer.isVibrationOn();
        SymmetryInterface symmetryInterface = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        this.pointGroup = symmetryInterface.setPointGroup(this.pointGroup, this.atoms, bitSet2, bl4, this.viewer.getPointGroupTolerance(0), this.viewer.getPointGroupTolerance(1));
        if (!bl && !bl3) {
            return this.pointGroup.getPointGroupName();
        }
        Object object2 = this.pointGroup.getPointGroupInfo(n3, bl2, bl3, string, n, f);
        if (bl3) {
            return object2;
        }
        return (this.modelCount > 1 ? "frame " + this.getModelNumberDotted(n3) + "; " : "") + object2;
    }

    private BitSet modelsOf(BitSet bitSet, BitSet bitSet2) {
        int n;
        BitSet bitSet3 = new BitSet(this.modelCount);
        boolean bl = bitSet == null;
        int n2 = n = bl ? this.atomCount - 1 : bitSet.nextSetBit(0);
        while (n2 >= 0) {
            int n3 = this.models[this.atoms[n2].modelIndex].trajectoryBaseIndex;
            if (!this.isJmolDataFrame(n3)) {
                bitSet3.set(n3);
                bitSet2.set(n2);
            }
            n2 = bl ? n2 - 1 : bitSet.nextSetBit(n2 + 1);
        }
        return bitSet3;
    }

    public int autoHbond(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, float f, float f2) {
        this.bsPseudoHBonds = new BitSet();
        if (f2 == 0.0f && this.bondCount > 0) {
            this.calcHydrogenBonds(bitSet, bitSet2);
            bitSet3 = this.bsPseudoHBonds;
            return BitSetUtil.cardinalityOf(bitSet3);
        }
        this.initializeBspf();
        return super.autoHbond(bitSet, bitSet2, bitSet3, f, f2);
    }

    protected void assignAromaticBonds(boolean bl) {
        super.assignAromaticBonds(bl, null);
        if (bl) {
            this.setShapeSize(1, Integer.MIN_VALUE, null, this.bsAromatic);
        }
    }

    public int[] makeConnections(float f, float f2, int n, int n2, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl) {
        if (n2 == 0 || n2 == 0x4000000E) {
            String string = "connect ";
            if (f != 0.1f) {
                string = string + f + " ";
            }
            if (f2 != 1.0E8f) {
                string = string + f2 + " ";
            }
            this.addStateScript(string, bl ? bitSet : null, bl ? null : bitSet, bl ? null : bitSet2, n2 == 0 ? " delete" : " auto", false, true);
        }
        return super.makeConnections(f, f2, n, n2, bitSet, bitSet2, bitSet3, bl);
    }

    public void setPdbConectBonding(int n, int n2, BitSet bitSet) {
        short s = this.viewer.getMadBond();
        for (int i = n2; i < this.modelCount; ++i) {
            int n3;
            Vector vector = (Vector)this.getModelAuxiliaryInfo(i, "PDB_CONECT_bonds");
            if (vector == null) continue;
            int n4 = vector.size();
            int[] nArray = (int[])this.getModelAuxiliaryInfo(i, "PDB_CONECT_firstAtom_count_max");
            int n5 = nArray[0] + n;
            int n6 = n5 + nArray[1];
            int n7 = nArray[2];
            int[] nArray2 = new int[n7 + 1];
            for (n3 = n5; n3 < n6; ++n3) {
                int n8 = this.atomSerials[n3];
                if (n8 <= 0) continue;
                nArray2[n8] = n3 + 1;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                int[] nArray3 = (int[])vector.get(n3);
                int n9 = nArray3[0];
                int n10 = nArray3[1];
                short s2 = (short)nArray3[2];
                if (n9 < 0 || n10 < 0 || n9 > n7 || n10 > n7) continue;
                int n11 = nArray2[n9] - 1;
                int n12 = nArray2[n10] - 1;
                if (n11 < 0 || n12 < 0) continue;
                if (bitSet != null) {
                    if (this.atoms[n11].isHetero()) {
                        bitSet.set(n11);
                    }
                    if (this.atoms[n12].isHetero()) {
                        bitSet.set(n12);
                    }
                }
                this.checkValencesAndBond(this.atoms[n11], this.atoms[n12], s2, s2 == 2048 ? (short)1 : s, null);
            }
        }
    }

    public void deleteAllBonds() {
        int n = this.stateScripts.size();
        while (--n >= 0) {
            if (!((ModelCollection.StateScript)this.stateScripts.get(n)).isConnect()) continue;
            this.stateScripts.removeElementAt(n);
        }
        super.deleteAllBonds();
    }

    public String getDefinedState(StringBuffer stringBuffer, boolean bl) {
        String string;
        int n = this.stateScripts.size();
        if (n == 0) {
            return "";
        }
        boolean bl2 = false;
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            ModelCollection.StateScript stateScript = (ModelCollection.StateScript)this.stateScripts.get(i);
            if (stateScript.postDefinitions || (string = stateScript.toString()).length() <= 0) continue;
            stringBuffer2.append("  ").append(string).append("\n");
            bl2 = true;
        }
        if (!bl2) {
            return "";
        }
        string = "";
        if (bl && stringBuffer != null) {
            stringBuffer.append("  _setDefinedState;\n");
            string = "function _setDefinedState() {\n\n";
        }
        if (stringBuffer != null) {
            stringBuffer2.append("\n}\n\n");
        }
        return string + stringBuffer2.toString();
    }

    public String getState(StringBuffer stringBuffer, boolean bl) {
        String string;
        int n;
        StringBuffer stringBuffer2 = new StringBuffer();
        if (bl && stringBuffer != null) {
            stringBuffer.append("  _setModelState;\n");
            stringBuffer2.append("function _setModelState() {\n");
        }
        if (bl) {
            Object object;
            int n2;
            n = this.stateScripts.size();
            for (n2 = 0; n2 < n; ++n2) {
                object = (ModelCollection.StateScript)this.stateScripts.get(n2);
                if (!((ModelCollection.StateScript)object).postDefinitions || (string = ((ModelCollection.StateScript)object).toString()).length() <= 0) continue;
                stringBuffer2.append("  ").append(string).append("\n");
            }
            for (n2 = 0; n2 < this.bondCount; ++n2) {
                if ((this.bonds[n2].order & 0x20000) == 0 && !this.bonds[n2].isHydrogen()) continue;
                object = this.bonds[n2];
                stringBuffer2.append("  connect ").append("({").append(((Bond)object).atom1.index).append("}) ").append("({").append(((Bond)object).atom2.index).append("}) ").append(JmolConstants.getBondOrderNameFromOrder(((Bond)object).order)).append(";\n");
            }
            stringBuffer2.append("\n");
        }
        this.setModelVisibility();
        if (this.viewer.getBooleanProperty("saveProteinStructureState")) {
            stringBuffer2.append(this.getProteinStructureState(null, true, false, false));
        }
        if (this.shapes != null) {
            for (n = 0; n < 34; ++n) {
                Shape shape = this.shapes[n];
                if (shape == null || !bl && !JmolConstants.isShapeSecondary(n) || (string = shape.getShapeState()) == null || string.length() <= 1) continue;
                stringBuffer2.append(string);
            }
        }
        if (bl) {
            for (n = 0; n < this.modelCount; ++n) {
                String string2 = this.frameTitles[n];
                if (string2 != null && string2.length() > 0) {
                    stringBuffer2.append("  frame " + this.getModelNumberDotted(n) + "; frame title " + Escape.escape(string2) + ";\n");
                }
                if (this.models[n].orientation == null) continue;
                stringBuffer2.append("  frame " + this.getModelNumberDotted(n) + "; " + this.models[n].orientation.getMoveToText(false) + "\n");
            }
            stringBuffer2.append("  set fontScaling " + this.viewer.getFontScaling() + ";\n");
        }
        if (stringBuffer != null) {
            stringBuffer2.append("\n}\n\n");
        }
        return stringBuffer2.toString();
    }

    private void includeAllRelatedFrames(BitSet bitSet) {
        for (int i = 0; i < this.modelCount; ++i) {
            if (bitSet.get(i)) {
                int n;
                if (!this.isTrajectory(i) || bitSet.get(n = this.models[i].trajectoryBaseIndex)) continue;
                bitSet.set(n);
                this.includeAllRelatedFrames(bitSet);
                return;
            }
            if ((!this.isTrajectory(i) || !bitSet.get(this.models[i].trajectoryBaseIndex)) && (!this.isJmolDataFrame(i) || !bitSet.get(this.models[i].dataSourceFrame))) continue;
            bitSet.set(i);
        }
    }

    public BitSet deleteModels(BitSet bitSet) {
        int n;
        BitSet bitSet2 = this.getModelBitSet(bitSet, false);
        this.includeAllRelatedFrames(bitSet2);
        int n2 = 0;
        int n3 = BitSetUtil.cardinalityOf(bitSet2);
        if (n3 == 0) {
            return null;
        }
        int n4 = bitSet2.nextSetBit(0);
        while (n4 >= 0) {
            this.clearDataFrameReference(n4);
            n4 = bitSet2.nextSetBit(n4 + 1);
        }
        if (n3 == this.modelCount) {
            BitSet bitSet3 = this.getModelAtomBitSet(-1, true);
            this.viewer.zap(true, false);
            return bitSet3;
        }
        this.bspf = null;
        Model[] modelArray = new Model[this.modelCount - n3];
        Model[] modelArray2 = this.models;
        BitSet bitSet4 = new BitSet();
        int n5 = 0;
        for (n = 0; n < this.modelCount; ++n) {
            if (bitSet2.get(n)) {
                this.getAtomCountInModel(n);
                bitSet4.or(this.getModelAtomBitSet(n, false));
                continue;
            }
            this.models[n].modelIndex = n5;
            modelArray[n5++] = this.models[n];
        }
        this.models = modelArray;
        n = this.modelCount;
        BitSet bitSet5 = this.getBondsForSelectedAtoms(bitSet4, true);
        this.deleteBonds(bitSet5, true);
        int n6 = 0;
        for (int i = 0; i < n; ++i) {
            if (!bitSet2.get(i)) {
                ++n6;
                continue;
            }
            int n7 = modelArray2[i].atomCount;
            if (n7 == 0) continue;
            n2 += n7;
            BitSet bitSet6 = modelArray2[i].bsAtoms;
            int n8 = modelArray2[i].firstAtomIndex;
            BitSetUtil.deleteBits(this.bsSymmetry, bitSet6);
            this.deleteModel(n6, n8, n7, bitSet6, bitSet5);
            int n9 = n;
            while (--n9 > i) {
                modelArray2[n9].fixIndices(n6, n7, bitSet6);
            }
            Object[] objectArray = new Object[]{modelArray, this.atoms, new int[]{n6, n8, n7}};
            if (this.shapes != null) {
                for (int j = 0; j < 34; ++j) {
                    if (this.shapes[j] == null) continue;
                    this.setShapeProperty(j, "deleteModelAtoms", objectArray, bitSet6);
                }
            }
            --this.modelCount;
        }
        this.deleteModel(-1, 0, 0, null, null);
        return bitSet4;
    }

    public void setLabel(String string, BitSet bitSet) {
        if (string != null) {
            this.loadShape(5);
            this.setShapeSize(5, 0, null, bitSet);
        }
        this.setShapeProperty(5, "label", string, bitSet);
    }

    public void setAtomProperty(BitSet bitSet, int n, int n2, float f, String string, float[] fArray, String[] stringArray) {
        switch (n) {
            case 1113200642: 
            case 1113200647: 
            case 1113200649: 
            case 1113200650: 
            case 1113200654: 
            case 1115297793: 
            case 1650071565: {
                if (f > 4.0f) {
                    f = 4.0f;
                }
            }
            case 1113200646: 
            case 1113200652: {
                if (fArray != null) {
                    return;
                }
                if (f > 16.0f) {
                    f = 16.0f;
                }
                if (f < 0.0f) {
                    f = 0.0f;
                }
                this.setShapeSize(JmolConstants.shapeTokenIndex(n), (int)(f * 2000.0f), null, bitSet);
                return;
            }
        }
        super.setAtomProperty(bitSet, n, n2, f, string, fArray, stringArray);
    }

    public void setAtomLabel(String string, int n) {
        if (this.shapes == null) {
            return;
        }
        this.loadShape(5);
        this.shapes[5].setProperty("label:" + string, new Integer(n), null);
    }

    public Object getFileData(int n) {
        if (n < 0) {
            return "";
        }
        Hashtable hashtable = (Hashtable)this.getModelAuxiliaryInfo(n, "fileData");
        if (hashtable != null) {
            return hashtable;
        }
        if (!this.getModelAuxiliaryInfoBoolean(n, "isCIF")) {
            return this.getPDBHeader(n);
        }
        hashtable = this.viewer.getCifData(n);
        this.setModelAuxiliaryInfo(n, "fileData", hashtable);
        return hashtable;
    }

    public int calculateStruts(BitSet bitSet, BitSet bitSet2) {
        this.setModelVisibility();
        return super.calculateStruts(bitSet, bitSet2);
    }

    public String getModelCml(BitSet bitSet, int n, boolean bl) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = BitSetUtil.cardinalityOf(bitSet);
        if (n2 == 0) {
            return "";
        }
        XmlUtil.openTag(stringBuffer, "molecule");
        XmlUtil.openTag(stringBuffer, "atomArray");
        BitSet bitSet2 = new BitSet();
        int n3 = bitSet.nextSetBit(0);
        while (n3 >= 0 && --n >= 0) {
            object2 = this.atoms[n3];
            object = ((Atom)object2).getAtomName();
            TextFormat.simpleReplace((String)object, "\"", "''");
            bitSet2.set(((Atom)object2).index);
            XmlUtil.appendTag(stringBuffer, "atom/", new String[]{"id", "a" + (((Atom)object2).index + 1), "title", ((Atom)object2).getAtomName(), "elementType", ((Atom)object2).getElementSymbol(), "x3", "" + ((Atom)object2).x, "y3", "" + ((Atom)object2).y, "z3", "" + ((Atom)object2).z});
            n3 = bitSet.nextSetBit(n3 + 1);
        }
        XmlUtil.closeTag(stringBuffer, "atomArray");
        if (bl) {
            XmlUtil.openTag(stringBuffer, "bondArray");
            for (n3 = 0; n3 < this.bondCount; ++n3) {
                String string;
                object2 = this.bonds[n3];
                object = ((Bond)object2).atom1;
                Atom atom = ((Bond)object2).atom2;
                if (!bitSet2.get(((Atom)object).index) || !bitSet2.get(atom.index) || (string = JmolConstants.getCmlOrder(((Bond)object2).order)) == null) continue;
                XmlUtil.appendTag(stringBuffer, "bond/", new String[]{"atomRefs2", "a" + (((Bond)object2).atom1.index + 1) + " a" + (((Bond)object2).atom2.index + 1), "order", string});
            }
            XmlUtil.closeTag(stringBuffer, "bondArray");
        }
        XmlUtil.closeTag(stringBuffer, "molecule");
        return stringBuffer.toString();
    }
}

