/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap.parsers;

import java.io.IOException;
import java.io.InputStream;
import opendap.dap.parsers.DapParser;
import opendap.dap.parsers.Dapparse;
import opendap.dap.parsers.ParseException;

class Daplex
implements DapParser.Lexer {
    static final boolean URLCVT = false;
    static final boolean DAP2STRING = true;
    String wordchars1 = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-+_/%.\\*";
    String worddelims = "{}[]:;=,";
    String ddswordcharsn;
    static String daswordcharsn = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-+_/%.\\*:#";
    String wordcharsn = this.ddswordcharsn = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-+_/%.\\*#";
    static String hexdigits = "0123456789abcdefABCDEF";
    static String[] keywords = new String[]{"alias", "array", "attributes", "byte", "code", "dataset", "error", "float32", "float64", "grid", "int16", "int32", "maps", "message", "program", "program_type", "sequence", "string", "structure", "uint16", "uint32", "url", null};
    static int[] keytokens = new int[]{258, 259, 260, 261, 262, 263, 265, 266, 267, 268, 269, 270, 271, 272, 281, 280, 273, 274, 275, 276, 277, 278};
    Dapparse parsestate = null;
    InputStream stream = null;
    StringBuilder input = null;
    StringBuilder yytext = null;
    int lineno = 0;
    Object lval = null;
    StringBuilder lookahead = null;

    public Daplex(Dapparse state) {
        this.reset(state);
    }

    public void reset(Dapparse state) {
        this.parsestate = state;
        this.stream = null;
        this.input = new StringBuilder();
        this.yytext = new StringBuilder();
        this.lineno = 0;
        this.lval = null;
        this.lookahead = new StringBuilder();
    }

    void setStream(InputStream stream) {
        this.stream = stream;
    }

    public String getInput() {
        return this.input.toString();
    }

    void dassetup() throws ParseException {
        this.wordcharsn = daswordcharsn;
    }

    int peek() throws IOException {
        int c = this.read();
        this.pushback(c);
        return c;
    }

    void pushback(int c) {
        this.lookahead.insert(0, (char)c);
    }

    int read() throws IOException {
        int c;
        if (this.lookahead.length() == 0) {
            c = this.stream.read();
            if (c < 0) {
                c = 0;
            }
        } else {
            c = this.lookahead.charAt(0);
            this.lookahead.deleteCharAt(0);
        }
        return c;
    }

    @Override
    public int yylex() throws ParseException {
        int token = 0;
        this.yytext.setLength(0);
        try {
            int c;
            token = -1;
            block6: while (token < 0 && (c = this.read()) > 0) {
                if (c == 10) {
                    ++this.lineno;
                    continue;
                }
                if (c <= 32 || c == 127) continue;
                if (c == 35) {
                    while ((c = this.read()) != 10 && c != 0) {
                    }
                    continue;
                }
                if (this.worddelims.indexOf(c) >= 0) {
                    token = c;
                    continue;
                }
                if (c == 34) {
                    boolean more = true;
                    while (more && (c = this.read()) > 0) {
                        switch (c) {
                            case 34: {
                                more = false;
                                break;
                            }
                            case 92: {
                                c = this.read();
                                if (c >= 0) break;
                                more = false;
                                break;
                            }
                        }
                        if (!more) continue;
                        this.yytext.append((char)c);
                    }
                    token = 279;
                    continue;
                }
                if (this.wordchars1.indexOf(c) >= 0) {
                    String tmp;
                    this.yytext.append((char)c);
                    while ((c = this.read()) > 0) {
                        if (this.wordcharsn.indexOf(c) < 0) {
                            this.pushback(c);
                            break;
                        }
                        this.yytext.append((char)c);
                    }
                    if ("Data".equals(tmp = this.yytext.toString()) && this.peek() == 58) {
                        this.yytext.append((char)this.read());
                        c = this.read();
                        if (c == 13) {
                            c = this.read();
                        }
                        if (c != 10) {
                            throw new ParseException("Malformed 'Data:' trailer");
                        }
                        token = 264;
                        continue;
                    }
                    token = 279;
                    int i = 0;
                    while (keywords[i] != null) {
                        if (keywords[i].equalsIgnoreCase(tmp)) {
                            token = keytokens[i];
                            continue block6;
                        }
                        ++i;
                    }
                    continue;
                }
                String msg = String.format("Illegal Character: '%c'", c);
                this.yytext.append((char)c);
                this.lexerror(msg);
                throw new ParseException(msg);
            }
            if (token <= 0) {
                token = 0;
                this.lval = null;
            } else {
                Object object = this.lval = this.yytext.length() == 0 ? (String)null : this.yytext.toString();
            }
            if (this.parsestate.getDebugLevel() > 0) {
                this.dumptoken(token, (String)this.lval);
            }
            return token;
        }
        catch (IOException ioe) {
            throw new ParseException(ioe);
        }
    }

    void dumptoken(int token, String lval) throws ParseException {
        String stoken;
        if (token == 279) {
            stoken = lval;
        } else if (token < 127) {
            stoken = "" + (char)token;
        } else {
            switch (token) {
                case 258: {
                    stoken = "alias";
                    break;
                }
                case 259: {
                    stoken = "array";
                    break;
                }
                case 260: {
                    stoken = "attributes";
                    break;
                }
                case 261: {
                    stoken = "byte";
                    break;
                }
                case 263: {
                    stoken = "dataset";
                    break;
                }
                case 266: {
                    stoken = "float32";
                    break;
                }
                case 267: {
                    stoken = "float64";
                    break;
                }
                case 268: {
                    stoken = "grid";
                    break;
                }
                case 269: {
                    stoken = "int16";
                    break;
                }
                case 270: {
                    stoken = "int32";
                    break;
                }
                case 271: {
                    stoken = "maps";
                    break;
                }
                case 273: {
                    stoken = "sequence";
                    break;
                }
                case 274: {
                    stoken = "string";
                    break;
                }
                case 275: {
                    stoken = "structure";
                    break;
                }
                case 276: {
                    stoken = "uint16";
                    break;
                }
                case 277: {
                    stoken = "uint32";
                    break;
                }
                case 278: {
                    stoken = "url";
                    break;
                }
                default: {
                    stoken = "X" + Integer.toString(token);
                }
            }
        }
        System.err.println("TOKEN = |" + stoken + "|");
        if (stoken.length() == 1) {
            System.err.println("TOKEN = " + stoken.charAt(0));
        }
    }

    static int tohex(int c) throws ParseException {
        if (c >= 97 && c <= 102) {
            return c - 97 + 10;
        }
        if (c >= 65 && c <= 70) {
            return c - 65 + 10;
        }
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        return -1;
    }

    @Override
    public Object getLVal() {
        return this.lval;
    }

    @Override
    public void yyerror(String s) {
        String kind = "?";
        switch (this.parsestate.parseClass) {
            case 1: {
                kind = "DAS";
                break;
            }
            case 2: {
                kind = "DDS";
                break;
            }
            case 3: {
                kind = "Error";
                break;
            }
            default: {
                kind = "?";
            }
        }
        System.err.print("yyerror: " + kind + " line " + this.lineno + " near |" + this.yytext + "|; " + s);
        if (this.parsestate.getURL() != null) {
            System.err.println("\turl=" + this.parsestate.getURL());
        }
        new Exception().printStackTrace(System.err);
    }

    public void lexerror(String msg) {
        StringBuilder nextline = new StringBuilder();
        int c = 0;
        try {
            for (int i = 0; i < 1024 && (c = this.read()) != -1 && c != 10; ++i) {
                nextline.append((char)c);
            }
            if (c != -1) {
                nextline.append("...");
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        System.out.printf("Lex error: %s; line: %d: %s^%s\n", msg, this.lineno, this.yytext, nextline);
    }

    String readallinput(InputStream is) {
        StringBuilder b = new StringBuilder();
        try {
            int c;
            while ((c = is.read()) > 0) {
                b.append((char)c);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return b.toString();
    }
}

