/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.radial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.radial.RadialDatasetSweepAdapter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.EarthLocationImpl;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class CFnetCDF2Dataset
extends RadialDatasetSweepAdapter
implements TypedDatasetFactoryIF {
    private NetcdfDataset ds = null;
    double latv;
    double lonv;
    double elev;
    double[] time;
    float[] elevation;
    float[] azimuth;
    float[] range;
    int[] rayStartIdx;
    int[] rayEndIdx;
    int nsweeps;

    @Override
    public boolean isMine(NetcdfDataset ds) {
        String convention = ds.findAttValueIgnoreCase(null, "Conventions", null);
        return null != convention && convention.startsWith("CF/Radial");
    }

    @Override
    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuilder errlog) throws IOException {
        return new CFnetCDF2Dataset(ncd);
    }

    @Override
    public FeatureType getScientificDataType() {
        return FeatureType.RADIAL;
    }

    public CFnetCDF2Dataset() {
    }

    public CFnetCDF2Dataset(NetcdfDataset ds) {
        this.ds = ds;
        this.desc = "CF netCDF 2 radar dataset";
        this.init();
        List<Variable> vars = ds.getVariables();
        for (int i = 0; i < vars.size(); ++i) {
            this.addRadialVariable(ds, vars.get(i));
        }
    }

    public void init() {
        Variable t = this.ds.findVariable("time");
        Variable ele = this.ds.findVariable("elevation");
        Variable azi = this.ds.findVariable("azimuth");
        Variable rng = this.ds.findVariable("range");
        Variable sidx0 = this.ds.findVariable("sweep_start_ray_index");
        Variable sidx1 = this.ds.findVariable("sweep_end_ray_index");
        Variable snumber = this.ds.findVariable("sweep_number");
        this.setEarthLocation();
        try {
            Array tArray = t.read();
            this.time = (double[])tArray.copyTo1DJavaArray();
            Array eArray = ele.read();
            this.elevation = (float[])eArray.copyTo1DJavaArray();
            Array aArray = azi.read();
            this.azimuth = (float[])aArray.copyTo1DJavaArray();
            Array rArray = rng.read();
            this.range = (float[])rArray.copyTo1DJavaArray();
            this.rayStartIdx = (int[])sidx0.read().copyTo1DJavaArray();
            this.rayEndIdx = (int[])sidx1.read().copyTo1DJavaArray();
            Array sn = snumber.read();
            this.nsweeps = ((int[])sn.copyTo1DJavaArray()).length;
            this.setTimeUnits();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setStartDate();
        this.setEndDate();
        this.setBoundingBox();
    }

    @Override
    protected void setBoundingBox() {
        LatLonRect bb;
        if (this.origin == null) {
            return;
        }
        double dLat = Math.toDegrees(this.getMaximumRadialDist() / Earth.getRadius());
        double latRadians = Math.toRadians(this.origin.getLatitude());
        double dLon = dLat * Math.cos(latRadians);
        double lat1 = this.origin.getLatitude() - dLat / 2.0;
        double lon1 = this.origin.getLongitude() - dLon / 2.0;
        this.boundingBox = bb = new LatLonRect((LatLonPoint)new LatLonPointImpl(lat1, lon1), dLat, dLon);
    }

    double getMaximumRadialDist() {
        double maxdist = 0.0;
        for (RadialDatasetSweep.RadialVariable rv : this.dataVariables) {
            RadialDatasetSweep.Sweep sp = rv.getSweep(0);
            double dist = (float)sp.getGateNumber() * sp.getGateSize();
            if (!(dist > maxdist)) continue;
            maxdist = dist;
        }
        return maxdist;
    }

    @Override
    protected void setEarthLocation() {
        try {
            Variable ga = this.ds.findVariable("latitude");
            this.latv = ga != null ? ga.readScalarDouble() : 0.0;
            ga = this.ds.findVariable("longitude");
            this.lonv = ga != null ? ga.readScalarDouble() : 0.0;
            ga = this.ds.findVariable("altitude");
            this.elev = ga != null ? ga.readScalarDouble() : 0.0;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.origin = new EarthLocationImpl(this.latv, this.lonv, this.elev);
    }

    @Override
    public EarthLocation getCommonOrigin() {
        return this.origin;
    }

    @Override
    public String getRadarID() {
        Attribute ga = this.ds.findGlobalAttribute("Station");
        if (ga != null) {
            return ga.getStringValue();
        }
        return "XXXX";
    }

    @Override
    public String getRadarName() {
        Attribute ga = this.ds.findGlobalAttribute("StationName");
        if (ga != null) {
            return ga.getStringValue();
        }
        return "Unknown Station";
    }

    @Override
    public String getDataFormat() {
        return "CF/RadialNetCDF";
    }

    @Override
    public boolean isVolume() {
        return true;
    }

    public boolean isHighResolution(NetcdfDataset nds) {
        return true;
    }

    @Override
    public boolean isStationary() {
        return true;
    }

    @Override
    protected void setTimeUnits() throws Exception {
        Variable t = this.ds.findVariable("time");
        String ut = t.getUnitsString();
        this.dateUnits = new DateUnit(ut);
    }

    @Override
    protected void setStartDate() {
        this.startDate = this.dateUnits.makeDate(this.time[0]);
    }

    @Override
    protected void setEndDate() {
        this.endDate = this.dateUnits.makeDate(this.time[this.time.length - 1]);
    }

    @Override
    public void clearDatasetMemory() {
        List<VariableSimpleIF> rvars = this.getDataVariables();
        for (RadialDatasetSweep.RadialVariable radialVariable : rvars) {
            radialVariable.clearVariableMemory();
        }
    }

    @Override
    protected void addRadialVariable(NetcdfDataset nds, Variable var) {
        RadialDatasetSweep.RadialVariable rsvar = null;
        String vName = var.getShortName();
        int tIdx = var.findDimensionIndex("time");
        int rIdx = var.findDimensionIndex("range");
        if (tIdx == 0 && rIdx == 1) {
            RadialDatasetSweepAdapter.MyRadialVariableAdapter v = new RadialDatasetSweepAdapter.MyRadialVariableAdapter(this, vName, var.getAttributes());
            rsvar = this.makeRadialVariable(nds, v, var);
        }
        if (rsvar != null) {
            this.dataVariables.add(rsvar);
        }
    }

    @Override
    protected RadialDatasetSweep.RadialVariable makeRadialVariable(NetcdfDataset nds, VariableSimpleIF v, Variable v0) {
        return new CFRadial2Variable(nds, v, v0);
    }

    public String getInfo() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("CFRadial2Dataset\n");
        sbuff.append(super.getDetailInfo());
        sbuff.append("\n\n");
        sbuff.append(this.parseInfo.toString());
        return sbuff.toString();
    }

    private static void testRadialVariable(RadialDatasetSweep.RadialVariable rv) throws IOException {
        RadialDatasetSweep.Sweep sw;
        int nsweep = rv.getNumSweeps();
        for (int i = 0; i < nsweep; ++i) {
            sw = rv.getSweep(i);
            float me = sw.getMeanElevation();
            System.out.println("*** radar Sweep mean elevation of sweep " + i + " is: " + me);
            int nrays = sw.getRadialNumber();
            float[] az = new float[nrays];
            for (int j = 0; j < nrays; ++j) {
                float azi;
                az[j] = azi = sw.getAzimuth(j);
            }
            float[] azz = sw.getAzimuth();
            float[] dat = sw.readData();
        }
        sw = rv.getSweep(0);
        float[] data = rv.readAllData();
        float[] ddd = sw.readData();
        float[] da = sw.getAzimuth();
        float[] de = sw.getElevation();
        assert (null != ddd);
        int nrays = sw.getRadialNumber();
        float[] az = new float[nrays];
        for (int i = 0; i < nrays; ++i) {
            int ngates = sw.getGateNumber();
            assert (ngates > 0);
            float[] d = sw.readData(i);
            assert (null != d);
            float azi = sw.getAzimuth(i);
            assert (azi > 0.0f);
            az[i] = azi;
            float ele = sw.getElevation(i);
            assert (ele > 0.0f);
            float la = (float)sw.getOrigin(i).getLatitude();
            assert (la > 0.0f);
            float lo = (float)sw.getOrigin(i).getLongitude();
            assert (lo > 0.0f);
            float al = (float)sw.getOrigin(i).getAltitude();
            assert (al > 0.0f);
        }
        assert (0 != nrays);
    }

    public static void main(String[] args) throws Exception, IOException, InstantiationException, IllegalAccessException {
        String fileIn = "C:/Users/yuanho/Desktop/idvData/cfrad.20080604_002217_000_SPOL_v36_SUR.nc";
        RadialDatasetSweep rds = (RadialDatasetSweep)TypedDatasetFactory.open(FeatureType.RADIAL, fileIn, null, new StringBuilder());
        String st = rds.getStartDate().toString();
        String et = rds.getEndDate().toString();
        String id = rds.getRadarID();
        String name = rds.getRadarName();
        if (rds.isStationary()) {
            System.out.println("*** radar is stationary with name and id: " + name + " " + id);
        }
        List<VariableSimpleIF> rvars = rds.getDataVariables();
        RadialDatasetSweep.RadialVariable vDM = (RadialDatasetSweep.RadialVariable)rds.getDataVariable("DBZ");
        float[] adata = vDM.readAllData();
        CFnetCDF2Dataset.testRadialVariable(vDM);
        for (int i = 0; i < rvars.size(); ++i) {
            RadialDatasetSweep.RadialVariable rv = (RadialDatasetSweep.RadialVariable)rvars.get(i);
        }
    }

    private class CFRadial2Variable
    extends RadialDatasetSweepAdapter.MyRadialVariableAdapter
    implements RadialDatasetSweep.RadialVariable {
        ArrayList sweeps;
        String name;

        private CFRadial2Variable(NetcdfDataset nds, VariableSimpleIF v, Variable v0) {
            super(CFnetCDF2Dataset.this, v.getShortName(), v0.getAttributes());
            this.sweeps = new ArrayList();
            this.name = v.getShortName();
            int[] shape = v0.getShape();
            int count = v0.getRank() - 1;
            int ngates = shape[count];
            int nrays = shape[--count];
            for (int i = 0; i < CFnetCDF2Dataset.this.nsweeps; ++i) {
                this.sweeps.add(new CFRadial2Sweep(v0, i, nrays, ngates, CFnetCDF2Dataset.this.rayStartIdx[i], CFnetCDF2Dataset.this.rayEndIdx[i]));
            }
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public int getNumSweeps() {
            return CFnetCDF2Dataset.this.nsweeps;
        }

        @Override
        public RadialDatasetSweep.Sweep getSweep(int sweepNo) {
            return (RadialDatasetSweep.Sweep)this.sweeps.get(sweepNo);
        }

        public int getNumRadials() {
            return CFnetCDF2Dataset.this.azimuth.length;
        }

        @Override
        public float[] readAllData() throws IOException {
            Array allData;
            Object hrData = null;
            RadialDatasetSweep.Sweep spn = (RadialDatasetSweep.Sweep)this.sweeps.get(0);
            Variable v = spn.getsweepVar();
            int minRadial = this.getMinRadialNumber();
            int minRadials = minRadial * CFnetCDF2Dataset.this.nsweeps;
            int radials = this.getNumRadials();
            int gates = CFnetCDF2Dataset.this.range.length;
            try {
                allData = v.read();
            }
            catch (IOException e) {
                throw new IOException(e.getMessage());
            }
            if (minRadials == radials) {
                return (float[])allData.get1DJavaArray(Float.TYPE);
            }
            float[] fa0 = (float[])allData.get1DJavaArray(Float.TYPE);
            float[] fa = new float[minRadials * gates * CFnetCDF2Dataset.this.nsweeps];
            int pos = 0;
            for (int i = 0; i < CFnetCDF2Dataset.this.nsweeps; ++i) {
                int startIdx = CFnetCDF2Dataset.this.rayStartIdx[i];
                int len = minRadial * gates;
                System.arraycopy(fa0, startIdx * gates, fa, pos, len);
                pos += len;
            }
            return fa;
        }

        public int getMinRadialNumber() {
            int minRadialNumber = 1000;
            for (int i = 0; i < CFnetCDF2Dataset.this.nsweeps; ++i) {
                RadialDatasetSweep.Sweep swp = (RadialDatasetSweep.Sweep)this.sweeps.get(i);
                int radialNumber = swp.getRadialNumber();
                if (radialNumber >= minRadialNumber) continue;
                minRadialNumber = radialNumber;
            }
            return minRadialNumber;
        }

        @Override
        public void clearVariableMemory() {
            for (int i = 0; i < CFnetCDF2Dataset.this.nsweeps; ++i) {
            }
        }

        private class CFRadial2Sweep
        implements RadialDatasetSweep.Sweep {
            double meanElevation = Double.NaN;
            double meanAzimuth = Double.NaN;
            int nrays;
            int ngates;
            public int startIdx;
            public int endIdx;
            int sweepno;
            Variable sweepVar;

            CFRadial2Sweep(Variable v, int sweepno, int rays, int gates, int startIdx, int endIdx) {
                this.sweepVar = v;
                this.sweepno = sweepno;
                this.nrays = rays;
                this.ngates = gates;
                this.startIdx = startIdx;
                this.endIdx = endIdx;
            }

            public int getStartIdx() {
                return this.startIdx;
            }

            public int getEndIdx() {
                return this.endIdx;
            }

            @Override
            public Variable getsweepVar() {
                return this.sweepVar;
            }

            @Override
            public float[] readData() throws IOException {
                return this.sweepData();
            }

            private float[] sweepData() {
                int[] shape = this.sweepVar.getShape();
                int[] origin = new int[2];
                Array sweepTmp = null;
                origin[0] = this.startIdx;
                shape[0] = this.endIdx - this.startIdx;
                try {
                    sweepTmp = this.sweepVar.read(origin, shape).reduce();
                }
                catch (InvalidRangeException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return (float[])sweepTmp.get1DJavaArray(Float.TYPE);
            }

            @Override
            public float[] readData(int ray) throws IOException {
                return this.rayData(ray);
            }

            public float[] rayData(int ray) throws IOException {
                int[] shape = this.sweepVar.getShape();
                int[] origin = new int[2];
                Array sweepTmp = null;
                origin[0] = this.startIdx + ray;
                shape[0] = 1;
                try {
                    sweepTmp = this.sweepVar.read(origin, shape).reduce();
                }
                catch (InvalidRangeException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return (float[])sweepTmp.get1DJavaArray(Float.TYPE);
            }

            public void setMeanElevation() {
                double sum = 0.0;
                int sumSize = 0;
                int size = this.endIdx - this.startIdx;
                for (int i = 0; i < size; ++i) {
                    if (Double.isNaN(CFnetCDF2Dataset.this.elevation[i])) continue;
                    sum += (double)CFnetCDF2Dataset.this.elevation[this.startIdx + i];
                    ++sumSize;
                }
                this.meanElevation = sum / (double)sumSize;
            }

            @Override
            public float getMeanElevation() {
                if (Double.isNaN(this.meanElevation)) {
                    this.setMeanElevation();
                }
                return (float)this.meanElevation;
            }

            @Override
            public int getGateNumber() {
                return this.ngates;
            }

            @Override
            public int getRadialNumber() {
                return this.endIdx - this.startIdx;
            }

            @Override
            public RadialDatasetSweep.Type getType() {
                return null;
            }

            @Override
            public EarthLocation getOrigin(int ray) {
                return CFnetCDF2Dataset.this.origin;
            }

            @Override
            public Date getStartingTime() {
                return CFnetCDF2Dataset.this.startDate;
            }

            @Override
            public Date getEndingTime() {
                return CFnetCDF2Dataset.this.endDate;
            }

            @Override
            public int getSweepIndex() {
                return this.sweepno;
            }

            public void setMeanAzimuth() {
                double sum = 0.0;
                int sumSize = 0;
                int size = this.endIdx - this.startIdx;
                for (int i = 0; i < size; ++i) {
                    if (Double.isNaN(CFnetCDF2Dataset.this.azimuth[i])) continue;
                    sum += (double)CFnetCDF2Dataset.this.azimuth[this.startIdx + i];
                    ++sumSize;
                }
                this.meanAzimuth = sum / (double)sumSize;
            }

            @Override
            public float getMeanAzimuth() {
                if (Double.isNaN(this.meanAzimuth)) {
                    this.setMeanAzimuth();
                }
                return (float)this.meanAzimuth;
            }

            public boolean isConic() {
                return true;
            }

            @Override
            public float getElevation(int ray) throws IOException {
                return CFnetCDF2Dataset.this.elevation[ray + this.startIdx];
            }

            @Override
            public float[] getElevation() throws IOException {
                int size = this.endIdx - this.startIdx;
                float[] elev = new float[size];
                for (int i = this.startIdx; i < this.endIdx; ++i) {
                    elev[i - this.startIdx] = CFnetCDF2Dataset.this.elevation[i];
                }
                return elev;
            }

            @Override
            public float[] getAzimuth() throws IOException {
                int size = this.endIdx - this.startIdx;
                float[] azimu = new float[size];
                for (int i = this.startIdx; i < this.endIdx; ++i) {
                    azimu[i - this.startIdx] = CFnetCDF2Dataset.this.azimuth[i];
                }
                return azimu;
            }

            @Override
            public float getAzimuth(int ray) throws IOException {
                return CFnetCDF2Dataset.this.azimuth[ray + this.startIdx];
            }

            public float getRadialDistance(int gate) throws IOException {
                return CFnetCDF2Dataset.this.range[gate];
            }

            @Override
            public float getTime(int ray) throws IOException {
                return (float)CFnetCDF2Dataset.this.time[ray + this.startIdx];
            }

            @Override
            public float getBeamWidth() {
                return 0.95f;
            }

            @Override
            public float getNyquistFrequency() {
                return 0.0f;
            }

            @Override
            public float getRangeToFirstGate() {
                try {
                    return this.getRadialDistance(0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return 0.0f;
                }
            }

            @Override
            public float getGateSize() {
                try {
                    return this.getRadialDistance(1) - this.getRadialDistance(0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return 0.0f;
                }
            }

            public boolean isGateSizeConstant() {
                return true;
            }

            @Override
            public void clearSweepMemory() {
            }
        }
    }
}

