/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.ogc;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.unidata.geoloc.Projection;

public class CoordRefSysToGML {
    private Logger logger = LoggerFactory.getLogger(CoordRefSysToGML.class);
    protected static final Namespace gmlNS = Namespace.getNamespace("http://www.opengis.net/gml");
    protected static final Namespace xlinkNS = Namespace.getNamespace("xlink", "http://www.w3.org/1999/xlink");

    public static void writeCoordRefSysAsGML(PrintWriter pw, CoordinateSystem coordSys) throws IOException {
        XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
        xmlOutputter.output(CoordRefSysToGML.genCoordRefSysAsGML(coordSys), (Writer)pw);
    }

    public static Document genCoordRefSysAsGML(CoordinateSystem coordSys) {
        if (coordSys == null) {
            throw new IllegalArgumentException("CoordinateSystem must be non-null.");
        }
        if (!coordSys.isGeoReferencing()) {
            throw new IllegalArgumentException("CoordinateSystem must be a georeferencing CS.");
        }
        if (coordSys.isGeoXY()) {
            Element xyCrsElem = CoordRefSysToGML.genProjectedCRS((Projection)coordSys.getProjection());
        } else {
            coordSys.getLatAxis();
            coordSys.getLonAxis();
        }
        Element rootElem = new Element("CompoundCRS", gmlNS);
        rootElem.addContent("");
        rootElem.addNamespaceDeclaration(gmlNS);
        rootElem.addNamespaceDeclaration(xlinkNS);
        return new Document(rootElem);
    }

    public static Element genProjectedCRS(Projection proj) {
        Element projElem = new Element("ProjectedCRS", gmlNS);
        projElem.setAttribute("id", "", gmlNS);
        projElem.addContent(new Element("identifier", gmlNS).setAttribute("codeSpace", "", gmlNS).addContent(""));
        projElem.addContent(new Element("name", gmlNS).addContent(proj.getName()));
        projElem.addContent(new Element("scope", gmlNS).addContent(""));
        projElem.addContent(new Element("conversion", gmlNS).addContent(""));
        return projElem;
    }
}

