/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ant;

import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.catalina.ant.BaseRedirectorHelperTask;
import org.apache.catalina.util.Base64;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tools.ant.BuildException;

public abstract class AbstractCatalinaTask
extends BaseRedirectorHelperTask {
    private static String CHARSET = "utf-8";
    protected String charset = "ISO-8859-1";
    protected String password = null;
    protected String url = "http://localhost:8080/manager";
    protected String username = null;

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void execute() throws BuildException {
        if (this.username == null || this.password == null || this.url == null) {
            throw new BuildException("Must specify all of 'username', 'password', and 'url'");
        }
    }

    public void execute(String command) throws BuildException {
        this.execute(command, null, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String command, InputStream istream, String contentType, int contentLength) throws BuildException {
        URLConnection conn = null;
        InputStreamReader reader = null;
        try {
            int ch;
            conn = new URL(this.url + command).openConnection();
            HttpURLConnection hconn = (HttpURLConnection)conn;
            hconn.setAllowUserInteraction(false);
            hconn.setDoInput(true);
            hconn.setUseCaches(false);
            if (istream != null) {
                hconn.setDoOutput(true);
                hconn.setRequestMethod("PUT");
                if (contentType != null) {
                    hconn.setRequestProperty("Content-Type", contentType);
                }
                if (contentLength >= 0) {
                    hconn.setRequestProperty("Content-Length", "" + contentLength);
                    hconn.setFixedLengthStreamingMode(contentLength);
                }
            } else {
                hconn.setDoOutput(false);
                hconn.setRequestMethod("GET");
            }
            hconn.setRequestProperty("User-Agent", "Catalina-Ant-Task/1.0");
            String input = this.username + ":" + this.password;
            String output = Base64.encode(input.getBytes());
            hconn.setRequestProperty("Authorization", "Basic " + output);
            hconn.connect();
            if (istream != null) {
                int n;
                BufferedOutputStream ostream = new BufferedOutputStream(hconn.getOutputStream(), 1024);
                byte[] buffer = new byte[1024];
                while ((n = istream.read(buffer)) >= 0) {
                    ostream.write(buffer, 0, n);
                }
                ostream.flush();
                ostream.close();
                istream.close();
            }
            reader = new InputStreamReader(hconn.getInputStream(), CHARSET);
            StringBuilder buff = new StringBuilder();
            String error = null;
            int msgPriority = 2;
            boolean first = true;
            while ((ch = reader.read()) >= 0) {
                if (ch == 13 || ch == 10) {
                    if (buff.length() <= 0) continue;
                    String line = buff.toString();
                    buff.setLength(0);
                    if (first) {
                        if (!line.startsWith("OK -")) {
                            error = line;
                            msgPriority = 0;
                        }
                        first = false;
                    }
                    this.handleOutput(line, msgPriority);
                    continue;
                }
                buff.append((char)ch);
            }
            if (buff.length() > 0) {
                this.handleOutput(buff.toString(), msgPriority);
            }
            if (error != null && this.isFailOnError()) {
                throw new BuildException(error);
            }
        }
        catch (Throwable t) {
            if (this.isFailOnError()) {
                throw new BuildException(t);
            }
            this.handleErrorOutput(t.getMessage());
        }
        finally {
            this.closeRedirector();
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable u) {
                    ExceptionUtils.handleThrowable((Throwable)u);
                }
                reader = null;
            }
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (Throwable u) {
                    ExceptionUtils.handleThrowable((Throwable)u);
                }
                istream = null;
            }
        }
    }
}

