/*
 * Decompiled with CFR 0.152.
 */
package visad.data.vis5d;

import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.MapProjection;

public class Vis5DCoordinateSystem
extends MapProjection {
    private static final int PROJ_GENERIC = 0;
    private static final int PROJ_LINEAR = 1;
    private static final int PROJ_CYLINDRICAL = 20;
    private static final int PROJ_SPHERICAL = 21;
    private static final int PROJ_LAMBERT = 2;
    private static final int PROJ_STEREO = 3;
    private static final int PROJ_ROTATED = 4;
    private static final double RADIUS = 6371.23;
    private static final double WEST_POSITIVE = -1.0;
    private int Projection;
    int REVERSE_POLES = 1;
    double NorthBound;
    double SouthBound;
    double WestBound;
    double EastBound;
    double RowInc;
    double ColInc;
    double Lat1;
    double Lat2;
    double PoleRow;
    double PoleCol;
    double CentralLat;
    double CentralLon;
    double CentralRow;
    double CentralCol;
    double Rotation;
    double Cone;
    double Hemisphere;
    double ConeFactor;
    double CosCentralLat;
    double SinCentralLat;
    double StereoScale;
    double InvScale;
    double CylinderScale;
    double Nr;
    double Nc;
    double[] projargs;
    private static Unit[] coordinate_system_units = new Unit[]{null, null};

    public Vis5DCoordinateSystem(int Projection, double[] projargs, double Nr, double Nc) throws VisADException {
        super(RealTupleType.LatitudeLongitudeTuple, coordinate_system_units);
        this.Projection = Projection;
        this.Nr = Nr;
        this.Nc = Nc;
        this.projargs = projargs;
        switch (Projection) {
            case 0: 
            case 1: 
            case 20: 
            case 21: {
                this.NorthBound = projargs[0];
                this.WestBound = projargs[1];
                this.RowInc = projargs[2];
                this.ColInc = projargs[3];
                break;
            }
            case 4: {
                this.NorthBound = projargs[0];
                this.WestBound = projargs[1];
                this.RowInc = projargs[2];
                this.ColInc = projargs[3];
                this.CentralLat = Math.PI / 180 * projargs[4];
                this.CentralLon = Math.PI / 180 * projargs[5];
                this.Rotation = Math.PI / 180 * projargs[6];
                break;
            }
            case 2: {
                this.Lat1 = projargs[0];
                this.Lat2 = projargs[1];
                this.PoleRow = projargs[2];
                this.PoleCol = projargs[3];
                this.CentralLon = projargs[4];
                this.ColInc = projargs[5];
                break;
            }
            case 3: {
                this.CentralLat = projargs[0];
                this.CentralLon = projargs[1];
                this.CentralRow = projargs[2];
                this.CentralCol = projargs[3];
                this.ColInc = projargs[4];
                break;
            }
            default: {
                throw new VisADException("Projection unknown");
            }
        }
        switch (Projection) {
            case 0: 
            case 1: {
                this.SouthBound = this.NorthBound - this.RowInc * (Nr - 1.0);
                this.EastBound = this.WestBound - this.ColInc * (Nc - 1.0);
                break;
            }
            case 2: {
                double lat1;
                if (this.Lat1 == this.Lat2) {
                    lat1 = this.Lat1 > 0.0 ? (90.0 - this.Lat1) * (Math.PI / 180) : (90.0 + this.Lat1) * (Math.PI / 180);
                    this.Cone = Math.cos(lat1);
                    this.Hemisphere = 1.0;
                } else {
                    if (Vis5DCoordinateSystem.sign(this.Lat1) != Vis5DCoordinateSystem.sign(this.Lat2)) {
                        throw new VisADException("Error: standard latitudes must have the same sign.\n");
                    }
                    if (this.Lat1 < this.Lat2) {
                        throw new VisADException("Error: Lat1 must be >= Lat2\n");
                    }
                    this.Hemisphere = 1.0;
                    lat1 = (90.0 - this.Lat1) * (Math.PI / 180);
                    double lat2 = (90.0 - this.Lat2) * (Math.PI / 180);
                    double a = Math.log(Math.sin(lat1)) - Math.log(Math.sin(lat2));
                    double b = Math.log(Math.tan(lat1 / 2.0)) - Math.log(Math.tan(lat2 / 2.0));
                    this.Cone = a / b;
                }
                this.ConeFactor = 6371.23 * Math.sin(lat1) / (this.ColInc * this.Cone * Math.pow(Math.tan(lat1 / 2.0), this.Cone));
                break;
            }
            case 3: {
                this.CosCentralLat = Math.cos(this.CentralLat * (Math.PI / 180));
                this.SinCentralLat = Math.sin(this.CentralLat * (Math.PI / 180));
                this.StereoScale = 12742.46 / this.ColInc;
                this.InvScale = 1.0 / this.StereoScale;
                break;
            }
            case 4: {
                this.SouthBound = this.NorthBound - this.RowInc * (Nr - 1.0);
                this.EastBound = this.WestBound - this.ColInc * (Nc - 1.0);
                break;
            }
            case 20: {
                this.CylinderScale = this.REVERSE_POLES == -1 ? 1.0 / (-1.0 * (-90.0 - this.NorthBound)) : 1.0 / (90.0 - this.SouthBound);
                this.SouthBound = this.NorthBound - this.RowInc * (Nr - 1.0);
                this.EastBound = this.WestBound - this.ColInc * (Nc - 1.0);
                break;
            }
            case 21: {
                this.SouthBound = this.NorthBound - this.RowInc * (Nr - 1.0);
                this.EastBound = this.WestBound - this.ColInc * (Nc - 1.0);
            }
        }
        if (Projection != 0) {
            if (this.SouthBound < -90.0) {
                throw new VisADException("SouthBound less than -90.0");
            }
            if (this.NorthBound < this.SouthBound) {
                throw new VisADException("NorthBound less than SouthBound");
            }
            if (90.0 < this.NorthBound) {
                throw new VisADException("NorthBound greater than 90.0");
            }
        }
    }

    public Rectangle2D getDefaultMapArea() {
        return new Rectangle2D.Double(0.0, 0.0, this.Nc, this.Nr);
    }

    public int getProjection() {
        return this.Projection;
    }

    public double getRows() {
        return this.Nr;
    }

    public double getColumns() {
        return this.Nc;
    }

    public double[] getProjectionParams() {
        return this.projargs;
    }

    public boolean isXYOrder() {
        return false;
    }

    public double[][] toReference(double[][] rowcol) throws VisADException {
        int length = rowcol[0].length;
        double[][] latlon = new double[2][length];
        switch (this.Projection) {
            case 0: 
            case 1: 
            case 20: 
            case 21: {
                int kk = 0;
                while (kk < length) {
                    latlon[0][kk] = this.NorthBound - (this.Nr - 1.0 - rowcol[0][kk]) * (this.NorthBound - this.SouthBound) / (this.Nr - 1.0);
                    latlon[1][kk] = this.WestBound - rowcol[1][kk] * (this.WestBound - this.EastBound) / (this.Nc - 1.0);
                    double[] dArray = latlon[1];
                    int n = kk++;
                    dArray[n] = dArray[n] * -1.0;
                }
                break;
            }
            case 2: {
                for (int kk = 0; kk < length; ++kk) {
                    double radius;
                    double xldif = this.Hemisphere * (this.Nr - 1.0 - rowcol[0][kk] - this.PoleRow) / this.ConeFactor;
                    double xedif = (this.PoleCol - rowcol[1][kk]) / this.ConeFactor;
                    double xrlon = xldif == 0.0 && xedif == 0.0 ? 0.0 : Math.atan2(xedif, xldif);
                    double lon = xrlon / this.Cone * 57.29577951308232 + this.CentralLon;
                    if (lon > 180.0) {
                        lon -= 360.0;
                    }
                    double lat = (radius = Math.sqrt(xldif * xldif + xedif * xedif)) < 1.0E-4 ? 90.0 * this.Hemisphere : this.Hemisphere * (90.0 - 2.0 * Math.atan(Math.exp(Math.log(radius) / this.Cone)) * 57.29577951308232);
                    latlon[0][kk] = lat;
                    latlon[1][kk] = -1.0 * lon;
                }
                break;
            }
            case 3: {
                for (int kk = 0; kk < length; ++kk) {
                    double lon;
                    double lat;
                    double xrow = this.CentralRow - (this.Nr - 1.0 - rowcol[0][kk]) - 1.0;
                    double xcol = this.CentralCol - rowcol[1][kk] - 1.0;
                    double rho = xrow * xrow + xcol * xcol;
                    if (rho < 1.0E-20) {
                        lat = this.CentralLat;
                        lon = this.CentralLon;
                    } else {
                        rho = Math.sqrt(rho);
                        double c = 2.0 * Math.atan(rho * this.InvScale);
                        double cc = Math.cos(c);
                        double sc = Math.sin(c);
                        lat = 57.29577951308232 * Math.asin(cc * this.SinCentralLat + xrow * sc * this.CosCentralLat / rho);
                        lon = this.CentralLon + 57.29577951308232 * Math.atan2(xcol * sc, rho * this.CosCentralLat * cc - xrow * this.SinCentralLat * sc);
                        if (lon < -180.0) {
                            lon += 360.0;
                        } else if (lon > 180.0) {
                            lon -= 360.0;
                        }
                    }
                    latlon[0][kk] = lat;
                    latlon[1][kk] = -1.0 * lon;
                }
                break;
            }
            case 4: {
                for (int kk = 0; kk < length; ++kk) {
                    latlon[0][kk] = this.NorthBound - (this.Nr - 1.0 - rowcol[0][kk]) * (this.NorthBound - this.SouthBound) / (this.Nr - 1.0);
                    latlon[1][kk] = this.WestBound - rowcol[1][kk] * (this.WestBound - this.EastBound) / (this.Nc - 1.0);
                }
                Vis5DCoordinateSystem.pandg_back(latlon, this.CentralLat, this.CentralLon, this.Rotation);
                break;
            }
            default: {
                throw new VisADException("projection unknown");
            }
        }
        return latlon;
    }

    public double[][] fromReference(double[][] latlon) throws VisADException {
        int length = latlon[0].length;
        double[][] rowcol = new double[2][length];
        switch (this.Projection) {
            case 0: 
            case 1: 
            case 20: 
            case 21: {
                for (int kk = 0; kk < length; ++kk) {
                    rowcol[0][kk] = (this.NorthBound - latlon[0][kk]) / this.RowInc;
                    rowcol[0][kk] = this.Nr - 1.0 - rowcol[0][kk];
                    rowcol[1][kk] = (this.WestBound - latlon[1][kk] * -1.0) / this.ColInc;
                }
                break;
            }
            case 2: {
                for (int kk = 0; kk < length; ++kk) {
                    double r;
                    double lat = latlon[0][kk];
                    double lon = latlon[1][kk] * -1.0;
                    double rlon = lon - this.CentralLon;
                    rlon = rlon * this.Cone * (Math.PI / 180);
                    if (lat < -85.0) {
                        r = 10000.0;
                    } else {
                        double rlat = (90.0 - this.Hemisphere * lat) * (Math.PI / 180) * 0.5;
                        r = this.ConeFactor * Math.pow(Math.tan(rlat), this.Cone);
                    }
                    rowcol[0][kk] = this.PoleRow + r * Math.cos(rlon);
                    rowcol[0][kk] = this.Nr - 1.0 - rowcol[0][kk];
                    rowcol[1][kk] = this.PoleCol - r * Math.sin(rlon);
                }
                break;
            }
            case 3: {
                for (int kk = 0; kk < length; ++kk) {
                    double lat = latlon[0][kk];
                    double lon = latlon[1][kk] * -1.0;
                    double rlat = Math.PI / 180 * lat;
                    double rlon = Math.PI / 180 * (this.CentralLon - lon);
                    double clon = Math.cos(rlon);
                    double clat = Math.cos(rlat);
                    double k = this.StereoScale / (1.0 + this.SinCentralLat * Math.sin(rlat) + this.CosCentralLat * clat * clon);
                    rowcol[1][kk] = this.CentralCol - 1.0 + k * clat * Math.sin(rlon);
                    rowcol[0][kk] = this.CentralRow - 1.0 - k * (this.CosCentralLat * Math.sin(rlat) - this.SinCentralLat * clat * clon);
                    rowcol[0][kk] = this.Nr - 1.0 - rowcol[0][kk];
                }
                break;
            }
            case 4: {
                Vis5DCoordinateSystem.pandg_for(latlon, this.CentralLat, this.CentralLon, this.Rotation);
                for (int kk = 0; kk < length; ++kk) {
                    rowcol[0][kk] = (this.NorthBound - latlon[0][kk]) / this.RowInc;
                    rowcol[0][kk] = this.Nr - 1.0 - rowcol[0][kk];
                    rowcol[1][kk] = (this.WestBound - latlon[1][kk]) / this.ColInc;
                }
                break;
            }
            default: {
                throw new VisADException("Projection unknown");
            }
        }
        return rowcol;
    }

    private static void pandg_back(double[][] latlon, double a, double b, double r) {
        int kk = 0;
        while (kk < latlon[0].length) {
            double pr = Math.PI / 180 * latlon[0][kk];
            double gr = -Math.PI / 180 * latlon[1][kk];
            double pm = Math.asin(Math.cos(pr) * Math.cos(gr));
            double gm = Math.atan2(Math.cos(pr) * Math.sin(gr), -Math.sin(pr));
            latlon[0][kk] = 57.29577951308232 * Math.asin(Math.sin(a) * Math.sin(pm) - Math.cos(a) * Math.cos(pm) * Math.cos(gm - r));
            latlon[1][kk] = -57.29577951308232 * (-b + Math.atan2(Math.cos(pm) * Math.sin(gm - r), Math.sin(a) * Math.cos(pm) * Math.cos(gm - r) + Math.cos(a) * Math.sin(pm)));
            double[] dArray = latlon[1];
            int n = kk++;
            dArray[n] = dArray[n] * -1.0;
        }
    }

    private static void pandg_for(double[][] latlon, double a, double b, double r) {
        for (int kk = 0; kk < latlon[0].length; ++kk) {
            double p1 = Math.PI / 180 * latlon[0][kk];
            double g1 = -Math.PI / 180 * latlon[1][kk] * -1.0;
            double p = Math.asin(Math.sin(a) * Math.sin(p1) + Math.cos(a) * Math.cos(p1) * Math.cos(g1 + b));
            double g = r + Math.atan2(Math.cos(p1) * Math.sin(g1 + b), Math.sin(a) * Math.cos(p1) * Math.cos(g1 + b) - Math.cos(a) * Math.sin(p1));
            latlon[0][kk] = 57.29577951308232 * Math.asin(-Math.cos(p) * Math.cos(g));
            latlon[1][kk] = -57.29577951308232 * Math.atan2(Math.cos(p) * Math.sin(g), Math.sin(p));
        }
    }

    private static boolean sign(double dub) {
        return !(dub < 0.0);
    }

    public boolean equals(Object cs) {
        if (!(cs instanceof Vis5DCoordinateSystem)) {
            return false;
        }
        Vis5DCoordinateSystem that = (Vis5DCoordinateSystem)cs;
        return this.Projection == that.Projection && Double.doubleToLongBits(this.Nr) == Double.doubleToLongBits(that.Nr) && Double.doubleToLongBits(this.Nc) == Double.doubleToLongBits(that.Nc) && Arrays.equals(this.projargs, that.projargs);
    }

    public static void main(String[] args) throws VisADException {
        int proj = 3;
        double[] projargs = new double[]{90.0, 100.0, 50.0, 50.0, 100.0};
        Vis5DCoordinateSystem v5dcs = new Vis5DCoordinateSystem(proj, projargs, 100.0, 100.0);
        double[][] latlon = new double[][]{{89.0, 42.0, 60.0}, {-100.0, -100.0, -180.0}};
        double[][] rowcol = v5dcs.fromReference(latlon);
        double[][] latlon_t = v5dcs.toReference(rowcol);
        System.out.println(latlon_t[0][0] + ", " + latlon_t[1][0] + " : " + latlon_t[0][2] + ", " + latlon_t[1][2]);
        proj = 2;
        double[] projargs_lam = new double[]{60.0, 30.0, 0.0, 50.0, 100.0, 100.0};
        v5dcs = new Vis5DCoordinateSystem(proj, projargs_lam, 100.0, 100.0);
        double[][] latlon2 = new double[][]{{90.0, 40.0, 50.0}, {-100.0, -100.0, -180.0}};
        rowcol = v5dcs.fromReference(latlon2);
        latlon_t = v5dcs.toReference(rowcol);
        System.out.println(latlon_t[0][0] + ", " + latlon_t[1][0] + " : " + latlon_t[0][2] + ", " + latlon_t[1][2]);
    }
}

