/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.console;

import java.io.Console;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.vecmath.MismatchedSizeException;
import org.geotoolkit.console.CommandLine;
import org.geotoolkit.io.X364;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.converter.Classes;

public abstract class InteractiveConsole
implements Runnable {
    private final CommandLine commands;
    private final Console console;
    private final LineNumberReader in;
    protected final PrintWriter out;
    protected final PrintWriter err;
    private final String lineSeparator;
    final boolean colors;
    final Locale locale;
    final NumberFormat numberFormat;
    final String numberSeparator;
    private String prompt;
    private transient String command;
    private char quote = '\u0000';
    private char[] openingBrackets = new char[0];
    private char[] closingBrackets = this.openingBrackets;
    private transient Exception lastError;
    private volatile transient boolean stop;

    protected InteractiveConsole(CommandLine commandLine) {
        this.commands = commandLine;
        this.console = System.console();
        if (this.console != null) {
            this.in = null;
            this.out = this.err = this.console.writer();
            this.prompt = "Geotk \u25b6 ";
        } else if (commandLine != null) {
            this.in = new LineNumberReader(commandLine.in);
            this.out = commandLine.out;
            this.err = commandLine.err;
        } else {
            this.in = new LineNumberReader(new InputStreamReader(System.in));
            this.out = new PrintWriter(System.out, true);
            this.err = new PrintWriter(System.err, true);
        }
        if (commandLine != null) {
            this.locale = commandLine.locale;
            this.colors = Boolean.TRUE.equals(commandLine.colors);
        } else {
            this.locale = Locale.CANADA;
            this.colors = X364.isSupported();
        }
        this.lineSeparator = System.getProperty("line.separator", "\n");
        this.numberFormat = NumberFormat.getNumberInstance(this.locale);
        this.numberSeparator = InteractiveConsole.getNumberSeparator(this.numberFormat);
        this.ensureNonNull();
    }

    protected InteractiveConsole(LineNumberReader lineNumberReader) {
        this(lineNumberReader, new PrintWriter(System.out, true));
    }

    protected InteractiveConsole(LineNumberReader lineNumberReader, PrintWriter printWriter) {
        this.commands = null;
        this.console = null;
        this.in = lineNumberReader;
        this.out = printWriter;
        this.err = new PrintWriter(System.err, true);
        this.colors = false;
        this.locale = Locale.CANADA;
        this.lineSeparator = System.getProperty("line.separator", "\n");
        this.numberFormat = NumberFormat.getNumberInstance(this.locale);
        this.numberSeparator = InteractiveConsole.getNumberSeparator(this.numberFormat);
        this.ensureNonNull();
    }

    private static String getNumberSeparator(NumberFormat numberFormat) {
        char c;
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumFractionDigits(6);
        numberFormat.setMaximumFractionDigits(6);
        if (numberFormat instanceof DecimalFormat && (c = ((DecimalFormat)numberFormat).getDecimalFormatSymbols().getDecimalSeparator()) == ',') {
            return ";";
        }
        return ",";
    }

    private void ensureNonNull() {
        if (this.console == null) {
            InteractiveConsole.ensureNonNull("in", this.in);
        }
        InteractiveConsole.ensureNonNull("out", this.out);
        InteractiveConsole.ensureNonNull("err", this.err);
        InteractiveConsole.ensureNonNull("lineSeparator", this.lineSeparator);
    }

    private static void ensureNonNull(String string, Object object) throws NullArgumentException {
        if (object == null) {
            throw new NullArgumentException(Errors.format(152, string));
        }
    }

    protected void setSymbols(char[] cArray, char[] cArray2, char c) {
        InteractiveConsole.ensureNonNull("openingBrackets", cArray);
        InteractiveConsole.ensureNonNull("closingBrackets", cArray2);
        if (cArray.length != cArray2.length) {
            throw new MismatchedSizeException(Errors.format(98));
        }
        this.openingBrackets = (char[])cArray.clone();
        this.closingBrackets = (char[])cArray2.clone();
        this.quote = c;
    }

    public void setPrompt(String string) {
        if (this.console != null) {
            InteractiveConsole.ensureNonNull("prompt", string);
            this.prompt = string;
        }
    }

    public String getPrompt() {
        return this.prompt;
    }

    private boolean read() {
        boolean bl;
        char c = this.quote;
        char[] cArray = this.openingBrackets;
        char[] cArray2 = this.closingBrackets;
        int[] nArray = new int[Math.min(cArray.length, cArray2.length)];
        int n = -1;
        boolean bl2 = false;
        StringBuilder stringBuilder = null;
        String string = null;
        while (!(bl = this.stop)) {
            int n2;
            if (this.console != null) {
                Object[] objectArray;
                String string2 = "%d %c\u2026%c \u25b6 ";
                X364 x364 = X364.FOREGROUND_CYAN;
                if (bl2) {
                    objectArray = new Object[]{1, Character.valueOf(c), Character.valueOf(c)};
                } else if (n >= 0) {
                    objectArray = new Object[]{nArray[n], Character.valueOf(cArray[n]), Character.valueOf(cArray2[n])};
                } else {
                    string2 = this.prompt;
                    objectArray = new Object[]{};
                    x364 = X364.FOREGROUND_GREEN;
                }
                if (this.colors) {
                    string2 = x364.sequence() + string2 + X364.FOREGROUND_DEFAULT.sequence();
                }
                string = this.console.readLine(string2, objectArray);
            } else {
                try {
                    this.out.flush();
                    string = this.in.readLine();
                }
                catch (IOException iOException) {
                    throw new IOError(iOException);
                }
            }
            if (string == null) break;
            int n3 = (string = string.trim()).length();
            if (n3 == 0 || string.startsWith("//") || string.startsWith("#")) continue;
            block3: for (n2 = 0; n2 < n3; ++n2) {
                char c2 = string.charAt(n2);
                if (c != '\u0000' && c2 == c) {
                    bl2 = !bl2;
                    continue;
                }
                if (bl2) continue;
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] != 0 && cArray2[i] == c2) {
                        int n4 = i;
                        nArray[n4] = nArray[n4] - 1;
                        continue block3;
                    }
                    if (cArray[i] != c2) continue;
                    int n5 = i;
                    nArray[n5] = nArray[n5] + 1;
                    continue block3;
                }
            }
            n2 = 0;
            n = -1;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] <= n2) continue;
                n2 = nArray[i];
                n = i;
            }
            if (!bl2 && n < 0) break;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(string);
                continue;
            }
            stringBuilder.append(this.lineSeparator).append(string);
        }
        if (stringBuilder != null) {
            string = stringBuilder.append(this.lineSeparator).append(string).toString();
        }
        this.command = string;
        return bl;
    }

    public void stop() {
        this.stop = true;
    }

    @Override
    public void run() {
        while (!this.read() && this.command != null) {
            try {
                this.execute(this.command);
            }
            catch (Exception exception) {
                this.reportError(exception);
            }
        }
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(String string) throws Exception {
        if (string.equalsIgnoreCase("exit") || string.equalsIgnoreCase("quit")) {
            this.stop();
            return;
        }
        if (string.equalsIgnoreCase("stacktrace")) {
            if (this.lastError != null) {
                this.lastError.printStackTrace(this.err);
            }
            return;
        }
        if (this.commands != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
            String[] stringArray2 = this.commands.arguments;
            try {
                this.commands.consoleRunning = true;
                this.commands.arguments = stringArray;
                this.commands.run();
            }
            finally {
                this.commands.arguments = stringArray2;
                this.commands.consoleRunning = false;
            }
            return;
        }
        throw this.unexpectedArgument(73, string);
    }

    protected void reportError(Exception exception) {
        String string;
        this.out.flush();
        if (this.in != null) {
            this.print(X364.BACKGROUND_RED);
            this.err.print(Classes.getShortClassName(exception));
            this.err.print(" at line ");
            this.err.println(this.in.getLineNumber());
            this.print(X364.BACKGROUND_DEFAULT);
        }
        this.err.println((string = exception.getLocalizedMessage()) != null ? string : Classes.getShortClassName(exception));
        Throwable throwable = exception;
        while ((throwable = throwable.getCause()) != null) {
            this.print(X364.FAINT);
            this.err.print("  Caused by ");
            this.err.print(Classes.getShortClassName(throwable));
            string = throwable.getLocalizedMessage();
            if (string != null) {
                this.err.print(": ");
                this.err.print(string);
            }
            this.print(X364.NORMAL);
            this.err.println();
        }
        this.lastError = exception;
    }

    private void print(X364 x364) {
        if (this.colors) {
            this.err.print(x364.sequence());
        }
    }

    final IllegalArgumentException unexpectedArgument(int n, String string) {
        if (this.colors) {
            string = X364.FOREGROUND_YELLOW.sequence() + string + X364.FOREGROUND_DEFAULT.sequence();
        }
        return new IllegalArgumentException(Errors.format(n, string));
    }

    final double[] parseVector(String string, boolean bl) throws ParseException {
        string = InteractiveConsole.removeDelimitors(string, '(', ')');
        if (bl && string.equalsIgnoreCase("null")) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.numberSeparator);
        double[] dArray = new double[stringTokenizer.countTokens()];
        for (int i = 0; i < dArray.length; ++i) {
            String string2 = stringTokenizer.nextToken().trim().toUpperCase(this.locale);
            ParsePosition parsePosition = new ParsePosition(0);
            Number number = this.numberFormat.parse(string2, parsePosition);
            if (parsePosition.getIndex() != string2.length()) {
                throw new ParseException(Errors.format(202, string2), parsePosition.getErrorIndex());
            }
            dArray[i] = number.doubleValue();
        }
        return dArray;
    }

    private static String removeDelimitors(String string, char c, char c2) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            char c3 = string.charAt(i);
            if (c3 == c) {
                if (n++ != 0) continue;
                n2 = i + 1;
                continue;
            }
            if (c3 != c2 || --n > 0) continue;
            string = string.substring(n2, i);
            break;
        }
        return string.trim();
    }
}

