/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.console;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.geotoolkit.console.Action;
import org.geotoolkit.console.CommandLine;
import org.geotoolkit.console.Option;
import org.geotoolkit.console.ReferencingAction;
import org.geotoolkit.console.ReferencingConsole;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.io.wkt.FormattableObject;
import org.geotoolkit.parameter.ParameterWriter;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.factory.FactoryDependencies;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.operation.MathTransformFactory;

public class ReferencingCommands
extends CommandLine {
    private static final Hints HINTS = null;
    @Option(examples={"OGC", "EPSG", "ESRI", "GeoTIFF"})
    String authority;
    @Option
    int indent = FormattableObject.getDefaultIndentation();
    @Option
    boolean forcexy;

    protected ReferencingCommands(String[] stringArray) {
        super("java -jar geotk-referencing.jar", stringArray);
    }

    public static void main(String[] stringArray) {
        ReferencingCommands referencingCommands = new ReferencingCommands(stringArray);
        referencingCommands.run();
    }

    @Override
    Map<String, String> examples() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("BasicExample", "EPSG:4181 EPSG:4326 CRS:84 AUTO:42001,30,0");
        linkedHashMap.put("BasicEpsgExample", "--authority=EPSG 4181 7411");
        linkedHashMap.put("BursawolfsExample", "bursawolfs EPSG:4230");
        linkedHashMap.put("OperationsExample", "operations --authority=EPSG 4230 4326");
        linkedHashMap.put("TransformExample", "transform EPSG:4230 EPSG:4326");
        linkedHashMap.put("ListExample", "list operations");
        linkedHashMap.put("CodesExample", "list codes | grep \"NTF\"");
        linkedHashMap.put("ParametersExample", "parameters Mercator_1SP Mercator_2SP");
        return linkedHashMap;
    }

    @Override
    protected void unknownAction(String string) {
        if (string == null) {
            super.unknownAction(string);
            return;
        }
        new ReferencingAction(this).printObjectsWKT(this.arguments);
    }

    @Action(minimalArgumentCount=1, maximalArgumentCount=1, examples={"authorities", "codes", "operations", "conversions", "projections"})
    protected void list() {
        new ReferencingAction(this).list(this.arguments);
    }

    @Action(maximalArgumentCount=0)
    protected void factories() {
        FactoryDependencies factoryDependencies = new FactoryDependencies(CRS.getAuthorityFactory(this.forcexy));
        factoryDependencies.setAttributeEnabled(true);
        factoryDependencies.setColorEnabled(this.colors);
        factoryDependencies.setAbridged(!this.debug);
        factoryDependencies.print(this.out);
        this.out.flush();
    }

    @Action(minimalArgumentCount=1, examples={"Affine", "EPSG:9624", "9624"})
    protected void parameters() {
        MathTransformFactory mathTransformFactory = FactoryFinder.getMathTransformFactory(HINTS);
        ParameterWriter parameterWriter = new ParameterWriter(this.out);
        parameterWriter.setLocale(this.locale);
        parameterWriter.setColorEnabled(this.colors);
        for (int i = 0; i < this.arguments.length; ++i) {
            ParameterValueGroup parameterValueGroup;
            try {
                parameterValueGroup = mathTransformFactory.getDefaultParameters(this.arguments[i]);
            }
            catch (NoSuchIdentifierException noSuchIdentifierException) {
                this.printException(noSuchIdentifierException);
                this.exit(1);
                return;
            }
            if (i != 0) {
                this.out.println();
            }
            try {
                parameterWriter.format(parameterValueGroup.getDescriptor());
                continue;
            }
            catch (IOException iOException) {
                this.printException(iOException);
                this.exit(100);
                return;
            }
        }
    }

    @Action(minimalArgumentCount=1, examples={"EPSG:4230"})
    protected void bursawolfs() {
        new ReferencingAction(this).bursawolfs(this.arguments);
    }

    @Action(minimalArgumentCount=2, examples={"EPSG:4230", "EPSG:4326"})
    protected void operations() {
        new ReferencingAction(this).operations(this.arguments);
    }

    @Action(minimalArgumentCount=2, examples={"EPSG:4230", "EPSG:4326"})
    protected void transform() {
        new ReferencingAction(this).transform(this.arguments);
    }

    @Action(maximalArgumentCount=0)
    protected void reformat() {
        new ReferencingAction(this).reformat(this.in, this.out, this.err);
    }

    @Action(minimalArgumentCount=1, maximalArgumentCount=1, examples={"creates", "duplicates", "all"})
    protected void test() {
        new ReferencingAction(this).test(this.arguments);
    }

    @Action(maximalArgumentCount=0)
    protected void console() {
        if (!this.consoleRunning) {
            ReferencingConsole referencingConsole = new ReferencingConsole(this);
            referencingConsole.run();
        }
    }
}

