/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.display.shape;

import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;

public final class ShapeUtilities {
    private static final double EPS = 1.0E-6;

    private ShapeUtilities() {
    }

    public static Point2D intersectionPoint(Line2D line2D, Line2D line2D2) {
        return ShapeUtilities.intersectionPoint(line2D.getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2(), line2D2.getX1(), line2D2.getY1(), line2D2.getX2(), line2D2.getY2());
    }

    public static Point2D intersectionPoint(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = (d4 -= d2) * (d7 -= d5);
        double d10 = (d3 -= d) * (d8 -= d6);
        d9 = ((d6 - d2) * (d3 * d7) + d9 * d - d10 * d5) / (d9 - d10);
        double d11 = d10 = Math.abs(d7) > Math.abs(d3) ? d8 / d7 * (d9 - d5) + d6 : d4 / d3 * (d9 - d) + d2;
        if (d3 != 0.0 && !(!(d3 < 0.0) ? d9 >= d && d9 <= d + d3 : d9 <= d && d9 >= d + d3)) {
            return null;
        }
        if (d7 != 0.0 && !(!(d7 < 0.0) ? d9 >= d5 && d9 <= d5 + d7 : d9 <= d5 && d9 >= d5 + d7)) {
            return null;
        }
        if (d4 != 0.0 && !(!(d4 < 0.0) ? d10 >= d2 && d10 <= d2 + d4 : d10 <= d2 && d10 >= d2 + d4)) {
            return null;
        }
        if (d8 != 0.0 && !(!(d8 < 0.0) ? d10 >= d6 && d10 <= d6 + d8 : d10 <= d6 && d10 >= d6 + d8)) {
            return null;
        }
        return new Point2D.Double(d9, d10);
    }

    public static Point2D nearestColinearPoint(Line2D line2D, Point2D point2D) {
        return ShapeUtilities.nearestColinearPoint(line2D.getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2(), point2D.getX(), point2D.getY());
    }

    public static Point2D nearestColinearPoint(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = (d4 - d2) / (d3 - d);
        if (!Double.isInfinite(d7)) {
            double d8 = d4 - d7 * d3;
            d5 = ((d6 - d8) * d7 + d5) / (d7 * d7 + 1.0);
            d6 = d5 * d7 + d8;
        } else {
            d5 = d3;
        }
        if (d <= d3) {
            if (d5 < d) {
                d5 = d;
            }
            if (d5 > d3) {
                d5 = d3;
            }
        } else {
            if (d5 > d) {
                d5 = d;
            }
            if (d5 < d3) {
                d5 = d3;
            }
        }
        if (d2 <= d4) {
            if (d6 < d2) {
                d6 = d2;
            }
            if (d6 > d4) {
                d6 = d4;
            }
        } else {
            if (d6 > d2) {
                d6 = d2;
            }
            if (d6 < d4) {
                d6 = d4;
            }
        }
        return new Point2D.Double(d5, d6);
    }

    public static Point2D colinearPoint(Line2D line2D, Point2D point2D, double d) {
        return ShapeUtilities.colinearPoint(line2D.getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2(), point2D.getX(), point2D.getY(), d);
    }

    public static Point2D colinearPoint(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        boolean bl;
        boolean bl2;
        double d8;
        double d9;
        double d10;
        double d11 = d;
        double d12 = d2;
        double d13 = d3;
        double d14 = d4;
        d7 *= d7;
        if (d == d3) {
            d10 = d - d5;
            d10 = Math.sqrt(d7 - d10 * d10);
            d2 = d6 - d10;
            d4 = d6 + d10;
        } else if (d2 == d4) {
            d10 = d2 - d6;
            d10 = Math.sqrt(d7 - d10 * d10);
            d = d5 - d10;
            d3 = d5 + d10;
        } else {
            d10 = (d2 - d4) / (d3 - d);
            d9 = d4 - d6 + d10 * (d3 - d5);
            d8 = d10 * d9;
            double d15 = d10 * d10 + 1.0;
            double d16 = Math.sqrt(d8 * d8 + d15 * (d7 - d9 * d9));
            d = (d8 + d16) / d15;
            d3 = (d8 - d16) / d15;
            d2 = d6 + d9 - d10 * d;
            d4 = d6 + d9 - d10 * d3;
            d += d5;
            d3 += d5;
        }
        if (d12 > d14) {
            bl2 = d2 <= d12 && d2 >= d14;
            bl = d4 <= d12 && d4 >= d14;
        } else {
            bl2 = d2 >= d12 && d2 <= d14;
            boolean bl3 = bl = d4 >= d12 && d4 <= d14;
        }
        if (d11 > d13) {
            bl2 &= d <= d11 && d >= d13;
            bl &= d3 <= d11 && d3 >= d13;
        } else {
            bl2 &= d >= d11 && d <= d13;
            bl &= d3 >= d11 && d3 <= d13;
        }
        if (!bl2 && !bl) {
            return null;
        }
        if (!bl2) {
            return new Point2D.Double(d3, d4);
        }
        if (!bl) {
            return new Point2D.Double(d, d2);
        }
        d5 = d - d11;
        d6 = d2 - d12;
        d9 = d5 * d5 + d6 * d6;
        d8 = (d5 = d3 - d11) * d5 + (d6 = d4 - d12) * d6;
        if (d9 > d8) {
            return new Point2D.Double(d3, d4);
        }
        return new Point2D.Double(d, d2);
    }

    public static QuadCurve2D fitParabol(Point2D point2D, Point2D point2D2, Point2D point2D3, boolean bl) {
        return ShapeUtilities.fitParabol(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), bl);
    }

    public static QuadCurve2D fitParabol(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        Point2D point2D = ShapeUtilities.parabolicControlPoint(d, d2, d3, d4, d5, d6, bl, null);
        return point2D != null ? new QuadCurve2D.Double(d, d2, point2D.getX(), point2D.getY(), d5, d6) : null;
    }

    public static Point2D parabolicControlPoint(double d, double d2, double d3, double d4, double d5, double d6, boolean bl, Point2D point2D) {
        d3 -= d;
        d4 -= d2;
        d5 -= d;
        d6 -= d2;
        if (bl) {
            double d7 = (d6 - d4 * d5 / d3) / (d5 - d3);
            double d8 = Math.abs(d7);
            if (!(d8 <= 1000000.0)) {
                return null;
            }
            if (!(d8 >= 1.0E-6)) {
                return null;
            }
            double d9 = d6 / d5 - d7;
            d3 = (1.0 + d9 / (2.0 * d7)) * d5 - d6 / (2.0 * d7);
            d4 = d2 + d9 * d3;
            d3 += d;
        } else {
            double d10 = d5;
            double d11 = d6;
            d5 = Math.hypot(d5, d6);
            d6 = (d3 * d10 + d4 * d11) / d5;
            d4 = (d4 * d10 - d3 * d11) / d5;
            d3 = d6;
            d6 = 0.0;
            double d12 = d4 * 0.5 * d5 / (d3 * (d5 - d3));
            double d13 = Math.abs(d12);
            if (!(d13 <= 1000000.0)) {
                return null;
            }
            if (!(d13 >= 1.0E-6)) {
                return null;
            }
            d3 = 0.5 * d10 - d12 * d11 + d;
            d4 = d12 * d10 + 0.5 * d11 + d2;
        }
        if (point2D != null) {
            point2D.setLocation(d3, d4);
            return point2D;
        }
        return new Point2D.Double(d3, d4);
    }

    public static Ellipse2D fitCircle(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        Point2D point2D4 = ShapeUtilities.circleCentre(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY());
        double d = point2D4.distance(point2D2);
        return new Ellipse2D.Double(point2D4.getX() - d, point2D4.getY() - d, 2.0 * d, 2.0 * d);
    }

    public static Point2D circleCentre(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = (d3 -= d) * d3 + (d4 -= d2) * d4;
        double d8 = (d5 -= d) * d5 + (d6 -= d2) * d6;
        double d9 = (d4 * d8 - d6 * d7) / (d4 * d5 - d6 * d3);
        return new Point2D.Double(d + 0.5 * d9, d2 + 0.5 * (d7 - d9 * d3) / d4);
    }

    public static Shape toPrimitive(Shape shape) {
        float[] fArray = new float[6];
        PathIterator pathIterator = shape.getPathIterator(null);
        if (!pathIterator.isDone() && pathIterator.currentSegment(fArray) == 0 && !pathIterator.isDone()) {
            float f = fArray[0];
            float f2 = fArray[1];
            int n = pathIterator.currentSegment(fArray);
            if (pathIterator.isDone()) {
                switch (n) {
                    case 1: {
                        return new Line2D.Float(f, f2, fArray[0], fArray[1]);
                    }
                    case 2: {
                        return new QuadCurve2D.Float(f, f2, fArray[0], fArray[1], fArray[2], fArray[3]);
                    }
                    case 3: {
                        return new CubicCurve2D.Float(f, f2, fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    }
                }
            }
        }
        return shape;
    }

    public static double getFlatness(Shape shape) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getHeight();
        return Math.max(0.025 * Math.min(d, d2), 0.001 * Math.max(d, d2));
    }
}

