/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.display.shape;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.geotoolkit.display.shape.InfiniteRectangle2D;
import org.geotoolkit.util.converter.Classes;

public class XRectangle2D
extends Rectangle2D
implements Serializable {
    private static final long serialVersionUID = -1918221103635749436L;
    private static final double EPS = 1.0E-6;
    public static final Rectangle2D INFINITY = new InfiniteRectangle2D();
    protected double xmin;
    protected double ymin;
    protected double xmax;
    protected double ymax;

    public XRectangle2D() {
    }

    public XRectangle2D(double d, double d2, double d3, double d4) {
        this.xmin = d;
        this.ymin = d2;
        this.xmax = d + d3;
        this.ymax = d2 + d4;
    }

    public XRectangle2D(Rectangle2D rectangle2D) {
        if (rectangle2D != null) {
            this.setRect(rectangle2D);
        }
    }

    public static XRectangle2D createFromExtremums(double d, double d2, double d3, double d4) {
        XRectangle2D xRectangle2D = new XRectangle2D();
        xRectangle2D.xmin = d;
        xRectangle2D.ymin = d2;
        xRectangle2D.xmax = d3;
        xRectangle2D.ymax = d4;
        return xRectangle2D;
    }

    @Override
    public boolean isEmpty() {
        return !(this.xmin < this.xmax) || !(this.ymin < this.ymax);
    }

    @Override
    public double getX() {
        return this.xmin;
    }

    @Override
    public double getY() {
        return this.ymin;
    }

    @Override
    public double getWidth() {
        return this.xmax - this.xmin;
    }

    @Override
    public double getHeight() {
        return this.ymax - this.ymin;
    }

    @Override
    public double getMinX() {
        return this.xmin;
    }

    @Override
    public double getMinY() {
        return this.ymin;
    }

    @Override
    public double getMaxX() {
        return this.xmax;
    }

    @Override
    public double getMaxY() {
        return this.ymax;
    }

    @Override
    public double getCenterX() {
        return (this.xmin + this.xmax) * 0.5;
    }

    @Override
    public double getCenterY() {
        return (this.ymin + this.ymax) * 0.5;
    }

    @Override
    public void setRect(double d, double d2, double d3, double d4) {
        this.xmin = d;
        this.ymin = d2;
        this.xmax = d + d3;
        this.ymax = d2 + d4;
    }

    @Override
    public void setRect(Rectangle2D rectangle2D) {
        this.xmin = rectangle2D.getMinX();
        this.ymin = rectangle2D.getMinY();
        this.xmax = rectangle2D.getMaxX();
        this.ymax = rectangle2D.getMaxY();
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        if (!(this.xmin < this.xmax && this.ymin < this.ymax && d3 > 0.0 && d4 > 0.0)) {
            return false;
        }
        return d < this.xmax && d2 < this.ymax && d + d3 > this.xmin && d2 + d4 > this.ymin;
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        if (!(this.xmin < this.xmax) || !(this.ymin < this.ymax)) {
            return false;
        }
        double d = rectangle2D.getMinX();
        double d2 = rectangle2D.getMaxX();
        if (!(d2 > d)) {
            return false;
        }
        double d3 = rectangle2D.getMinY();
        double d4 = rectangle2D.getMaxY();
        if (!(d4 > d3)) {
            return false;
        }
        return d < this.xmax && d3 < this.ymax && d2 > this.xmin && d4 > this.ymin;
    }

    public static boolean intersectInclusive(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double d = rectangle2D.getMinX();
        double d2 = rectangle2D.getMaxX();
        if (!(d2 >= d)) {
            return false;
        }
        double d3 = rectangle2D.getMinY();
        double d4 = rectangle2D.getMaxY();
        if (!(d4 >= d3)) {
            return false;
        }
        double d5 = rectangle2D2.getMinX();
        double d6 = rectangle2D2.getMaxX();
        if (!(d6 >= d5)) {
            return false;
        }
        double d7 = rectangle2D2.getMinY();
        double d8 = rectangle2D2.getMaxY();
        if (!(d8 >= d7)) {
            return false;
        }
        return d6 >= d && d8 >= d3 && d5 <= d2 && d7 <= d4;
    }

    public static boolean intersectInclusive(Shape shape, Rectangle2D rectangle2D) {
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        if (d3 == 0.0 && d4 == 0.0) {
            d3 = 1.0E-6;
            d4 = 1.0E-6;
        } else if (d3 == 0.0) {
            d3 = d4 * 1.0E-6;
            d -= 0.5 * d3;
        } else if (d4 == 0.0) {
            d4 = d3 * 1.0E-6;
            d2 -= 0.5 * d4;
        }
        return shape.intersects(d, d2, d3, d4);
    }

    public static boolean equalsEpsilon(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double d = 0.5 * Math.abs(rectangle2D.getWidth() + rectangle2D2.getWidth());
        double d2 = 0.5 * Math.abs(rectangle2D.getHeight() + rectangle2D2.getHeight());
        d = d > 0.0 ? (d *= 1.0E-6) : 1.0E-6;
        d2 = d2 > 0.0 ? (d2 *= 1.0E-6) : 1.0E-6;
        return XRectangle2D.equalsEpsilon(rectangle2D.getMinX(), rectangle2D2.getMinX(), d) && XRectangle2D.equalsEpsilon(rectangle2D.getMinY(), rectangle2D2.getMinY(), d2) && XRectangle2D.equalsEpsilon(rectangle2D.getMaxX(), rectangle2D2.getMaxX(), d) && XRectangle2D.equalsEpsilon(rectangle2D.getMaxY(), rectangle2D2.getMaxY(), d2);
    }

    private static boolean equalsEpsilon(double d, double d2, double d3) {
        return Math.abs(d - d2) < d3 || Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        if (!(this.xmin < this.xmax && this.ymin < this.ymax && d3 > 0.0 && d4 > 0.0)) {
            return false;
        }
        return d >= this.xmin && d2 >= this.ymin && d + d3 <= this.xmax && d2 + d4 <= this.ymax;
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        if (!(this.xmin < this.xmax) || !(this.ymin < this.ymax)) {
            return false;
        }
        double d = rectangle2D.getMinX();
        double d2 = rectangle2D.getMaxX();
        if (!(d2 > d)) {
            return false;
        }
        double d3 = rectangle2D.getMinY();
        double d4 = rectangle2D.getMaxY();
        if (!(d4 > d3)) {
            return false;
        }
        return d >= this.xmin && d3 >= this.ymin && d2 <= this.xmax && d4 <= this.ymax;
    }

    @Override
    public boolean contains(double d, double d2) {
        return d >= this.xmin && d2 >= this.ymin && d < this.xmax && d2 < this.ymax;
    }

    public static boolean containsInclusive(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        return rectangle2D.getMinX() <= rectangle2D2.getMinX() && rectangle2D.getMaxX() >= rectangle2D2.getMaxX() && rectangle2D.getMinY() <= rectangle2D2.getMinY() && rectangle2D.getMaxY() >= rectangle2D2.getMaxY();
    }

    @Override
    public int outcode(double d, double d2) {
        int n = 0;
        if (!(this.xmax > this.xmin)) {
            n |= 5;
        } else if (d < this.xmin) {
            n |= 1;
        } else if (d > this.xmax) {
            n |= 4;
        }
        if (!(this.ymax > this.ymin)) {
            n |= 0xA;
        } else if (d2 < this.ymin) {
            n |= 2;
        } else if (d2 > this.ymax) {
            n |= 8;
        }
        return n;
    }

    @Override
    public Rectangle2D createIntersection(Rectangle2D rectangle2D) {
        XRectangle2D xRectangle2D = new XRectangle2D();
        xRectangle2D.xmin = Math.max(this.xmin, rectangle2D.getMinX());
        xRectangle2D.ymin = Math.max(this.ymin, rectangle2D.getMinY());
        xRectangle2D.xmax = Math.min(this.xmax, rectangle2D.getMaxX());
        xRectangle2D.ymax = Math.min(this.ymax, rectangle2D.getMaxY());
        return xRectangle2D;
    }

    @Override
    public Rectangle2D createUnion(Rectangle2D rectangle2D) {
        XRectangle2D xRectangle2D = new XRectangle2D();
        xRectangle2D.xmin = Math.min(this.xmin, rectangle2D.getMinX());
        xRectangle2D.ymin = Math.min(this.ymin, rectangle2D.getMinY());
        xRectangle2D.xmax = Math.max(this.xmax, rectangle2D.getMaxX());
        xRectangle2D.ymax = Math.max(this.ymax, rectangle2D.getMaxY());
        return xRectangle2D;
    }

    @Override
    public void add(double d, double d2) {
        if (d < this.xmin) {
            this.xmin = d;
        }
        if (d > this.xmax) {
            this.xmax = d;
        }
        if (d2 < this.ymin) {
            this.ymin = d2;
        }
        if (d2 > this.ymax) {
            this.ymax = d2;
        }
    }

    @Override
    public void add(Rectangle2D rectangle2D) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5 = rectangle2D.getMinX();
        if (d4 < this.xmin) {
            this.xmin = d5;
        }
        d5 = rectangle2D.getMaxX();
        if (d3 > this.xmax) {
            this.xmax = d5;
        }
        d5 = rectangle2D.getMinY();
        if (d2 < this.ymin) {
            this.ymin = d5;
        }
        d5 = rectangle2D.getMaxY();
        if (d > this.ymax) {
            this.ymax = d5;
        }
    }

    public String toString() {
        return Classes.getShortClassName(this) + "[xmin=" + this.xmin + " xmax=" + this.xmax + " ymin=" + this.ymin + " ymax=" + this.ymax + ']';
    }
}

