/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.factory;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.spi.ServiceRegistry;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.FactoryNotFoundException;
import org.geotoolkit.factory.FactoryRegistry;
import org.geotoolkit.factory.FactoryRegistryException;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.logging.Logging;

public class DynamicFactoryRegistry
extends FactoryRegistry {
    private static final Class<?>[] HINTS_ARGUMENT = new Class[]{Hints.class};
    private final Map<Class<?>, List<Reference<?>>> cache = new HashMap();
    private final Set<Class<?>> underConstruction = new HashSet();
    private final Set<Class<? extends Factory>> unavailables = new HashSet<Class<? extends Factory>>();

    public DynamicFactoryRegistry(Class<?> clazz) {
        super(clazz);
    }

    public DynamicFactoryRegistry(Class<?>[] classArray) {
        super(classArray);
    }

    public DynamicFactoryRegistry(Collection<Class<?>> collection) {
        super(collection);
    }

    private <T> List<Reference<T>> getCachedProviders(Class<T> clazz) {
        List<Reference<T>> list = this.cache.get(clazz);
        if (list == null) {
            list = new LinkedList();
            this.cache.put(clazz, list);
        }
        List<Reference<T>> list2 = list;
        return list2;
    }

    private <T> void cache(Class<T> clazz, T t) {
        this.getCachedProviders(clazz).add(new WeakReference<T>(t));
    }

    @Override
    final void reset() {
        super.reset();
        this.unavailables.clear();
    }

    @Override
    final <T> T getOrCreateServiceProvider(Class<T> clazz, ServiceRegistry.Filter filter, Hints hints, Hints.ClassKey classKey) throws FactoryRegistryException {
        try {
            return super.getOrCreateServiceProvider(clazz, filter, hints, classKey);
        }
        catch (FactoryNotFoundException factoryNotFoundException) {
            Class clazz2;
            Iterator<T> iterator;
            Class[] classArray;
            FactoryNotFoundException factoryNotFoundException2 = factoryNotFoundException;
            if (hints == null || classKey == null) {
                classArray = null;
            } else {
                iterator = hints.get(classKey);
                if (iterator == null) {
                    classArray = null;
                } else {
                    classArray = iterator instanceof Class[] ? (Class[])iterator : new Class[]{(Class)((Object)iterator)};
                    if ((hints = hints.clone()).remove(classKey) != iterator) {
                        throw new AssertionError(iterator);
                    }
                    for (int i = 0; i < classArray.length; ++i) {
                        T t;
                        int n;
                        clazz2 = classArray[i];
                        if (clazz2 == null || !clazz.isAssignableFrom(clazz2) || this.unavailables.contains(clazz2) || Modifier.isAbstract(n = clazz2.getModifiers()) || (t = this.createSafe(clazz, clazz2, hints)) == null) continue;
                        if (this.isAcceptable(t, clazz, hints, filter, true)) {
                            this.cache(clazz, t);
                            return t;
                        }
                        DynamicFactoryRegistry.dispose(t);
                    }
                }
            }
            iterator = this.getUnfilteredProviders(clazz);
            while (iterator.hasNext()) {
                T t;
                T t2 = iterator.next();
                clazz2 = t2.getClass();
                if (this.unavailables.contains(clazz2) || !DynamicFactoryRegistry.isAssignableTo(clazz2, classArray) || filter != null && !filter.filter(t2)) continue;
                try {
                    t = this.createSafe(clazz, clazz2, hints);
                }
                catch (FactoryNotFoundException factoryNotFoundException3) {
                    Logging.recoverableException(LOGGER, DynamicFactoryRegistry.class, "getServiceProvider", factoryNotFoundException3);
                    continue;
                }
                catch (FactoryRegistryException factoryRegistryException) {
                    if (factoryRegistryException.getCause() instanceof NoSuchMethodException) continue;
                    throw factoryRegistryException;
                }
                if (t == null) continue;
                if (this.isAcceptable(t, clazz, hints, filter, true)) {
                    this.cache(clazz, t);
                    return t;
                }
                DynamicFactoryRegistry.dispose(t);
            }
            this.initCause(factoryNotFoundException2);
            throw factoryNotFoundException2;
        }
    }

    private static boolean isAssignableTo(Class<?> clazz, Class<?>[] classArray) {
        if (classArray == null) {
            return true;
        }
        for (Class<?> clazz2 : classArray) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    final void unavailable(Factory factory) {
        this.unavailables.add(factory.getClass());
        super.unavailable(factory);
    }

    @Override
    final <T> T getServiceImplementation(Class<T> clazz, Class<?> clazz2, ServiceRegistry.Filter filter, Hints hints) {
        T t = super.getServiceImplementation(clazz, clazz2, filter, hints);
        if (t != null) {
            return t;
        }
        List<Reference<T>> list = this.getCachedProviders(clazz);
        Iterator<Reference<T>> iterator = list.iterator();
        while (iterator.hasNext()) {
            t = iterator.next().get();
            if (t == null) {
                iterator.remove();
                continue;
            }
            if (clazz2 != null && !clazz2.isInstance(t) || !this.isAcceptable(t, clazz, hints, filter, true)) continue;
            return t;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T createSafe(Class<T> clazz, Class<?> clazz2, Hints hints) {
        if (!this.underConstruction.add(clazz2)) {
            return null;
        }
        try {
            T t = this.createServiceProvider(clazz, clazz2, hints);
            return t;
        }
        finally {
            if (!this.underConstruction.remove(clazz2)) {
                throw new AssertionError();
            }
        }
    }

    protected <T> T createServiceProvider(Class<T> clazz, Class<?> clazz2, Hints hints) throws FactoryRegistryException {
        Throwable throwable;
        block9: {
            try {
                try {
                    Constructor<?> constructor = clazz2.getConstructor(HINTS_ARGUMENT);
                    return clazz.cast(constructor.newInstance(hints));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throwable = noSuchMethodException;
                    if (super.getServiceProviderByClass(clazz2) == null) {
                        try {
                            Constructor<?> constructor = clazz2.getConstructor(null);
                            return clazz.cast(constructor.newInstance(null));
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {}
                    }
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throwable = illegalAccessException;
            }
            catch (InstantiationException instantiationException) {
                throwable = instantiationException;
            }
            catch (InvocationTargetException invocationTargetException) {
                throwable = invocationTargetException.getCause();
                if (!(throwable instanceof FactoryRegistryException)) break block9;
                throw (FactoryRegistryException)throwable;
            }
        }
        throw new FactoryRegistryException(Errors.format(24, clazz2), throwable);
    }

    private static void dispose(Object object) {
        if (object instanceof Factory) {
            ((Factory)object).dispose(false);
        }
    }
}

